/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javatraceit.gui.depurador.editor.JEditTextArea;
import javatraceit.gui.depurador.editor.JTIEditor;
import javatraceit.gui.depurador.editor.JTIEditorNotifier;
import javatraceit.gui.depurador.editor.JTITextAreaPainter;
import javatraceit.gui.depurador.editor.JTIUndoableSyntaxDocument;
import javatraceit.gui.depurador.editor.JavaTokenMarker;
import javatraceit.gui.depurador.editor.TextAreaDefaults;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;

public class JTITextArea
extends JEditTextArea
implements JTIEditor {
    Vector notifiers = new Vector();
    public NumLineas numLineas = new NumLineas();
    private boolean modificado = false;
    private Vector numerosDeLineaVector = new Vector();
    private JList numerosDeLineaList = new JList();
    private File fichero;
    private int lineaDestacada = 3;
    private Vector breakpoints = new Vector();

    public void setFirstLine(int firstLine) {
        super.setFirstLine(firstLine);
        if (this.numerosDeLineaList != null) {
            this.numerosDeLineaList.repaint();
        }
    }

    public void undo() {
        ((JTIUndoableSyntaxDocument)super.getDocument()).undo();
    }

    public void removeUndos() {
        ((JTIUndoableSyntaxDocument)super.getDocument()).removeUndos();
    }

    public JTITextArea() {
        super.setDocument(new JTIUndoableSyntaxDocument());
        super.add("left", this.numLineas);
        this.remove(this.painter);
        this.painter = new JTITextAreaPainter(this, TextAreaDefaults.getDefaults());
        this.painter.addComponentListener(new JEditTextArea.ComponentHandler());
        this.painter.addMouseListener(new JEditTextArea.MouseHandler());
        this.painter.addMouseMotionListener(new JEditTextArea.DragHandler());
        this.setTokenMarker(new JavaTokenMarker());
        this.add(JEditTextArea.CENTER, this.painter);
        this.setMinimumSize(new Dimension(0, 0));
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() == 0) {
                    int lineaDestino = JTITextArea.this.firstLine + e.getScrollAmount() * e.getWheelRotation();
                    if (e.getWheelRotation() > 0) {
                        if (lineaDestino + JTITextArea.this.visibleLines <= JTITextArea.this.getLineCount()) {
                            JTITextArea.this.setFirstLine(lineaDestino);
                        } else {
                            lineaDestino = JTITextArea.this.getLineCount() - JTITextArea.this.visibleLines;
                            if (lineaDestino < 0) {
                                lineaDestino = 0;
                            }
                            JTITextArea.this.setFirstLine(lineaDestino);
                        }
                    } else if (lineaDestino >= 0) {
                        JTITextArea.this.setFirstLine(lineaDestino);
                    } else {
                        JTITextArea.this.setFirstLine(0);
                    }
                }
            }
        });
        super.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (!JTITextArea.this.modificado) {
                    JTITextArea.this.modificado = true;
                    JTITextArea.this.fireModificado(JTITextArea.this.getFichero());
                }
            }

            public void insertUpdate(DocumentEvent evt) {
                if (!JTITextArea.this.modificado) {
                    JTITextArea.this.modificado = true;
                    JTITextArea.this.fireModificado(JTITextArea.this.getFichero());
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (!JTITextArea.this.modificado) {
                    JTITextArea.this.modificado = true;
                    JTITextArea.this.fireModificado(JTITextArea.this.getFichero());
                }
            }
        });
        this.requestFocus();
    }

    public void addJTIEditorNotifier(JTIEditorNotifier notifier) {
        this.notifiers.add(notifier);
    }

    private void fireModificado(File f) {
        int i = 0;
        while (i < this.notifiers.size()) {
            ((JTIEditorNotifier)this.notifiers.elementAt(i)).modificado(f);
            ++i;
        }
    }

    private void fireBreakpointPuesto(File f, int linea) {
        int i = 0;
        while (i < this.notifiers.size()) {
            ((JTIEditorNotifier)this.notifiers.elementAt(i)).a\u00f1adidoBreakpoint(f, linea);
            ++i;
        }
    }

    private void fireBreakpointSacado(File f, int linea) {
        int i = 0;
        while (i < this.notifiers.size()) {
            ((JTIEditorNotifier)this.notifiers.elementAt(i)).sacadoBreakpoint(f, linea);
            ++i;
        }
    }

    public void abrir(File fichero) throws IOException, BadLocationException {
        this.getDocument().remove(0, this.getDocument().getLength() - 1);
        StyledEditorKit kit = new StyledEditorKit();
        kit.read(new InputStreamReader(new FileInputStream(fichero)), (Document)this.getDocument(), 0);
        this.fichero = fichero;
        this.scrollTo(1, 0);
        this.numLineas.repaint();
        this.removeUndos();
        this.modificado = false;
    }

    public void guardar() throws IOException, BadLocationException {
        if (this.fichero == null) {
            return;
        }
        StyledEditorKit kit = new StyledEditorKit();
        kit.write(new FileOutputStream(this.fichero), (Document)this.getDocument(), 0, this.getDocument().getLength());
        this.modificado = false;
    }

    public void guardarComo(File f) throws IOException, BadLocationException {
        StyledEditorKit kit = new StyledEditorKit();
        kit.write(new FileOutputStream(f), (Document)this.getDocument(), 0, this.getDocument().getLength());
        this.fichero = f;
        this.modificado = false;
    }

    public File getFichero() {
        return this.fichero;
    }

    public void destacarLinea(int numLinea) {
        ((JTITextAreaPainter)this.painter).setLineaDestacada(numLinea);
        this.scrollTo(numLinea - 1, 0);
    }

    public void noDestacarLineaCodigo() {
        ((JTITextAreaPainter)this.painter).sacarLineaDestacada();
    }

    public void toggleBreakpoint(int numLinea) {
        if (this.fichero == null) {
            return;
        }
        boolean a\u00f1adido = ((JTITextAreaPainter)this.painter).toggleBreakpoint(numLinea);
        if (a\u00f1adido) {
            this.fireBreakpointPuesto(this.getFichero(), numLinea + 1);
        } else {
            this.fireBreakpointSacado(this.getFichero(), numLinea + 1);
        }
    }

    public int lineaActual() {
        return super.getCaretLine();
    }

    public void sacarBreakpoints() {
        ((JTITextAreaPainter)this.painter).sacarTodosLosBreakpoints();
    }

    public Vector getBreakpoints() {
        return ((JTITextAreaPainter)this.painter).getBreakpoints();
    }

    public void setEnabled(boolean valor) {
        this.setEditable(valor);
    }

    public boolean getModificado() {
        return this.modificado;
    }

    class NumLineas
    extends JComponent {
        public int y;
        private int first;
        private int last;

        public NumLineas() {
            int lineHeight = JTITextArea.this.painter.getFontMetrics().getHeight();
            int alto = JTITextArea.this.getPreferredSize().height;
            int numLineasVisibles = alto / lineHeight;
            int anchoMinimo = JTITextArea.this.painter.fm.stringWidth(String.valueOf(numLineasVisibles));
            this.setPreferredSize(new Dimension(anchoMinimo + 10, alto));
            this.setMaximumSize(new Dimension(anchoMinimo + 10, alto));
            this.setOpaque(true);
            this.addMouseListener(new MiMouseAdapter());
            this.setToolTipText("colocar / descartar breakpoint");
        }

        public void paint(Graphics g) {
            int anchoDelNumeroMasGrande;
            int lineHeight = JTITextArea.this.painter.getFontMetrics().getHeight();
            int anchoNumLineasVisibles = JTITextArea.this.painter.fm.stringWidth(String.valueOf(this.getParent().getHeight() / lineHeight));
            int anchoDebido = Math.max(anchoNumLineasVisibles, anchoDelNumeroMasGrande = JTITextArea.this.painter.fm.stringWidth(String.valueOf(JTITextArea.this.getLineCount())));
            if (this.getPreferredSize().width != anchoDebido) {
                JTITextArea.this.getLayout().removeLayoutComponent(this);
                this.setPreferredSize(new Dimension(anchoDebido + 15, 20));
                this.setMaximumSize(new Dimension(anchoDebido, 20));
                JTITextArea.this.add((Component)this, LEFT);
            }
            super.paint(g);
            g.setColor(new Color(230, 230, 244));
            g.fillRect(0, 0, this.getBounds().width - 5, this.getParent().getHeight());
            g.setColor(JTITextArea.this.painter.getBackground());
            g.fillRect(this.getBounds().width - 5, 0, 5, this.getParent().getHeight());
            int i = this.first + 1;
            while (i < this.last + 1) {
                g.setColor(new Color(153, 153, 204));
                g.drawString(String.valueOf(i), 0, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.2));
                if (((JTITextAreaPainter)JTITextArea.this.getPainter()).getLineaDestacada() == i) {
                    Polygon p = new Polygon();
                    p.addPoint(anchoDebido + 2, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3));
                    p.addPoint(anchoDebido + 2, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3) - 8);
                    p.addPoint(anchoDebido + 10, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3) - 4);
                    g.setColor(new Color(238));
                    g.fillPolygon(p);
                }
                ++i;
            }
        }

        public void repaint(int first, int last) {
            this.first = first;
            this.last = last;
            this.repaint();
        }

        class MiMouseAdapter
        extends MouseAdapter {
            MiMouseAdapter() {
            }

            public void mouseClicked(MouseEvent e) {
                if (NumLineas.this.isEnabled()) {
                    int linea = JTITextArea.this.yToLine(e.getPoint().y);
                    JTITextArea.this.toggleBreakpoint(linea);
                }
            }

            public void mouseEntered(MouseEvent e) {
                JTITextArea.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }
}

