/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.controladores;

import java.io.File;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.traza.ManejadorBreakpoints;
import javatraceit.depurador.traza.ManejadorSteps;
import javatraceit.depurador.traza.NoSePuedeHacerStepException;
import javatraceit.depurador.traza.UIBreakpointsNotifier;
import javatraceit.depurador.traza.UIStepsNotifier;
import javatraceit.gui.depurador.controladores.ControladorMemoria;
import javatraceit.gui.depurador.controladores.UIDepurador;

public class ControladorTraza
implements UIStepsNotifier,
UIBreakpointsNotifier {
    private UIDepurador ventanaDepurador;
    private ManejadorSteps manejadorSteps = ManejadorSteps.getManejadorSteps();
    private ManejadorBreakpoints manejadorBreakpoints;

    public ControladorTraza(UIDepurador v) {
        this.manejadorSteps.setUIStepsNotifier(this);
        this.manejadorBreakpoints = ManejadorBreakpoints.getManejadorBreakpoints();
        this.manejadorBreakpoints.setUIBreakpointsNotifier(this);
        this.ventanaDepurador = v;
    }

    public void stepOver() {
        try {
            this.ventanaDepurador.estadoEnEjecucion();
            this.manejadorSteps.stepOver();
        }
        catch (NoSePuedeHacerStepException ex) {
            this.ventanaDepurador.mostrarError("No se puede hacer un step en ejecucion");
        }
    }

    public void stepInto() {
        try {
            this.ventanaDepurador.estadoEnEjecucion();
            this.manejadorSteps.stepInto();
        }
        catch (NoSePuedeHacerStepException ex) {
            this.ventanaDepurador.mostrarError("No se puede hacer un step en ejecucion");
        }
    }

    public void stepOut() {
        try {
            this.ventanaDepurador.estadoEnEjecucion();
            this.manejadorSteps.stepOut();
        }
        catch (NoSePuedeHacerStepException ex) {
            this.ventanaDepurador.mostrarError("No se puede hacer un step en ejecucion");
        }
    }

    public void nuevoBreakpoint(File fichero, int numLinea) {
        System.out.println("solicitando breakpoint para: " + fichero + ": " + numLinea);
        FicheroJava ficheroJava = ManejadorFicheros.getManejadorFicheros().getFicheroJava(fichero);
        if (ficheroJava != null) {
            this.manejadorBreakpoints.nuevoBreakpoint(ficheroJava, numLinea);
        } else {
            this.ventanaDepurador.mostrarError("No se puede solicitar el breakpoint.El fichero no tiene nombre");
        }
    }

    public void sacarBreakpoint(File fichero, int numLinea) {
        System.out.println("solicitando quitar breakpoint para: " + fichero + ": " + numLinea);
        FicheroJava ficheroJava = ManejadorFicheros.getManejadorFicheros().getFicheroJava(fichero);
        if (ficheroJava != null) {
            this.manejadorBreakpoints.sacarBreakpoint(ficheroJava, numLinea);
        } else {
            this.ventanaDepurador.mostrarError("No se puede solicitar el breakpoint.");
        }
    }

    public void stepRealizado(FicheroJava f, int lineaCodigoActual) {
        this.ventanaDepurador.mostrarFichero(f.getFichero());
        this.ventanaDepurador.se\u00f1alarLineaFichero(f.getFichero(), lineaCodigoActual);
        new ControladorMemoria(this.ventanaDepurador).crearArbolMemoria();
        this.ventanaDepurador.estadoEnDepuracion();
    }

    public void breakpointAlcanzado(FicheroJava f, int lineaCodigoActual) {
        this.ventanaDepurador.mostrarFichero(f.getFichero());
        this.ventanaDepurador.se\u00f1alarLineaFichero(f.getFichero(), lineaCodigoActual);
        new ControladorMemoria(this.ventanaDepurador).crearArbolMemoria();
        this.ventanaDepurador.estadoEnDepuracion();
    }
}

