/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javatraceit.gui.depurador.DepuradorComponenteCambioEstadoNotifier;
import javatraceit.gui.depurador.FicherosJTabbedPane;
import javatraceit.gui.depurador.NuevoValorPrimitivoDialog;
import javatraceit.gui.depurador.PreferenciasUsuario;
import javatraceit.gui.depurador.PreferenciasUsuarioDialog;
import javatraceit.gui.depurador.controladores.ControladorGeneral;
import javatraceit.gui.depurador.controladores.UIDepurador;
import javatraceit.gui.depurador.editor.JTIEditor;
import javatraceit.gui.depurador.editor.JTIEditorNotifier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DepuradorComponente
extends JPanel
implements JTIEditorNotifier,
UIDepurador {
    JPanel menusPane = new JPanel();
    JSplitPane splitPaneHoriz = new JSplitPane();
    JSplitPane splitPaneVert = new JSplitPane();
    JScrollPane arbolScroll = new JScrollPane();
    JTree arbol = new JTree();
    JScrollPane consolaScroll = new JScrollPane();
    JTextPane consolaArea = new JTextPane();
    JToolBar jToolBar1 = new JToolBar();
    JFrame padre;
    FicherosJTabbedPane ficherosPane = new FicherosJTabbedPane(this.padre, this);
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel depuradorPane = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel consolaPanel = new JPanel();
    JTextField entradaConsola = new JTextField();
    public static final int ESTADO_NO_DEPURANDO = 1;
    public static final int ESTADO_DEPURANDO = 2;
    private int estado = 1;
    DepuradorComponenteCambioEstadoNotifier estadoNotifier;
    ControladorGeneral controlador = new ControladorGeneral(this);
    public Action abrirAction = new AbrirAction();
    public Action nuevoFicheroAction = new NuevoFicheroAction();
    public Action cerrarAction = new CerrarAction();
    public Action guardarAction = new GuardarAction();
    public Action guardarComoAction = new GuardarComoAction();
    public Action compilarAction = new CompilarAction();
    public Action preferenciasAction = new PreferenciasAction();
    public Action lanzarAction = new LanzarAction();
    public Action detenerAction = new DetenerAction();
    public Action continuarAction = new ContinuarAction();
    public Action stepOverAction = new StepOverAction();
    public Action stepIntoAction = new StepIntoAction();
    public Action stepOutAction = new StepOutAction();
    public Action toggleBreakpointAction = new ToggleBreakpointAction();
    public Action copiarAction = new CopiarAction();
    public Action pegarAction = new PegarAction();
    public Action cortarAction = new CortarAction();
    public Action undoAction = new UndoAction();
    static /* synthetic */ Class class$javatraceit$gui$depurador$DepuradorComponente;

    public int getEstado() {
        return this.estado;
    }

    public void setEstadoNotifier(DepuradorComponenteCambioEstadoNotifier notifier) {
        this.estadoNotifier = notifier;
    }

    public void setArbolMemoria(JTree nuevoArbol) {
        this.arbol = nuevoArbol;
        this.arbolScroll.setViewportView(this.arbol);
    }

    public String getUnNuevoValor() {
        NuevoValorPrimitivoDialog dialogo = new NuevoValorPrimitivoDialog(this.padre, "Introduce un valor nuevo...", true);
        dialogo.setVisible(true);
        dialogo.setVisible(false);
        String resultado = dialogo.getValor();
        dialogo.dispose();
        return resultado;
    }

    public Vector getFicherosAbiertos() {
        Vector<File> resultado = new Vector<File>();
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            JTIEditor doc = this.ficherosPane.getJTIEditor(i);
            if (doc.getFichero() != null) {
                resultado.add(doc.getFichero());
            }
            ++i;
        }
        return resultado;
    }

    public void mostrarFichero(File fichero) {
        if (fichero == null) {
            this.ficherosPane.nuevoDocumento();
            this.guardarComoAction.setEnabled(true);
            this.cerrarAction.setEnabled(true);
        } else if (this.ficherosPane.indexFichero(fichero) == -1) {
            this.ficherosPane.abrirDocumento(fichero);
        } else {
            this.ficherosPane.setSelectedIndex(this.ficherosPane.indexFichero(fichero));
        }
        this.copiarAction.setEnabled(true);
        this.pegarAction.setEnabled(true);
        this.cortarAction.setEnabled(true);
        this.undoAction.setEnabled(true);
    }

    public void se\u00f1alarLineaFichero(File fichero, int linea) {
        int pos = this.ficherosPane.indexFichero(fichero);
        if (pos != -1) {
            this.ficherosPane.getJTIEditor(pos).destacarLinea(linea);
        }
    }

    public void mostrarError(String texto) {
        JOptionPane.showMessageDialog(this, texto, "Error", 0);
    }

    public void mostrarAdvertencia(String texto) {
        JOptionPane.showMessageDialog(this, texto, "Advertencia", 2);
    }

    public void mostrarInfoCompilacion(String texto) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, "Monospaced");
        StyleConstants.setForeground(set, Color.black);
        StyleConstants.setFontSize(set, 12);
        try {
            this.consolaArea.getDocument().insertString(this.consolaArea.getDocument().getLength(), texto + "\n", set);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.consolaArea.setCaretPosition(this.consolaArea.getDocument().getLength());
    }

    public void mostrarSalidaConsola(String texto) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, "Monospaced");
        StyleConstants.setFontSize(set, 12);
        StyleConstants.setForeground(set, new Color(0, 200, 0));
        try {
            this.consolaArea.getDocument().insertString(this.consolaArea.getDocument().getLength(), texto, set);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.consolaArea.setCaretPosition(this.consolaArea.getDocument().getLength());
    }

    public void mostrarSalidaExcepciones(String texto) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, "Monospaced");
        StyleConstants.setForeground(set, Color.red);
        StyleConstants.setBold(set, true);
        StyleConstants.setFontSize(set, 12);
        try {
            this.consolaArea.getDocument().insertString(this.consolaArea.getDocument().getLength(), texto, set);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.consolaArea.setCaretPosition(this.consolaArea.getDocument().getLength());
    }

    public void guardarFichero(File f) {
        block2: {
            int pos = this.ficherosPane.indexFichero(f);
            if (pos == -1) break block2;
            try {
                this.ficherosPane.guardarDocumento(pos);
            }
            catch (Exception ex) {
                this.mostrarError("Se produjo un error grave al guardar " + f + " (" + ex + ")");
            }
        }
    }

    public void guardarComo(File f) {
        try {
            this.ficherosPane.guardarDocumentoSeleccionadoComo(f);
            this.ficherosPane.setTitleAt(this.ficherosPane.getSelectedIndex(), f.getName());
        }
        catch (Exception ex) {
            this.mostrarError("Se produjo un error grave al guardar " + f + " (" + ex + ")");
        }
    }

    public void guardarTodos() {
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            try {
                this.ficherosPane.guardarTodo();
            }
            catch (Exception ex) {
                this.mostrarError("Se produjo un error grave al guardar los ficheros (" + ex + ")");
            }
            ++i;
        }
    }

    public boolean cerrarTodos() {
        while (this.ficherosPane.getComponentCount() > 0) {
            int anterior = this.ficherosPane.getComponentCount();
            this.cerrarFichero(this.ficherosPane.getJTIEditor(0).getFichero());
            if (anterior != this.ficherosPane.getComponentCount()) continue;
            return false;
        }
        return true;
    }

    public void cerrarFichero(File f) {
        int respuesta;
        int pos = this.ficherosPane.indexFichero(f);
        if (pos != -1) {
            if (this.ficherosPane.getJTIEditor(pos).getModificado()) {
                respuesta = JOptionPane.showConfirmDialog(this, "\u00bfGuardar los cambios?", "Guardar", 1);
                switch (respuesta) {
                    case 0: {
                        this.guardarFichero(f);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            this.ficherosPane.remove(pos);
            if (PreferenciasUsuario.getPreferenciasUsuario().getFicheroMain() != null && PreferenciasUsuario.getPreferenciasUsuario().getFicheroMain().equals(f)) {
                PreferenciasUsuario.getPreferenciasUsuario().setFicheroMain(null);
            }
        } else {
            if (this.ficherosPane.getJTIEditor(this.ficherosPane.getSelectedIndex()).getModificado()) {
                respuesta = JOptionPane.showConfirmDialog(this, "\u00bfGuardar los cambios?", "Guardar", 1);
                switch (respuesta) {
                    case 0: {
                        this.guardarComoAction.actionPerformed(null);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            this.ficherosPane.remove(this.ficherosPane.getSelectedIndex());
        }
        if (this.ficherosPane.getComponentCount() == 0) {
            this.estadoSinFicheros();
            this.copiarAction.setEnabled(false);
            this.pegarAction.setEnabled(false);
            this.cortarAction.setEnabled(false);
            this.undoAction.setEnabled(false);
        } else {
            boolean todosSinNombre = true;
            int i = 0;
            while (i < this.ficherosPane.getComponentCount()) {
                if (this.ficherosPane.getJTIEditor(i).getFichero() != null) {
                    todosSinNombre = false;
                    break;
                }
                ++i;
            }
            if (todosSinNombre) {
                this.estadoSinFicheros();
            }
        }
    }

    public String getClassPathUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().getClasspath();
    }

    public String getJDKHomeUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().getJdkHome();
    }

    public String getParametrosUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().getParametros();
    }

    public File getFicheroMain() {
        return PreferenciasUsuario.getPreferenciasUsuario().getFicheroMain();
    }

    public int getModoAplicacion() {
        return PreferenciasUsuario.getPreferenciasUsuario().MODO;
    }

    public int getAppletAncho() {
        return PreferenciasUsuario.getPreferenciasUsuario().getAppletAncho();
    }

    public int getAppletAlto() {
        return PreferenciasUsuario.getPreferenciasUsuario().getAppletAlto();
    }

    public void a\u00f1adidoBreakpoint(File fichero, int linea) {
        this.controlador.nuevoBreakpoint(fichero, linea);
        System.out.println("a\u00f1adido breakpoint: " + fichero + ": " + linea);
    }

    public void sacadoBreakpoint(File fichero, int linea) {
        this.controlador.sacarBreakpoint(fichero, linea);
        System.out.println("sacado breakpoint: " + fichero + ": " + linea);
    }

    public void modificado(File f) {
    }

    public DepuradorComponente(JFrame padre) {
        this.padre = padre;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DepuradorComponente(String parametroFicheroAbrir, JFrame padre) {
        this(padre);
        this.controlador.abrirFichero(new File(parametroFicheroAbrir));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.consolaPanel.setLayout(new BorderLayout());
        this.consolaArea.setDocument(new DefaultStyledDocument());
        this.arbolScroll.setDoubleBuffered(true);
        this.arbolScroll.setMinimumSize(new Dimension(0, 0));
        this.depuradorPane.setLayout(this.borderLayout2);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.jToolBar1.add(this.nuevoFicheroAction);
        this.jToolBar1.add(this.abrirAction);
        this.jToolBar1.add(this.guardarAction);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.lanzarAction);
        this.jToolBar1.add(this.detenerAction);
        this.jToolBar1.add(this.continuarAction);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.stepOverAction);
        this.jToolBar1.add(this.stepIntoAction);
        this.jToolBar1.add(this.stepOutAction);
        this.depuradorPane.add((Component)this.jToolBar1, "North");
        this.consolaScroll.setPreferredSize(new Dimension(0, 100));
        this.consolaScroll.setViewportView(this.consolaArea);
        this.depuradorPane.add((Component)this.splitPaneHoriz, "Center");
        this.add((Component)this.depuradorPane, "Center");
        this.splitPaneVert.setOrientation(1);
        this.splitPaneVert.setLeftComponent(this.arbolScroll);
        this.splitPaneVert.setResizeWeight(0.2);
        this.splitPaneVert.setRightComponent(this.ficherosPane);
        this.splitPaneVert.setDividerLocation(150);
        this.splitPaneVert.setContinuousLayout(true);
        this.splitPaneHoriz.setResizeWeight(1.0);
        this.splitPaneHoriz.setDividerLocation(375);
        this.splitPaneHoriz.setOrientation(0);
        this.splitPaneHoriz.setTopComponent(this.splitPaneVert);
        this.splitPaneHoriz.setContinuousLayout(true);
        this.consolaPanel.add((Component)this.consolaScroll, "Center");
        this.consolaPanel.add((Component)this.entradaConsola, "South");
        this.entradaConsola.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (DepuradorComponente.this.entradaConsola.isEditable()) {
                    if (e.getKeyCode() == 10) {
                        String entrada = DepuradorComponente.this.entradaConsola.getText() + "\n";
                        DepuradorComponente.this.controlador.entradaConsola(entrada.getBytes());
                        SimpleAttributeSet set = new SimpleAttributeSet();
                        StyleConstants.setFontFamily(set, "Monospaced");
                        StyleConstants.setFontSize(set, 12);
                        StyleConstants.setForeground(set, new Color(200, 200, 200));
                        try {
                            DepuradorComponente.this.consolaArea.getDocument().insertString(DepuradorComponente.this.consolaArea.getDocument().getLength(), DepuradorComponente.this.entradaConsola.getText() + "\n", set);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        DepuradorComponente.this.consolaArea.setCaretPosition(DepuradorComponente.this.consolaArea.getDocument().getLength());
                        DepuradorComponente.this.entradaConsola.setText("");
                    }
                }
            }
        });
        this.splitPaneHoriz.setBottomComponent(this.consolaPanel);
        this.splitPaneHoriz.setOneTouchExpandable(true);
        this.consolaScroll.setSize(new Dimension(0, 100));
        this.arbol = new JTree(new Vector());
        this.arbolScroll.setViewportView(this.arbol);
        this.estadoInicial();
        JLabel logo_depurador = new JLabel();
        JPanel panelLogo = new JPanel();
        panelLogo.setLayout(new BorderLayout());
        panelLogo.setBackground(new Color(0x666699));
        panelLogo.setOpaque(true);
        ImageIcon icono = new ImageIcon(this.getClass().getResource("iconos/logo.gif"));
        logo_depurador.setIcon(icono);
        logo_depurador.setBackground(Color.white);
        logo_depurador.setPreferredSize(new Dimension(300, 35));
        panelLogo.add((Component)logo_depurador, "South");
        this.add((Component)panelLogo, "South");
        this.splitPaneHoriz.setInputMap(1, null);
        this.splitPaneVert.setInputMap(1, null);
    }

    void estadoInicial() {
        this.compilarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.lanzarAction.setEnabled(false);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.toggleBreakpointAction.setEnabled(false);
        this.copiarAction.setEnabled(false);
        this.cortarAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.pegarAction.setEnabled(false);
        this.entradaConsola.setBackground(Color.gray);
        this.entradaConsola.setEditable(false);
    }

    void estadoSinFicheros() {
        this.compilarAction.setEnabled(false);
        this.lanzarAction.setEnabled(false);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.toggleBreakpointAction.setEnabled(false);
    }

    public void estadoConFicheros() {
        this.compilarAction.setEnabled(true);
        this.lanzarAction.setEnabled(true);
        this.guardarAction.setEnabled(true);
        this.guardarComoAction.setEnabled(true);
        this.cerrarAction.setEnabled(true);
        this.toggleBreakpointAction.setEnabled(true);
    }

    public void estadoEnDepuracion() {
        this.stepOverAction.setEnabled(true);
        this.stepIntoAction.setEnabled(true);
        this.stepOutAction.setEnabled(true);
        this.detenerAction.setEnabled(true);
        this.continuarAction.setEnabled(true);
        this.nuevoFicheroAction.setEnabled(false);
        this.abrirAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.lanzarAction.setEnabled(false);
        this.entradaConsola.setBackground(Color.white);
        this.entradaConsola.setEditable(true);
        this.copiarAction.setEnabled(false);
        this.cortarAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.pegarAction.setEnabled(false);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(false);
            ++i;
        }
        if (this.estado == 1) {
            this.estado = 2;
            if (this.estadoNotifier != null) {
                this.estadoNotifier.nuevoEstado(this.estado);
            }
        }
    }

    public void estadoEnEjecucion() {
        this.nuevoFicheroAction.setEnabled(false);
        this.abrirAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(true);
        this.continuarAction.setEnabled(false);
        this.preferenciasAction.setEnabled(false);
        this.arbolScroll.setViewportView(new JLabel());
        this.lanzarAction.setEnabled(false);
        this.compilarAction.setEnabled(false);
        this.consolaArea.setBackground(Color.black);
        this.entradaConsola.setBackground(Color.white);
        this.entradaConsola.setEditable(true);
        this.copiarAction.setEnabled(false);
        this.cortarAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.pegarAction.setEnabled(false);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(false);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i2).noDestacarLineaCodigo();
            ++i2;
        }
        this.arbolScroll.setEnabled(false);
        if (this.estado == 1) {
            this.estado = 2;
            this.consolaArea.setText("");
            if (this.estadoNotifier != null) {
                this.estadoNotifier.nuevoEstado(this.estado);
            }
        }
    }

    public void estadoSinDepuracion() {
        this.nuevoFicheroAction.setEnabled(true);
        this.abrirAction.setEnabled(true);
        this.guardarAction.setEnabled(true);
        this.guardarComoAction.setEnabled(true);
        this.cerrarAction.setEnabled(true);
        this.compilarAction.setEnabled(true);
        this.lanzarAction.setEnabled(true);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.preferenciasAction.setEnabled(true);
        this.consolaArea.setBackground(Color.white);
        this.entradaConsola.setBackground(Color.gray);
        this.entradaConsola.setEditable(false);
        this.copiarAction.setEnabled(true);
        this.cortarAction.setEnabled(true);
        this.undoAction.setEnabled(true);
        this.pegarAction.setEnabled(true);
        this.arbol = new JTree(new Vector());
        this.arbolScroll.setViewportView(this.arbol);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(true);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i2).noDestacarLineaCodigo();
            ++i2;
        }
        if (this.estado == 2) {
            this.estado = 1;
            if (this.estadoNotifier != null) {
                this.estadoNotifier.nuevoEstado(this.estado);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ToggleBreakpointAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/togglebreakpoint.gif"));

        public ToggleBreakpointAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "colocar / descartar breakpoint");
            this.putValue("ShortDescription", "colocar / descartar breakpoint");
        }

        public void actionPerformed(ActionEvent ev) {
            if (DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero() == null) {
                DepuradorComponente.this.mostrarAdvertencia("El fichero debe tener un nombre para poder establecer un breakpoint. Gu\u00e1rdelo primero.");
                return;
            }
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().toggleBreakpoint(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().lineaActual());
        }
    }

    class UndoAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Undo16.gif"));

        public UndoAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.putValue("Name", "deshacer");
            this.putValue("ShortDescription", "deshacer");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().undo();
        }
    }

    class CortarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Cut16.gif"));

        public CortarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.putValue("Name", "cortar");
            this.putValue("ShortDescription", "cortar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().cut();
        }
    }

    class PegarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Paste16.gif"));

        public PegarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
            this.putValue("Name", "pegar");
            this.putValue("ShortDescription", "pegar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().paste();
        }
    }

    class CopiarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Copy16.gif"));

        public CopiarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
            this.putValue("Name", "copiar");
            this.putValue("ShortDescription", "copiar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().copy();
        }
    }

    class StepOutAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_out.gif"));

        public StepOutAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step out");
            this.putValue("ShortDescription", "step out");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepOut();
        }
    }

    class StepIntoAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_into.gif"));

        public StepIntoAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F7"));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step into");
            this.putValue("ShortDescription", "step into");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepInto();
        }
    }

    class StepOverAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_over.gif"));

        public StepOverAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F8"));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step over");
            this.putValue("ShortDescription", "step over");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepOver();
        }
    }

    class ContinuarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Play16.gif"));

        public ContinuarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "continuar ejecuci\u00f3n");
            this.putValue("ShortDescription", "continuar ejecuci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.continuarEjecucion();
        }
    }

    class DetenerAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Stop16.gif"));

        public DetenerAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 2));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "detener depuraci\u00f3n");
            this.putValue("ShortDescription", "detener depuraci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.detenerDepuracion();
        }
    }

    class LanzarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/lanzar16.gif"));

        public LanzarAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F9"));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "lanzar depuraci\u00f3n");
            this.putValue("ShortDescription", "lanzar depuraci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            if (PreferenciasUsuario.getPreferenciasUsuario().getFicheroMain() == null) {
                DepuradorComponente.this.preferenciasAction.actionPerformed(null);
            }
            DepuradorComponente.this.controlador.lanzarDepuracion();
        }
    }

    class PreferenciasAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Preferences16.gif"));

        public PreferenciasAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "preferencias...");
            this.putValue("ShortDescription", "preferencias...");
        }

        public void actionPerformed(ActionEvent ev) {
            PreferenciasUsuarioDialog ventana = new PreferenciasUsuarioDialog((Frame)DepuradorComponente.this.padre, "Preferencias...", DepuradorComponente.this.getFicherosAbiertos(), true);
            ventana.setVisible(true);
            String cp = PreferenciasUsuario.getPreferenciasUsuario().getClasspath();
            String jdkHome = PreferenciasUsuario.getPreferenciasUsuario().getJdkHome();
            String param = PreferenciasUsuario.getPreferenciasUsuario().getParametros();
            int modo = PreferenciasUsuario.getPreferenciasUsuario().MODO;
            int applet_alto = PreferenciasUsuario.getPreferenciasUsuario().getAppletAlto();
            int applet_ancho = PreferenciasUsuario.getPreferenciasUsuario().getAppletAncho();
        }
    }

    class CompilarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/compilar16.gif"));

        public CompilarAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 8));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "compilar");
            this.putValue("ShortDescription", "compilar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.compilarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
        }
    }

    class GuardarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/save16.gif"));

        public GuardarAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            this.putValue("Name", "guardar");
            this.putValue("ShortDescription", "guardar");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            if (DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero() == null) {
                DepuradorComponente.this.guardarComoAction.actionPerformed(null);
            } else {
                DepuradorComponente.this.controlador.guardarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
            }
        }
    }

    class CerrarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/cerrar16.gif"));

        public CerrarAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 8));
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "cerrar");
            this.putValue("ShortDescription", "cerrar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.cerrarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
        }
    }

    class GuardarComoAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/SaveAs16.gif"));

        public GuardarComoAction() {
            this.putValue("Name", "guardar como...");
            this.putValue("ShortDescription", "guardar como...");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            JFileChooser chooser = new JFileChooser();
            if (PreferenciasUsuario.getPreferenciasUsuario().getDirectorioActual() != null) {
                chooser = new JFileChooser(PreferenciasUsuario.getPreferenciasUsuario().getDirectorioActual());
            }
            chooser.setFileFilter(new FileFilter(this){
                private final /* synthetic */ GuardarComoAction this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".java") || f.isDirectory();
                }

                public String getDescription() {
                    return "Ficheros fuente Java";
                }
            });
            int decision = chooser.showSaveDialog(DepuradorComponente.this);
            if (decision != 0) {
                return;
            }
            File fichero = chooser.getSelectedFile();
            if (fichero.getName().indexOf(".") == -1) {
                fichero = new File(fichero.getAbsolutePath() + ".java");
            }
            PreferenciasUsuario.getPreferenciasUsuario().setDirectorioActual(fichero.getParentFile());
            if (fichero != null) {
                DepuradorComponente.this.controlador.guardarComo(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero(), fichero);
            }
        }
    }

    class NuevoFicheroAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Add16.gif"));

        public NuevoFicheroAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
            this.putValue("Name", "nuevo");
            this.putValue("ShortDescription", "nuevo");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.nuevoFichero();
        }
    }

    class AbrirAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Open16.gif"));
        private JFileChooser chooser;

        public AbrirAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
            this.putValue("Name", "abrir fichero...");
            this.putValue("ShortDescription", "abrir fichero...");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            this.chooser.setFileFilter(new FileFilter(this){
                private final /* synthetic */ AbrirAction this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".java") || f.isDirectory();
                }

                public String getDescription() {
                    return "Ficheros fuente Java";
                }
            });
            int decision = this.chooser.showOpenDialog(DepuradorComponente.this);
            if (decision != 0) {
                return;
            }
            File fichero = this.chooser.getSelectedFile();
            PreferenciasUsuario.getPreferenciasUsuario().setDirectorioActual(fichero.getParentFile());
            if (fichero != null) {
                DepuradorComponente.this.controlador.abrirFichero(fichero);
            }
        }
    }
}

