/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.memoria;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import java.util.Iterator;
import java.util.Vector;
import javatraceit.depurador.memoria.ComponenteMemoria;
import javatraceit.depurador.memoria.ComponenteMemoriaArray;
import javatraceit.depurador.memoria.ComponenteMemoriaExpansible;
import javatraceit.depurador.memoria.ComponenteMemoriaObjeto;
import javatraceit.depurador.memoria.ComponenteMemoriaPrimitivo;

public class ComponenteMemoriaStackFrame
extends ComponenteMemoria
implements ComponenteMemoriaExpansible {
    private String nombreCache = "";

    public ComponenteMemoriaStackFrame(StackFrame f) {
        super(f);
    }

    public StackFrame getStackFrame() {
        return (StackFrame)this.getMirror();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector expandir() {
        StackFrame stackFrame = this.getStackFrame();
        Vector<ComponenteMemoria> resultado = new Vector<ComponenteMemoria>();
        try {
            Iterator variablesIterador;
            ObjectReference thisObject = this.getStackFrame().thisObject();
            if (thisObject != null) {
                ComponenteMemoriaObjeto thisNodo = new ComponenteMemoriaObjeto(this.getStackFrame().location().method().declaringType(), this.getStackFrame().thisObject(), "this");
                resultado.add(thisNodo);
            }
            if ((variablesIterador = stackFrame.visibleVariables().iterator()) == null) {
                return resultado;
            }
            while (true) {
                Type tipo;
                if (!variablesIterador.hasNext()) {
                    return resultado;
                }
                LocalVariable variableLocal = (LocalVariable)variablesIterador.next();
                try {
                    tipo = variableLocal.type();
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    System.out.println("[ComponenteMemoriaStackFrame: no se visualiza la variable " + variableLocal.name() + " por no estar su clase cargada]");
                    continue;
                }
                if (tipo instanceof ReferenceType) {
                    if (tipo instanceof ArrayType) {
                        ComponenteMemoriaArray componenteMemoriaArray = new ComponenteMemoriaArray((ArrayType)tipo, (ArrayReference)stackFrame.getValue(variableLocal), variableLocal.name());
                        resultado.add(componenteMemoriaArray);
                        continue;
                    }
                    ComponenteMemoriaObjeto componenteMemoriaObjeto = new ComponenteMemoriaObjeto((ReferenceType)tipo, (ObjectReference)this.getStackFrame().getValue(variableLocal), variableLocal.name());
                    resultado.add(componenteMemoriaObjeto);
                    continue;
                }
                if (!(tipo instanceof PrimitiveType)) continue;
                ComponenteMemoriaPrimitivo componenteMemoriaPrimitivo = new ComponenteMemoriaPrimitivo((PrimitiveType)tipo, this.getStackFrame(), variableLocal);
                System.out.println("metiendo el primitivo" + componenteMemoriaPrimitivo);
                resultado.add(componenteMemoriaPrimitivo);
            }
        }
        catch (AbsentInformationException ex) {
            System.out.println("CoponenteMemoriaStackFrame: No existe informaci\u00f3n. Compile con -g.");
            return new Vector();
        }
        catch (InvalidStackFrameException ex) {
            ex.printStackTrace();
            return new Vector();
        }
    }

    public String toString() {
        if (!this.nombreCache.equals("")) {
            return this.nombreCache;
        }
        try {
            String nombreClase = this.getStackFrame().location().method().declaringType().name();
            this.nombreCache = nombreClase + "." + this.getStackFrame().location().method().name() + " :" + this.getStackFrame().location().lineNumber();
            return this.nombreCache;
        }
        catch (InvalidStackFrameException ex) {
            System.out.println("ComponenteMemoriaStackFrame: Excepcion en toString");
            return "";
        }
    }
}

