/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.manejoDepuracion;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.VMEventHandler;
import javatraceit.depurador.VMEventNotifier;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.manejoDepuracion.AplicacionEjecutandoseException;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.depurador.manejoDepuracion.LanzarDepuracionException;
import javatraceit.depurador.manejoDepuracion.NoEnDepuracionException;
import javatraceit.depurador.manejoDepuracion.UIConsolaNotifier;
import javatraceit.depurador.manejoDepuracion.UIManejoDepuracionNotifier;

public class ManejadorDepurador
implements VMEventNotifier {
    private long idProfilerThread = -1L;
    private HiloEscuchaConsola hiloConsola;
    private HiloEscuchaExcepciones hiloExcepciones;
    private UIConsolaNotifier elUIConsolaNotifier;
    private UIManejoDepuracionNotifier elUIManejoDepuracionNotifier;
    private Object lock = new Object();
    private static ManejadorDepurador referenciaAlSingleton;

    public static ManejadorDepurador getManejadorDepurador() {
        if (referenciaAlSingleton == null) {
            referenciaAlSingleton = new ManejadorDepurador();
        }
        return referenciaAlSingleton;
    }

    public void setUIConsolaNotifier(UIConsolaNotifier notifier) {
        this.elUIConsolaNotifier = notifier;
    }

    public void setManejoDepuracionNotifier(UIManejoDepuracionNotifier notifier) {
        this.elUIManejoDepuracionNotifier = notifier;
    }

    public ManejadorDepurador() {
        VMEventHandler.getVMEventHandler().addEventNotifier(this);
    }

    public void lanzarDepuracion() throws LanzarDepuracionException {
        if (DepuradorParametros.getDepuradorParametros().getModo() == 2) {
            this.lanzarDepuracionApplet();
            return;
        }
        FicheroJava ficheroMain = DepuradorParametros.getDepuradorParametros().getFicheroMain();
        if (ficheroMain == null || !ManejadorFicheros.getManejadorFicheros().estaAbierto(ficheroMain) || !ficheroMain.getFichero().exists()) {
            throw new LanzarDepuracionException("Fichero main no se encuentra, o no se ha indicado");
        }
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        Map losArgumentos = manager.defaultConnector().defaultArguments();
        Vector clases = ficheroMain.getClases();
        if (clases.size() == 0) {
            throw new LanzarDepuracionException("No hay ninguna clase en el fichero main. Es posible que no se haya compilado correctamente.");
        }
        String unaClase = (String)clases.elementAt(0);
        String nombrePaquete = "";
        if (unaClase.indexOf(".") != -1) {
            nombrePaquete = unaClase.substring(0, unaClase.lastIndexOf("."));
            System.out.println("nombre paquete main: " + nombrePaquete);
        }
        String nombreClaseMain = (nombrePaquete.length() > 0 ? nombrePaquete + "." : "") + ficheroMain.getFichero().getName().substring(0, ficheroMain.getFichero().getName().lastIndexOf("."));
        ((Connector.Argument)losArgumentos.get("home")).setValue(DepuradorParametros.getDepuradorParametros().getJdkHome());
        ((Connector.Argument)losArgumentos.get("main")).setValue(nombreClaseMain + (DepuradorParametros.getDepuradorParametros().getParametros().length() > 0 ? " " + DepuradorParametros.getDepuradorParametros().getParametros() : ""));
        File ficheroProfiler = new File(DepuradorParametros.getDepuradorParametros().getJdkHome() + File.separator + "jre" + File.separator + "bin" + File.separator + "jtiprof.dll");
        try {
            try {
                ((Connector.Argument)losArgumentos.get("options")).setValue(" -Xrunjtiprof -cp \"" + ficheroMain.getFichero().getParent() + File.pathSeparator + DepuradorParametros.getDepuradorParametros().getClasspath() + "\"");
                VirtualMachine vm = manager.defaultConnector().launch(losArgumentos);
                this.hiloConsola = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getInputStream());
                this.hiloExcepciones = new HiloEscuchaExcepciones(this.elUIConsolaNotifier, vm.process().getErrorStream());
                vm.setDebugTraceMode(0);
                EntornoDepurador.getEntornoDepurador().setVirtualMachine(vm);
                VMEventHandler.getVMEventHandler().start();
            }
            catch (VMStartException ex) {
                ((Connector.Argument)losArgumentos.get("options")).setValue("-cp \"" + ficheroMain.getFichero().getParent() + File.pathSeparator + DepuradorParametros.getDepuradorParametros().getClasspath() + "\"");
                VirtualMachine vm = manager.defaultConnector().launch(losArgumentos);
                this.hiloConsola = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getInputStream());
                this.hiloExcepciones = new HiloEscuchaExcepciones(this.elUIConsolaNotifier, vm.process().getErrorStream());
                vm.setDebugTraceMode(0);
                EntornoDepurador.getEntornoDepurador().setVirtualMachine(vm);
                VMEventHandler.getVMEventHandler().start();
            }
        }
        catch (IOException ex) {
            throw new LanzarDepuracionException("Imposible comenzar depuraci\u00f3n, no se encuentra java. Revise JDK Home");
        }
        catch (VMStartException ex) {
            throw new LanzarDepuracionException("Imposible comenzar la depuracion. Se obtuvo: " + ex.toString());
        }
        catch (IllegalConnectorArgumentsException ex) {
            // empty catch block
        }
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
    }

    private void lanzarDepuracionApplet() throws LanzarDepuracionException {
        FicheroJava ficheroMain = DepuradorParametros.getDepuradorParametros().getFicheroMain();
        if (ficheroMain == null || !ManejadorFicheros.getManejadorFicheros().estaAbierto(ficheroMain) || !ficheroMain.getFichero().exists()) {
            throw new LanzarDepuracionException("Fichero main no se encuentra, o no se ha indicado");
        }
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        Iterator connectors = manager.attachingConnectors().iterator();
        while (connectors.hasNext()) {
            AttachingConnector connector = (AttachingConnector)connectors.next();
            if (!connector.transport().name().equals("dt_socket")) continue;
            Map args = connector.defaultArguments();
            ((Connector.Argument)args.get("hostname")).setValue("localhost");
            ((Connector.Argument)args.get("port")).setValue("3501");
            try {
                Vector clases = ficheroMain.getClases();
                String unaClase = (String)clases.elementAt(0);
                String nombrePaquete = "";
                if (unaClase.indexOf(".") != -1) {
                    nombrePaquete = unaClase.substring(0, unaClase.lastIndexOf("."));
                    System.out.println("nombre paquete main: " + nombrePaquete);
                }
                String nombreClaseMain = (nombrePaquete.length() > 0 ? nombrePaquete + "." : "") + ficheroMain.getFichero().getName().substring(0, ficheroMain.getFichero().getName().lastIndexOf("."));
                int profundidad = 0;
                int i = 0;
                while (i < nombreClaseMain.length()) {
                    if (nombreClaseMain.charAt(i) == '.') {
                        ++profundidad;
                    }
                    ++i;
                }
                String haciaAtras = "";
                int i2 = 0;
                while (i2 < profundidad) {
                    haciaAtras = haciaAtras + File.separator + "..";
                    ++i2;
                }
                FileOutputStream autogenFile = new FileOutputStream(ficheroMain.getFichero().getParent() + haciaAtras + File.separator + "autogen.html");
                System.out.println("fichero: " + autogenFile);
                PrintStream escritor = new PrintStream(autogenFile);
                int alto = DepuradorParametros.getDepuradorParametros().getAppletAlto();
                int ancho = DepuradorParametros.getDepuradorParametros().getAppletAncho();
                escritor.print("<html>\n<body>\n<applet code=\"" + nombreClaseMain + "\" width=\"" + ancho + "\" height=\"" + alto + "\">\n");
                StringTokenizer tk = new StringTokenizer(DepuradorParametros.getDepuradorParametros().getParametros());
                while (tk.hasMoreTokens()) {
                    String parametro = tk.nextToken();
                    String valor = "";
                    if (tk.hasMoreTokens()) {
                        valor = tk.nextToken();
                    }
                    escritor.print("<param name=\"" + parametro + "\" value=\"" + valor + "\">\n");
                }
                escritor.print("</applet>\n</body>\n</html>\n");
                escritor.flush();
                escritor.close();
                String[] array = new String[]{DepuradorParametros.getDepuradorParametros().getJdkHome() + File.separator + "bin" + File.separator + "appletviewer", "-J-Xdebug", "-J-Xnoagent", "-J-Djava.compiler=NONE", "-J-Xrunjdwp:transport=dt_socket,server=y,address=3501,suspend=y", "-J-Xrunjtiprof", "file:///" + ficheroMain.getFichero().getParent() + haciaAtras + File.separator + "autogen.html"};
                Process proceso = null;
                try {
                    proceso = Runtime.getRuntime().exec(array);
                }
                catch (IOException e) {
                    throw new LanzarDepuracionException("No se pudo lanzar appletviewer. Asegurese de que lo tiene disponible en su JDKhome/bin.");
                }
                VirtualMachine vm = connector.attach(args);
                vm.setDebugTraceMode(0);
                EntornoDepurador.getEntornoDepurador().setVirtualMachine(vm);
                VMEventHandler.getVMEventHandler().attached();
                VMEventHandler.getVMEventHandler().start();
                EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
                this.hiloConsola = new HiloEscuchaConsola(this.elUIConsolaNotifier, proceso.getInputStream());
                this.hiloExcepciones = new HiloEscuchaExcepciones(this.elUIConsolaNotifier, proceso.getErrorStream());
                vm.resume();
            }
            catch (IOException ex) {
                throw new LanzarDepuracionException("Imposible lanzar la depuraci\u00f3n del Applet, se produjo un error de E/S: " + ex.getMessage());
            }
            catch (IllegalConnectorArgumentsException ex) {
                throw new LanzarDepuracionException("Imposible lanzar la depuraci\u00f3n del Applet.");
            }
        }
    }

    public void detenerDepuracion() throws NoEnDepuracionException {
        int estado = EntornoDepurador.getEntornoDepurador().getEstadoActual();
        if (estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO && estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO) {
            throw new NoEnDepuracionException("No se esta depurando.");
        }
        System.out.println("[Manejador Depurador]: Deteniendo depuracion...");
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().exit(0);
    }

    public void continuarEjecucion() throws AplicacionEjecutandoseException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO) {
            throw new AplicacionEjecutandoseException("La aplicaci\u00f3n ya se est\u00e1 ejecutando");
        }
        System.out.println("Generando un resume...");
        try {
            EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().deleteEventRequests(EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().stepRequests());
        }
        catch (Exception ex) {
            // empty catch block
        }
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
    }

    public void entradaConsola(byte[] b) throws NoEnDepuracionException {
        int estado = EntornoDepurador.getEntornoDepurador().getEstadoActual();
        if (estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO && estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO) {
            throw new NoEnDepuracionException("no se puede introducir datos si no se depura");
        }
        try {
            EntornoDepurador.getEntornoDepurador().getVirtualMachine().process().getOutputStream().write(b);
            EntornoDepurador.getEntornoDepurador().getVirtualMachine().process().getOutputStream().flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void vmStartEvent(VMStartEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMStartEvent");
        this.elUIManejoDepuracionNotifier.depuracionLanzada();
    }

    public void vmDeathEvent(VMDeathEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMDeathEvent");
        this.finalizacionEvent(e);
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMDisconnectEvent");
        this.finalizacionEvent(e);
    }

    public void vmInterrupted() {
        System.out.println("ManejadorDepuracion: Recibido un VMInterruptedEvent");
        this.finalizacionEvent(null);
    }

    private void finalizacionEvent(Event e) {
        if (this.hiloConsola != null) {
            this.hiloConsola.stop();
        }
        if (this.hiloExcepciones != null) {
            this.hiloExcepciones.stop();
        }
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().NO_DEPURANDO);
        EntornoDepurador.getEntornoDepurador().eliminarVirtualMachine();
        this.elUIManejoDepuracionNotifier.depuracionFinalizada();
    }

    public void stepEvent(StepEvent e) {
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
    }

    public void breakpointEvent(BreakpointEvent e) {
    }

    public void threadStartEvent(ThreadStartEvent e) {
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    public void fieldWatchEvent(WatchpointEvent e) {
    }

    public void exceptionEvent(ExceptionEvent e) {
    }

    public void methodEntryEvent(MethodEntryEvent e) {
    }

    public void methodExitEvent(MethodExitEvent e) {
    }

    public void receivedEvent(Event event) {
    }

    class HiloEscuchaExcepciones
    implements Runnable {
        private UIConsolaNotifier userInterface = null;
        private InputStream reader = null;
        private Thread t;

        HiloEscuchaExcepciones(UIConsolaNotifier userInterface, InputStream reader) {
            this.userInterface = userInterface;
            this.reader = reader;
            this.t = new Thread((Runnable)this, "HiloEscuchaExcepciones");
            this.t.start();
        }

        public void stop() {
            try {
                this.reader = null;
            }
            catch (Exception ex) {
                System.out.println("exception en close");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    byte[] datos;
                    int leidos;
                    if ((leidos = this.reader.read(datos = new byte[100])) <= 0) {
                        continue;
                    }
                    Object object = ManejadorDepurador.this.lock;
                    synchronized (object) {
                        this.userInterface.nuevaSalidaExcepcion(new String(datos, 0, leidos));
                    }
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    class HiloEscuchaConsola
    implements Runnable {
        private UIConsolaNotifier userInterface = null;
        private InputStream reader = null;
        private Thread t;

        HiloEscuchaConsola(UIConsolaNotifier userInterface, InputStream reader) {
            this.userInterface = userInterface;
            this.reader = reader;
            this.t = new Thread((Runnable)this, "HiloEscuchaConsola");
            this.t.start();
        }

        public void stop() {
            try {
                this.reader = null;
            }
            catch (Exception ex) {
                System.out.println("exception en close");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    byte[] datos;
                    int leidos;
                    if ((leidos = this.reader.read(datos = new byte[100])) <= 0) {
                        continue;
                    }
                    Object object = ManejadorDepurador.this.lock;
                    synchronized (object) {
                        this.userInterface.nuevaSalidaConsola(new String(datos, 0, leidos));
                    }
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }
}

