/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyDefaultTheme;
import de.muntjak.tinylookandfeel.controlpanel.ColorReference;
import de.muntjak.tinylookandfeel.controlpanel.ColoredFont;
import de.muntjak.tinylookandfeel.controlpanel.PSColorChooser;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import de.muntjak.tinylookandfeel.controlpanel.ToolButtonIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Position;

public class ControlPanel {
    private JFrame theFrame;
    private static final String WINDOW_TITLE = "TinyLaF 1.1 Controlpanel";
    private static final int PLAIN_FONT = 1;
    private static final int BOLD_FONT = 2;
    private static final int SPECIAL_FONT = 3;
    public static boolean isInstantiated = false;
    private String currentFileName;
    private ActionListener checkAction = new CheckAction();
    private ActionListener iconCheckAction = new IconCheckAction();
    private ChangeListener updateAction = new UpdateAction();
    private boolean resistUpdate = false;
    private JMenu themesMenu;
    private ActionListener selectThemeAction = new SelectThemeAction();
    private JTabbedPane mainTab;
    private JTabbedPane compTab;
    private JButton updateThemeButton;
    private JCheckBoxMenuItem customStyle;
    private FontPanel plainFontPanel;
    private FontPanel boldFontPanel;
    private FontPanel specialFontPanel;
    private JComboBox fontCombo;
    private JRadioButton isPlainFont;
    private JRadioButton isBoldFont;
    private ColoredFont[] selectedFont;
    private ExamplePanel examplePanel;
    private JButton exampleButton;
    private JButton exampleDisabledButton;
    private JToggleButton exampleToggleButton;
    private Icon buttonIcon;
    private JPopupMenu thePopup;
    private JInternalFrame internalFrame;
    private JInternalFrame palette;
    private JPopupMenu hsbPopup;
    private ButtonsCP buttonsCP;
    private ScrollsCP scrollsCP;
    private TabsCP tabsCP;
    private ComboCP comboCP;
    private MenuCP menuCP;
    private ListCP listCP;
    private SliderCP sliderCP;
    private SpinnerCP spinnerCP;
    private ProgressCP progressCP;
    private TextCP textCP;
    private TreeCP treeCP;
    private ToolCP toolCP;
    private TableCP tableCP;
    private FrameCP frameCP;
    private IconCP iconCP;
    private TipCP tipCP;
    private MiscCP miscCP;
    private JSlider vertSlider;
    private JSlider horzSlider;
    private HSBField selectedHSBField;
    private HSBField colorizeField;
    private HSBField mainField;
    private HSBField rollField;
    private HSBField backField;
    private HSBField frameField;
    private HSBField sub1Field;
    private HSBField sub2Field;
    private HSBField sub3Field;
    private HSBField sub4Field;
    private HSBField sub5Field;
    private HSBField sub6Field;
    private HSBField sub7Field;
    private HSBField sub8Field;
    private HSBField buttonNormalBg;
    private HSBField buttonRolloverBg;
    private HSBField buttonPressedBg;
    private HSBField buttonDisabledBg;
    private HSBField buttonBorder;
    private HSBField buttonDark;
    private HSBField buttonLight;
    private HSBField buttonRollover;
    private HSBField buttonDefault;
    private HSBField buttonCheck;
    private HSBField buttonCheckDisabled;
    private HSBField buttonDisabledBorder;
    private HSBField buttonDisabledDark;
    private HSBField buttonDisabledLight;
    private HSBField buttonDisabledFg;
    private HSBField checkDisabledFg;
    private HSBField radioDisabledFg;
    SpreadPanel buttonSpreadLight;
    SpreadPanel buttonSpreadLightDisabled;
    SpreadPanel buttonSpreadDark;
    SpreadPanel buttonSpreadDarkDisabled;
    private HSBField textBg;
    private HSBField textSelectedBg;
    private HSBField textDisabledBg;
    private HSBField textBorder;
    private HSBField textBorderDisabled;
    private HSBField textDark;
    private HSBField textDisabledDark;
    private HSBField textLight;
    private HSBField textDisabledLight;
    private BlackWhitePanel textText;
    private BlackWhitePanel textSelectedText;
    private HSBField comboBorder;
    private HSBField comboBorderDisabled;
    private HSBField comboSelectedBg;
    private HSBField comboDark;
    private HSBField comboDisabledDark;
    private HSBField comboLight;
    private HSBField comboDisabledLight;
    private HSBField comboArrowField;
    private HSBField comboArrowDisabled;
    private HSBField comboButt;
    private HSBField comboButtRollover;
    private HSBField comboButtPressed;
    private HSBField comboButtDisabled;
    private HSBField comboButtBorder;
    private HSBField comboButtDark;
    private HSBField comboButtLight;
    private HSBField comboButtBorderDisabled;
    private HSBField comboButtDarkDisabled;
    private HSBField comboButtLightDisabled;
    private BlackWhitePanel comboSelectedText;
    SpreadPanel comboSpreadLight;
    SpreadPanel comboSpreadLightDisabled;
    SpreadPanel comboSpreadDark;
    SpreadPanel comboSpreadDarkDisabled;
    private HSBField menuRolloverField;
    private HSBField menuSepDark;
    private HSBField menuSepLight;
    private HSBField menuBar;
    private HSBField menuItemRollover;
    private HSBField menuPopup;
    private HSBField menuBorder;
    private HSBField menuDark;
    private HSBField menuLight;
    private HSBField menuIcon;
    private HSBField menuIconRollover;
    private HSBField menuIconDisabled;
    private HSBField menuIconShadow;
    private BlackWhitePanel menuSelectedText;
    private HSBField listSelectedBg;
    private BlackWhitePanel listSelectedText;
    private HSBField tabNormalBg;
    private HSBField tabSelectedBg;
    private HSBField tabRoll;
    private HSBField tabBorder;
    private HSBField tabDark;
    private HSBField tabLight;
    private HSBField tabPaneBorder;
    private HSBField tabPaneDark;
    private HSBField tabPaneLight;
    private HSBField scrollThumbField;
    private HSBField scrollButtField;
    private HSBField scrollArrowField;
    private HSBField trackField;
    private HSBField scrollThumbRolloverBg;
    private HSBField scrollThumbPressedBg;
    private HSBField scrollThumbDisabledBg;
    private HSBField scrollButtRolloverBg;
    private HSBField scrollButtPressedBg;
    private HSBField scrollButtDisabledBg;
    private HSBField trackDisabled;
    private HSBField trackBorder;
    private HSBField trackBorderDisabled;
    private HSBField scrollArrowDisabled;
    private HSBField scrollGripDark;
    private HSBField scrollGripLight;
    private HSBField scrollPane;
    private HSBField scrollBorder;
    private HSBField scrollDark;
    private HSBField scrollLight;
    private HSBField scrollBorderDisabled;
    private HSBField scrollDarkDisabled;
    private HSBField scrollLightDisabled;
    SpreadPanel scrollSpreadLight;
    SpreadPanel scrollSpreadLightDisabled;
    SpreadPanel scrollSpreadDark;
    SpreadPanel scrollSpreadDarkDisabled;
    private HSBField sliderThumbRolloverBg;
    private HSBField sliderThumbPressedBg;
    private HSBField sliderThumbDisabledBg;
    private HSBField sliderBorder;
    private HSBField sliderDark;
    private HSBField sliderLight;
    private HSBField sliderThumbField;
    private HSBField sliderDisabledBorder;
    private HSBField sliderDisabledDark;
    private HSBField sliderDisabledLight;
    private HSBField sliderTrack;
    private HSBField sliderTrackBorder;
    private HSBField sliderTrackDark;
    private HSBField sliderTrackLight;
    private HSBField sliderTick;
    private HSBField sliderTickDisabled;
    private HSBField spinnerButtField;
    private HSBField spinnerArrowField;
    private HSBField spinnerButtRolloverBg;
    private HSBField spinnerButtPressedBg;
    private HSBField spinnerButtDisabledBg;
    private HSBField spinnerBorder;
    private HSBField spinnerDark;
    private HSBField spinnerLight;
    private HSBField spinnerArrowDisabled;
    private HSBField spinnerDisabledBorder;
    private HSBField spinnerDisabledDark;
    private HSBField spinnerDisabledLight;
    SpreadPanel spinnerSpreadLight;
    SpreadPanel spinnerSpreadLightDisabled;
    SpreadPanel spinnerSpreadDark;
    SpreadPanel spinnerSpreadDarkDisabled;
    private Timer progressTimer;
    private JProgressBar horzProgressBar;
    private JProgressBar vertProgressBar;
    private HSBField progressField;
    private HSBField progressTrack;
    private HSBField progressBorder;
    private HSBField progressDark;
    private HSBField progressLight;
    private HSBField progressSelectFore;
    private HSBField progressSelectBack;
    private HSBField treeBg;
    private HSBField treeTextBg;
    private HSBField treeSelectedBg;
    private BlackWhitePanel treeText;
    private BlackWhitePanel treeSelectedText;
    private HSBField toolBar;
    private HSBField toolBarDark;
    private HSBField toolBarLight;
    private HSBField toolButt;
    private HSBField toolButtRollover;
    private HSBField toolButtPressed;
    private HSBField toolBorder;
    private HSBField toolBorderPressed;
    private HSBField toolBorderSelected;
    private HSBField toolBorderDark;
    private HSBField toolBorderLight;
    private HSBField frameCaption;
    private HSBField frameCaptionDisabled;
    private HSBField frameBorder;
    private HSBField frameDark;
    private HSBField frameLight;
    private HSBField frameBorderDisabled;
    private HSBField frameDarkDisabled;
    private HSBField frameLightDisabled;
    private HSBField frameTitle;
    private HSBField frameTitleDisabled;
    private HSBField frameButt;
    private HSBField frameButtRollover;
    private HSBField frameButtPressed;
    private HSBField frameButtDisabled;
    SpreadPanel frameButtSpreadLight;
    SpreadPanel frameButtSpreadLightDisabled;
    SpreadPanel frameButtSpreadDark;
    SpreadPanel frameButtSpreadDarkDisabled;
    private HSBField frameButtClose;
    private HSBField frameButtCloseRollover;
    private HSBField frameButtClosePressed;
    private HSBField frameButtCloseDisabled;
    SpreadPanel frameButtCloseSpreadLight;
    SpreadPanel frameButtCloseSpreadLightDisabled;
    SpreadPanel frameButtCloseSpreadDark;
    SpreadPanel frameButtCloseSpreadDarkDisabled;
    private HSBField frameButtBorder;
    private HSBField frameButtDark;
    private HSBField frameButtLight;
    private HSBField frameButtBorderDisabled;
    private HSBField frameButtDarkDisabled;
    private HSBField frameButtLightDisabled;
    private HSBField frameButtCloseBorder;
    private HSBField frameButtCloseDark;
    private HSBField frameButtCloseLight;
    private HSBField frameButtCloseBorderDisabled;
    private HSBField frameButtCloseDarkDisabled;
    private HSBField frameButtCloseLightDisabled;
    private HSBField frameSymbol;
    private HSBField frameSymbolPressed;
    private HSBField frameSymbolDisabled;
    private HSBField frameSymbolDark;
    private HSBField frameSymbolLight;
    private HSBField frameSymbolClose;
    private HSBField frameSymbolClosePressed;
    private HSBField frameSymbolCloseDisabled;
    private HSBField frameSymbolCloseDark;
    private HSBField frameSymbolCloseLight;
    SpreadPanel frameSpreadDark;
    SpreadPanel frameSpreadLight;
    SpreadPanel frameSpreadDarkDisabled;
    SpreadPanel frameSpreadLightDisabled;
    private CheckedIcon[] iconChecks = new CheckedIcon[17];
    private HSBField frameIcon;
    private HSBField fileViewIcon;
    private HSBField fileChooserIcon;
    private HSBField optionPaneIcon;
    private HSBField treeIcon;
    private HSBField tableBack;
    private HSBField tableHeaderBack;
    private HSBField tableGrid;
    private HSBField tableSelectedBack;
    private BlackWhitePanel tableSelectedFore;
    private HSBField tipBg;
    private HSBField tipBorder;
    private HSBField titledBorderColor;

    public ControlPanel() {
        this.createFrame();
    }

    private void createFrame() {
        if (Theme.frameIsDecorated[Theme.style]) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        } else {
            JFrame.setDefaultLookAndFeelDecorated(false);
            JDialog.setDefaultLookAndFeelDecorated(false);
        }
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        this.theFrame = new JFrame(WINDOW_TITLE);
        this.theFrame.setDefaultCloseOperation(3);
        boolean isCustomEnabled = false;
        boolean isCustomSelected = false;
        if (this.customStyle != null) {
            isCustomEnabled = this.customStyle.isEnabled();
            isCustomSelected = this.customStyle.isSelected();
        }
        this.setupUI();
        this.customStyle.setEnabled(isCustomEnabled);
        this.customStyle.setSelected(isCustomSelected);
        this.createHSBPopup();
        this.initColors();
        this.initPanels();
        this.updateThemeButton.setEnabled(false);
        this.startProgressTimer();
    }

    private void startProgressTimer() {
        if (this.progressTimer == null) {
            this.progressTimer = new Timer(500, new ProgressAction());
        }
        this.vertProgressBar.setIndeterminate(true);
        this.progressTimer.start();
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.stop();
        this.horzProgressBar.setIndeterminate(false);
        this.vertProgressBar.setIndeterminate(false);
    }

    private void showUIVariables() {
        String key;
        UIDefaults defaults = UIManager.getDefaults();
        int c = 0;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            map.put(key, defaults.get(key));
        }
        Iterator ii = map.keySet().iterator();
        while (ii.hasNext()) {
            key = ii.next().toString();
            System.out.print("#" + c++ + " : " + key);
            System.out.println(" = " + map.get(key));
        }
        System.out.println();
    }

    private void showUIVariables(String inString) {
        String key;
        UIDefaults defaults = UIManager.getDefaults();
        int c = 0;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            if (key.indexOf(inString) == -1) continue;
            map.put(key, defaults.get(key));
        }
        Iterator ii = map.keySet().iterator();
        while (ii.hasNext()) {
            key = ii.next().toString();
            Object val = map.get(key);
            System.out.print("#" + c++ + " : " + key);
            System.out.println(" = " + map.get(key));
        }
    }

    private void showUIValues(String val) {
        String key;
        UIDefaults defaults = UIManager.getDefaults();
        int c = 0;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            map.put(key, defaults.get(key));
        }
        Iterator ii = map.keySet().iterator();
        while (ii.hasNext()) {
            key = ii.next().toString();
            Object value = map.get(key);
            if (value == null || value.toString().indexOf(val) == -1) continue;
            System.out.print("#" + c++ + " : " + key);
            System.out.println(" = " + value);
        }
        System.out.println();
    }

    private void showInsets() {
        String key;
        UIDefaults defaults = UIManager.getDefaults();
        int c = 0;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            Object val = defaults.get(key);
            if (!(val instanceof Insets)) continue;
            map.put(key, val);
        }
        Iterator ii = map.keySet().iterator();
        while (ii.hasNext()) {
            key = ii.next().toString();
            System.out.print("#" + c++ + " : " + key);
            System.out.println(" = " + map.get(key));
        }
        System.out.println();
    }

    private void showSystemProperties() {
        Enumeration e = ((Hashtable)System.getProperties()).keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = System.getProperty(key.toString());
            System.out.println(String.valueOf(key.toString()) + " : " + value.toString());
        }
    }

    private void showMessageDialog() {
        JOptionPane.showMessageDialog(this.theFrame, "No messages today.");
    }

    private void showConfirmationDialog() {
        JOptionPane.showConfirmDialog(this.theFrame, "Do you really have a choice?");
    }

    private void showWarningDialog() {
        JOptionPane.showMessageDialog(this.theFrame, "You have been warned!", "Warning", 2);
    }

    private void showErrorDialog() {
        JOptionPane.showMessageDialog(this.theFrame, "Unknown software error. Panic!", "Error", 0);
    }

    private void setupUI() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createThemeMenu());
        menuBar.add(this.createStyleMenu());
        menuBar.add(this.createDisabledMenu());
        menuBar.add(this.createCheckBoxMenu());
        menuBar.add(this.createRadioButtonMenu());
        this.theFrame.setJMenuBar(menuBar);
        JPanel p0 = new JPanel(new BorderLayout());
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)this.createToolBar(), "North");
        this.mainTab = new JTabbedPane(2);
        this.mainTab.add("Color", this.createColorPanel());
        this.mainTab.add("Font", this.createFontPanel());
        this.mainTab.add("Decoration", this.createDecorationPanel());
        p1.add((Component)this.mainTab, "Center");
        p0.add((Component)p1, "North");
        p1 = new JPanel(new FlowLayout(1, 8, 4));
        this.updateThemeButton = new JButton("Apply Settings");
        this.theFrame.getRootPane().setDefaultButton(this.updateThemeButton);
        this.updateThemeButton.addActionListener(new SetThemeAction());
        p1.add(this.updateThemeButton);
        p0.add((Component)p1, "South");
        this.theFrame.getContentPane().add((Component)p0, "North");
        this.examplePanel = new ExamplePanel();
        p0 = new JPanel(new BorderLayout());
        p0.setBorder(new TitledBorder("Examples"));
        p0.add((Component)this.examplePanel, "Center");
        this.theFrame.getContentPane().add((Component)p0, "Center");
        int w = 960;
        int h = 752;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.theFrame).setSize(w, h);
        ((Component)this.theFrame).setLocation((d.width - w) / 2, (d.height - h) / 3);
        ((Component)this.theFrame).setVisible(true);
    }

    private void decorateFrame(boolean b) {
        this.theFrame.dispose();
        Theme.frameIsDecorated[Theme.style] = b;
        this.createFrame();
        this.mainTab.setSelectedComponent(this.compTab);
        this.compTab.setSelectedComponent(this.frameCP);
    }

    private JPanel createColorPanel() {
        JPanel p0 = new JPanel(new BorderLayout());
        JPanel p1 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = new Insets(2, 4, 0, 4);
        p1.add((Component)new JLabel("Main Color"), gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 0, 4);
        p1.add((Component)new JLabel("Background Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Disabled Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Frame Color"), gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(2, 4, 8, 4);
        this.mainField = new HSBField(Theme.mainColor, 24);
        p1.add((Component)this.mainField, gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 8, 4);
        this.backField = new HSBField(Theme.backColor, 24);
        p1.add((Component)this.backField, gc);
        ++gc.gridx;
        this.rollField = new HSBField(Theme.disColor, 24);
        p1.add((Component)this.rollField, gc);
        ++gc.gridx;
        this.frameField = new HSBField(Theme.frameColor, 24);
        p1.add((Component)this.frameField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(2, 4, 0, 4);
        p1.add((Component)new JLabel("Sub1 Color"), gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 0, 4);
        p1.add((Component)new JLabel("Sub2 Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Sub3 Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Sub4 Color"), gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(2, 4, 8, 4);
        this.sub1Field = new HSBField(Theme.sub1Color, true);
        p1.add((Component)this.sub1Field, gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 8, 4);
        this.sub2Field = new HSBField(Theme.sub2Color, true);
        p1.add((Component)this.sub2Field, gc);
        ++gc.gridx;
        this.sub3Field = new HSBField(Theme.sub3Color, true);
        p1.add((Component)this.sub3Field, gc);
        ++gc.gridx;
        this.sub4Field = new HSBField(Theme.sub4Color, true);
        p1.add((Component)this.sub4Field, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(2, 4, 0, 4);
        p1.add((Component)new JLabel("Sub5 Color"), gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 0, 4);
        p1.add((Component)new JLabel("Sub6 Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Sub7 Color"), gc);
        ++gc.gridx;
        p1.add((Component)new JLabel("Sub8 Color"), gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(2, 4, 8, 4);
        this.sub5Field = new HSBField(Theme.sub5Color, true);
        p1.add((Component)this.sub5Field, gc);
        ++gc.gridx;
        gc.insets = new Insets(2, 8, 8, 4);
        this.sub6Field = new HSBField(Theme.sub6Color, true);
        p1.add((Component)this.sub6Field, gc);
        ++gc.gridx;
        this.sub7Field = new HSBField(Theme.sub7Color, true);
        p1.add((Component)this.sub7Field, gc);
        ++gc.gridx;
        this.sub8Field = new HSBField(Theme.sub8Color, true);
        p1.add((Component)this.sub8Field, gc);
        JPanel p2 = new JPanel(new FlowLayout(1, 0, 12));
        p2.add(p1);
        p0.add((Component)p2, "North");
        return p0;
    }

    private JToolBar createToolBar() {
        JToolBar tb = new JToolBar();
        ButtonGroup group = new ButtonGroup();
        JToggleButton b = null;
        int i = 0;
        while (i < 6) {
            b = new JToggleButton("");
            group.add(b);
            b.setIcon(new ToolButtonIcon(b));
            tb.add(b);
            ++i;
        }
        tb.addSeparator();
        i = 0;
        while (i < 5) {
            b = new JToggleButton("");
            group.add(b);
            b.setIcon(new ToolButtonIcon(b));
            tb.add(b);
            ++i;
        }
        tb.addSeparator();
        i = 0;
        while (i < 4) {
            b = new JToggleButton("");
            group.add(b);
            b.setIcon(new ToolButtonIcon(b));
            tb.add(b);
            ++i;
        }
        b = new JToggleButton("TB_Button");
        group.add(b);
        tb.add(b);
        return tb;
    }

    private JPopupMenu createHSBPopup() {
        if (this.hsbPopup != null) {
            return this.hsbPopup;
        }
        HSBPopupAction hsbPopupAction = new HSBPopupAction();
        this.hsbPopup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Absolute Color");
        item.setActionCommand("1");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        this.hsbPopup.addSeparator();
        item = new JMenuItem("Derive from Main Color");
        item.setActionCommand("2");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Back Color");
        item.setActionCommand("3");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Disabled Color");
        item.setActionCommand("4");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Frame Color");
        item.setActionCommand("5");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub1 Color");
        item.setActionCommand("6");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub2 Color");
        item.setActionCommand("7");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub3 Color");
        item.setActionCommand("8");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub4 Color");
        item.setActionCommand("9");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub5 Color");
        item.setActionCommand("10");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub6 Color");
        item.setActionCommand("11");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub7 Color");
        item.setActionCommand("12");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        item = new JMenuItem("Derive from Sub8 Color");
        item.setActionCommand("13");
        item.addActionListener(hsbPopupAction);
        this.hsbPopup.add(item);
        return this.hsbPopup;
    }

    private void updateHSBPopupIcons() {
        MenuElement[] me = this.hsbPopup.getSubElements();
        ((JMenuItem)me[0]).setIcon(ColorReference.getAbsoluteIcon());
        ((JMenuItem)me[1]).setIcon(Theme.mainColor[Theme.style].getIcon());
        ((JMenuItem)me[2]).setIcon(Theme.backColor[Theme.style].getIcon());
        ((JMenuItem)me[3]).setIcon(Theme.disColor[Theme.style].getIcon());
        ((JMenuItem)me[4]).setIcon(Theme.frameColor[Theme.style].getIcon());
        ((JMenuItem)me[5]).setIcon(Theme.sub1Color[Theme.style].getIcon());
        ((JMenuItem)me[6]).setIcon(Theme.sub2Color[Theme.style].getIcon());
        ((JMenuItem)me[7]).setIcon(Theme.sub3Color[Theme.style].getIcon());
        ((JMenuItem)me[8]).setIcon(Theme.sub4Color[Theme.style].getIcon());
        ((JMenuItem)me[9]).setIcon(Theme.sub5Color[Theme.style].getIcon());
        ((JMenuItem)me[10]).setIcon(Theme.sub6Color[Theme.style].getIcon());
        ((JMenuItem)me[11]).setIcon(Theme.sub7Color[Theme.style].getIcon());
        ((JMenuItem)me[12]).setIcon(Theme.sub8Color[Theme.style].getIcon());
        int i = 0;
        while (i < 13) {
            ((JMenuItem)me[i]).setSelected(false);
            ++i;
        }
        i = 5;
        while (i < 13) {
            ((JMenuItem)me[i]).setEnabled(true);
            ++i;
        }
    }

    private void showHSBPopup(HSBField cf) {
        this.updateHSBPopupIcons();
        this.selectedHSBField = cf;
        int index = cf.getColorReference().getReference() - 1;
        MenuElement[] me = this.hsbPopup.getSubElements();
        ((JMenuItem)me[index]).setSelected(true);
        if (cf.equals(this.sub1Field)) {
            ((JMenuItem)me[5]).setEnabled(false);
        } else if (cf.equals(this.sub2Field)) {
            ((JMenuItem)me[6]).setEnabled(false);
        } else if (cf.equals(this.sub3Field)) {
            ((JMenuItem)me[7]).setEnabled(false);
        } else if (cf.equals(this.sub4Field)) {
            ((JMenuItem)me[8]).setEnabled(false);
        } else if (cf.equals(this.sub5Field)) {
            ((JMenuItem)me[9]).setEnabled(false);
        } else if (cf.equals(this.sub6Field)) {
            ((JMenuItem)me[10]).setEnabled(false);
        } else if (cf.equals(this.sub7Field)) {
            ((JMenuItem)me[11]).setEnabled(false);
        } else if (cf.equals(this.sub8Field)) {
            ((JMenuItem)me[12]).setEnabled(false);
        }
        this.hsbPopup.show(cf, 0, cf.getHeight() + 2);
    }

    private JPanel createFontPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = new Insets(4, 2, 4, 2);
        this.plainFontPanel = new FontPanel(1);
        p1.add((Component)this.plainFontPanel, gc);
        ++gc.gridy;
        this.boldFontPanel = new FontPanel(2);
        p1.add((Component)this.boldFontPanel, gc);
        ++gc.gridy;
        gc.insets = new Insets(11, 2, 0, 2);
        JPanel p2 = new JPanel(new FlowLayout(0, 0, 0));
        p2.add(this.createFontCombo());
        p2.add(new JLabel("    "));
        this.isPlainFont = new JRadioButton("is Plain Font");
        this.isPlainFont.addActionListener(new DerivedFontAction());
        p2.add(this.isPlainFont);
        p2.add(new JLabel("    "));
        this.isBoldFont = new JRadioButton("is Bold Font");
        this.isBoldFont.addActionListener(new DerivedFontAction());
        p2.add(this.isBoldFont);
        p1.add((Component)p2, gc);
        ++gc.gridy;
        gc.insets = new Insets(2, 2, 0, 2);
        this.specialFontPanel = new FontPanel(3);
        this.specialFontPanel.init(this.selectedFont[Theme.style]);
        p1.add((Component)this.specialFontPanel, gc);
        return p1;
    }

    private JComboBox createFontCombo() {
        Vector<String> items = new Vector<String>();
        items.add("Button Font");
        items.add("CheckBox Font");
        items.add("ComboBox Font");
        items.add("Label Font");
        items.add("List Font");
        items.add("Menu Font");
        items.add("MenuItem Font");
        items.add("Password Font");
        items.add("RadioButton Font");
        items.add("Table Font");
        items.add("TableHeader Font");
        items.add("TextArea Font");
        items.add("TextField Font");
        items.add("TextPane Font");
        items.add("TitledBorder Font");
        items.add("ToolTip Font");
        items.add("Tree Font");
        items.add("TabbedPane Font");
        items.add("EditorPane Font");
        items.add("FrameTitle Font");
        items.add("ProgressBar Font");
        Collections.sort(items);
        this.fontCombo = new JComboBox(items);
        this.fontCombo.addActionListener(new SelectSpecialFontAction());
        this.selectedFont = Theme.buttonFont;
        return this.fontCombo;
    }

    private JTabbedPane createDecorationPanel() {
        this.compTab = new JTabbedPane();
        this.buttonsCP = new ButtonsCP();
        this.compTab.add("Button", this.buttonsCP);
        this.comboCP = new ComboCP();
        this.compTab.add("ComboBox", this.comboCP);
        this.frameCP = new FrameCP();
        this.compTab.add("Frame", this.frameCP);
        this.iconCP = new IconCP();
        this.compTab.add("Icons", this.iconCP);
        this.listCP = new ListCP();
        this.compTab.add("List", this.listCP);
        this.menuCP = new MenuCP();
        this.compTab.add("Menu", this.menuCP);
        this.miscCP = new MiscCP();
        this.compTab.add("Miscellaneous", this.miscCP);
        this.progressCP = new ProgressCP();
        this.compTab.add("ProgressBar", this.progressCP);
        this.scrollsCP = new ScrollsCP();
        this.compTab.add("ScrollBar", this.scrollsCP);
        this.sliderCP = new SliderCP();
        this.compTab.add("Slider", this.sliderCP);
        this.spinnerCP = new SpinnerCP();
        this.compTab.add("Spinner", this.spinnerCP);
        this.tabsCP = new TabsCP();
        this.compTab.add("TabbedPane", this.tabsCP);
        this.tableCP = new TableCP();
        this.compTab.add("Table", this.tableCP);
        this.textCP = new TextCP();
        this.compTab.add("Text", this.textCP);
        this.toolCP = new ToolCP();
        this.compTab.add("ToolBar", this.toolCP);
        this.tipCP = new TipCP();
        this.compTab.add("ToolTip", this.tipCP);
        this.treeCP = new TreeCP();
        this.compTab.add("Tree", this.treeCP);
        return this.compTab;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Open Theme...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.openTheme();
            }
        });
        item.setMnemonic(79);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.saveTheme(false);
            }
        });
        item.setMnemonic(83);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menu.add(item);
        item = new JMenuItem("Save as Default");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.saveDefaults();
            }
        });
        menu.add(item);
        item = new JMenuItem("Save as...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.saveTheme(true);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Disabled Menu Item");
        item.setEnabled(false);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Quit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menu.add(item);
        return menu;
    }

    private Vector loadThemes() {
        Vector<String> names = new Vector<String>();
        File f = new File(System.getProperty("user.dir"));
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".theme")) {
                names.add(files[i].getName());
            }
            ++i;
        }
        return names;
    }

    private JMenu createThemeMenu() {
        this.themesMenu = new JMenu("Themes");
        JMenuItem item = null;
        String fn = null;
        Iterator ii = ((AbstractList)this.loadThemes()).iterator();
        while (ii.hasNext()) {
            fn = (String)ii.next();
            item = new JMenuItem(fn.substring(0, fn.lastIndexOf(".")));
            item.addActionListener(this.selectThemeAction);
            this.themesMenu.add(item);
        }
        return this.themesMenu;
    }

    private void updateThemeMenu() {
        this.themesMenu.removeAll();
        JMenuItem item = null;
        String fn = null;
        Iterator ii = ((AbstractList)this.loadThemes()).iterator();
        while (ii.hasNext()) {
            fn = (String)ii.next();
            item = new JMenuItem(fn.substring(0, fn.lastIndexOf(".")));
            item.addActionListener(this.selectThemeAction);
            this.themesMenu.add(item);
        }
    }

    private JMenu createStyleMenu() {
        JMenu menu = new JMenu("Style");
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Tiny", Theme.style == 0);
        group.add(item);
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.updateStyle(0);
            }
        });
        item = new JCheckBoxMenuItem("Windows 98", Theme.style == 1);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.updateStyle(1);
            }
        });
        menu.add(item);
        item = new JCheckBoxMenuItem("Windows XP", Theme.style == 2);
        group.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.updateStyle(2);
            }
        });
        menu.add(item);
        this.customStyle = new JCheckBoxMenuItem("Custom", false);
        this.customStyle.setEnabled(false);
        group.add(this.customStyle);
        this.customStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.updateStyle(3);
            }
        });
        menu.add(this.customStyle);
        return menu;
    }

    private JMenu createDisabledMenu() {
        JMenu menu = new JMenu("DisabledMenu");
        menu.setEnabled(false);
        return menu;
    }

    private JMenu createCheckBoxMenu() {
        JMenu menu = new JMenu("JCheckBoxMenuItems");
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Item 1", true);
        menu.add(item);
        item = new JCheckBoxMenuItem("Item 2", false);
        menu.add(item);
        item = new JCheckBoxMenuItem("Item 3", true);
        menu.add(item);
        item = new JCheckBoxMenuItem("Item 4", false);
        menu.add(item);
        item = new JCheckBoxMenuItem("Disabled Item 5", true);
        item.setEnabled(false);
        menu.add(item);
        item = new JCheckBoxMenuItem("Disabled Item 6", false);
        item.setEnabled(false);
        menu.add(item);
        return menu;
    }

    private JMenu createRadioButtonMenu() {
        JMenu menu = new JMenu("JRadioButtonMenuItems");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem("Item 1");
        group.add(item);
        menu.add(item);
        item = new JRadioButtonMenuItem("Item 2");
        group.add(item);
        menu.add(item);
        item = new JRadioButtonMenuItem("Item 3", true);
        group.add(item);
        menu.add(item);
        item = new JRadioButtonMenuItem("Item 4");
        group.add(item);
        menu.add(item);
        item = new JRadioButtonMenuItem("Disabled Item 5", true);
        item.setEnabled(false);
        menu.add(item);
        item = new JRadioButtonMenuItem("Disabled Item 6", false);
        item.setEnabled(false);
        menu.add(item);
        return menu;
    }

    private void addButtonIcons(boolean b) {
        if (b && this.exampleButton.getIcon() == null) {
            if (this.buttonIcon == null) {
                this.buttonIcon = new ImageIcon(ClassLoader.getSystemResource("de/muntjak/tinylookandfeel/icons/theIcon.gif"));
            }
            this.exampleButton.setIcon(this.buttonIcon);
            this.exampleDisabledButton.setIcon(this.buttonIcon);
            this.exampleToggleButton.setIcon(this.buttonIcon);
        } else if (!b && this.exampleButton.getIcon() != null) {
            this.exampleButton.setIcon(null);
            this.exampleDisabledButton.setIcon(null);
            this.exampleToggleButton.setIcon(null);
        }
    }

    private void updateFont(int type) {
        if (type == 1) {
            Theme.plainFont[Theme.style].setFont(this.plainFontPanel.getCurrentFont());
        } else if (type == 2) {
            Theme.boldFont[Theme.style].setFont(this.boldFontPanel.getCurrentFont());
        } else {
            this.selectedFont[Theme.style].setFont(this.specialFontPanel.getCurrentFont());
        }
        this.examplePanel.update(true);
    }

    private void updateSpecialFont() {
        int index = this.fontCombo.getSelectedIndex();
        switch (index) {
            case 0: {
                this.selectedFont = Theme.buttonFont;
                break;
            }
            case 1: {
                this.selectedFont = Theme.checkFont;
                break;
            }
            case 2: {
                this.selectedFont = Theme.comboFont;
                break;
            }
            case 3: {
                this.selectedFont = Theme.editorFont;
                break;
            }
            case 4: {
                this.selectedFont = Theme.frameTitleFont;
                break;
            }
            case 5: {
                this.selectedFont = Theme.labelFont;
                break;
            }
            case 6: {
                this.selectedFont = Theme.listFont;
                break;
            }
            case 7: {
                this.selectedFont = Theme.menuFont;
                break;
            }
            case 8: {
                this.selectedFont = Theme.menuItemFont;
                break;
            }
            case 9: {
                this.selectedFont = Theme.passwordFont;
                break;
            }
            case 10: {
                this.selectedFont = Theme.progressBarFont;
                break;
            }
            case 11: {
                this.selectedFont = Theme.radioFont;
                break;
            }
            case 12: {
                this.selectedFont = Theme.tabFont;
                break;
            }
            case 13: {
                this.selectedFont = Theme.tableFont;
                break;
            }
            case 14: {
                this.selectedFont = Theme.tableHeaderFont;
                break;
            }
            case 15: {
                this.selectedFont = Theme.textAreaFont;
                break;
            }
            case 16: {
                this.selectedFont = Theme.textFieldFont;
                break;
            }
            case 17: {
                this.selectedFont = Theme.textPaneFont;
                break;
            }
            case 18: {
                this.selectedFont = Theme.titledBorderFont;
                break;
            }
            case 19: {
                this.selectedFont = Theme.toolTipFont;
                break;
            }
            case 20: {
                this.selectedFont = Theme.treeFont;
            }
        }
        this.specialFontPanel.init(this.selectedFont[Theme.style]);
        Theme.buttonFontColor[Theme.style].update();
        Theme.labelFontColor[Theme.style].update();
        Theme.menuFontColor[Theme.style].update();
        Theme.menuItemFontColor[Theme.style].update();
        Theme.radioFontColor[Theme.style].update();
        Theme.checkFontColor[Theme.style].update();
        Theme.tableFontColor[Theme.style].update();
        Theme.tableHeaderFontColor[Theme.style].update();
        Theme.titledBorderFontColor[Theme.style].update();
        Theme.toolTipFontColor[Theme.style].update();
        Theme.tabFontColor[Theme.style].update();
    }

    private void setTheme() {
        this.updateTheme();
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(currentLookAndFeel);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this.theFrame);
        this.updateThemeButton.setEnabled(false);
        this.iconCP.init(true);
        this.theFrame.repaint(0L);
        PSColorChooser.deleteInstance();
        SBChooser.deleteInstance();
    }

    private void updateTheme() {
        Theme.mainColor[Theme.style].setColor(this.mainField.getBackground());
        Theme.disColor[Theme.style].setColor(this.rollField.getBackground());
        Theme.backColor[Theme.style].setColor(this.backField.getBackground());
        Theme.frameColor[Theme.style].setColor(this.frameField.getBackground());
        TinyDefaultTheme.secondary3 = new ColorUIResource(Theme.backColor[Theme.style].getColor());
        this.updatePanels();
        UIDefaults table = UIManager.getDefaults();
        table.put("Button.margin", this.buttonsCP.getButtonMargin());
        table.put("TabbedPane.tabAreaInsets", new Insets(6, this.tabsCP.getFirstTabDistance(), 0, 0));
    }

    private void updatePanels() {
        this.buttonsCP.updateTheme();
        this.scrollsCP.updateTheme();
        this.tabsCP.updateTheme();
        this.comboCP.updateTheme();
        this.listCP.updateTheme();
        this.sliderCP.updateTheme();
        this.spinnerCP.updateTheme();
        this.progressCP.updateTheme();
        this.menuCP.updateTheme();
        this.textCP.updateTheme();
        this.treeCP.updateTheme();
        this.toolCP.updateTheme();
        this.tableCP.updateTheme();
        this.frameCP.updateTheme();
        this.iconCP.updateTheme();
        this.tipCP.updateTheme();
        this.miscCP.updateTheme();
    }

    private void updateStyle(int newStyle) {
        this.stopProgressTimer();
        Theme.style = newStyle;
        this.initColors();
        this.initPanels();
        this.setTheme();
        this.startProgressTimer();
    }

    private String getDescription() {
        if (Theme.style == 3) {
            return this.currentFileName;
        }
        if (Theme.style == 1) {
            return "Windows 98";
        }
        if (Theme.style == 2) {
            return "Windows XP";
        }
        if (Theme.style == 0) {
            return "Tiny";
        }
        return "";
    }

    private void initPanels() {
        this.resistUpdate = true;
        this.initColors();
        this.buttonsCP.init(true);
        this.scrollsCP.init(true);
        this.tabsCP.init(true);
        this.comboCP.init(true);
        this.menuCP.init(true);
        this.listCP.init(true);
        this.sliderCP.init(true);
        this.spinnerCP.init(true);
        this.progressCP.init(true);
        this.textCP.init(true);
        this.treeCP.init(true);
        this.toolCP.init(true);
        this.tableCP.init(true);
        this.frameCP.init(true);
        this.iconCP.init(true);
        this.tipCP.init(true);
        this.miscCP.init(true);
        this.initFonts();
        this.resistUpdate = false;
        this.theFrame.setTitle("TinyLaF 1.1 Controlpanel - " + this.getDescription());
    }

    private void initColors() {
        this.mainField.setBackground(Theme.mainColor[Theme.style].getColor());
        this.rollField.setBackground(Theme.disColor[Theme.style].getColor());
        this.backField.setBackground(Theme.backColor[Theme.style].getColor());
        this.frameField.setBackground(Theme.frameColor[Theme.style].getColor());
        this.sub1Field.update();
        this.sub2Field.update();
        this.sub3Field.update();
        this.sub4Field.update();
        this.sub5Field.update();
        this.sub6Field.update();
        this.sub7Field.update();
        this.sub8Field.update();
    }

    private void initFonts() {
        this.plainFontPanel.init(Theme.plainFont[Theme.style]);
        this.boldFontPanel.init(Theme.boldFont[Theme.style]);
        this.updateSpecialFont();
    }

    private void openTheme() {
        JFileChooser ch = new JFileChooser(System.getProperty("user.dir"));
        ch.setFileFilter(new ThemeFileFilter());
        int answer = ch.showOpenDialog(this.theFrame);
        if (answer == 1) {
            return;
        }
        File f = ch.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!Theme.loadTheme(f, 3)) {
            JOptionPane.showMessageDialog(this.theFrame, "This file is not a valid TinyLaF theme.", "Error", 0);
            return;
        }
        this.currentFileName = f.getAbsolutePath();
        this.customStyle.setEnabled(true);
        this.customStyle.setSelected(true);
        this.updateStyle(3);
    }

    private void openTheme(String fn) {
        File f = new File(fn);
        if (!Theme.loadTheme(f, 3)) {
            JOptionPane.showMessageDialog(this.theFrame, "This file is not a valid TinyLaF theme.", "Error", 0);
            return;
        }
        this.currentFileName = fn;
        this.customStyle.setEnabled(true);
        this.customStyle.setSelected(true);
        this.updateStyle(3);
    }

    private void saveTheme(boolean showFileChooser) {
        if (this.currentFileName != null && !showFileChooser && Theme.style == 3) {
            Theme.saveTheme(this.currentFileName);
            this.updateThemeMenu();
            return;
        }
        JFileChooser ch = new JFileChooser(System.getProperty("user.dir"));
        ch.setFileFilter(new ThemeFileFilter());
        ch.setSelectedFile(new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "Untitled.theme"));
        int answer = ch.showSaveDialog(this.theFrame);
        if (answer == 1) {
            return;
        }
        File f = ch.getSelectedFile();
        if (f == null) {
            return;
        }
        this.currentFileName = this.createFileExtension(f, ".theme");
        Theme.saveTheme(this.currentFileName);
        this.updateThemeMenu();
        if (Theme.style != 3) {
            this.openTheme(this.currentFileName);
        }
        this.theFrame.setTitle("TinyLaF 1.1 Controlpanel - " + this.getDescription());
    }

    private String createFileExtension(File f, String ext) {
        String fn = f.getAbsolutePath();
        if (fn.endsWith(ext)) {
            return fn;
        }
        if (fn.lastIndexOf(".") < fn.lastIndexOf(File.separator)) {
            return String.valueOf(fn) + ext;
        }
        return String.valueOf(fn.substring(0, fn.lastIndexOf("."))) + ext;
    }

    private void saveDefaults() {
        Theme.saveTheme("Default.theme");
        this.updateThemeMenu();
    }

    public static void main(String[] args) {
        isInstantiated = true;
        try {
            UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new ControlPanel();
    }

    static /* synthetic */ void access$24(ControlPanel controlPanel, boolean bl) {
        controlPanel.addButtonIcons(bl);
    }

    static /* synthetic */ void access$33(ControlPanel controlPanel) {
        controlPanel.showMessageDialog();
    }

    static /* synthetic */ void access$34(ControlPanel controlPanel) {
        controlPanel.showConfirmationDialog();
    }

    static /* synthetic */ void access$35(ControlPanel controlPanel) {
        controlPanel.showWarningDialog();
    }

    static /* synthetic */ void access$36(ControlPanel controlPanel) {
        controlPanel.showErrorDialog();
    }

    class HSBField
    extends JPanel {
        private boolean forceUpdate = false;
        private Dimension size = new Dimension(64, 18);
        private ColorReference[] ref;

        HSBField(ColorReference[] ref) {
            this.ref = ref;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            if (ref == null) {
                return;
            }
            this.update();
            this.addMouseListener(new Mousey());
        }

        HSBField(ColorReference[] ref, boolean forceUpdate) {
            this.ref = ref;
            this.forceUpdate = forceUpdate;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            if (ref == null) {
                return;
            }
            this.update();
            this.addMouseListener(new Mousey());
        }

        HSBField(ColorReference[] ref, int height) {
            this.ref = ref;
            this.forceUpdate = true;
            this.size = new Dimension(64, height);
            this.setBorder(new LineBorder(Color.BLACK, 1));
            if (ref == null) {
                return;
            }
            this.update();
            this.addMouseListener(new Mousey());
        }

        public ColorReference getColorReference() {
            return this.ref[Theme.style];
        }

        public void resetReference() {
            if (this.ref == null) {
                return;
            }
            this.ref[Theme.style].reset();
        }

        public void update() {
            if (this.ref != null) {
                this.setBackground(this.ref[Theme.style].update());
            }
            this.repaint();
            this.updateTTT();
        }

        private void updateTTT() {
            if (this.ref == null) {
                return;
            }
            Color c = this.ref[Theme.style].getColor();
            StringBuffer buff = new StringBuffer();
            if (this.ref[Theme.style].isAbsoluteColor()) {
                buff.append("R:" + c.getRed());
                buff.append(" G:" + c.getGreen());
                buff.append(" B:" + c.getBlue());
            } else {
                buff.append("S:" + this.ref[Theme.style].getSaturation());
                buff.append(" B:" + this.ref[Theme.style].getBrightness());
                buff.append(" (" + this.ref[Theme.style].getReferenceString() + ")");
                buff.append(" R:" + c.getRed());
                buff.append(" G:" + c.getGreen());
                buff.append(" B:" + c.getBlue());
            }
            this.setToolTipText(buff.toString());
        }

        public void setColorReference(ColorReference[] ref) {
            this.ref = ref;
            this.update();
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g) {
            if (this.ref == null) {
                g.setColor(Theme.backColor[Theme.style].getColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            super.paint(g);
            if (this.ref[Theme.style].isLocked()) {
                return;
            }
            if (this.ref[Theme.style].isAbsoluteColor()) {
                int x = this.getWidth() - 19;
                float hue = 0.0f;
                g.setColor(Color.BLACK);
                g.drawLine(x - 1, 1, x - 1, this.getHeight() - 2);
                int i = 0;
                while (i < 18) {
                    g.setColor(Color.getHSBColor(hue, 0.5f, 1.0f));
                    g.drawLine(x + i, 1, x + i, this.getHeight() - 2);
                    hue = (float)((double)hue + 0.05263157894736842);
                    ++i;
                }
            } else {
                int x = this.getWidth() - 19;
                int grey = 255;
                g.setColor(Color.BLACK);
                g.drawLine(x - 1, 1, x - 1, this.getHeight() - 2);
                int i = 0;
                while (i < 18) {
                    g.setColor(new Color(grey, grey, grey));
                    g.drawLine(x + i, 1, x + i, this.getHeight() - 2);
                    grey -= 14;
                    ++i;
                }
            }
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !HSBField.this.ref[Theme.style].isLocked()) {
                    ControlPanel.this.showHSBPopup((HSBField)e.getSource());
                }
            }

            public void mousePressed(MouseEvent e) {
                HSBField cf = (HSBField)e.getSource();
                cf.requestFocus();
                if (e.isPopupTrigger() && !HSBField.this.ref[Theme.style].isLocked()) {
                    ControlPanel.this.showHSBPopup(cf);
                    return;
                }
                if (e.getX() > cf.getWidth() - 19 && !HSBField.this.ref[Theme.style].isLocked()) {
                    ControlPanel.this.showHSBPopup(cf);
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                Color newColor = null;
                if (HSBField.this.ref[Theme.style].isAbsoluteColor()) {
                    newColor = PSColorChooser.showColorChooser(ControlPanel.this.theFrame, cf.getBackground());
                    if (newColor == null) {
                        return;
                    }
                    cf.getColorReference().setColor(newColor);
                    cf.setBackground(newColor);
                } else {
                    newColor = SBChooser.showSBChooser(ControlPanel.this.theFrame, cf);
                    if (newColor == null) {
                        return;
                    }
                    cf.getColorReference().setColor(SBChooser.getSat(), SBChooser.getBri());
                    cf.setBackground(newColor);
                }
                HSBField.this.updateTTT();
                ControlPanel.this.initPanels();
                ControlPanel.this.examplePanel.update(HSBField.this.forceUpdate);
            }
        }
    }

    class SelectSpecialFontAction
    implements ActionListener {
        SelectSpecialFontAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.updateSpecialFont();
        }
    }

    class DerivedFontAction
    implements ActionListener {
        DerivedFontAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ControlPanel.this.resistUpdate) {
                return;
            }
            if (e.getSource().equals(ControlPanel.this.isPlainFont)) {
                if (ControlPanel.this.isPlainFont.isSelected()) {
                    ControlPanel.this.isBoldFont.setSelected(false);
                    ControlPanel.this.selectedFont[Theme.style].setPlainFont(true);
                } else {
                    ControlPanel.this.selectedFont[Theme.style].setPlainFont(false);
                }
            } else if (e.getSource().equals(ControlPanel.this.isBoldFont)) {
                if (ControlPanel.this.isBoldFont.isSelected()) {
                    ControlPanel.this.isPlainFont.setSelected(false);
                    ControlPanel.this.selectedFont[Theme.style].setBoldFont(true);
                } else {
                    ControlPanel.this.selectedFont[Theme.style].setBoldFont(false);
                }
            }
            ControlPanel.this.specialFontPanel.init(ControlPanel.this.selectedFont[Theme.style]);
            ControlPanel.this.updateFont(3);
        }
    }

    class HSBPopupAction
    implements ActionListener {
        HSBPopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int ref = Integer.parseInt(e.getActionCommand());
            ControlPanel.this.selectedHSBField.getColorReference().setReference(ref);
            ControlPanel.this.selectedHSBField.resetReference();
            ControlPanel.this.selectedHSBField.update();
            ControlPanel.this.initPanels();
            ControlPanel.this.examplePanel.update(ControlPanel.this.selectedHSBField.forceUpdate);
        }
    }

    class SetThemeAction
    implements ActionListener {
        SetThemeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.setTheme();
        }
    }

    class FontPanel
    extends JPanel {
        private int type;
        private JComboBox fontFamilyCombo;
        private JComboBox fontSizeCombo;
        private JCheckBox bold;
        private HSBField colorField;

        FontPanel(int type) {
            this.type = type;
            this.setupUI();
        }

        private void setupUI() {
            UpdateFontAction updateFontAction = new UpdateFontAction();
            FontUIResource theFont = null;
            theFont = this.type == 1 ? Theme.plainFont[Theme.style].getFont() : (this.type == 2 ? Theme.boldFont[Theme.style].getFont() : ControlPanel.this.selectedFont[Theme.style].getFont());
            this.setLayout(new FlowLayout(0, 3, 1));
            if (this.type == 1) {
                this.setBorder(new TitledBorder("Plain Font"));
            } else if (this.type == 2) {
                this.setBorder(new TitledBorder("Bold Font"));
            } else {
                this.setBorder(new TitledBorder("Special Font"));
            }
            this.add(new JLabel("Family"));
            this.fontFamilyCombo = this.createSchriftarten(theFont);
            this.fontFamilyCombo.addActionListener(updateFontAction);
            this.add(this.fontFamilyCombo);
            this.add(new JLabel("  Size"));
            this.fontSizeCombo = this.createSchriftgroessen(theFont);
            this.fontSizeCombo.addActionListener(updateFontAction);
            this.add(this.fontSizeCombo);
            this.add(new JLabel("    "));
            this.bold = new JCheckBox("Bold", theFont.isBold());
            this.bold.addActionListener(updateFontAction);
            this.add(this.bold);
            if (this.type == 3) {
                this.colorField = new HSBField(ControlPanel.this.selectedFont[Theme.style].getColorReference(), true);
                this.add(this.colorField);
            }
        }

        public String getFontFamily() {
            return (String)this.fontFamilyCombo.getSelectedItem();
        }

        public int getFontSize() {
            return Integer.parseInt((String)this.fontSizeCombo.getSelectedItem());
        }

        public int getFontType() {
            if (this.bold.isSelected()) {
                return 1;
            }
            return 0;
        }

        public FontUIResource getCurrentFont() {
            return new FontUIResource(this.getFontFamily(), this.getFontType(), this.getFontSize());
        }

        public void init(ColoredFont f) {
            ControlPanel.this.resistUpdate = true;
            this.fontSizeCombo.setSelectedItem(String.valueOf(f.getFont().getSize()));
            this.fontFamilyCombo.setSelectedItem(f.getFont().getFamily(Locale.GERMANY));
            this.bold.setSelected(f.getFont().isBold());
            ControlPanel.this.resistUpdate = false;
            if (this.colorField == null) {
                return;
            }
            ControlPanel.this.resistUpdate = true;
            this.colorField.setColorReference(f.getColorReference());
            ControlPanel.this.isPlainFont.setSelected(f.isPlainFont());
            ControlPanel.this.isBoldFont.setSelected(f.isBoldFont());
            ControlPanel.this.resistUpdate = false;
        }

        private JComboBox createSchriftarten(Font font) {
            Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            TreeSet<String> family = new TreeSet<String>();
            int i = 0;
            while (i < fonts.length) {
                family.add(fonts[i].getFamily(Locale.GERMANY));
                ++i;
            }
            JComboBox box = new JComboBox(new Vector(family));
            int i2 = 0;
            while (i2 < box.getItemCount()) {
                if (box.getItemAt(i2).equals(font.getFamily(Locale.GERMANY))) {
                    box.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
            return box;
        }

        private JComboBox createSchriftgroessen(Font font) {
            String[] groessen = new String[]{"10", "11", "12", "13", "14"};
            JComboBox<String> box = new JComboBox<String>(groessen);
            switch (font.getSize()) {
                case 10: {
                    box.setSelectedIndex(0);
                    break;
                }
                case 11: {
                    box.setSelectedIndex(1);
                    break;
                }
                case 12: {
                    box.setSelectedIndex(2);
                    break;
                }
                case 13: {
                    box.setSelectedIndex(3);
                    break;
                }
                case 14: {
                    box.setSelectedIndex(4);
                }
            }
            return box;
        }

        class UpdateFontAction
        implements ActionListener {
            UpdateFontAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.resistUpdate) {
                    return;
                }
                if (FontPanel.this.type == 3) {
                    ControlPanel.this.selectedFont[Theme.style].setPlainFont(false);
                    ControlPanel.this.selectedFont[Theme.style].setBoldFont(false);
                }
                ControlPanel.this.updateFont(FontPanel.this.type);
                ControlPanel.this.specialFontPanel.init(ControlPanel.this.selectedFont[Theme.style]);
            }
        }
    }

    class ExamplePanel
    extends JPanel {
        ExamplePanel() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new BorderLayout());
            JPanel p0 = new JPanel(new BorderLayout(4, 0));
            JPanel p1 = new JPanel(new GridLayout(2, 2, 4, 4));
            JPanel p2 = new JPanel(new BorderLayout(4, 4));
            SizedPanel sizey = new SizedPanel(70, 130);
            JScrollPane sp = new JScrollPane(sizey, 22, 32);
            sp.setPreferredSize(new Dimension(96, 96));
            sp.getVerticalScrollBar().setUnitIncrement(4);
            sp.getHorizontalScrollBar().setUnitIncrement(4);
            p1.add(sp);
            sizey = new SizedPanel(130, 130);
            sp = new JScrollPane(sizey, 22, 32);
            sp.setPreferredSize(new Dimension(96, 96));
            sp.getVerticalScrollBar().setUnitIncrement(4);
            sp.getHorizontalScrollBar().setUnitIncrement(4);
            p1.add(sp);
            JList list = this.createList();
            list.setSelectedIndex(1);
            list.setVisibleRowCount(4);
            sp = new JScrollPane(list, 22, 31);
            p1.add(sp);
            JTextArea ta = new JTextArea("\n  JTextArea", 4, 4);
            sp = new JScrollPane(ta, 22, 31);
            p1.add(sp);
            p2.add((Component)p1, "Center");
            p0.add((Component)p2, "West");
            p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(0, 2, 4, 2);
            ControlPanel.this.exampleButton = new JButton("JButton");
            p1.add((Component)ControlPanel.this.exampleButton, gc);
            ++gc.gridx;
            ControlPanel.this.exampleDisabledButton = new JButton("Disabled");
            ControlPanel.this.exampleDisabledButton.setEnabled(false);
            p1.add((Component)ControlPanel.this.exampleDisabledButton, gc);
            gc.gridx = 0;
            ++gc.gridy;
            ControlPanel.this.exampleToggleButton = new JToggleButton("JToggleButton");
            p1.add((Component)ControlPanel.this.exampleToggleButton, gc);
            ++gc.gridx;
            JCheckBox ch = new JCheckBox("Buttons w/icon", false);
            ch.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.access$24(ExamplePanel.access$0(this.this$1), ((AbstractButton)e.getSource()).isSelected());
                }
            });
            p1.add((Component)ch, gc);
            gc.gridx = 0;
            ++gc.gridy;
            ch = new JCheckBox("JCheckBox", false);
            p1.add((Component)ch, gc);
            ++gc.gridx;
            ch = new JCheckBox("Disabled", true);
            ch.setEnabled(false);
            p1.add((Component)ch, gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.insets = new Insets(0, 2, 12, 2);
            JRadioButton rb = new JRadioButton("JRadioButton");
            p1.add((Component)rb, gc);
            ++gc.gridx;
            rb = new JRadioButton("Disabled", true);
            rb.setEnabled(false);
            p1.add((Component)rb, gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.insets = new Insets(0, 2, 4, 2);
            JComboBox cb = this.createCombo("JComboBox");
            p1.add((Component)cb, gc);
            ++gc.gridx;
            cb = this.createCombo("Disabled");
            cb.setEnabled(false);
            p1.add((Component)cb, gc);
            gc.gridx = 0;
            ++gc.gridy;
            cb = this.createCombo("Editable JComboBox");
            cb.setEditable(true);
            p1.add((Component)cb, gc);
            ++gc.gridx;
            cb = this.createCombo("Disabled");
            cb.setEditable(true);
            cb.setEnabled(false);
            p1.add((Component)cb, gc);
            gc.gridx = 0;
            ++gc.gridy;
            JTextField tf = new JTextField("JTextField");
            p1.add((Component)tf, gc);
            ++gc.gridx;
            tf = new JTextField("Disabled");
            tf.setEnabled(false);
            p1.add((Component)tf, gc);
            gc.gridx = 0;
            ++gc.gridy;
            tf = new JTextField("Non-Editable Textfield");
            tf.setEditable(false);
            p1.add((Component)tf, gc);
            ++gc.gridx;
            PopupTrigger trigger = new PopupTrigger();
            p1.add((Component)trigger, gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.insets = new Insets(8, 2, 2, 2);
            p2 = new JPanel(new FlowLayout(0, 0, 0));
            JSpinner spinn = new JSpinner(new SpinnerNumberModel(41, 0, 42, 1));
            p2.add(spinn);
            p2.add(new JLabel(" "));
            spinn = new JSpinner(new SpinnerDateModel());
            p2.add(spinn);
            p1.add((Component)p2, gc);
            ++gc.gridx;
            p2 = new JPanel(new FlowLayout(0, 0, 0));
            spinn = new JSpinner(new SpinnerNumberModel(42, 0, 42, 1));
            spinn.setEnabled(false);
            p2.add(spinn);
            p2.add(new JLabel(" "));
            spinn = new JSpinner(new SpinnerDateModel(new Date(), null, null, 7));
            spinn.setEnabled(false);
            p2.add(spinn);
            p1.add((Component)p2, gc);
            p2 = new JPanel(new FlowLayout(0, 0, 0));
            p2.add(p1);
            p0.add((Component)p2, "Center");
            JPanel p3 = new JPanel(new BorderLayout());
            p2 = new JPanel(new GridLayout(1, 2));
            JTree tree = new JTree();
            tree.expandPath(tree.getNextMatch("sports", 0, Position.Bias.Forward));
            p2.add(tree);
            tree = new JTree();
            tree.expandPath(tree.getNextMatch("sports", 0, Position.Bias.Forward));
            tree.setEnabled(false);
            p2.add(tree);
            p3.add((Component)p2, "Center");
            p1 = new JPanel(new BorderLayout(8, 0));
            p2 = new JPanel(new GridBagLayout());
            gc.anchor = 17;
            gc.fill = 3;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(0, 2, 0, 2);
            ControlPanel.this.vertProgressBar = new JProgressBar(1, 0, 20);
            ControlPanel.this.vertProgressBar.setValue(0);
            ControlPanel.this.vertProgressBar.setStringPainted(true);
            ControlPanel.this.vertProgressBar.addMouseListener(new ProgressBarAction());
            ControlPanel.this.vertProgressBar.setToolTipText("Click to start/stop");
            p2.add((Component)ControlPanel.this.vertProgressBar, gc);
            ++gc.gridx;
            ControlPanel.this.vertSlider = new JSlider(1, 0, 30, 25);
            ControlPanel.this.vertSlider.setPreferredSize(new Dimension(36, 130));
            ControlPanel.this.vertSlider.setMajorTickSpacing(10);
            ControlPanel.this.vertSlider.setMinorTickSpacing(5);
            ControlPanel.this.vertSlider.setPaintTicks(true);
            p2.add((Component)ControlPanel.this.vertSlider, gc);
            p1.add((Component)p2, "West");
            p2 = new JPanel(new GridBagLayout());
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 0, 2, 0);
            ControlPanel.this.horzProgressBar = new JProgressBar(0, 20);
            ControlPanel.this.horzProgressBar.setValue(0);
            ControlPanel.this.horzProgressBar.setStringPainted(true);
            ControlPanel.this.horzProgressBar.addMouseListener(new ProgressBarAction());
            ControlPanel.this.horzProgressBar.setToolTipText("Click to start/stop");
            p2.add((Component)ControlPanel.this.horzProgressBar, gc);
            ++gc.gridy;
            ControlPanel.this.horzSlider = new JSlider(0, 0, 30, 25);
            ControlPanel.this.horzSlider.setPreferredSize(new Dimension(150, 36));
            ControlPanel.this.horzSlider.setMajorTickSpacing(10);
            ControlPanel.this.horzSlider.setMinorTickSpacing(5);
            ControlPanel.this.horzSlider.setPaintTicks(true);
            p2.add((Component)ControlPanel.this.horzSlider, gc);
            p1.add((Component)p2, "North");
            p2 = new JPanel(new GridBagLayout());
            gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(3, 2, 3, 2);
            rb = new JRadioButton("Sliders Enabled", true);
            rb.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    if (ControlPanel.access$32(ExamplePanel.access$0(this.this$1)).isEnabled()) {
                        ControlPanel.access$32(ExamplePanel.access$0(this.this$1)).setEnabled(false);
                        ControlPanel.access$28(ExamplePanel.access$0(this.this$1)).setEnabled(false);
                    } else {
                        ControlPanel.access$32(ExamplePanel.access$0(this.this$1)).setEnabled(true);
                        ControlPanel.access$28(ExamplePanel.access$0(this.this$1)).setEnabled(true);
                    }
                }
            });
            p2.add((Component)rb, gc);
            ++gc.gridy;
            JButton b = new JButton("MessageDialog");
            b.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.access$33(ExamplePanel.access$0(this.this$1));
                }
            });
            p2.add((Component)b, gc);
            ++gc.gridy;
            b = new JButton("ConfirmDialog");
            b.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.access$34(ExamplePanel.access$0(this.this$1));
                }
            });
            p2.add((Component)b, gc);
            ++gc.gridy;
            b = new JButton("WarningDialog");
            b.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.access$35(ExamplePanel.access$0(this.this$1));
                }
            });
            p2.add((Component)b, gc);
            ++gc.gridy;
            b = new JButton("ErrorDialog");
            b.addActionListener(new ActionListener(this){
                final /* synthetic */ ExamplePanel this$1;
                {
                    this.this$1 = examplePanel;
                }

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.access$36(ExamplePanel.access$0(this.this$1));
                }
            });
            p2.add((Component)b, gc);
            p1.add((Component)p2, "Center");
            p3.add((Component)p1, "East");
            p0.add((Component)p3, "East");
            p2 = new JPanel(new FlowLayout(0, 4, 4));
            p2.setBorder(new EtchedBorder());
            p2.add(p0);
            this.add((Component)p2, "North");
            this.add((Component)new Desktop(), "Center");
        }

        private JList createList() {
            String[] items = new String[]{"A JList", "can have", "zero to", "many items", "and can be", "scrolled", "(or not)"};
            return new JList<String>(items);
        }

        private JComboBox createCombo(String s) {
            String[] items = new String[]{s, "can have", "zero to", "many items", "and can be", "triggered", "many times"};
            return new JComboBox<String>(items);
        }

        public void update(boolean forceUpdate) {
            ControlPanel.this.updateTheme();
            if (forceUpdate) {
                ControlPanel.this.updateThemeButton.setEnabled(true);
            }
            this.repaint(0L);
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        class Desktop
        extends JDesktopPane {
            Desktop() {
                this.setBackground(Color.GRAY);
                this.setupUI();
            }

            private void setupUI() {
                JPanel p0 = new JPanel();
                p0.setBounds(0, 0, 780, 160);
                JTable table = new JTable(new SmallTableModel());
                table.setColumnSelectionAllowed(true);
                JScrollPane sp = new JScrollPane(table);
                sp.setBounds(10, 40, 192, 96);
                this.add((Component)sp, JLayeredPane.DEFAULT_LAYER);
                ControlPanel.this.internalFrame = new JInternalFrame("JInternalFrame", true, true, true, true);
                ControlPanel.this.internalFrame.setDefaultCloseOperation(0);
                ControlPanel.this.internalFrame.addInternalFrameListener(new InternalFrameAdapter(this){
                    final /* synthetic */ Desktop this$2;
                    {
                        this.this$2 = desktop;
                    }

                    public void internalFrameClosing(InternalFrameEvent e) {
                        String msg = "This internal frame cannot be closed.";
                        JOptionPane.showMessageDialog(ControlPanel.access$1(ExamplePanel.access$0(Desktop.access$0(this.this$2))), msg, "Info", 1);
                        e.getInternalFrame().show();
                    }
                });
                ControlPanel.this.internalFrame.getContentPane().add(new SizedPanel(200, 100));
                ControlPanel.this.internalFrame.pack();
                Dimension frameSize = ControlPanel.this.internalFrame.getPreferredSize();
                ControlPanel.this.internalFrame.setBounds(400, 10, frameSize.width, frameSize.height);
                ControlPanel.this.internalFrame.show();
                this.add((Component)ControlPanel.this.internalFrame, JLayeredPane.PALETTE_LAYER);
                ControlPanel.this.palette = new JInternalFrame("Palette");
                ControlPanel.this.palette.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
                JPanel pp = new JPanel();
                pp.setBackground(Color.WHITE);
                ControlPanel.this.palette.getContentPane().add(pp);
                ControlPanel.this.palette.setBounds(400 + ControlPanel.this.internalFrame.getWidth() + 2, 10, 80, 140);
                ControlPanel.this.palette.show();
                this.add((Component)ControlPanel.this.palette, JLayeredPane.DRAG_LAYER);
            }

            static /* synthetic */ ExamplePanel access$0(Desktop desktop) {
                return desktop.ExamplePanel.this;
            }
        }
    }

    class ScrollsCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private boolean inited = false;

        ScrollsCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Thumb Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.scrollThumbField = new HSBField(Theme.scrollThumbColor);
            p1.add((Component)ControlPanel.this.scrollThumbField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.scrollThumbRolloverBg = new HSBField(Theme.scrollThumbRolloverColor);
            p1.add((Component)ControlPanel.this.scrollThumbRolloverBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Presssed Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.scrollThumbPressedBg = new HSBField(Theme.scrollThumbPressedColor);
            p1.add((Component)ControlPanel.this.scrollThumbPressedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.scrollThumbDisabledBg = new HSBField(Theme.scrollThumbDisabledColor);
            p1.add((Component)ControlPanel.this.scrollThumbDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Grip Dark Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollGripDark = new HSBField(Theme.scrollGripDarkColor);
            p1.add((Component)ControlPanel.this.scrollGripDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Grip Light Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollGripLight = new HSBField(Theme.scrollGripLightColor);
            p1.add((Component)ControlPanel.this.scrollGripLight, gc);
            gc.gridy = 7;
            gc.insets = new Insets(0, 8, 0, 4);
            this.rolloverEnabled = new JCheckBox("Paint Rollover", false);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.rolloverEnabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollButtField = new HSBField(Theme.scrollButtColor);
            p1.add((Component)ControlPanel.this.scrollButtField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Rollover Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollButtRolloverBg = new HSBField(Theme.scrollButtRolloverColor);
            p1.add((Component)ControlPanel.this.scrollButtRolloverBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Presssed Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollButtPressedBg = new HSBField(Theme.scrollButtPressedColor);
            p1.add((Component)ControlPanel.this.scrollButtPressedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollButtDisabledBg = new HSBField(Theme.scrollButtDisabledColor);
            p1.add((Component)ControlPanel.this.scrollButtDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollSpreadLight = new SpreadPanel(Theme.scrollSpreadLight, 20);
            p1.add((Component)ControlPanel.this.scrollSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollSpreadDark = new SpreadPanel(Theme.scrollSpreadDark, 20);
            p1.add((Component)ControlPanel.this.scrollSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollSpreadLightDisabled = new SpreadPanel(Theme.scrollSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.scrollSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollSpreadDarkDisabled = new SpreadPanel(Theme.scrollSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.scrollSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollBorder = new HSBField(Theme.scrollBorderColor);
            p1.add((Component)ControlPanel.this.scrollBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollDark = new HSBField(Theme.scrollDarkColor);
            p1.add((Component)ControlPanel.this.scrollDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollLight = new HSBField(Theme.scrollLightColor);
            p1.add((Component)ControlPanel.this.scrollLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollBorderDisabled = new HSBField(Theme.scrollBorderDisabledColor);
            p1.add((Component)ControlPanel.this.scrollBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollDarkDisabled = new HSBField(Theme.scrollDarkDisabledColor);
            p1.add((Component)ControlPanel.this.scrollDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollLightDisabled = new HSBField(Theme.scrollLightDisabledColor);
            p1.add((Component)ControlPanel.this.scrollLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Track Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.trackField = new HSBField(Theme.scrollTrackColor);
            p1.add((Component)ControlPanel.this.trackField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Track Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.trackDisabled = new HSBField(Theme.scrollTrackDisabledColor);
            p1.add((Component)ControlPanel.this.trackDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Track Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.trackBorder = new HSBField(Theme.scrollTrackBorderColor);
            p1.add((Component)ControlPanel.this.trackBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.trackBorderDisabled = new HSBField(Theme.scrollTrackBorderDisabledColor);
            p1.add((Component)ControlPanel.this.trackBorderDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Arrow Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollArrowField = new HSBField(Theme.scrollArrowColor);
            p1.add((Component)ControlPanel.this.scrollArrowField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Arrow Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollArrowDisabled = new HSBField(Theme.scrollArrowDisabledColor);
            p1.add((Component)ControlPanel.this.scrollArrowDisabled, gc);
            gc.gridy += 3;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Scrollpane Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.scrollPane = new HSBField(Theme.scrollPaneBorderColor);
            p1.add((Component)ControlPanel.this.scrollPane, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.rolloverEnabled.setSelected(Theme.scrollRollover[Theme.style]);
            ControlPanel.this.scrollThumbField.update();
            ControlPanel.this.scrollButtField.update();
            ControlPanel.this.scrollArrowField.update();
            ControlPanel.this.trackField.update();
            ControlPanel.this.scrollThumbRolloverBg.update();
            ControlPanel.this.scrollThumbPressedBg.update();
            ControlPanel.this.scrollThumbDisabledBg.update();
            ControlPanel.this.trackBorder.update();
            ControlPanel.this.scrollButtRolloverBg.update();
            ControlPanel.this.scrollButtPressedBg.update();
            ControlPanel.this.scrollButtDisabledBg.update();
            ControlPanel.this.trackDisabled.update();
            ControlPanel.this.trackBorderDisabled.update();
            ControlPanel.this.scrollArrowDisabled.update();
            ControlPanel.this.scrollGripDark.update();
            ControlPanel.this.scrollGripLight.update();
            ControlPanel.this.scrollBorder.update();
            ControlPanel.this.scrollDark.update();
            ControlPanel.this.scrollLight.update();
            ControlPanel.this.scrollBorderDisabled.update();
            ControlPanel.this.scrollDarkDisabled.update();
            ControlPanel.this.scrollLightDisabled.update();
            ControlPanel.this.scrollPane.update();
            ControlPanel.this.scrollSpreadDark.init();
            ControlPanel.this.scrollSpreadLight.init();
            ControlPanel.this.scrollSpreadDarkDisabled.init();
            ControlPanel.this.scrollSpreadLightDisabled.init();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.scrollRollover[Theme.style] = this.rolloverEnabled.isSelected();
        }
    }

    class SliderCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private boolean inited = false;

        SliderCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Thumb Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.sliderThumbField = new HSBField(Theme.sliderThumbColor);
            p1.add((Component)ControlPanel.this.sliderThumbField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.sliderThumbRolloverBg = new HSBField(Theme.sliderThumbRolloverColor);
            p1.add((Component)ControlPanel.this.sliderThumbRolloverBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Presssed Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.sliderThumbPressedBg = new HSBField(Theme.sliderThumbPressedColor);
            p1.add((Component)ControlPanel.this.sliderThumbPressedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.sliderThumbDisabledBg = new HSBField(Theme.sliderThumbDisabledColor);
            p1.add((Component)ControlPanel.this.sliderThumbDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderBorder = new HSBField(Theme.sliderBorderColor);
            p1.add((Component)ControlPanel.this.sliderBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderDark = new HSBField(Theme.sliderDarkColor);
            p1.add((Component)ControlPanel.this.sliderDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderLight = new HSBField(Theme.sliderLightColor);
            p1.add((Component)ControlPanel.this.sliderLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderDisabledBorder = new HSBField(Theme.sliderBorderDisabledColor);
            p1.add((Component)ControlPanel.this.sliderDisabledBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Dark Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderDisabledDark = new HSBField(Theme.sliderDarkDisabledColor);
            p1.add((Component)ControlPanel.this.sliderDisabledDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Light Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderDisabledLight = new HSBField(Theme.sliderLightDisabledColor);
            p1.add((Component)ControlPanel.this.sliderDisabledLight, gc);
            gc.gridy += 2;
            gc.insets = new Insets(0, 8, 0, 4);
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.rolloverEnabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Track Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTrack = new HSBField(Theme.sliderTrackColor);
            p1.add((Component)ControlPanel.this.sliderTrack, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Track Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTrackBorder = new HSBField(Theme.sliderTrackBorderColor);
            p1.add((Component)ControlPanel.this.sliderTrackBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Track Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTrackDark = new HSBField(Theme.sliderTrackDarkColor);
            p1.add((Component)ControlPanel.this.sliderTrackDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Track Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTrackLight = new HSBField(Theme.sliderTrackLightColor);
            p1.add((Component)ControlPanel.this.sliderTrackLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Ticks Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTick = new HSBField(Theme.sliderTickColor);
            p1.add((Component)ControlPanel.this.sliderTick, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Ticks Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.sliderTickDisabled = new HSBField(Theme.sliderTickDisabledColor);
            p1.add((Component)ControlPanel.this.sliderTickDisabled, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.rolloverEnabled.setSelected(Theme.sliderRollover[Theme.style]);
            ControlPanel.this.sliderThumbField.update();
            ControlPanel.this.sliderThumbRolloverBg.update();
            ControlPanel.this.sliderThumbPressedBg.update();
            ControlPanel.this.sliderThumbDisabledBg.update();
            ControlPanel.this.sliderBorder.update();
            ControlPanel.this.sliderDark.update();
            ControlPanel.this.sliderLight.update();
            ControlPanel.this.sliderDisabledBorder.update();
            ControlPanel.this.sliderDisabledDark.update();
            ControlPanel.this.sliderDisabledLight.update();
            ControlPanel.this.sliderTrack.update();
            ControlPanel.this.sliderTrackBorder.update();
            ControlPanel.this.sliderTrackDark.update();
            ControlPanel.this.sliderTrackLight.update();
            ControlPanel.this.sliderTick.update();
            ControlPanel.this.sliderTickDisabled.update();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.sliderRollover[Theme.style] = this.rolloverEnabled.isSelected();
        }
    }

    class ToolCP
    extends JPanel {
        private JCheckBox focusEnabled;
        private boolean inited = false;

        ToolCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("ToolBar Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.toolBar = new HSBField(Theme.toolBarColor, true);
            p1.add((Component)ControlPanel.this.toolBar, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("ToolBar Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.toolBarLight = new HSBField(Theme.toolBarLightColor, true);
            p1.add((Component)ControlPanel.this.toolBarLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("ToolBar Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.toolBarDark = new HSBField(Theme.toolBarDarkColor, true);
            p1.add((Component)ControlPanel.this.toolBarDark, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolButt = new HSBField(Theme.toolButtColor, true);
            p1.add((Component)ControlPanel.this.toolButt, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Button Rollover"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolButtRollover = new HSBField(Theme.toolButtRolloverColor, true);
            p1.add((Component)ControlPanel.this.toolButtRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Button Pressed"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolButtPressed = new HSBField(Theme.toolButtPressedColor, true);
            p1.add((Component)ControlPanel.this.toolButtPressed, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolBorder = new HSBField(Theme.toolBorderColor, true);
            p1.add((Component)ControlPanel.this.toolBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Pressed"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolBorderPressed = new HSBField(Theme.toolBorderPressedColor, true);
            p1.add((Component)ControlPanel.this.toolBorderPressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Selected"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolBorderSelected = new HSBField(Theme.toolBorderSelectedColor, true);
            p1.add((Component)ControlPanel.this.toolBorderSelected, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolBorderDark = new HSBField(Theme.toolBorderDarkColor, true);
            p1.add((Component)ControlPanel.this.toolBorderDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.toolBorderLight = new HSBField(Theme.toolBorderLightColor, true);
            p1.add((Component)ControlPanel.this.toolBorderLight, gc);
            gc.gridy += 2;
            gc.insets = new Insets(0, 8, 0, 4);
            gc.gridheight = 2;
            this.focusEnabled = new JCheckBox("Paint Focus", true);
            this.focusEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.focusEnabled, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.focusEnabled.setSelected(Theme.toolFocus[Theme.style]);
            ControlPanel.this.toolBar.update();
            ControlPanel.this.toolBarDark.update();
            ControlPanel.this.toolBarLight.update();
            ControlPanel.this.toolButt.update();
            ControlPanel.this.toolButtRollover.update();
            ControlPanel.this.toolButtPressed.update();
            ControlPanel.this.toolBorder.update();
            ControlPanel.this.toolBorderPressed.update();
            ControlPanel.this.toolBorderSelected.update();
            ControlPanel.this.toolBorderDark.update();
            ControlPanel.this.toolBorderLight.update();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.toolFocus[Theme.style] = this.focusEnabled.isSelected();
        }
    }

    class TableCP
    extends JPanel {
        private JCheckBox focusEnabled;
        private boolean inited = false;

        TableCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Background Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tableBack = new HSBField(Theme.tableBackColor, true);
            p1.add((Component)ControlPanel.this.tableBack, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Header Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tableHeaderBack = new HSBField(Theme.tableHeaderBackColor, true);
            p1.add((Component)ControlPanel.this.tableHeaderBack, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Grid Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tableGrid = new HSBField(Theme.tableGridColor, true);
            p1.add((Component)ControlPanel.this.tableGrid, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Cell Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tableSelectedBack = new HSBField(Theme.tableSelectedBackColor, true);
            p1.add((Component)ControlPanel.this.tableSelectedBack, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Cell Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tableSelectedFore = new BlackWhitePanel(Theme.tableSelectedForeColor, true);
            p1.add((Component)ControlPanel.this.tableSelectedFore, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.tableBack.update();
            ControlPanel.this.tableHeaderBack.update();
            ControlPanel.this.tableGrid.update();
            ControlPanel.this.tableSelectedBack.update();
            ControlPanel.this.tableSelectedFore.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class SpinnerCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private boolean inited = false;

        SpinnerCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.spinnerButtField = new HSBField(Theme.spinnerButtColor);
            p1.add((Component)ControlPanel.this.spinnerButtField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.spinnerButtRolloverBg = new HSBField(Theme.spinnerButtRolloverColor);
            p1.add((Component)ControlPanel.this.spinnerButtRolloverBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Presssed Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.spinnerButtPressedBg = new HSBField(Theme.spinnerButtPressedColor);
            p1.add((Component)ControlPanel.this.spinnerButtPressedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.spinnerButtDisabledBg = new HSBField(Theme.spinnerButtDisabledColor);
            p1.add((Component)ControlPanel.this.spinnerButtDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerSpreadLight = new SpreadPanel(Theme.spinnerSpreadLight, 20);
            p1.add((Component)ControlPanel.this.spinnerSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerSpreadDark = new SpreadPanel(Theme.spinnerSpreadDark, 20);
            p1.add((Component)ControlPanel.this.spinnerSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerSpreadLightDisabled = new SpreadPanel(Theme.spinnerSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.spinnerSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerSpreadDarkDisabled = new SpreadPanel(Theme.spinnerSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.spinnerSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerBorder = new HSBField(Theme.spinnerBorderColor);
            p1.add((Component)ControlPanel.this.spinnerBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerDark = new HSBField(Theme.spinnerDarkColor);
            p1.add((Component)ControlPanel.this.spinnerDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerLight = new HSBField(Theme.spinnerLightColor);
            p1.add((Component)ControlPanel.this.spinnerLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerDisabledBorder = new HSBField(Theme.spinnerBorderDisabledColor);
            p1.add((Component)ControlPanel.this.spinnerDisabledBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerDisabledDark = new HSBField(Theme.spinnerDarkDisabledColor);
            p1.add((Component)ControlPanel.this.spinnerDisabledDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerDisabledLight = new HSBField(Theme.spinnerLightDisabledColor);
            p1.add((Component)ControlPanel.this.spinnerDisabledLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Arrow Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerArrowField = new HSBField(Theme.spinnerArrowColor);
            p1.add((Component)ControlPanel.this.spinnerArrowField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Arrow"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.spinnerArrowDisabled = new HSBField(Theme.spinnerArrowDisabledColor);
            p1.add((Component)ControlPanel.this.spinnerArrowDisabled, gc);
            gc.gridy += 2;
            gc.gridheight = 2;
            gc.insets = new Insets(0, 8, 0, 4);
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.rolloverEnabled, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.rolloverEnabled.setSelected(Theme.spinnerRollover[Theme.style]);
            ControlPanel.this.spinnerButtField.update();
            ControlPanel.this.spinnerArrowField.update();
            ControlPanel.this.spinnerButtRolloverBg.update();
            ControlPanel.this.spinnerButtPressedBg.update();
            ControlPanel.this.spinnerButtDisabledBg.update();
            ControlPanel.this.spinnerBorder.update();
            ControlPanel.this.spinnerDark.update();
            ControlPanel.this.spinnerLight.update();
            ControlPanel.this.spinnerDisabledBorder.update();
            ControlPanel.this.spinnerDisabledDark.update();
            ControlPanel.this.spinnerDisabledLight.update();
            ControlPanel.this.spinnerArrowDisabled.update();
            ControlPanel.this.spinnerSpreadDark.init();
            ControlPanel.this.spinnerSpreadLight.init();
            ControlPanel.this.spinnerSpreadDarkDisabled.init();
            ControlPanel.this.spinnerSpreadLightDisabled.init();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.spinnerRollover[Theme.style] = this.rolloverEnabled.isSelected();
        }
    }

    class MenuCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private boolean inited = false;

        MenuCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("MenuBar Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.menuBar = new HSBField(Theme.menuBarColor, true);
            p1.add((Component)ControlPanel.this.menuBar, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Menu Rollover Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.menuRolloverField = new HSBField(Theme.menuRolloverColor);
            p1.add((Component)ControlPanel.this.menuRolloverField, gc);
            gc.gridy += 2;
            gc.insets = new Insets(0, 4, 0, 4);
            gc.gridheight = 2;
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.rolloverEnabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Popup Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuPopup = new HSBField(Theme.menuPopupColor);
            p1.add((Component)ControlPanel.this.menuPopup, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuBorder = new HSBField(Theme.menuBorderColor);
            p1.add((Component)ControlPanel.this.menuBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuDark = new HSBField(Theme.menuDarkColor);
            p1.add((Component)ControlPanel.this.menuDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuLight = new HSBField(Theme.menuLightColor);
            p1.add((Component)ControlPanel.this.menuLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuItemRollover = new HSBField(Theme.menuItemRolloverColor);
            p1.add((Component)ControlPanel.this.menuItemRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuSelectedText = new BlackWhitePanel(Theme.menuSelectedTextColor);
            p1.add((Component)ControlPanel.this.menuSelectedText, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Icon Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuIcon = new HSBField(Theme.menuIconColor);
            p1.add((Component)ControlPanel.this.menuIcon, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Icon Rollover"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuIconRollover = new HSBField(Theme.menuIconRolloverColor);
            p1.add((Component)ControlPanel.this.menuIconRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Icon Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuIconDisabled = new HSBField(Theme.menuIconDisabledColor);
            p1.add((Component)ControlPanel.this.menuIconDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Shadow"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuIconShadow = new HSBField(Theme.menuIconShadowColor);
            p1.add((Component)ControlPanel.this.menuIconShadow, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Separator Dark Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuSepDark = new HSBField(Theme.menuSepDarkColor);
            p1.add((Component)ControlPanel.this.menuSepDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Separator Light Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.menuSepLight = new HSBField(Theme.menuSepLightColor);
            p1.add((Component)ControlPanel.this.menuSepLight, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.menuSelectedText.update();
            ControlPanel.this.menuRolloverField.update();
            ControlPanel.this.menuBar.update();
            ControlPanel.this.menuBorder.update();
            ControlPanel.this.menuDark.update();
            ControlPanel.this.menuLight.update();
            ControlPanel.this.menuPopup.update();
            ControlPanel.this.menuItemRollover.update();
            ControlPanel.this.menuIcon.update();
            ControlPanel.this.menuIconRollover.update();
            ControlPanel.this.menuIconDisabled.update();
            ControlPanel.this.menuIconShadow.update();
            ControlPanel.this.menuSepDark.update();
            ControlPanel.this.menuSepLight.update();
            this.rolloverEnabled.setSelected(Theme.menuRollover[Theme.style]);
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.menuRollover[Theme.style] = this.rolloverEnabled.isSelected();
        }
    }

    class TreeCP
    extends JPanel {
        private boolean inited = false;

        TreeCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Tree Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.treeBg = new HSBField(Theme.treeBgColor, true);
            p1.add((Component)ControlPanel.this.treeBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Text Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.treeTextBg = new HSBField(Theme.treeTextBgColor, true);
            p1.add((Component)ControlPanel.this.treeTextBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Text Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.treeText = new BlackWhitePanel(Theme.treeTextColor, true);
            p1.add((Component)ControlPanel.this.treeText, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Text Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.treeSelectedBg = new HSBField(Theme.treeSelectedBgColor, true);
            p1.add((Component)ControlPanel.this.treeSelectedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.treeSelectedText = new BlackWhitePanel(Theme.treeSelectedTextColor, true);
            p1.add((Component)ControlPanel.this.treeSelectedText, gc);
            ++gc.gridy;
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.treeText.update();
            ControlPanel.this.treeSelectedText.update();
            ControlPanel.this.treeBg.update();
            ControlPanel.this.treeTextBg.update();
            ControlPanel.this.treeSelectedBg.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class TabsCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private JCheckBox focusEnabled;
        private JSpinner firstTabDist;
        private boolean inited = false;

        TabsCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Pane Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tabPaneBorder = new HSBField(Theme.tabPaneBorderColor, true);
            p1.add((Component)ControlPanel.this.tabPaneBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Pane Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tabPaneDark = new HSBField(Theme.tabPaneDarkColor, true);
            p1.add((Component)ControlPanel.this.tabPaneDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Pane Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tabPaneLight = new HSBField(Theme.tabPaneLightColor, true);
            p1.add((Component)ControlPanel.this.tabPaneLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Unselected Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabNormalBg = new HSBField(Theme.tabNormalColor, true);
            p1.add((Component)ControlPanel.this.tabNormalBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabSelectedBg = new HSBField(Theme.tabSelectedColor, true);
            p1.add((Component)ControlPanel.this.tabSelectedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Rollover Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabRoll = new HSBField(Theme.tabRolloverColor, true);
            p1.add((Component)ControlPanel.this.tabRoll, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Tab Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabBorder = new HSBField(Theme.tabBorderColor, true);
            p1.add((Component)ControlPanel.this.tabBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Tab Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabDark = new HSBField(Theme.tabDarkColor, true);
            p1.add((Component)ControlPanel.this.tabDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Tab Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.tabLight = new HSBField(Theme.tabLightColor, true);
            p1.add((Component)ControlPanel.this.tabLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("First Tab Distance"), gc);
            ++gc.gridy;
            gc.gridheight = 2;
            this.firstTabDist = new JSpinner(new SpinnerNumberModel(2, 2, 12, 1));
            this.firstTabDist.addChangeListener(ControlPanel.this.updateAction);
            p1.add((Component)this.firstTabDist, gc);
            gc.gridy = 3;
            gc.gridheight = 3;
            gc.insets = new Insets(0, 8, 0, 4);
            JPanel p2 = new JPanel(new GridLayout(2, 1));
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p2.add(this.rolloverEnabled);
            this.focusEnabled = new JCheckBox("Paint Focus", true);
            this.focusEnabled.addActionListener(ControlPanel.this.iconCheckAction);
            p2.add(this.focusEnabled);
            p1.add((Component)p2, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.firstTabDist.setValue(new Integer(Theme.firstTabDistance[Theme.style]));
            this.rolloverEnabled.setSelected(Theme.tabRollover[Theme.style]);
            this.focusEnabled.setSelected(Theme.tabFocus[Theme.style]);
            ControlPanel.this.tabPaneBorder.update();
            ControlPanel.this.tabPaneDark.update();
            ControlPanel.this.tabPaneLight.update();
            ControlPanel.this.tabNormalBg.update();
            ControlPanel.this.tabSelectedBg.update();
            ControlPanel.this.tabBorder.update();
            ControlPanel.this.tabDark.update();
            ControlPanel.this.tabLight.update();
            ControlPanel.this.tabRoll.update();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.tabRollover[Theme.style] = this.rolloverEnabled.isSelected();
            Theme.tabFocus[Theme.style] = this.focusEnabled.isSelected();
            Theme.firstTabDistance[Theme.style] = this.getFirstTabDistance();
        }

        int getFirstTabDistance() {
            return (Integer)this.firstTabDist.getValue();
        }
    }

    class TextCP
    extends JPanel {
        private JSpinner mTop;
        private JSpinner mLeft;
        private JSpinner mBottom;
        private JSpinner mRight;
        private boolean inited = false;

        TextCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Text Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.textBg = new HSBField(Theme.textBgColor, true);
            p1.add((Component)ControlPanel.this.textBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Text Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.textText = new BlackWhitePanel(Theme.textTextColor, true);
            p1.add((Component)ControlPanel.this.textText, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textSelectedBg = new HSBField(Theme.textSelectedBgColor, true);
            p1.add((Component)ControlPanel.this.textSelectedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Selected Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textSelectedText = new BlackWhitePanel(Theme.textSelectedTextColor, true);
            p1.add((Component)ControlPanel.this.textSelectedText, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textDisabledBg = new HSBField(Theme.textDisabledBgColor);
            p1.add((Component)ControlPanel.this.textDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textBorder = new HSBField(Theme.textBorderColor);
            p1.add((Component)ControlPanel.this.textBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textDark = new HSBField(Theme.textDarkColor);
            p1.add((Component)ControlPanel.this.textDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textLight = new HSBField(Theme.textLightColor);
            p1.add((Component)ControlPanel.this.textLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textBorderDisabled = new HSBField(Theme.textBorderDisabledColor);
            p1.add((Component)ControlPanel.this.textBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textDisabledDark = new HSBField(Theme.textDarkDisabledColor);
            p1.add((Component)ControlPanel.this.textDisabledDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.textDisabledLight = new HSBField(Theme.textLightDisabledColor);
            p1.add((Component)ControlPanel.this.textDisabledLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 6;
            gc.insets = new Insets(2, 16, 0, 4);
            JPanel p2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc2 = new GridBagConstraints();
            gc2.anchor = 18;
            gc2.fill = 2;
            gc2.gridx = 0;
            gc2.gridy = 1;
            gc2.insets = new Insets(0, 2, 0, 2);
            this.mLeft = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mLeft.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mLeft, gc2);
            ++gc2.gridx;
            gc2.gridy = 0;
            this.mTop = new JSpinner(new SpinnerNumberModel(2, 1, 8, 1));
            this.mTop.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mTop, gc2);
            ++gc2.gridy;
            p2.add((Component)new JLabel("Insets"), gc2);
            ++gc2.gridy;
            this.mBottom = new JSpinner(new SpinnerNumberModel(3, 1, 8, 1));
            this.mBottom.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mBottom, gc2);
            ++gc2.gridx;
            gc2.gridy = 1;
            this.mRight = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mRight.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mRight, gc2);
            p1.add((Component)p2, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.textText.update();
            ControlPanel.this.textSelectedText.update();
            this.mTop.setValue(new Integer(Theme.textInsets[Theme.style].top));
            this.mLeft.setValue(new Integer(Theme.textInsets[Theme.style].left));
            this.mBottom.setValue(new Integer(Theme.textInsets[Theme.style].bottom));
            this.mRight.setValue(new Integer(Theme.textInsets[Theme.style].right));
            ControlPanel.this.textBg.update();
            ControlPanel.this.textSelectedBg.update();
            ControlPanel.this.textDisabledBg.update();
            ControlPanel.this.textBorder.update();
            ControlPanel.this.textDark.update();
            ControlPanel.this.textLight.update();
            ControlPanel.this.textDisabledDark.update();
            ControlPanel.this.textDisabledLight.update();
            ControlPanel.this.textBorderDisabled.update();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.textInsets[Theme.style] = new Insets((Integer)this.mTop.getValue(), (Integer)this.mLeft.getValue(), (Integer)this.mBottom.getValue(), (Integer)this.mRight.getValue());
        }
    }

    class ListCP
    extends JPanel {
        private boolean inited = false;

        ListCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Selected Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.listSelectedBg = new HSBField(Theme.listSelectedBgColor, true);
            p1.add((Component)ControlPanel.this.listSelectedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Selected Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.listSelectedText = new BlackWhitePanel(Theme.listSelectedTextColor, true);
            p1.add((Component)ControlPanel.this.listSelectedText, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.listSelectedText.update();
            ControlPanel.this.listSelectedBg.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class MiscCP
    extends JPanel {
        private boolean inited = false;

        MiscCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("TitledBorder Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.titledBorderColor = new HSBField(Theme.titledBorderColor, true);
            p1.add((Component)ControlPanel.this.titledBorderColor, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.titledBorderColor.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class TipCP
    extends JPanel {
        private boolean inited = false;

        TipCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Background Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tipBg = new HSBField(Theme.tipBgColor);
            p1.add((Component)ControlPanel.this.tipBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.tipBorder = new HSBField(Theme.tipBorderColor);
            p1.add((Component)ControlPanel.this.tipBorder, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.tipBg.update();
            ControlPanel.this.tipBorder.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class IconCP
    extends JPanel {
        private boolean inited = false;
        private JCheckBox colorizeFrameIcon;
        private JCheckBox colorizeFileViewIcon;
        private JCheckBox colorizeFileChooserIcon;
        private JCheckBox colorizeOptionPaneIcon;
        private JCheckBox colorizeTreeIcon;

        IconCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 2, 0, 12);
            p1.add((Component)new JLabel("Frame Icon"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 0, 12);
            ControlPanel.this.frameIcon = new HSBField(Theme.frameIconColor, true);
            p1.add((Component)ControlPanel.this.frameIcon, gc);
            ++gc.gridy;
            this.colorizeFrameIcon = new JCheckBox("Colorize");
            this.colorizeFrameIcon.addActionListener(ControlPanel.this.iconCheckAction);
            p1.add((Component)this.colorizeFrameIcon, gc);
            gc.gridy = 1;
            gc.gridx = 1;
            gc.gridheight = 2;
            gc.insets = new Insets(1, 2, 0, 2);
            ((ControlPanel)ControlPanel.this).iconChecks[0] = new CheckedIcon(true);
            p1.add((Component)ControlPanel.this.iconChecks[0], gc);
            gc.gridy = 3;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(12, 2, 0, 12);
            p1.add((Component)new JLabel("Tree Icon"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 0, 12);
            ControlPanel.this.treeIcon = new HSBField(Theme.treeIconColor, true);
            p1.add((Component)ControlPanel.this.treeIcon, gc);
            ++gc.gridy;
            this.colorizeTreeIcon = new JCheckBox("Colorize");
            this.colorizeTreeIcon.addActionListener(ControlPanel.this.iconCheckAction);
            p1.add((Component)this.colorizeTreeIcon, gc);
            gc.gridy = 4;
            gc.gridx = 1;
            gc.gridheight = 2;
            gc.insets = new Insets(1, 2, 0, 2);
            JPanel p4 = new JPanel(new GridLayout(1, 5, 8, 0));
            int i = 1;
            while (i < 3) {
                ((ControlPanel)ControlPanel.this).iconChecks[i] = new CheckedIcon(true);
                p4.add(ControlPanel.this.iconChecks[i]);
                ++i;
            }
            p1.add((Component)p4, gc);
            JPanel p2 = new JPanel(new BorderLayout(12, 0));
            JPanel p3 = new JPanel(new FlowLayout(0, 2, 2));
            p3.add(p1);
            p2.add((Component)p3, "West");
            p1 = new JPanel(new GridBagLayout());
            gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 2, 0, 12);
            p1.add((Component)new JLabel("FileView Icon"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 0, 12);
            ControlPanel.this.fileViewIcon = new HSBField(Theme.fileViewIconColor, true);
            p1.add((Component)ControlPanel.this.fileViewIcon, gc);
            ++gc.gridy;
            this.colorizeFileViewIcon = new JCheckBox("Colorize");
            this.colorizeFileViewIcon.addActionListener(ControlPanel.this.iconCheckAction);
            p1.add((Component)this.colorizeFileViewIcon, gc);
            gc.gridy = 1;
            gc.gridx = 1;
            gc.gridheight = 2;
            gc.fill = 0;
            gc.insets = new Insets(1, 2, 0, 2);
            p4 = new JPanel(new GridLayout(1, 6, 8, 0));
            int i2 = 3;
            while (i2 < 8) {
                ((ControlPanel)ControlPanel.this).iconChecks[i2] = new CheckedIcon(true);
                p4.add(ControlPanel.this.iconChecks[i2]);
                ++i2;
            }
            p1.add((Component)p4, gc);
            gc.gridy = 3;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.fill = 2;
            gc.insets = new Insets(12, 2, 0, 12);
            p1.add((Component)new JLabel("FileChooser Icon"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 0, 12);
            ControlPanel.this.fileChooserIcon = new HSBField(Theme.fileChooserIconColor, true);
            p1.add((Component)ControlPanel.this.fileChooserIcon, gc);
            ++gc.gridy;
            this.colorizeFileChooserIcon = new JCheckBox("Colorize");
            this.colorizeFileChooserIcon.addActionListener(ControlPanel.this.iconCheckAction);
            p1.add((Component)this.colorizeFileChooserIcon, gc);
            gc.gridy = 4;
            gc.gridx = 1;
            gc.gridheight = 2;
            gc.insets = new Insets(1, 2, 0, 2);
            p4 = new JPanel(new GridLayout(1, 4, 8, 0));
            i2 = 8;
            while (i2 < 13) {
                ((ControlPanel)ControlPanel.this).iconChecks[i2] = new CheckedIcon(true);
                p4.add(ControlPanel.this.iconChecks[i2]);
                ++i2;
            }
            p1.add((Component)p4, gc);
            p3 = new JPanel(new FlowLayout(0, 2, 2));
            p3.add(p1);
            p2.add((Component)p3, "Center");
            p1 = new JPanel(new GridBagLayout());
            gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 2, 0, 12);
            p1.add((Component)new JLabel("OptionPane Icon"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 2, 0, 12);
            ControlPanel.this.optionPaneIcon = new HSBField(Theme.optionPaneIconColor, true);
            p1.add((Component)ControlPanel.this.optionPaneIcon, gc);
            ++gc.gridy;
            this.colorizeOptionPaneIcon = new JCheckBox("Colorize");
            this.colorizeOptionPaneIcon.addActionListener(ControlPanel.this.iconCheckAction);
            p1.add((Component)this.colorizeOptionPaneIcon, gc);
            gc.gridy = 1;
            gc.gridx = 1;
            gc.gridheight = 2;
            gc.insets = new Insets(1, 2, 0, 2);
            p4 = new JPanel(new GridLayout(1, 4, 8, 0));
            i2 = 13;
            while (i2 < 17) {
                ((ControlPanel)ControlPanel.this).iconChecks[i2] = new CheckedIcon(true);
                p4.add(ControlPanel.this.iconChecks[i2]);
                ++i2;
            }
            p1.add((Component)p4, gc);
            p3 = new JPanel(new FlowLayout(0, 2, 2));
            p3.add(p1);
            p2.add((Component)p3, "East");
            this.add(p2);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.colorizeFrameIcon.setSelected(Theme.colorizeFrameIcon[Theme.style]);
            this.colorizeTreeIcon.setSelected(Theme.colorizeTreeIcon[Theme.style]);
            this.colorizeFileViewIcon.setSelected(Theme.colorizeFileViewIcon[Theme.style]);
            this.colorizeFileChooserIcon.setSelected(Theme.colorizeFileChooserIcon[Theme.style]);
            this.colorizeOptionPaneIcon.setSelected(Theme.colorizeOptionPaneIcon[Theme.style]);
            ControlPanel.this.iconChecks[0].setIcon(UIManager.getIcon("InternalFrame.icon"));
            ControlPanel.this.iconChecks[1].setIcon(UIManager.getIcon("Tree.closedIcon"));
            ControlPanel.this.iconChecks[2].setIcon(UIManager.getIcon("Tree.openIcon"));
            ControlPanel.this.iconChecks[3].setIcon(UIManager.getIcon("FileView.computerIcon"));
            ControlPanel.this.iconChecks[4].setIcon(UIManager.getIcon("FileView.floppyDriveIcon"));
            ControlPanel.this.iconChecks[5].setIcon(UIManager.getIcon("FileView.hardDriveIcon"));
            ControlPanel.this.iconChecks[6].setIcon(UIManager.getIcon("FileView.directoryIcon"));
            ControlPanel.this.iconChecks[7].setIcon(UIManager.getIcon("FileView.fileIcon"));
            ControlPanel.this.iconChecks[8].setIcon(UIManager.getIcon("FileChooser.upFolderIcon"));
            ControlPanel.this.iconChecks[9].setIcon(UIManager.getIcon("FileChooser.homeFolderIcon"));
            ControlPanel.this.iconChecks[10].setIcon(UIManager.getIcon("FileChooser.newFolderIcon"));
            ControlPanel.this.iconChecks[11].setIcon(UIManager.getIcon("FileChooser.listViewIcon"));
            ControlPanel.this.iconChecks[12].setIcon(UIManager.getIcon("FileChooser.detailsViewIcon"));
            ControlPanel.this.iconChecks[13].setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            ControlPanel.this.iconChecks[14].setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            ControlPanel.this.iconChecks[15].setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            ControlPanel.this.iconChecks[16].setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            int i = 0;
            while (i < 17) {
                ControlPanel.this.iconChecks[i].setSelected(Theme.colorize[Theme.style][i]);
                ++i;
            }
            ControlPanel.this.frameIcon.update();
            ControlPanel.this.treeIcon.update();
            ControlPanel.this.fileViewIcon.update();
            ControlPanel.this.fileChooserIcon.update();
            ControlPanel.this.optionPaneIcon.update();
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.colorizeFrameIcon[Theme.style] = this.colorizeFrameIcon.isSelected();
            Theme.colorizeTreeIcon[Theme.style] = this.colorizeTreeIcon.isSelected();
            Theme.colorizeFileViewIcon[Theme.style] = this.colorizeFileViewIcon.isSelected();
            Theme.colorizeFileChooserIcon[Theme.style] = this.colorizeFileChooserIcon.isSelected();
            Theme.colorizeOptionPaneIcon[Theme.style] = this.colorizeOptionPaneIcon.isSelected();
            int i = 0;
            while (i < 17) {
                Theme.colorize[Theme.style][i] = ControlPanel.this.iconChecks[i].isSelected();
                ++i;
            }
        }
    }

    class ProgressCP
    extends JPanel {
        private boolean inited = false;

        ProgressCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Track Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.progressTrack = new HSBField(Theme.progressTrackColor);
            p1.add((Component)ControlPanel.this.progressTrack, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Display Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.progressField = new HSBField(Theme.progressColor);
            p1.add((Component)ControlPanel.this.progressField, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.progressBorder = new HSBField(Theme.progressBorderColor);
            p1.add((Component)ControlPanel.this.progressBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.progressDark = new HSBField(Theme.progressDarkColor);
            p1.add((Component)ControlPanel.this.progressDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.progressLight = new HSBField(Theme.progressLightColor);
            p1.add((Component)ControlPanel.this.progressLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Text Forecolor"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.progressSelectFore = new HSBField(Theme.progressSelectForeColor);
            p1.add((Component)ControlPanel.this.progressSelectFore, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Text Backcolor"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.progressSelectBack = new HSBField(Theme.progressSelectBackColor);
            p1.add((Component)ControlPanel.this.progressSelectBack, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.progressField.update();
            ControlPanel.this.progressTrack.update();
            ControlPanel.this.progressBorder.update();
            ControlPanel.this.progressDark.update();
            ControlPanel.this.progressLight.update();
            ControlPanel.this.progressSelectFore.update();
            ControlPanel.this.progressSelectBack.update();
            this.inited = true;
        }

        void updateTheme() {
        }
    }

    class ComboCP
    extends JPanel {
        private JCheckBox paintFocus;
        private JCheckBox rolloverEnabled;
        private JSpinner mTop;
        private JSpinner mLeft;
        private JSpinner mBottom;
        private JSpinner mRight;
        private boolean inited = false;

        ComboCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Selected Background"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.comboSelectedBg = new HSBField(Theme.comboSelectedBgColor, true);
            p1.add((Component)ControlPanel.this.comboSelectedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Selected Foreground"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.comboSelectedText = new BlackWhitePanel(Theme.comboSelectedTextColor, true);
            p1.add((Component)ControlPanel.this.comboSelectedText, gc);
            ++gc.gridy;
            gc.insets = new Insets(8, 4, 0, 4);
            gc.gridheight = 4;
            JPanel p2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc2 = new GridBagConstraints();
            gc2.anchor = 17;
            gc2.fill = 2;
            gc2.gridx = 0;
            gc2.gridy = 1;
            gc2.insets = new Insets(0, 2, 0, 2);
            this.mLeft = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mLeft.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mLeft, gc2);
            ++gc2.gridx;
            gc2.gridy = 0;
            this.mTop = new JSpinner(new SpinnerNumberModel(2, 1, 8, 1));
            this.mTop.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mTop, gc2);
            ++gc2.gridy;
            p2.add((Component)new JLabel("Insets"), gc2);
            ++gc2.gridy;
            this.mBottom = new JSpinner(new SpinnerNumberModel(3, 1, 8, 1));
            this.mBottom.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mBottom, gc2);
            ++gc2.gridx;
            gc2.gridy = 1;
            this.mRight = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mRight.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mRight, gc2);
            p1.add((Component)p2, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboBorder = new HSBField(Theme.comboBorderColor);
            p1.add((Component)ControlPanel.this.comboBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboDark = new HSBField(Theme.comboDarkColor);
            p1.add((Component)ControlPanel.this.comboDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboLight = new HSBField(Theme.comboLightColor);
            p1.add((Component)ControlPanel.this.comboLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboBorderDisabled = new HSBField(Theme.comboBorderDisabledColor);
            p1.add((Component)ControlPanel.this.comboBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboDisabledDark = new HSBField(Theme.comboDarkDisabledColor);
            p1.add((Component)ControlPanel.this.comboDisabledDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboDisabledLight = new HSBField(Theme.comboLightDisabledColor);
            p1.add((Component)ControlPanel.this.comboDisabledLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButt = new HSBField(Theme.comboButtColor);
            p1.add((Component)ControlPanel.this.comboButt, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Rollover Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtRollover = new HSBField(Theme.comboButtRolloverColor);
            p1.add((Component)ControlPanel.this.comboButtRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Presssed Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtPressed = new HSBField(Theme.comboButtPressedColor);
            p1.add((Component)ControlPanel.this.comboButtPressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtDisabled = new HSBField(Theme.comboButtDisabledColor);
            p1.add((Component)ControlPanel.this.comboButtDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboSpreadLight = new SpreadPanel(Theme.comboSpreadLight, 20);
            p1.add((Component)ControlPanel.this.comboSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboSpreadDark = new SpreadPanel(Theme.comboSpreadDark, 20);
            p1.add((Component)ControlPanel.this.comboSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboSpreadLightDisabled = new SpreadPanel(Theme.comboSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.comboSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboSpreadDarkDisabled = new SpreadPanel(Theme.comboSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.comboSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtBorder = new HSBField(Theme.comboButtBorderColor);
            p1.add((Component)ControlPanel.this.comboButtBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtDark = new HSBField(Theme.comboButtDarkColor);
            p1.add((Component)ControlPanel.this.comboButtDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtLight = new HSBField(Theme.comboButtLightColor);
            p1.add((Component)ControlPanel.this.comboButtLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtBorderDisabled = new HSBField(Theme.comboButtBorderDisabledColor);
            p1.add((Component)ControlPanel.this.comboButtBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtDarkDisabled = new HSBField(Theme.comboButtDarkDisabledColor);
            p1.add((Component)ControlPanel.this.comboButtDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboButtLightDisabled = new HSBField(Theme.comboButtLightDisabledColor);
            p1.add((Component)ControlPanel.this.comboButtLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Arrow Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboArrowField = new HSBField(Theme.comboArrowColor);
            p1.add((Component)ControlPanel.this.comboArrowField, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Arrow"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.comboArrowDisabled = new HSBField(Theme.comboArrowDisabledColor);
            p1.add((Component)ControlPanel.this.comboArrowDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            gc.gridheight = 4;
            p2 = new JPanel(new GridLayout(2, 1, 0, 2));
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p2.add(this.rolloverEnabled);
            this.paintFocus = new JCheckBox("Paint Focus");
            this.paintFocus.addActionListener(ControlPanel.this.checkAction);
            p2.add(this.paintFocus);
            p1.add((Component)p2, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.rolloverEnabled.setSelected(Theme.comboRollover[Theme.style]);
            this.paintFocus.setSelected(Theme.comboFocus[Theme.style]);
            ControlPanel.this.comboSelectedText.update();
            ControlPanel.this.comboArrowField.update();
            ControlPanel.this.comboSelectedBg.update();
            ControlPanel.this.comboBorder.update();
            ControlPanel.this.comboDark.update();
            ControlPanel.this.comboLight.update();
            ControlPanel.this.comboBorderDisabled.update();
            ControlPanel.this.comboDisabledDark.update();
            ControlPanel.this.comboDisabledLight.update();
            ControlPanel.this.comboButt.update();
            ControlPanel.this.comboButtRollover.update();
            ControlPanel.this.comboButtDisabled.update();
            ControlPanel.this.comboButtPressed.update();
            ControlPanel.this.comboButtBorder.update();
            ControlPanel.this.comboButtDark.update();
            ControlPanel.this.comboButtLight.update();
            ControlPanel.this.comboButtBorderDisabled.update();
            ControlPanel.this.comboButtDarkDisabled.update();
            ControlPanel.this.comboButtLightDisabled.update();
            ControlPanel.this.comboArrowField.update();
            ControlPanel.this.comboArrowDisabled.update();
            ControlPanel.this.comboSpreadDark.init();
            ControlPanel.this.comboSpreadLight.init();
            ControlPanel.this.comboSpreadDarkDisabled.init();
            ControlPanel.this.comboSpreadLightDisabled.init();
            this.mTop.setValue(new Integer(Theme.comboInsets[Theme.style].top));
            this.mLeft.setValue(new Integer(Theme.comboInsets[Theme.style].left));
            this.mBottom.setValue(new Integer(Theme.comboInsets[Theme.style].bottom));
            this.mRight.setValue(new Integer(Theme.comboInsets[Theme.style].right));
            this.inited = true;
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.comboRollover[Theme.style] = this.rolloverEnabled.isSelected();
            Theme.comboFocus[Theme.style] = this.paintFocus.isSelected();
            Theme.comboInsets[Theme.style] = new Insets((Integer)this.mTop.getValue(), (Integer)this.mLeft.getValue(), (Integer)this.mBottom.getValue(), (Integer)this.mRight.getValue());
        }
    }

    class ButtonsCP
    extends JPanel {
        private JCheckBox rolloverEnabled;
        private JCheckBox focusEnabled;
        private JSpinner mTop;
        private JSpinner mLeft;
        private JSpinner mBottom;
        private JSpinner mRight;
        private boolean inited = false;

        ButtonsCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Normal Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.buttonNormalBg = new HSBField(Theme.buttonNormalColor);
            p1.add((Component)ControlPanel.this.buttonNormalBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.buttonRolloverBg = new HSBField(Theme.buttonRolloverBgColor);
            p1.add((Component)ControlPanel.this.buttonRolloverBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Presssed Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.buttonPressedBg = new HSBField(Theme.buttonPressedColor);
            p1.add((Component)ControlPanel.this.buttonPressedBg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Bg"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.buttonDisabledBg = new HSBField(Theme.buttonDisabledColor);
            p1.add((Component)ControlPanel.this.buttonDisabledBg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonSpreadLight = new SpreadPanel(Theme.buttonSpreadLight, 20);
            p1.add((Component)ControlPanel.this.buttonSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonSpreadDark = new SpreadPanel(Theme.buttonSpreadDark, 20);
            p1.add((Component)ControlPanel.this.buttonSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonSpreadLightDisabled = new SpreadPanel(Theme.buttonSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.buttonSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonSpreadDarkDisabled = new SpreadPanel(Theme.buttonSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.buttonSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonBorder = new HSBField(Theme.buttonBorderColor);
            p1.add((Component)ControlPanel.this.buttonBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDark = new HSBField(Theme.buttonDarkColor);
            p1.add((Component)ControlPanel.this.buttonDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonLight = new HSBField(Theme.buttonLightColor);
            p1.add((Component)ControlPanel.this.buttonLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDisabledBorder = new HSBField(Theme.buttonBorderDisabledColor);
            p1.add((Component)ControlPanel.this.buttonDisabledBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDisabledDark = new HSBField(Theme.buttonDarkDisabledColor);
            p1.add((Component)ControlPanel.this.buttonDisabledDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDisabledLight = new HSBField(Theme.buttonLightDisabledColor);
            p1.add((Component)ControlPanel.this.buttonDisabledLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Button Disabled Text"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDisabledFg = new HSBField(Theme.buttonDisabledFgColor, true);
            p1.add((Component)ControlPanel.this.buttonDisabledFg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("CheckBox  Disabled T."), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.checkDisabledFg = new HSBField(Theme.checkDisabledFgColor, true);
            p1.add((Component)ControlPanel.this.checkDisabledFg, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("RadioButton  Disabled T."), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.radioDisabledFg = new HSBField(Theme.radioDisabledFgColor, true);
            p1.add((Component)ControlPanel.this.radioDisabledFg, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Default Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonDefault = new HSBField(Theme.buttonDefaultColor, true);
            p1.add((Component)ControlPanel.this.buttonDefault, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Rollover Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonRollover = new HSBField(Theme.buttonRolloverColor);
            p1.add((Component)ControlPanel.this.buttonRollover, gc);
            gc.gridy = 5;
            gc.gridheight = 2;
            gc.insets = new Insets(0, 8, 0, 4);
            this.rolloverEnabled = new JCheckBox("Paint Rollover", true);
            this.rolloverEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.rolloverEnabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridheight = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Checkmark Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonCheck = new HSBField(Theme.buttonCheckColor);
            p1.add((Component)ControlPanel.this.buttonCheck, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Check Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.buttonCheckDisabled = new HSBField(Theme.buttonCheckDisabledColor);
            p1.add((Component)ControlPanel.this.buttonCheckDisabled, gc);
            gc.gridy = 5;
            gc.gridheight = 2;
            gc.insets = new Insets(0, 8, 0, 4);
            this.focusEnabled = new JCheckBox("Paint Focus", true);
            this.focusEnabled.addActionListener(ControlPanel.this.checkAction);
            p1.add((Component)this.focusEnabled, gc);
            ++gc.gridx;
            gc.gridy = 1;
            gc.gridheight = 7;
            gc.insets = new Insets(0, 16, 0, 4);
            JPanel p2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc2 = new GridBagConstraints();
            gc2.anchor = 18;
            gc2.fill = 2;
            gc2.gridx = 0;
            gc2.gridy = 1;
            gc2.insets = new Insets(0, 2, 0, 2);
            this.mLeft = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mLeft.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mLeft, gc2);
            ++gc2.gridx;
            gc2.gridy = 0;
            this.mTop = new JSpinner(new SpinnerNumberModel(2, 1, 8, 1));
            this.mTop.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mTop, gc2);
            ++gc2.gridy;
            p2.add((Component)new JLabel("Margin"), gc2);
            ++gc2.gridy;
            this.mBottom = new JSpinner(new SpinnerNumberModel(3, 1, 8, 1));
            this.mBottom.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mBottom, gc2);
            ++gc2.gridx;
            gc2.gridy = 1;
            this.mRight = new JSpinner(new SpinnerNumberModel(16, 2, 24, 1));
            this.mRight.addChangeListener(ControlPanel.this.updateAction);
            p2.add((Component)this.mRight, gc2);
            p1.add((Component)p2, gc);
            this.add(p1);
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            this.rolloverEnabled.setSelected(Theme.buttonRollover[Theme.style]);
            this.focusEnabled.setSelected(Theme.buttonFocus[Theme.style]);
            ControlPanel.this.buttonNormalBg.update();
            ControlPanel.this.buttonRolloverBg.update();
            ControlPanel.this.buttonPressedBg.update();
            ControlPanel.this.buttonDisabledBg.update();
            ControlPanel.this.buttonBorder.update();
            ControlPanel.this.buttonDark.update();
            ControlPanel.this.buttonLight.update();
            ControlPanel.this.buttonDisabledBorder.update();
            ControlPanel.this.buttonDisabledDark.update();
            ControlPanel.this.buttonDisabledLight.update();
            ControlPanel.this.buttonDisabledFg.update();
            ControlPanel.this.checkDisabledFg.update();
            ControlPanel.this.radioDisabledFg.update();
            ControlPanel.this.buttonRollover.update();
            ControlPanel.this.buttonDefault.update();
            ControlPanel.this.buttonCheck.update();
            ControlPanel.this.buttonCheckDisabled.update();
            ControlPanel.this.buttonSpreadDark.init();
            ControlPanel.this.buttonSpreadLight.init();
            ControlPanel.this.buttonSpreadDarkDisabled.init();
            ControlPanel.this.buttonSpreadLightDisabled.init();
            this.mTop.setValue(new Integer(Theme.buttonMarginTop[Theme.style]));
            this.mLeft.setValue(new Integer(Theme.buttonMarginLeft[Theme.style]));
            this.mBottom.setValue(new Integer(Theme.buttonMarginBottom[Theme.style]));
            this.mRight.setValue(new Integer(Theme.buttonMarginRight[Theme.style]));
            this.inited = true;
        }

        InsetsUIResource getButtonMargin() {
            return new InsetsUIResource((Integer)this.mTop.getValue(), (Integer)this.mLeft.getValue(), (Integer)this.mBottom.getValue(), (Integer)this.mRight.getValue());
        }

        void updateTheme() {
            if (!this.inited || ControlPanel.this.resistUpdate) {
                return;
            }
            Theme.buttonRollover[Theme.style] = this.rolloverEnabled.isSelected();
            Theme.buttonFocus[Theme.style] = this.focusEnabled.isSelected();
            Theme.buttonMarginTop[Theme.style] = (Integer)this.mTop.getValue();
            Theme.buttonMarginLeft[Theme.style] = (Integer)this.mLeft.getValue();
            Theme.buttonMarginBottom[Theme.style] = (Integer)this.mBottom.getValue();
            Theme.buttonMarginRight[Theme.style] = (Integer)this.mRight.getValue();
        }
    }

    class FrameCP
    extends JPanel {
        private boolean inited = false;
        private CardLayout cardLayout = new CardLayout();
        private JPanel cardPanel;

        FrameCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new BorderLayout());
            JPanel p1 = new JPanel(new GridLayout(5, 1, 0, 0));
            JPanel p2 = new JPanel(new FlowLayout(0, 24, 8));
            ButtonGroup group = new ButtonGroup();
            JRadioButton radio = new JRadioButton("Frame", true);
            group.add(radio);
            radio.addActionListener(new ActionListener(this){
                final /* synthetic */ FrameCP this$1;
                {
                    this.this$1 = frameCP;
                }

                public void actionPerformed(ActionEvent e) {
                    FrameCP.access$0(this.this$1).show(FrameCP.access$1(this.this$1), "Frame");
                }
            });
            p1.add(radio);
            radio = new JRadioButton("Iconify/Maximize Buttons");
            group.add(radio);
            radio.addActionListener(new ActionListener(this){
                final /* synthetic */ FrameCP this$1;
                {
                    this.this$1 = frameCP;
                }

                public void actionPerformed(ActionEvent e) {
                    FrameCP.access$0(this.this$1).show(FrameCP.access$1(this.this$1), "FrameButtons");
                }
            });
            p1.add(radio);
            radio = new JRadioButton("Close Button");
            group.add(radio);
            radio.addActionListener(new ActionListener(this){
                final /* synthetic */ FrameCP this$1;
                {
                    this.this$1 = frameCP;
                }

                public void actionPerformed(ActionEvent e) {
                    FrameCP.access$0(this.this$1).show(FrameCP.access$1(this.this$1), "FrameCloseButton");
                }
            });
            p1.add(radio);
            p1.add(new JLabel(""));
            JButton b = new JButton("Activate/Deactivate Frame");
            b.addActionListener(new DeactivateInternalFrameAction());
            p1.add(b);
            p2.add(p1);
            this.add((Component)p2, "Center");
            this.cardPanel = new JPanel(this.cardLayout);
            this.cardPanel.add((Component)new FrameFrameCP(), "Frame");
            this.cardPanel.add((Component)new FrameButtonsCP(), "FrameButtons");
            this.cardPanel.add((Component)new FrameCloseButtonCP(), "FrameCloseButton");
            this.cardLayout.layoutContainer(this);
            this.add((Component)this.cardPanel, "West");
        }

        void init(boolean always) {
            if (this.inited && !always) {
                return;
            }
            ControlPanel.this.frameCaption.update();
            ControlPanel.this.frameCaptionDisabled.update();
            ControlPanel.this.frameBorder.update();
            ControlPanel.this.frameDark.update();
            ControlPanel.this.frameLight.update();
            ControlPanel.this.frameBorderDisabled.update();
            ControlPanel.this.frameDarkDisabled.update();
            ControlPanel.this.frameLightDisabled.update();
            ControlPanel.this.frameTitle.update();
            ControlPanel.this.frameTitleDisabled.update();
            ControlPanel.this.frameButt.update();
            ControlPanel.this.frameButtRollover.update();
            ControlPanel.this.frameButtPressed.update();
            ControlPanel.this.frameButtDisabled.update();
            ControlPanel.this.frameButtBorder.update();
            ControlPanel.this.frameButtDark.update();
            ControlPanel.this.frameButtLight.update();
            ControlPanel.this.frameButtBorderDisabled.update();
            ControlPanel.this.frameButtDarkDisabled.update();
            ControlPanel.this.frameButtLightDisabled.update();
            ControlPanel.this.frameButtSpreadDark.init();
            ControlPanel.this.frameButtSpreadLight.init();
            ControlPanel.this.frameButtSpreadDarkDisabled.init();
            ControlPanel.this.frameButtSpreadLightDisabled.init();
            ControlPanel.this.frameButtClose.update();
            ControlPanel.this.frameButtCloseRollover.update();
            ControlPanel.this.frameButtClosePressed.update();
            ControlPanel.this.frameButtCloseDisabled.update();
            ControlPanel.this.frameButtCloseBorder.update();
            ControlPanel.this.frameButtCloseDark.update();
            ControlPanel.this.frameButtCloseLight.update();
            ControlPanel.this.frameButtCloseBorderDisabled.update();
            ControlPanel.this.frameButtCloseDarkDisabled.update();
            ControlPanel.this.frameButtCloseLightDisabled.update();
            ControlPanel.this.frameButtCloseSpreadDark.init();
            ControlPanel.this.frameButtCloseSpreadLight.init();
            ControlPanel.this.frameButtCloseSpreadDarkDisabled.init();
            ControlPanel.this.frameButtCloseSpreadLightDisabled.init();
            ControlPanel.this.frameSymbol.update();
            ControlPanel.this.frameSymbolPressed.update();
            ControlPanel.this.frameSymbolDisabled.update();
            ControlPanel.this.frameSymbolDark.update();
            ControlPanel.this.frameSymbolLight.update();
            ControlPanel.this.frameSymbolClose.update();
            ControlPanel.this.frameSymbolClosePressed.update();
            ControlPanel.this.frameSymbolCloseDisabled.update();
            ControlPanel.this.frameSymbolCloseDark.update();
            ControlPanel.this.frameSymbolCloseLight.update();
            ControlPanel.this.frameSpreadDark.init();
            ControlPanel.this.frameSpreadLight.init();
            ControlPanel.this.frameSpreadDarkDisabled.init();
            ControlPanel.this.frameSpreadLightDisabled.init();
            this.inited = true;
        }

        void updateTheme() {
        }

        static /* synthetic */ CardLayout access$0(FrameCP frameCP) {
            return frameCP.cardLayout;
        }

        static /* synthetic */ JPanel access$1(FrameCP frameCP) {
            return frameCP.cardPanel;
        }

        class DeactivateInternalFrameAction
        implements ActionListener {
            DeactivateInternalFrameAction() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ControlPanel.this.internalFrame.setSelected(!ControlPanel.this.internalFrame.isSelected());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    class FrameFrameCP
    extends JPanel {
        FrameFrameCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Caption Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameCaption = new HSBField(Theme.frameCaptionColor);
            p1.add((Component)ControlPanel.this.frameCaption, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameCaptionDisabled = new HSBField(Theme.frameCaptionDisabledColor);
            p1.add((Component)ControlPanel.this.frameCaptionDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSpreadDark = new SpreadPanel(Theme.frameSpreadDark, 10);
            p1.add((Component)ControlPanel.this.frameSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSpreadLight = new SpreadPanel(Theme.frameSpreadLight, 10);
            p1.add((Component)ControlPanel.this.frameSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("S. Dark Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSpreadDarkDisabled = new SpreadPanel(Theme.frameSpreadDarkDisabled, 10);
            p1.add((Component)ControlPanel.this.frameSpreadDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("S. Light Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSpreadLightDisabled = new SpreadPanel(Theme.frameSpreadLightDisabled, 10);
            p1.add((Component)ControlPanel.this.frameSpreadLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameBorder = new HSBField(Theme.frameBorderColor);
            p1.add((Component)ControlPanel.this.frameBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameDark = new HSBField(Theme.frameDarkColor);
            p1.add((Component)ControlPanel.this.frameDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameLight = new HSBField(Theme.frameLightColor);
            p1.add((Component)ControlPanel.this.frameLight, gc);
            gc.gridy += 2;
            gc.gridwidth = 3;
            gc.insets = new Insets(0, 8, 0, 4);
            JCheckBox check = new JCheckBox("Decorated Frames (experimental, not saved)", Theme.frameIsDecorated[Theme.style]);
            check.addActionListener(new DecorateFrameAction());
            p1.add((Component)check, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameBorderDisabled = new HSBField(Theme.frameBorderDisabledColor);
            p1.add((Component)ControlPanel.this.frameBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameDarkDisabled = new HSBField(Theme.frameDarkDisabledColor);
            p1.add((Component)ControlPanel.this.frameDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light Col"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameLightDisabled = new HSBField(Theme.frameLightDisabledColor);
            p1.add((Component)ControlPanel.this.frameLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Title Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameTitle = new HSBField(Theme.frameTitleColor);
            p1.add((Component)ControlPanel.this.frameTitle, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Title Disabled"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameTitleDisabled = new HSBField(Theme.frameTitleDisabledColor);
            p1.add((Component)ControlPanel.this.frameTitleDisabled, gc);
            this.add(p1);
        }
    }

    class FrameButtonsCP
    extends JPanel {
        FrameButtonsCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButt = new HSBField(Theme.frameButtColor);
            p1.add((Component)ControlPanel.this.frameButt, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtRollover = new HSBField(Theme.frameButtRolloverColor);
            p1.add((Component)ControlPanel.this.frameButtRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Pressed Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtPressed = new HSBField(Theme.frameButtPressedColor);
            p1.add((Component)ControlPanel.this.frameButtPressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtDisabled = new HSBField(Theme.frameButtDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtSpreadLight = new SpreadPanel(Theme.frameButtSpreadLight, 20);
            p1.add((Component)ControlPanel.this.frameButtSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtSpreadDark = new SpreadPanel(Theme.frameButtSpreadDark, 20);
            p1.add((Component)ControlPanel.this.frameButtSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtSpreadLightDisabled = new SpreadPanel(Theme.frameButtSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.frameButtSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtSpreadDarkDisabled = new SpreadPanel(Theme.frameButtSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.frameButtSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtBorder = new HSBField(Theme.frameButtBorderColor);
            p1.add((Component)ControlPanel.this.frameButtBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtDark = new HSBField(Theme.frameButtDarkColor);
            p1.add((Component)ControlPanel.this.frameButtDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtLight = new HSBField(Theme.frameButtLightColor);
            p1.add((Component)ControlPanel.this.frameButtLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtBorderDisabled = new HSBField(Theme.frameButtBorderDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtDarkDisabled = new HSBField(Theme.frameButtDarkDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtLightDisabled = new HSBField(Theme.frameButtLightDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbol = new HSBField(Theme.frameSymbolColor);
            p1.add((Component)ControlPanel.this.frameSymbol, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Pressed Symbol"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolPressed = new HSBField(Theme.frameSymbolPressedColor);
            p1.add((Component)ControlPanel.this.frameSymbolPressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Symbol"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolDisabled = new HSBField(Theme.frameSymbolDisabledColor);
            p1.add((Component)ControlPanel.this.frameSymbolDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolDark = new HSBField(Theme.frameSymbolDarkColor);
            p1.add((Component)ControlPanel.this.frameSymbolDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolLight = new HSBField(Theme.frameSymbolLightColor);
            p1.add((Component)ControlPanel.this.frameSymbolLight, gc);
            this.add(p1);
        }
    }

    class FrameCloseButtonCP
    extends JPanel {
        FrameCloseButtonCP() {
            this.setupUI();
        }

        private void setupUI() {
            this.setLayout(new FlowLayout(0, 2, 2));
            JPanel p1 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.insets = new Insets(2, 4, 0, 4);
            p1.add((Component)new JLabel("Button Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtClose = new HSBField(Theme.frameButtCloseColor);
            p1.add((Component)ControlPanel.this.frameButtClose, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Rollover Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtCloseRollover = new HSBField(Theme.frameButtCloseRolloverColor);
            p1.add((Component)ControlPanel.this.frameButtCloseRollover, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Pressed Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtClosePressed = new HSBField(Theme.frameButtClosePressedColor);
            p1.add((Component)ControlPanel.this.frameButtClosePressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 4, 0, 4);
            p1.add((Component)new JLabel("Disabled Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 4, 0, 4);
            ControlPanel.this.frameButtCloseDisabled = new HSBField(Theme.frameButtCloseDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtCloseDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseSpreadLight = new SpreadPanel(Theme.frameButtCloseSpreadLight, 20);
            p1.add((Component)ControlPanel.this.frameButtCloseSpreadLight, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Spread Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseSpreadDark = new SpreadPanel(Theme.frameButtCloseSpreadDark, 20);
            p1.add((Component)ControlPanel.this.frameButtCloseSpreadDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseSpreadLightDisabled = new SpreadPanel(Theme.frameButtCloseSpreadLightDisabled, 20);
            p1.add((Component)ControlPanel.this.frameButtCloseSpreadLightDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled S. Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseSpreadDarkDisabled = new SpreadPanel(Theme.frameButtCloseSpreadDarkDisabled, 20);
            p1.add((Component)ControlPanel.this.frameButtCloseSpreadDarkDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Border Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseBorder = new HSBField(Theme.frameButtCloseBorderColor);
            p1.add((Component)ControlPanel.this.frameButtCloseBorder, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseDark = new HSBField(Theme.frameButtCloseDarkColor);
            p1.add((Component)ControlPanel.this.frameButtCloseDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Border Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseLight = new HSBField(Theme.frameButtCloseLightColor);
            p1.add((Component)ControlPanel.this.frameButtCloseLight, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseBorderDisabled = new HSBField(Theme.frameButtCloseBorderDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtCloseBorderDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Dark"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseDarkDisabled = new HSBField(Theme.frameButtCloseDarkDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtCloseDarkDisabled, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Light"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameButtCloseLightDisabled = new HSBField(Theme.frameButtCloseLightDisabledColor);
            p1.add((Component)ControlPanel.this.frameButtCloseLightDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Color"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolClose = new HSBField(Theme.frameSymbolCloseColor);
            p1.add((Component)ControlPanel.this.frameSymbolClose, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Pressed Symbol"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolClosePressed = new HSBField(Theme.frameSymbolClosePressedColor);
            p1.add((Component)ControlPanel.this.frameSymbolClosePressed, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Disabled Symbol"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolCloseDisabled = new HSBField(Theme.frameSymbolCloseDisabledColor);
            p1.add((Component)ControlPanel.this.frameSymbolCloseDisabled, gc);
            ++gc.gridx;
            gc.gridy = 0;
            gc.insets = new Insets(2, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Dark Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolCloseDark = new HSBField(Theme.frameSymbolCloseDarkColor);
            p1.add((Component)ControlPanel.this.frameSymbolCloseDark, gc);
            ++gc.gridy;
            gc.insets = new Insets(4, 8, 0, 4);
            p1.add((Component)new JLabel("Symbol Light Border"), gc);
            ++gc.gridy;
            gc.insets = new Insets(1, 8, 0, 4);
            ControlPanel.this.frameSymbolCloseLight = new HSBField(Theme.frameSymbolCloseLightColor);
            p1.add((Component)ControlPanel.this.frameSymbolCloseLight, gc);
            this.add(p1);
        }
    }

    class BlackWhitePanel
    extends JPanel {
        private boolean forceUpdate;
        private Dimension size = new Dimension(18, 18);
        private Font font = new Font("sansserif", 1, 11);
        private String text = "Item text";
        private ColorReference[] ref;

        BlackWhitePanel(ColorReference[] ref) {
            this.ref = ref;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setBackground(ref[Theme.style].getColor());
            this.switchColors();
            this.addMouseListener(new Mousey());
        }

        BlackWhitePanel(ColorReference[] ref, boolean forceUpdate) {
            this.ref = ref;
            this.forceUpdate = forceUpdate;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setBackground(ref[Theme.style].getColor());
            this.switchColors();
            this.addMouseListener(new Mousey());
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void switchColors() {
            if (this.getBackground().equals(Color.BLACK)) {
                this.setBackground(Color.WHITE);
                this.ref[Theme.style].setColor(Color.BLACK);
            } else {
                this.setBackground(Color.BLACK);
                this.ref[Theme.style].setColor(Color.WHITE);
            }
        }

        public void setTextColor(Color c) {
            if (c.equals(Color.BLACK)) {
                this.setBackground(Color.WHITE);
            } else {
                this.setBackground(Color.BLACK);
            }
        }

        public void update() {
            if (this.ref[Theme.style].update().equals(Color.BLACK)) {
                this.setBackground(Color.WHITE);
            } else {
                this.setBackground(Color.BLACK);
            }
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.getBackground().equals(Color.BLACK)) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.setFont(this.font);
            int textWidth = g.getFontMetrics().stringWidth(this.text);
            int x = (this.getWidth() - textWidth) / 2;
            int y = this.getHeight() - 5;
            g.drawString(this.text, x, y);
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent e) {
                BlackWhitePanel.this.switchColors();
                ControlPanel.this.examplePanel.update(BlackWhitePanel.this.forceUpdate);
            }
        }
    }

    class SpreadPanel
    extends JPanel
    implements FocusListener {
        private int max = 20;
        private Dimension size = new Dimension(18, 18);
        private Font font = new Font("sansserif", 1, 12);
        private int[] spreadRef;
        private boolean hasFocus = false;
        private int spread;
        private int x1 = 7;
        private int x2;
        private int paintX;
        private int y = 7;

        SpreadPanel(int[] spreadRef, int max) {
            this.spreadRef = spreadRef;
            this.max = max;
            this.addMouseListener(new Mousey());
            this.addMouseMotionListener(new MouseyMove());
            this.addKeyListener(new ArrowKeyAction());
            this.addFocusListener(this);
            this.init();
        }

        public void update(int spread) {
            this.spread = spread;
            this.spreadRef[Theme.style] = spread;
            this.repaint(0L);
            if (ControlPanel.this.internalFrame == null) {
                return;
            }
            ControlPanel.this.internalFrame.repaint(0L);
            ControlPanel.this.examplePanel.repaint(0L);
        }

        public void init() {
            this.paintX = -1;
            this.update(this.spreadRef[Theme.style]);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g) {
            if (this.hasFocus) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Theme.backColor[Theme.style].getColor());
            }
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            this.x2 = this.getWidth() - 24;
            g.drawLine(this.x1, this.y - 3, this.x1, this.y + 3);
            g.drawLine(this.x2, this.y - 3, this.x2, this.y + 3);
            g.drawLine(this.x1, this.y, this.x2, this.y);
            int x = this.paintX;
            if (x == -1) {
                x = this.spread * (this.x2 - this.x1) / this.max + this.x1;
            }
            g.drawLine(x, this.y + 2, x, this.y + 2);
            g.drawLine(x - 1, this.y + 3, x + 1, this.y + 3);
            g.drawLine(x - 2, this.y + 4, x + 2, this.y + 4);
            g.drawLine(x - 3, this.y + 5, x + 3, this.y + 5);
            g.drawLine(x - 4, this.y + 6, x + 4, this.y + 6);
            g.setFont(this.font);
            FontMetrics fm = g.getFontMetrics();
            int xd = fm.stringWidth(String.valueOf(this.spread));
            g.drawString(String.valueOf(this.spread), this.getWidth() - xd - 3, this.getHeight() - 5);
        }

        public void focusGained(FocusEvent e) {
            this.hasFocus = true;
        }

        public void focusLost(FocusEvent e) {
            this.hasFocus = false;
            this.repaint(0L);
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent e) {
                if (SpreadPanel.this.equals(((SpreadPanel)SpreadPanel.this).ControlPanel.this.frameSpreadDark) || SpreadPanel.this.equals(((SpreadPanel)SpreadPanel.this).ControlPanel.this.frameSpreadLight)) {
                    if (!ControlPanel.this.internalFrame.isSelected()) {
                        try {
                            ControlPanel.this.internalFrame.setSelected(true);
                        }
                        catch (PropertyVetoException ignore) {}
                    }
                } else if ((SpreadPanel.this.equals(((SpreadPanel)SpreadPanel.this).ControlPanel.this.frameSpreadDarkDisabled) || SpreadPanel.this.equals(((SpreadPanel)SpreadPanel.this).ControlPanel.this.frameSpreadLightDisabled)) && ControlPanel.this.internalFrame.isSelected()) {
                    try {
                        ControlPanel.this.internalFrame.setSelected(false);
                    }
                    catch (PropertyVetoException ignore) {
                        // empty catch block
                    }
                }
                if (!SpreadPanel.this.hasFocus) {
                    SpreadPanel.this.requestFocus();
                    SpreadPanel.this.repaint(0L);
                } else {
                    int x = e.getX();
                    if (x < SpreadPanel.this.x1) {
                        x = SpreadPanel.this.x1;
                    }
                    if (x > SpreadPanel.this.x2) {
                        x = SpreadPanel.this.x2;
                    }
                    int xd = x - SpreadPanel.this.x1;
                    SpreadPanel.this.paintX = x;
                    SpreadPanel.this.update(xd * SpreadPanel.this.max / (SpreadPanel.this.x2 - SpreadPanel.this.x1));
                }
            }

            public void mouseReleased(MouseEvent e) {
                SpreadPanel.this.repaint(0L);
                ControlPanel.this.examplePanel.update(false);
            }
        }

        class MouseyMove
        extends MouseMotionAdapter {
            MouseyMove() {
            }

            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                if (x < SpreadPanel.this.x1) {
                    x = SpreadPanel.this.x1;
                }
                if (x > SpreadPanel.this.x2) {
                    x = SpreadPanel.this.x2;
                }
                int xd = x - SpreadPanel.this.x1;
                SpreadPanel.this.paintX = x;
                SpreadPanel.this.update(xd * SpreadPanel.this.max / (SpreadPanel.this.x2 - SpreadPanel.this.x1));
            }
        }

        class ArrowKeyAction
        extends KeyAdapter
        implements ActionListener {
            private Timer keyTimer = new Timer(20, this);
            private int step;

            ArrowKeyAction() {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    if (SpreadPanel.this.spread == SpreadPanel.this.max) {
                        return;
                    }
                    this.step = 1;
                    this.changeVal();
                    this.keyTimer.setInitialDelay(300);
                    this.keyTimer.start();
                } else if (e.getKeyCode() == 40) {
                    if (SpreadPanel.this.spread == 0) {
                        return;
                    }
                    this.step = -1;
                    this.changeVal();
                    this.keyTimer.setInitialDelay(300);
                    this.keyTimer.start();
                }
            }

            public void keyReleased(KeyEvent e) {
                this.keyTimer.stop();
            }

            public void actionPerformed(ActionEvent e) {
                this.changeVal();
            }

            private void changeVal() {
                if (SpreadPanel.this.spread + this.step < 0 || SpreadPanel.this.spread + this.step > SpreadPanel.this.max) {
                    return;
                }
                SpreadPanel spreadPanel = SpreadPanel.this;
                spreadPanel.spread = spreadPanel.spread + this.step;
                SpreadPanel.this.paintX = -1;
                SpreadPanel.this.update(SpreadPanel.this.spread);
            }
        }
    }

    class SizedPanel
    extends JPanel {
        private Dimension size;
        private Color grey = new Color(204, 204, 204);

        SizedPanel(int w, int h) {
            this.size = new Dimension(w, h);
            this.setBackground(Color.ORANGE);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g) {
            int w = 8;
            int index = 0;
            int x = 0;
            int y = 0;
            while (x < this.getWidth()) {
                y = 0;
                while (y < this.getHeight()) {
                    if (index++ % 2 == 0) {
                        g.setColor(this.grey);
                    } else {
                        g.setColor(Color.WHITE);
                    }
                    g.fillRect(x, y, w, w);
                    y += w;
                }
                x += w;
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    }

    class ProgressAction
    implements ActionListener {
        private int value = 0;

        ProgressAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ++this.value;
            if (this.value > 20) {
                this.value = 0;
                ControlPanel.this.horzProgressBar.setIndeterminate(!ControlPanel.this.horzProgressBar.isIndeterminate());
                ControlPanel.this.vertProgressBar.setIndeterminate(!ControlPanel.this.horzProgressBar.isIndeterminate());
            }
            ControlPanel.this.horzProgressBar.setValue(this.value);
            ControlPanel.this.vertProgressBar.setValue(this.value);
            int v = this.value % 25;
            if (v < 8) {
                ControlPanel.this.horzProgressBar.setString("Fun");
                ControlPanel.this.vertProgressBar.setString("Fun");
            } else if (v < 16) {
                ControlPanel.this.horzProgressBar.setString("with");
                ControlPanel.this.vertProgressBar.setString("with");
            } else {
                ControlPanel.this.horzProgressBar.setString("Swing");
                ControlPanel.this.vertProgressBar.setString("Swing");
            }
        }
    }

    class ProgressBarAction
    extends MouseAdapter {
        ProgressBarAction() {
        }

        public void mousePressed(MouseEvent e) {
            if (ControlPanel.this.progressTimer.isRunning()) {
                ControlPanel.this.stopProgressTimer();
            } else {
                ControlPanel.this.startProgressTimer();
            }
        }
    }

    class SmallTableModel
    extends AbstractTableModel {
        private String[] colNames = new String[]{"Col1", "Col2", "Col3", "Col4"};
        private String[][] data = new String[][]{{"E", "ne", "me", "ne"}, {"mis", "te", "was", "rap"}, {"pelt", "in", "der", "Kis"}, {"te", ".", "E", "ne"}, {"me", "ne", "meck", "und"}, {"du", "bist", "weg", "."}};

        SmallTableModel() {
        }

        public int getColumnCount() {
            return this.colNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = aValue.toString();
        }

        public String getColumnName(int col) {
            return this.colNames[col];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    class ThemeFileFilter
    extends FileFilter {
        ThemeFileFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return pathname.getName().endsWith(".theme");
        }

        public String getDescription() {
            return ".theme";
        }
    }

    class SelectThemeAction
    implements ActionListener {
        SelectThemeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.openTheme(String.valueOf(((JMenuItem)e.getSource()).getText()) + ".theme");
        }
    }

    class CheckedIcon
    extends JPanel {
        private JLabel iconLabel;
        private JCheckBox check;

        CheckedIcon(boolean b) {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.check = new JCheckBox("", b);
            this.check.addActionListener(ControlPanel.this.iconCheckAction);
            this.add(this.check);
            this.iconLabel = new JLabel("");
            this.add(this.iconLabel);
        }

        public void setIcon(Icon i) {
            this.iconLabel.setIcon(i);
        }

        public void setSelected(boolean b) {
            this.check.setSelected(b);
        }

        public boolean isSelected() {
            return this.check.isSelected();
        }
    }

    class DecorateFrameAction
    implements ActionListener {
        DecorateFrameAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.decorateFrame(((AbstractButton)e.getSource()).isSelected());
        }
    }

    class CheckAction
    implements ActionListener {
        CheckAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.examplePanel.update(false);
        }
    }

    class UpdateAction
    implements ChangeListener {
        UpdateAction() {
        }

        public void stateChanged(ChangeEvent e) {
            ControlPanel.this.examplePanel.update(true);
        }
    }

    class IconCheckAction
    implements ActionListener {
        IconCheckAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanel.this.examplePanel.update(true);
        }
    }

    class PopupTrigger
    extends JPanel
    implements MouseListener {
        PopupTrigger() {
            this.setLayout(new FlowLayout(1, 4, 2));
            this.setBackground(Color.ORANGE);
            JLabel l = new JLabel("Popup trigger");
            l.setForeground(Color.BLUE);
            this.add(l);
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent e) {
            if (ControlPanel.this.thePopup != null && ControlPanel.this.thePopup.isShowing()) {
                return;
            }
            ControlPanel.this.thePopup = new JPopupMenu("Popup Menu");
            BasicPopupMenuUI ui = (BasicPopupMenuUI)ControlPanel.this.thePopup.getUI();
            JMenuItem item = new JMenuItem("Popup item #1");
            ControlPanel.this.thePopup.add(item);
            item = new JMenuItem("Popup item #2");
            ControlPanel.this.thePopup.add(item);
            ControlPanel.this.thePopup.addSeparator();
            item = new JMenuItem("Popup item #III");
            ControlPanel.this.thePopup.add(item);
            item = new JMenuItem("Popup disabled item #IV");
            item.setEnabled(false);
            ControlPanel.this.thePopup.add(item);
            ControlPanel.this.thePopup.show(e.getComponent(), 0, -((ControlPanel)ControlPanel.this).thePopup.getPreferredSize().height - 1);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class GoodFrame
    extends JFrame {
        private boolean resized = false;

        GoodFrame(String title) {
            super(title);
            this.addComponentListener(new ResizeListener());
        }

        protected JRootPane createRootPane() {
            return new GoodRootPane();
        }

        public void paint(Graphics g) {
            if (this.resized) {
                System.out.println("Frame.paint() " + System.currentTimeMillis());
                this.resized = false;
            }
            super.paint(g);
        }

        public void invalidate() {
            if (this.resized) {
                System.out.println("Frame.invalidate() " + System.currentTimeMillis());
            }
            super.invalidate();
        }

        public void validate() {
            if (this.resized) {
                System.out.println("Frame.validate() " + System.currentTimeMillis());
            }
            super.validate();
        }

        public void setBounds(int x, int y, int w, int h) {
            System.out.println("Frame.setBounds() " + System.currentTimeMillis());
            super.setBounds(x, y, w, h);
        }

        public void setBounds(Rectangle r) {
            System.out.println("Frame.setBounds() " + System.currentTimeMillis());
            super.setBounds(r);
        }

        public void setSize(Dimension d) {
            System.out.println("Frame.setSize() " + System.currentTimeMillis());
            super.setSize(d);
        }

        public void setSize(int w, int h) {
            System.out.println("Frame.setSize() " + System.currentTimeMillis());
            super.setSize(w, h);
        }

        class ResizeListener
        extends ComponentAdapter {
            ResizeListener() {
            }

            public void componentResized(ComponentEvent e) {
                System.out.println("Frame.Event " + System.currentTimeMillis());
                GoodFrame.this.resized = true;
            }
        }
    }

    class GoodLayeredPane
    extends JLayeredPane {
        private boolean resized = false;

        GoodLayeredPane() {
            this.addComponentListener(new ResizeListener());
        }

        public void paint(Graphics g) {
            if (this.resized) {
                System.out.println("LayeredPane.paint() " + System.currentTimeMillis());
                this.resized = false;
            }
            super.paint(g);
        }

        public void setBounds(int x, int y, int w, int h) {
            System.out.println("LayeredPane.setBounds() " + System.currentTimeMillis());
            super.setBounds(x, y, w, h);
        }

        public void setBounds(Rectangle r) {
            System.out.println("LayeredPane.setBounds() " + System.currentTimeMillis());
            super.setBounds(r);
        }

        public void setSize(Dimension d) {
            System.out.println("LayeredPane.setSize() " + System.currentTimeMillis());
            super.setSize(d);
        }

        public void setSize(int w, int h) {
            System.out.println("LayeredPane.setSize() " + System.currentTimeMillis());
            super.setSize(w, h);
        }

        public void invalidate() {
            if (this.resized) {
                System.out.println("LayeredPane.invalidate() " + System.currentTimeMillis());
            }
            super.invalidate();
        }

        public void validate() {
            if (this.resized) {
                System.out.println("LayeredPane.validate() " + System.currentTimeMillis());
            }
            super.validate();
        }

        class ResizeListener
        extends ComponentAdapter {
            ResizeListener() {
            }

            public void componentResized(ComponentEvent e) {
                System.out.println("LayeredPane.Event " + System.currentTimeMillis());
                GoodLayeredPane.this.resized = true;
            }
        }
    }

    class GoodRootPane
    extends JRootPane {
        private boolean resized = false;

        GoodRootPane() {
            this.addComponentListener(new ResizeListener());
        }

        protected JLayeredPane createLayeredPane() {
            GoodLayeredPane p = new GoodLayeredPane();
            p.setName(String.valueOf(this.getName()) + ".layeredPane");
            return p;
        }

        public void paint(Graphics g) {
            if (this.resized) {
                System.out.println("RootPane.paint() " + System.currentTimeMillis());
                this.resized = false;
                System.out.println(this.getUI().getClass().getName());
            }
            super.paint(g);
        }

        public void setBounds(int x, int y, int w, int h) {
            System.out.println("RootPane.setBounds() " + System.currentTimeMillis());
            super.setBounds(x, y, w, h);
        }

        public void setBounds(Rectangle r) {
            System.out.println("RootPane.setBounds() " + System.currentTimeMillis());
            super.setBounds(r);
        }

        public void setSize(Dimension d) {
            System.out.println("RootPane.setSize() " + System.currentTimeMillis());
            super.setSize(d);
        }

        public void setSize(int w, int h) {
            System.out.println("RootPane.setSize() " + System.currentTimeMillis());
            super.setSize(w, h);
        }

        public void invalidate() {
            if (this.resized) {
                System.out.println("RootPane.invalidate() " + System.currentTimeMillis());
            }
            super.invalidate();
        }

        public void validate() {
            if (this.resized) {
                System.out.println("RootPane.validate() " + System.currentTimeMillis());
            }
            super.validate();
        }

        class ResizeListener
        extends ComponentAdapter {
            ResizeListener() {
            }

            public void componentResized(ComponentEvent e) {
                System.out.println("RootPane.Event " + System.currentTimeMillis());
                GoodRootPane.this.resized = true;
            }
        }
    }

    class GoodContentPane
    extends JPanel {
        private boolean resized = false;

        public Component add(Component comp) {
            super.add(comp);
            return comp;
        }

        public Component add(Component comp, int index) {
            super.add(comp, index);
            return comp;
        }

        public void add(Component comp, Object constraints) {
            super.add(comp, constraints);
        }

        GoodContentPane() {
            super(new BorderLayout());
            this.addComponentListener(new ResizeListener());
        }

        GoodContentPane(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
            this.addComponentListener(new ResizeListener());
        }

        GoodContentPane(LayoutManager layout) {
            super(layout);
            this.addComponentListener(new ResizeListener());
        }

        GoodContentPane(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
            this.addComponentListener(new ResizeListener());
        }

        public void paint(Graphics g) {
            if (this.resized) {
                System.out.println("ContentPane.paint() " + System.currentTimeMillis());
                this.resized = false;
            }
            super.paint(g);
        }

        public void invalidate() {
            if (this.resized) {
                System.out.println("ContentPane.invalidate() " + System.currentTimeMillis());
            }
            super.invalidate();
        }

        public void validate() {
            if (this.resized) {
                System.out.println("ContentPane.validate() " + System.currentTimeMillis());
            }
            super.validate();
        }

        class ResizeListener
        extends ComponentAdapter {
            ResizeListener() {
            }

            public void componentResized(ComponentEvent e) {
                System.out.println("ContentPane.Event " + System.currentTimeMillis());
                GoodContentPane.this.resized = true;
            }
        }
    }
}

