/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;

public class TinyTextFieldUI
extends MetalTextFieldUI {
    JTextField textField;

    public static ComponentUI createUI(JComponent c) {
        return new TinyTextFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (!ControlPanel.isInstantiated) {
            return;
        }
        this.textField = (JTextField)c;
        this.textField.setSelectionColor(Theme.textSelectedBgColor[Theme.style].getColor());
        this.textField.setSelectedTextColor(Theme.textSelectedTextColor[Theme.style].getColor());
        this.textField.setBackground(Theme.textBgColor[Theme.style].getColor());
        this.textField.setForeground(Theme.textTextColor[Theme.style].getColor());
        this.textField.setDisabledTextColor(Theme.disColor[Theme.style].getColor());
    }

    protected void paintBackground(Graphics g) {
        JTextComponent editor = this.getComponent();
        if (editor.isEnabled()) {
            if (editor.isEditable()) {
                g.setColor(editor.getBackground());
            } else {
                g.setColor(Theme.backColor[Theme.style].getColor());
            }
            g.fillRect(0, 0, editor.getWidth(), editor.getHeight());
        } else {
            g.setColor(Theme.textDisabledBgColor[Theme.style].getColor());
            g.fillRect(0, 0, editor.getWidth(), editor.getHeight());
            if (Theme.style != 2) {
                return;
            }
            g.setColor(Theme.backColor[Theme.style].getColor());
            g.drawRect(1, 1, editor.getWidth() - 3, editor.getHeight() - 3);
            g.drawRect(2, 2, editor.getWidth() - 5, editor.getHeight() - 5);
        }
    }
}

