/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class TinyProgressBarUI
extends BasicProgressBarUI {
    int offset = 1;

    public static ComponentUI createUI(JComponent c) {
        return new TinyProgressBarUI();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (this.progressBar.getOrientation() == 0) {
            int amountFull = this.getAmountFull(b, barRectWidth - 2 * this.offset, barRectHeight);
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyHorzProgress(g, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 1: {
                    this.drawWinHorzProgress(g, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 2: {
                    this.drawXpHorzProgress(g, barRectWidth, barRectHeight, amountFull);
                }
            }
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        } else {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight - 2 * this.offset);
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyVertProgress(g, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 1: {
                    this.drawWinVertProgress(g, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 2: {
                    this.drawXpVertProgress(g, barRectWidth, barRectHeight, amountFull);
                }
            }
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    private void drawTinyHorzProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
    }

    private void drawWinBorder(Graphics g, int bWidth, int bHeight) {
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(1, 1, bWidth - 1, bHeight - 1);
        g.setColor(Theme.progressDarkColor[Theme.style].getColor());
        g.drawLine(0, 0, bWidth - 1, 0);
        g.drawLine(0, 1, 0, bHeight - 1);
        g.setColor(Theme.progressLightColor[Theme.style].getColor());
        g.drawLine(bWidth - 1, 1, bWidth - 1, bHeight - 1);
        g.drawLine(1, bHeight - 1, bWidth - 1, bHeight - 1);
    }

    private void drawWinHorzProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
        this.drawWinBorder(g, barRectWidth, barRectHeight);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int h = barRectHeight - 4;
        int x = 2;
        while (x < amountFull) {
            g.fillRect(x, 2, Math.min(6, barRectWidth - x - 3), h);
            x += 8;
        }
    }

    private void drawXPBorder(Graphics g, int bWidth, int bHeight) {
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(1, 1, bWidth - 1, bHeight - 1);
        DrawRoutines.drawRoundedBorder(g, Theme.progressBorderColor[Theme.style].getColor(), 0, 0, bWidth, bHeight);
        DrawRoutines.drawRoundedBorder(g, Theme.progressDarkColor[Theme.style].getColor(), 1, 1, bWidth - 2, bHeight - 2);
        DrawRoutines.drawRoundedBorder(g, Theme.progressLightColor[Theme.style].getColor(), 2, 2, bWidth - 4, bHeight - 4);
    }

    private void drawXpHorzProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
        this.drawXPBorder(g, barRectWidth, barRectHeight);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int y = (barRectHeight - 6) / 2;
        int x = 3;
        while (x < amountFull) {
            g.fillRect(x, y, Math.min(6, barRectWidth - x - 3), 6);
            x += 8;
        }
    }

    private void drawTinyVertProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
    }

    private void drawWinVertProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
        this.drawWinBorder(g, barRectWidth, barRectHeight);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int w = barRectWidth - 4;
        int y = 8;
        while (y < amountFull) {
            g.fillRect(2, barRectHeight - y, w, 6);
            y += 8;
        }
    }

    private void drawXpVertProgress(Graphics g, int barRectWidth, int barRectHeight, int amountFull) {
        this.drawXPBorder(g, barRectWidth, barRectHeight);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int x = (barRectWidth - 6) / 2;
        int y = 9;
        while (y < amountFull) {
            g.fillRect(x, barRectHeight - y, 6, 6);
            y += 8;
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle boxRect = null;
        try {
            boxRect = this.getBox(null);
        }
        catch (NullPointerException ex) {
            return;
        }
        if (this.progressBar.getOrientation() == 0) {
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyHorzProgress(g, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 1: {
                    this.drawWinHorzProgress(g, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 2: {
                    this.drawXpHorzProgress(g, barRectWidth, barRectHeight, boxRect);
                }
            }
        } else {
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyVertProgress(g, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 1: {
                    this.drawWinVertProgress(g, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 2: {
                    this.drawXpVertProgress(g, barRectWidth, barRectHeight, boxRect);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.x, boxRect.width, b);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.y, boxRect.height, b);
            }
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    private void drawTinyHorzProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
    }

    private void drawWinHorzProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
        this.drawWinBorder(g, barRectWidth, barRectHeight);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int h = barRectHeight - 4;
        int x = 0;
        while (x + 6 < boxRect.width) {
            g.fillRect(x, 2, 6, h);
            x += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawXpHorzProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
        this.drawXPBorder(g, barRectWidth, barRectHeight);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int y = (barRectHeight - 6) / 2;
        int x = 0;
        while (x + 6 < boxRect.width) {
            g.fillRect(x, y, 6, 6);
            x += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawTinyVertProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
    }

    private void drawWinVertProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
        this.drawWinBorder(g, barRectWidth, barRectHeight);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int w = barRectWidth - 4;
        int y = 0;
        while (y + 6 < boxRect.height) {
            g.fillRect(2, y, w, 6);
            y += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawXpVertProgress(Graphics g, int barRectWidth, int barRectHeight, Rectangle boxRect) {
        this.drawXPBorder(g, barRectWidth, barRectHeight);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int x = (barRectWidth - 6) / 2;
        int y = 0;
        while (y + 6 < boxRect.height) {
            g.fillRect(x, y, 6, 6);
            y += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    protected Color getSelectionForeground() {
        return Theme.progressSelectForeColor[Theme.style].getColor();
    }

    protected Color getSelectionBackground() {
        return Theme.progressSelectBackColor[Theme.style].getColor();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }
}

