/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.optimizador.analizadorMemoria;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javatraceit.optimizador.analizadorMemoria.AnalizadorMemoriaNotifier;
import javatraceit.optimizador.analizadorMemoria.ImposibleConectarException;
import javatraceit.optimizador.analizadorMemoria.InformacionClase;

public class AnalizadorMemoria {
    private AnalizadorMemoriaNotifier notifier;
    private String IP = "127.0.0.1";
    private int puerto;
    private Socket profilerSocket = null;
    private PrintStream salida;
    private InputStream lector;
    private Object lock = new Object();
    private boolean actualizando;
    Thread hiloEscucha = null;
    Thread hiloPeticiones = null;
    ArrayList volcado = new ArrayList();

    public AnalizadorMemoria(AnalizadorMemoriaNotifier notifier) {
        this.notifier = notifier;
    }

    public void conectar(int puerto) throws ImposibleConectarException {
        try {
            if (this.profilerSocket != null) {
                this.salida.println("close");
                this.profilerSocket = null;
                this.hiloEscucha.interrupt();
                this.hiloEscucha = null;
                this.hiloPeticiones.interrupt();
                this.hiloPeticiones = null;
                this.salida = null;
                this.lector = null;
            }
            this.profilerSocket = new Socket(InetAddress.getByName(this.IP), puerto);
            this.profilerSocket.setSendBufferSize(1);
        }
        catch (IOException ex) {
            throw new ImposibleConectarException("Imposible conectar con la JVM");
        }
        this.hiloEscucha = new Thread(){

            public void run() {
                int i = 0;
                byte[] buf = new byte[2048];
                try {
                    AnalizadorMemoria.this.lector = AnalizadorMemoria.this.profilerSocket.getInputStream();
                    while (true) {
                        byte[] buf_pequeno = new byte[1];
                        if (AnalizadorMemoria.this.profilerSocket.isClosed()) {
                            AnalizadorMemoria.this.profilerSocket.close();
                            AnalizadorMemoria.this.notifier.desconectado();
                            AnalizadorMemoria.this.lector = null;
                            return;
                        }
                        AnalizadorMemoria.this.lector.read(buf_pequeno, 0, 1);
                        buf[i] = buf_pequeno[0];
                        ++i;
                        if (!new String(buf_pequeno, 0, 1).equals("\n")) continue;
                        String linea = new String(buf, 0, i - 1);
                        AnalizadorMemoria.this.parsear(linea);
                        i = 0;
                    }
                }
                catch (Exception ex) {
                    AnalizadorMemoria.this.notifier.desconectado();
                    return;
                }
            }
        };
        this.hiloEscucha.setPriority(1);
        this.hiloEscucha.start();
        this.hiloPeticiones = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        if (AnalizadorMemoria.this.salida == null) {
                            AnalizadorMemoria.this.salida = new PrintStream(AnalizadorMemoria.this.profilerSocket.getOutputStream());
                        }
                        if (AnalizadorMemoria.this.profilerSocket.isClosed()) break;
                        Object object = AnalizadorMemoria.this.lock;
                        synchronized (object) {
                            if (!AnalizadorMemoria.this.actualizando) {
                                AnalizadorMemoria.this.salida.println("volcar_classes");
                            }
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex2) {
                            break;
                        }
                    }
                    catch (IOException ex) {
                        AnalizadorMemoria.this.salida = null;
                        AnalizadorMemoria.this.notifier.desconectado();
                        return;
                    }
                    catch (Exception ex) {
                        AnalizadorMemoria.this.salida = null;
                        AnalizadorMemoria.this.notifier.desconectado();
                        return;
                    }
                }
            }
        };
        this.hiloPeticiones.start();
    }

    public void desconectar() {
        if (this.hiloEscucha != null) {
            this.hiloEscucha.interrupt();
        }
        if (this.hiloPeticiones != null) {
            this.hiloPeticiones.interrupt();
        }
        if (this.salida != null) {
            this.salida.println("close");
        }
        this.salida = null;
        this.lector = null;
        try {
            if (this.profilerSocket != null) {
                this.profilerSocket.close();
            }
            this.profilerSocket = null;
        }
        catch (IOException ex) {}
    }

    public void solicitarRecolectorBasura() {
        try {
            if (this.salida == null) {
                this.salida = new PrintStream(this.profilerSocket.getOutputStream());
            }
            this.salida.println("gc");
        }
        catch (IOException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsear(String linea) {
        StringTokenizer tokenizer = new StringTokenizer(linea);
        String comando = tokenizer.nextToken();
        if (comando.equals("CLASS_DUMP")) {
            String nombre_clase = tokenizer.nextToken();
            String valor = tokenizer.nextToken();
            Integer tama\u00f1o = new Integer(tokenizer.nextToken());
            Integer nuevoValor = new Integer(valor);
            this.volcado.add(new InformacionClase(nombre_clase, nuevoValor, tama\u00f1o));
        } else if (comando.equals("CLASS_DUMP_START")) {
            Object object = this.lock;
            synchronized (object) {
                this.actualizando = true;
                this.volcado = new ArrayList();
            }
        } else if (comando.equals("CLASS_DUMP_END")) {
            Object object = this.lock;
            synchronized (object) {
                this.notifier.nuevosDatosClase(this.volcado);
                this.actualizando = false;
            }
        } else if (comando.equals("JVMPI_EVENT_GC_START")) {
            this.notifier.comienzoRecolector();
        } else if (comando.equals("JVMPI_EVENT_GC_FINISH")) {
            this.notifier.finRecolector();
        }
    }
}

