/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.controladores;

import java.io.File;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.manejoDepuracion.AplicacionEjecutandoseException;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.depurador.manejoDepuracion.LanzarDepuracionException;
import javatraceit.depurador.manejoDepuracion.ManejadorDepurador;
import javatraceit.depurador.manejoDepuracion.NoEnDepuracionException;
import javatraceit.depurador.manejoDepuracion.UIConsolaNotifier;
import javatraceit.depurador.manejoDepuracion.UIManejoDepuracionNotifier;
import javatraceit.gui.depurador.controladores.ControladorFicheros;
import javatraceit.gui.depurador.controladores.UIDepurador;

public class ControladorManejoDepuracion
implements UIConsolaNotifier,
UIManejoDepuracionNotifier {
    private UIDepurador ventanaDepurador;
    private ManejadorDepurador manejadorDepurador;

    public ControladorManejoDepuracion(UIDepurador v) {
        this.ventanaDepurador = v;
        this.manejadorDepurador = ManejadorDepurador.getManejadorDepurador();
        this.manejadorDepurador.setManejoDepuracionNotifier(this);
        this.manejadorDepurador.setUIConsolaNotifier(this);
    }

    public void lanzarDepuracion() {
        if (this.ventanaDepurador.getFicherosAbiertos().size() == 0) {
            this.ventanaDepurador.mostrarAdvertencia("No hay ning\u00fan fichero abierto");
            return;
        }
        DepuradorParametros.getDepuradorParametros().setFicheroMain(ManejadorFicheros.getManejadorFicheros().getFicheroJava(this.ventanaDepurador.getFicheroMain()));
        if (DepuradorParametros.getDepuradorParametros().getFicheroMain() == null) {
            this.ventanaDepurador.mostrarAdvertencia("No se ha definido ningun fichero para depurar.");
            return;
        }
        this.ventanaDepurador.guardarTodos();
        String errores = new ControladorFicheros(this.ventanaDepurador).compilarTodo();
        if (errores.length() > 0) {
            this.ventanaDepurador.mostrarAdvertencia("Hay errores de compilacion, no se puede comenzar la depuracion");
            return;
        }
        DepuradorParametros.getDepuradorParametros().setClasspath(DepuradorParametros.getDepuradorParametros().getFicheroMain().getFichero().getParent() + File.pathSeparator + this.ventanaDepurador.getClassPathUsuario());
        DepuradorParametros.getDepuradorParametros().setJdkHome(this.ventanaDepurador.getJDKHomeUsuario());
        DepuradorParametros.getDepuradorParametros().setParametros(this.ventanaDepurador.getParametrosUsuario());
        DepuradorParametros.getDepuradorParametros().setModo(this.ventanaDepurador.getModoAplicacion());
        DepuradorParametros.getDepuradorParametros().setAppletAlto(this.ventanaDepurador.getAppletAlto());
        DepuradorParametros.getDepuradorParametros().setAppletAncho(this.ventanaDepurador.getAppletAncho());
        try {
            ManejadorDepurador.getManejadorDepurador().lanzarDepuracion();
        }
        catch (LanzarDepuracionException ex) {
            this.ventanaDepurador.mostrarError(ex.getMessage());
        }
    }

    public void detenerDepuracion() {
        try {
            this.depuracionFinalizada();
            ManejadorDepurador.getManejadorDepurador().detenerDepuracion();
        }
        catch (NoEnDepuracionException ex) {}
    }

    public void continuarEjecucion() {
        try {
            this.ventanaDepurador.estadoEnEjecucion();
            this.manejadorDepurador.continuarEjecucion();
        }
        catch (AplicacionEjecutandoseException ex) {
            this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
        }
    }

    public void entradaConsola(byte[] b) {
        try {
            this.manejadorDepurador.entradaConsola(b);
        }
        catch (NoEnDepuracionException ex) {
            this.ventanaDepurador.mostrarError("Error interno.");
        }
    }

    public void depuracionLanzada() {
        this.ventanaDepurador.estadoEnEjecucion();
    }

    public void depuracionFinalizada() {
        this.ventanaDepurador.estadoSinDepuracion();
    }

    public void nuevaSalidaConsola(String s) {
        this.ventanaDepurador.mostrarSalidaConsola(s);
    }

    public void nuevaSalidaExcepcion(String s) {
        this.ventanaDepurador.mostrarSalidaExcepciones(s);
    }
}

