/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.controladores;

import java.io.File;
import javatraceit.gui.depurador.controladores.ControladorFicheros;
import javatraceit.gui.depurador.controladores.ControladorManejoDepuracion;
import javatraceit.gui.depurador.controladores.ControladorMemoria;
import javatraceit.gui.depurador.controladores.ControladorTraza;
import javatraceit.gui.depurador.controladores.UIDepurador;

public class ControladorGeneral {
    private UIDepurador ventanaDepurador;
    private ControladorMemoria controladorMemoria;
    private ControladorFicheros controladorFicheros;
    private ControladorTraza controladorTraza;
    private ControladorManejoDepuracion controladorManejoDepuracion;

    public ControladorGeneral(UIDepurador v) {
        this.ventanaDepurador = v;
        this.controladorMemoria = new ControladorMemoria(v);
        this.controladorFicheros = new ControladorFicheros(v);
        this.controladorTraza = new ControladorTraza(v);
        this.controladorManejoDepuracion = new ControladorManejoDepuracion(v);
    }

    public void nuevoFichero() {
        this.controladorFicheros.nuevoFichero();
    }

    public void abrirFichero(File f) {
        this.controladorFicheros.abrirFichero(f);
    }

    public void cerrarFichero(File f) {
        this.controladorFicheros.cerrarFichero(f);
    }

    public void guardarFichero(File f) {
        this.controladorFicheros.guardarFichero(f);
    }

    public void guardarComo(File f_viejo, File f_nuevo) {
        this.controladorFicheros.guardarComo(f_viejo, f_nuevo);
    }

    public String compilarTodo() {
        return this.controladorFicheros.compilarTodo();
    }

    public String compilarFichero(File f) {
        return this.controladorFicheros.compilarFichero(f);
    }

    public void lanzarDepuracion() {
        this.controladorManejoDepuracion.lanzarDepuracion();
    }

    public void detenerDepuracion() {
        this.controladorManejoDepuracion.detenerDepuracion();
    }

    public void continuarEjecucion() {
        this.controladorManejoDepuracion.continuarEjecucion();
    }

    public void entradaConsola(byte[] b) {
        this.controladorManejoDepuracion.entradaConsola(b);
    }

    public void stepOver() {
        this.controladorTraza.stepOver();
    }

    public void stepInto() {
        this.controladorTraza.stepInto();
    }

    public void stepOut() {
        this.controladorTraza.stepOut();
    }

    public void nuevoBreakpoint(File fichero, int numLinea) {
        this.controladorTraza.nuevoBreakpoint(fichero, numLinea);
    }

    public void sacarBreakpoint(File fichero, int numLinea) {
        this.controladorTraza.sacarBreakpoint(fichero, numLinea);
    }
}

