/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.controladores;

import java.io.File;
import java.util.Vector;
import javatraceit.depurador.ficheros.CompiladorFicheroException;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.FicheroNoAbiertoException;
import javatraceit.depurador.ficheros.FicheroYaAbiertoException;
import javatraceit.depurador.ficheros.ImposibleA\u00f1adirFicheroException;
import javatraceit.depurador.ficheros.ImposibleSacarFicheroException;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.gui.depurador.controladores.UIDepurador;

class ControladorFicheros {
    private UIDepurador ventanaDepurador;
    private ManejadorFicheros manejadorFicheros;

    public ControladorFicheros(UIDepurador v) {
        this.ventanaDepurador = v;
        this.manejadorFicheros = ManejadorFicheros.getManejadorFicheros();
    }

    public void nuevoFichero() {
        this.ventanaDepurador.mostrarFichero(null);
    }

    public void abrirFichero(File f) {
        if (!f.exists()) {
            this.ventanaDepurador.mostrarAdvertencia("No se encuentra fichero " + f + ". Por favor, revise la ruta");
            return;
        }
        try {
            this.manejadorFicheros.a\u00f1adirFichero(new FicheroJava(f));
        }
        catch (FicheroYaAbiertoException ex) {
        }
        catch (ImposibleA\u00f1adirFicheroException ex) {
            this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
            return;
        }
        this.ventanaDepurador.estadoConFicheros();
        this.ventanaDepurador.mostrarFichero(f);
    }

    public void cerrarFichero(File f) {
        FicheroJava miFicheroJava = this.manejadorFicheros.getFicheroJava(f);
        if (miFicheroJava != null) {
            try {
                this.manejadorFicheros.sacarFichero(miFicheroJava);
                this.ventanaDepurador.cerrarFichero(f);
            }
            catch (ImposibleSacarFicheroException ex) {
                this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
            }
        } else {
            this.ventanaDepurador.cerrarFichero(f);
        }
    }

    public void guardarFichero(File f) {
        this.ventanaDepurador.guardarFichero(f);
    }

    public void guardarComo(File f_viejo, File f_nuevo) {
        if (f_viejo != null) {
            FicheroJava ficheroJava = this.manejadorFicheros.getFicheroJava(f_viejo);
            if (ficheroJava == null) {
                this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
                return;
            }
            ficheroJava.setFichero(f_nuevo);
            this.ventanaDepurador.mostrarFichero(f_viejo);
        } else {
            FicheroJava nuevoFichero = new FicheroJava(f_nuevo);
            try {
                this.manejadorFicheros.a\u00f1adirFichero(nuevoFichero);
            }
            catch (Exception ex) {
                this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
                return;
            }
        }
        this.ventanaDepurador.guardarComo(f_nuevo);
        this.ventanaDepurador.estadoConFicheros();
    }

    public String compilarTodo() {
        String errores = "";
        Vector ficherosAbiertos = this.ventanaDepurador.getFicherosAbiertos();
        int i = 0;
        while (i < ficherosAbiertos.size()) {
            errores = errores + this.compilarFichero((File)ficherosAbiertos.elementAt(i));
            ++i;
        }
        return errores;
    }

    public String compilarFichero(File f) {
        if (f == null) {
            System.out.println("se quiso compilar un fichero null");
            this.ventanaDepurador.mostrarError("Se debe guardar primero el fichero antes de compilar.");
            return "";
        }
        System.out.println("[Controlador Ficheros]: se quiere compilar " + f);
        this.guardarFichero(f);
        DepuradorParametros.getDepuradorParametros().setJdkHome(this.ventanaDepurador.getJDKHomeUsuario());
        DepuradorParametros.getDepuradorParametros().setClasspath(this.ventanaDepurador.getClassPathUsuario());
        FicheroJava ficheroJava = this.manejadorFicheros.getFicheroJava(f);
        String errores = "";
        try {
            errores = this.manejadorFicheros.compilarFichero(ficheroJava);
            if (errores.length() > 0) {
                this.ventanaDepurador.mostrarInfoCompilacion(errores);
            } else {
                this.ventanaDepurador.mostrarInfoCompilacion("Compilacion de " + f.getAbsolutePath() + " correcta.");
            }
            return errores;
        }
        catch (FicheroNoAbiertoException ex) {
            this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
            return errores;
        }
        catch (CompiladorFicheroException ex) {
            this.ventanaDepurador.mostrarError(ex.getMessage());
            return errores;
        }
    }
}

