/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador;

import java.awt.BorderLayout;
import java.io.File;
import javatraceit.gui.depurador.editor.JTIEditor;
import javatraceit.gui.depurador.editor.JTIEditorNotifier;
import javatraceit.gui.depurador.editor.JTITextArea;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FicherosJTabbedPane
extends JTabbedPane {
    private JFrame framePadre;
    private JTIEditorNotifier notifier;

    public FicherosJTabbedPane(JFrame padre, JTIEditorNotifier notifier) {
        this.framePadre = padre;
        this.notifier = notifier;
        this.setTabPlacement(3);
    }

    public int indexFichero(File f) {
        if (f == null) {
            return -1;
        }
        int index = -1;
        int i = 0;
        while (i < this.getTabCount()) {
            if (this.getJTIEditor(i).getFichero() != null && this.getJTIEditor(i).getFichero().equals(f)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void abrirDocumento(File fichero) {
        JTITextArea jtiEditor = new JTITextArea(this.notifier);
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(jtiEditor);
            jtiEditor.abrir(fichero);
            this.addTab(fichero.getName(), panel);
            this.setSelectedIndex(this.getTabCount() - 1);
        }
        catch (Exception ex) {
            System.out.println(ex.fillInStackTrace());
            JOptionPane.showMessageDialog(this.framePadre, "Se produjo la siguiente excepcion al abrir el documento: " + ex.getMessage(), "Error", 0);
        }
    }

    public void nuevoDocumento() {
        JTITextArea jtiEditor = new JTITextArea(this.notifier);
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(jtiEditor);
            this.addTab("Sin titulo", panel);
            this.setSelectedIndex(this.getTabCount() - 1);
        }
        catch (Exception ex) {
            System.out.println(ex.fillInStackTrace());
            JOptionPane.showMessageDialog(this.framePadre, "Se produjo la siguiente excepcion al abrir el documento: " + ex.getMessage(), "Error", 0);
        }
    }

    public void cerrarDocumento(File f) {
        int index = this.indexFichero(f);
        if (index == -1) {
            return;
        }
        this.remove(index);
        this.repaint();
    }

    public void cerrarDocumentoSeleccionado() {
        this.remove(this.getSelectedIndex());
    }

    public void guardarDocumento(int index) {
        try {
            this.getJTIEditor(index).guardar();
        }
        catch (Exception ex) {
            System.out.println(ex.fillInStackTrace());
            JOptionPane.showMessageDialog(this.framePadre, "Se produjo la siguiente excepcion al guardar el documento: " + ex.getMessage(), "Error", 0);
        }
    }

    public void guardarDocumentoSeleccionado() {
        this.guardarDocumento(this.getSelectedIndex());
    }

    public void guardarTodo() {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.guardarDocumento(i);
            ++i;
        }
    }

    public JTIEditor getJTIEditor(int index) {
        return (JTIEditor)((Object)((JPanel)this.getComponentAt(index)).getComponent(0));
    }

    public JTIEditor getJTIEditorSeleccionado() {
        return (JTIEditor)((Object)((JPanel)this.getSelectedComponent()).getComponent(0));
    }
}

