/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.traza;

import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.StepRequest;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.VMEventHandler;
import javatraceit.depurador.VMEventNotifier;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.traza.NoSePuedeHacerStepException;
import javatraceit.depurador.traza.UIStepsNotifier;

public class ManejadorSteps
implements VMEventNotifier {
    private UIStepsNotifier elUIStepsNotifier;
    private static ManejadorSteps referenciaAlSingleton;

    public static ManejadorSteps getManejadorSteps() {
        if (referenciaAlSingleton == null) {
            referenciaAlSingleton = new ManejadorSteps();
        }
        return referenciaAlSingleton;
    }

    public void setUIStepsNotifier(UIStepsNotifier notifier) {
        this.elUIStepsNotifier = notifier;
    }

    public ManejadorSteps() {
        VMEventHandler.getVMEventHandler().addEventNotifier(this);
    }

    public void stepOver() throws NoSePuedeHacerStepException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO) {
            throw new NoSePuedeHacerStepException("No se puede hacer un step ahora");
        }
        System.out.println("ManejadorSteps: Creando Step OVER Request...");
        StepRequest s = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().createStepRequest(EntornoDepurador.getEntornoDepurador().getThreadActual(), -2, 2);
        s.addCountFilter(1);
        s.setSuspendPolicy(2);
        s.enable();
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
    }

    public void stepOut() throws NoSePuedeHacerStepException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO) {
            throw new NoSePuedeHacerStepException("No se puede hacer un step ahora");
        }
        System.out.println("ManejadorSteps: Creando Step OUT Request...");
        StepRequest s = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().createStepRequest(EntornoDepurador.getEntornoDepurador().getThreadActual(), -2, 3);
        s.addCountFilter(1);
        s.setSuspendPolicy(2);
        s.enable();
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
    }

    public void stepInto() throws NoSePuedeHacerStepException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO) {
            throw new NoSePuedeHacerStepException("No se puede hacer un step ahora");
        }
        StepRequest s = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().createStepRequest(EntornoDepurador.getEntornoDepurador().getThreadActual(), -2, 1);
        s.addCountFilter(1);
        s.setSuspendPolicy(2);
        s.addCountFilter(1);
        s.enable();
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
    }

    public void stepEvent(StepEvent e) {
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO);
        EntornoDepurador.getEntornoDepurador().setLocationActual(e.location());
        EntornoDepurador.getEntornoDepurador().setThreadActual(e.thread());
        System.out.println("ManejadorSteps: Recibido un StepEvent");
        e.virtualMachine().eventRequestManager().deleteEventRequest(e.request());
        FicheroJava ficheroFuente = ManejadorFicheros.getManejadorFicheros().buscarFicheroFuente(e.location());
        if (ficheroFuente == null) {
            try {
                this.stepOut();
            }
            catch (Exception ex) {
                ex.fillInStackTrace();
            }
        } else {
            if (!ManejadorFicheros.getManejadorFicheros().estaAbierto(ficheroFuente)) {
                try {
                    ManejadorFicheros.getManejadorFicheros().a\u00f1adirFichero(ficheroFuente);
                    ManejadorFicheros.getManejadorFicheros().compilarFichero(ficheroFuente);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.elUIStepsNotifier.stepRealizado(ficheroFuente, e.location().lineNumber());
        }
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
    }

    public void breakpointEvent(BreakpointEvent e) {
    }

    public void vmStartEvent(VMStartEvent e) {
    }

    public void vmDeathEvent(VMDeathEvent e) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
    }

    public void threadStartEvent(ThreadStartEvent e) {
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    public void fieldWatchEvent(WatchpointEvent e) {
    }

    public void exceptionEvent(ExceptionEvent e) {
    }

    public void methodEntryEvent(MethodEntryEvent e) {
    }

    public void methodExitEvent(MethodExitEvent e) {
    }

    public void vmInterrupted() {
    }

    public void receivedEvent(Event event) {
    }
}

