/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.traza;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.Iterator;
import java.util.Vector;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.VMEventHandler;
import javatraceit.depurador.VMEventNotifier;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.traza.ManejadorSteps;
import javatraceit.depurador.traza.UIBreakpointsNotifier;

public class ManejadorBreakpoints
implements VMEventNotifier {
    private UIBreakpointsNotifier elUIBreakpointsNotifier;
    private Vector breakpointsSolicitados = new Vector();
    private Vector breakpointsSolicitadosSinDepuracion = new Vector();
    private static ManejadorBreakpoints referenciaAlSingleton;

    public static ManejadorBreakpoints getManejadorBreakpoints() {
        if (referenciaAlSingleton == null) {
            referenciaAlSingleton = new ManejadorBreakpoints();
        }
        return referenciaAlSingleton;
    }

    public void setUIBreakpointsNotifier(UIBreakpointsNotifier notifier) {
        this.elUIBreakpointsNotifier = notifier;
    }

    public ManejadorBreakpoints() {
        VMEventHandler.getVMEventHandler().addEventNotifier(this);
    }

    private void nuevoBreakpointEnDepuracion(FicheroJava f, int lineaCodigo) {
        int pos = this.breakpointsSolicitadosSinDepuracion.indexOf(new BreakpointPrevio(f, lineaCodigo));
        if (pos == -1) {
            this.nuevoBreakpointSinDepuracion(f, lineaCodigo);
        }
        int i = 0;
        while (i < f.getClases().size()) {
            BreakpointsClase breakpointsClase = this.addNuevoBreakpointsClase((String)f.getClases().elementAt(i), lineaCodigo);
            Iterator clasesIt = EntornoDepurador.getEntornoDepurador().getVirtualMachine().allClasses().iterator();
            boolean yaCargada = false;
            while (clasesIt.hasNext()) {
                ReferenceType claseCargada = (ReferenceType)clasesIt.next();
                if (!claseCargada.name().equals((String)f.getClases().elementAt(i))) continue;
                yaCargada = true;
                try {
                    EventRequestManager eManager = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager();
                    Iterator locationIterator = claseCargada.locationsOfLine(lineaCodigo).iterator();
                    if (!locationIterator.hasNext() || ((BreakpointRequestLinea)breakpointsClase.numLineas.elementAt((int)breakpointsClase.numLineas.indexOf((Object)(ManejadorBreakpoints)this.new BreakpointRequestLinea(null, (int)lineaCodigo)))).br != null && ((BreakpointRequestLinea)breakpointsClase.numLineas.elementAt((int)breakpointsClase.numLineas.indexOf((Object)(ManejadorBreakpoints)this.new BreakpointRequestLinea(null, (int)lineaCodigo)))).br.isEnabled()) break;
                    Location loc = (Location)locationIterator.next();
                    BreakpointRequest rec = eManager.createBreakpointRequest(loc);
                    rec.setSuspendPolicy(2);
                    rec.enable();
                    System.out.println("ManejadorBreakpoints : Creada " + rec + " dinamicamente");
                    ((BreakpointRequestLinea)breakpointsClase.numLineas.elementAt((int)breakpointsClase.numLineas.indexOf((Object)(ManejadorBreakpoints)this.new BreakpointRequestLinea(null, (int)lineaCodigo)))).br = rec;
                }
                catch (Exception ex) {
                    System.out.println("La linea " + claseCargada.name() + ": " + lineaCodigo + " no vale, se ignora" + ex);
                    ex.printStackTrace();
                }
                break;
            }
            if (!yaCargada) {
                EventRequestManager eManager = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager();
                if (breakpointsClase.prepareRequest == null) {
                    ClassPrepareRequest request = eManager.createClassPrepareRequest();
                    request.addClassFilter(breakpointsClase.patron);
                    request.setSuspendPolicy(2);
                    breakpointsClase.setPrepareRequest(request);
                    request.enable();
                    System.out.println("ManejadorBreakpoints: Generado ClassPrepareRequest para la clase: " + breakpointsClase.patron);
                }
            }
            ++i;
        }
    }

    private void nuevoBreakpointSinDepuracion(FicheroJava f, int lineaCodigo) {
        this.breakpointsSolicitadosSinDepuracion.add(new BreakpointPrevio(f, lineaCodigo));
    }

    private void sacarBreakpointEnDepuracion(FicheroJava f, int lineaCodigo) {
        int pos = this.breakpointsSolicitadosSinDepuracion.indexOf(new BreakpointPrevio(f, lineaCodigo));
        if (pos != -1) {
            this.breakpointsSolicitadosSinDepuracion.remove(pos);
        }
        int i = 0;
        while (i < f.getClases().size()) {
            String patron = (String)f.getClases().elementAt(i);
            int pos2 = this.breakpointsSolicitados.indexOf(new BreakpointsClase(patron));
            if (pos2 != -1) {
                BreakpointsClase breakpointsClase = (BreakpointsClase)this.breakpointsSolicitados.elementAt(pos2);
                Vector numLineas = breakpointsClase.numLineas;
                int pos3 = numLineas.indexOf(new BreakpointRequestLinea(null, lineaCodigo));
                if (pos3 != -1) {
                    BreakpointRequestLinea breakpointRequestLinea = (BreakpointRequestLinea)numLineas.elementAt(pos3);
                    if (breakpointRequestLinea.br != null) {
                        breakpointRequestLinea.br.disable();
                    }
                    numLineas.remove(pos3);
                    System.out.println("ManejadorBreakpoints: Sacado breakpoint dinamicamente: " + breakpointRequestLinea.br);
                }
            }
            ++i;
        }
    }

    private void sacarBreakpointSinDepuracion(FicheroJava f, int lineaCodigo) {
        int pos = this.breakpointsSolicitadosSinDepuracion.indexOf(new BreakpointPrevio(f, lineaCodigo));
        if (pos != -1) {
            this.breakpointsSolicitadosSinDepuracion.remove(pos);
            System.out.println("ManejadorBreakpoints: Sacado breakpoint sin depuracion: fichero: " + f.getFichero() + ": " + lineaCodigo);
        }
    }

    public void nuevoBreakpoint(FicheroJava f, int lineaCodigo) {
        if (!ManejadorFicheros.getManejadorFicheros().estaAbierto(f)) {
            return;
        }
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() == EntornoDepurador.getEntornoDepurador().NO_DEPURANDO) {
            this.nuevoBreakpointSinDepuracion(f, lineaCodigo);
        } else {
            this.nuevoBreakpointEnDepuracion(f, lineaCodigo);
        }
    }

    public void sacarBreakpoint(FicheroJava f, int lineaCodigo) {
        if (!ManejadorFicheros.getManejadorFicheros().estaAbierto(f)) {
            return;
        }
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() == EntornoDepurador.getEntornoDepurador().NO_DEPURANDO) {
            this.sacarBreakpointSinDepuracion(f, lineaCodigo);
        } else {
            this.sacarBreakpointEnDepuracion(f, lineaCodigo);
        }
    }

    public void sacarBreakpoints(FicheroJava f) {
        if (!ManejadorFicheros.getManejadorFicheros().estaAbierto(f)) {
            return;
        }
        Vector breakpoints = new Vector();
        int i = 0;
        while (i < this.breakpointsSolicitadosSinDepuracion.size()) {
            BreakpointPrevio p = (BreakpointPrevio)this.breakpointsSolicitadosSinDepuracion.elementAt(i);
            if (p.fichero.equals(f)) {
                this.sacarBreakpoint(f, p.lineaCodigo);
            }
            ++i;
        }
    }

    private BreakpointsClase addNuevoBreakpointsClase(String patron, int linea) {
        int index = this.breakpointsSolicitados.indexOf(new BreakpointsClase(patron));
        if (index != -1) {
            BreakpointsClase spec = (BreakpointsClase)this.breakpointsSolicitados.elementAt(index);
            spec.addLinea(linea);
            return spec;
        }
        BreakpointsClase nuevoBreakpointsClase = new BreakpointsClase(patron);
        nuevoBreakpointsClase.addLinea(linea);
        this.breakpointsSolicitados.add(nuevoBreakpointsClase);
        return nuevoBreakpointsClase;
    }

    private void generarClassPrepareRequests() {
        EventRequestManager eManager = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager();
        int i = this.breakpointsSolicitados.size() - 1;
        while (i >= 0) {
            BreakpointsClase spec = (BreakpointsClase)this.breakpointsSolicitados.elementAt(i);
            if (spec.prepareRequest == null) {
                ClassPrepareRequest request = eManager.createClassPrepareRequest();
                request.addClassFilter(spec.patron);
                request.setSuspendPolicy(2);
                spec.setPrepareRequest(request);
                request.enable();
                System.out.println("ManejadorBreakpoints: Generado ClassPrepareRequest para la clase: " + spec.patron);
            }
            --i;
        }
    }

    private void pasarBreakpointsPrevios() {
        int i = 0;
        while (i < this.breakpointsSolicitadosSinDepuracion.size()) {
            BreakpointPrevio breakpointPrevio = (BreakpointPrevio)this.breakpointsSolicitadosSinDepuracion.elementAt(i);
            this.nuevoBreakpointEnDepuracion(breakpointPrevio.fichero, breakpointPrevio.lineaCodigo);
            ++i;
        }
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        System.out.println("ManejadorBreakpoints: Recibido class prepare request para la clase " + e.referenceType().name());
        EventRequestManager eManager = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager();
        BreakpointsClase spec = null;
        int numLinea = 0;
        try {
            int i = 0;
            while (i < this.breakpointsSolicitados.size()) {
                spec = (BreakpointsClase)this.breakpointsSolicitados.elementAt(i);
                if (e.request().equals(spec.prepareRequest)) {
                    Vector lineas = spec.numLineas;
                    int j = 0;
                    while (j < lineas.size()) {
                        numLinea = ((BreakpointRequestLinea)lineas.elementAt((int)j)).numLinea;
                        try {
                            Iterator locationIterator = e.referenceType().locationsOfLine(numLinea).iterator();
                            if (locationIterator.hasNext()) {
                                Location loc = (Location)locationIterator.next();
                                BreakpointRequest rec = eManager.createBreakpointRequest(loc);
                                rec.setSuspendPolicy(2);
                                rec.enable();
                                System.out.println("ManejadorBreakpoints :Creado " + rec);
                                ((BreakpointRequestLinea)lineas.elementAt((int)j)).br = rec;
                            }
                        }
                        catch (InvalidLineNumberException ex) {
                            System.out.println("La linea " + e.referenceType().name() + ": " + numLinea + " no vale, se ignora");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
        }
        catch (AbsentInformationException ex) {
            ex.printStackTrace();
        }
    }

    public void breakpointEvent(BreakpointEvent e) {
        System.out.println("ManejadorBreakpoints: Recibido un BreakpointEvent " + e.location());
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO);
        EntornoDepurador.getEntornoDepurador().setLocationActual(e.location());
        EntornoDepurador.getEntornoDepurador().setThreadActual(e.thread());
        e.request().enable();
        Iterator stepRequests = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().stepRequests().iterator();
        Vector<StepRequest> requestsAEliminar = new Vector<StepRequest>();
        while (stepRequests.hasNext()) {
            StepRequest req = (StepRequest)stepRequests.next();
            if (!req.thread().equals(e.thread())) continue;
            requestsAEliminar.add(req);
        }
        int i = 0;
        while (i < requestsAEliminar.size()) {
            System.out.println("ManejadorBreakpoints: Se elimino un step request solicitada en el mismo hilo.");
            EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().deleteEventRequest((StepRequest)requestsAEliminar.elementAt(i));
            ++i;
        }
        FicheroJava ficheroFuente = ManejadorFicheros.getManejadorFicheros().buscarFicheroFuente(e.location());
        if (ficheroFuente == null) {
            try {
                ManejadorSteps.getManejadorSteps().stepOut();
            }
            catch (Exception ex) {
                ex.fillInStackTrace();
            }
        } else {
            if (!ManejadorFicheros.getManejadorFicheros().estaAbierto(ficheroFuente)) {
                try {
                    ManejadorFicheros.getManejadorFicheros().a\u00f1adirFichero(ficheroFuente);
                    ManejadorFicheros.getManejadorFicheros().compilarFichero(ficheroFuente);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.elUIBreakpointsNotifier.breakpointAlcanzado(ficheroFuente, e.location().lineNumber());
        }
    }

    public void vmStartEvent(VMStartEvent e) {
        this.pasarBreakpointsPrevios();
    }

    public void vmDeathEvent(VMDeathEvent e) {
        System.out.println("ManejadorBreakpoints: voy borrar todos los breakpoints");
        this.breakpointsSolicitados = new Vector();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        System.out.println("ManejadorBreakpoints: voy borrar todos los breakpoints");
        this.breakpointsSolicitados = new Vector();
    }

    public void vmInterrupted() {
    }

    public void stepEvent(StepEvent e) {
    }

    public void threadStartEvent(ThreadStartEvent e) {
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    public void fieldWatchEvent(WatchpointEvent e) {
    }

    public void exceptionEvent(ExceptionEvent e) {
    }

    public void methodEntryEvent(MethodEntryEvent e) {
    }

    public void methodExitEvent(MethodExitEvent e) {
    }

    public void receivedEvent(Event event) {
    }

    private class BreakpointRequestLinea {
        public int numLinea;
        public BreakpointRequest br;

        public BreakpointRequestLinea(BreakpointRequest br, int numLinea) {
            this.numLinea = numLinea;
            this.br = br;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BreakpointRequestLinea)) {
                return false;
            }
            return ((BreakpointRequestLinea)o).numLinea == this.numLinea;
        }
    }

    private class BreakpointsClase {
        public String patron;
        public Vector numLineas = new Vector();
        public ClassPrepareRequest prepareRequest = null;

        BreakpointsClase(String patron) {
            this.patron = patron;
        }

        void setPrepareRequest(ClassPrepareRequest r) {
            this.prepareRequest = r;
        }

        void addLinea(int linea) {
            if (this.numLineas.indexOf(new BreakpointRequestLinea(null, linea)) == -1) {
                int i = 0;
                while (i < this.numLineas.size()) {
                    int num = ((BreakpointRequestLinea)this.numLineas.elementAt((int)i)).numLinea;
                    if (num > linea) {
                        this.numLineas.add(i, new BreakpointRequestLinea(null, linea));
                        return;
                    }
                    ++i;
                }
                this.numLineas.add(new BreakpointRequestLinea(null, linea));
            }
        }

        void sacarLinea(int linea) {
            int pos = this.numLineas.indexOf(new Integer(linea));
            if (pos != -1) {
                this.numLineas.remove(pos);
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof BreakpointsClase)) {
                return false;
            }
            return ((BreakpointsClase)o).patron.equals(this.patron);
        }
    }

    private class BreakpointPrevio {
        public FicheroJava fichero;
        public int lineaCodigo;

        public BreakpointPrevio(FicheroJava f, int lineaCodigo) {
            this.fichero = f;
            this.lineaCodigo = lineaCodigo;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BreakpointPrevio)) {
                return false;
            }
            BreakpointPrevio o_bp = (BreakpointPrevio)o;
            return o_bp.fichero.equals(this.fichero) && o_bp.lineaCodigo == this.lineaCodigo;
        }
    }
}

