/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.ficheros;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

class SourceMapper {
    private final String[] dirs;

    SourceMapper(String sourcepath) {
        StringTokenizer st = new StringTokenizer(sourcepath, File.pathSeparator);
        ArrayList<String> dlist = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            dlist.add(st.nextToken());
        }
        this.dirs = dlist.toArray(new String[0]);
    }

    File sourceFile(Location loc) {
        try {
            String filename = loc.sourceName();
            String refName = loc.declaringType().name();
            int iDot = refName.lastIndexOf(46);
            String pkgName = iDot >= 0 ? refName.substring(0, iDot + 1) : "";
            String full = pkgName.replace('.', File.separatorChar) + filename;
            int i = 0;
            while (i < this.dirs.length) {
                File path = new File(this.dirs[i], full);
                if (path.exists()) {
                    return path;
                }
                ++i;
            }
            return null;
        }
        catch (AbsentInformationException e) {
            return null;
        }
    }

    BufferedReader sourceReader(Location loc) {
        File sourceFile = this.sourceFile(loc);
        if (sourceFile == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(sourceFile));
        }
        catch (IOException exc) {
            return null;
        }
    }
}

