/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.ficheros;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javatraceit.depurador.ficheros.CompiladorFicheroException;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.JJTJavaParserState;
import javatraceit.depurador.ficheros.JavaCharStream;
import javatraceit.depurador.ficheros.JavaParser;
import javatraceit.depurador.ficheros.JavaParserTokenManager;
import javatraceit.depurador.ficheros.ParseException;
import javatraceit.depurador.ficheros.SimpleNode;

class CompiladorFicheroJava {
    private String JDK = new String();
    private String classpath = new String();
    private static JavaCharStream stream;
    private static JavaParserTokenManager tokenM;
    private static JavaParser parser;

    public CompiladorFicheroJava(String JDK, String classpath) {
        this.JDK = JDK;
        if (classpath.startsWith("\"") && classpath.length() > 1 && classpath.endsWith("\"")) {
            classpath = classpath.substring(1, classpath.length() - 1);
            System.out.println("Rectificado el classpath a: " + classpath);
        }
        this.classpath = classpath;
    }

    private int calcularNumClases(File f) throws ParseException, IOException {
        FileInputStream flujo = new FileInputStream(f);
        if (stream == null) {
            stream = new JavaCharStream(flujo);
        } else {
            stream.ReInit(flujo);
        }
        if (tokenM == null) {
            tokenM = new JavaParserTokenManager(stream);
        } else {
            JavaParserTokenManager.ReInit(stream);
        }
        if (parser == null) {
            parser = new JavaParser(tokenM);
        } else {
            parser.ReInit(tokenM);
        }
        JJTJavaParserState state = JavaParser.jjtree;
        parser.CompilationUnit();
        SimpleNode node = (SimpleNode)state.rootNode();
        return CompiladorFicheroJava.contarClasesNodo(node);
    }

    private static int contarClasesNodo(SimpleNode raiz) {
        int resultado = 0;
        if (raiz.toString().equals("ClassBody") || raiz.toString().equals("ClassBodyAnonym")) {
            ++resultado;
        }
        int i = 0;
        while (i < raiz.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)raiz.jjtGetChild(i);
            if (n != null) {
                resultado += CompiladorFicheroJava.contarClasesNodo(n);
            }
            ++i;
        }
        return resultado;
    }

    /*
     * WARNING - void declaration
     */
    public String compilarFicheroJava(FicheroJava fichero) throws CompiladorFicheroException {
        int numClases = 0;
        try {
            numClases = this.calcularNumClases(fichero.getFichero());
        }
        catch (IOException ex) {
            throw new CompiladorFicheroException("Se produjo un error de E/S al acceder a: " + fichero);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        String classpath = (this.classpath.length() > 0 ? this.classpath + File.pathSeparator : "") + fichero.getFichero().getParent();
        String[] array = new String[]{this.JDK + File.separator + "bin" + File.separator + "javac", "-g", "-verbose", "-classpath", classpath, fichero.getFichero().getAbsolutePath()};
        Process proceso = null;
        try {
            proceso = Runtime.getRuntime().exec(array);
        }
        catch (IOException e) {
            throw new CompiladorFicheroException("No se puede ejecutar el compilador. Asegurese de que la ruta es correcta o que tiene permisos");
        }
        BufferedReader lector = new BufferedReader(new InputStreamReader(proceso.getErrorStream()));
        String errores = "";
        boolean num_parsing = false;
        fichero.setClases(new Vector());
        boolean cogidoPaquete = false;
        String nombrePaquete = "";
        try {
            String linea;
            while ((linea = lector.readLine()) != null) {
                StringTokenizer tk;
                void var8_14;
                if (!var8_14.startsWith("[")) {
                    errores = errores + (String)var8_14 + "\n";
                }
                if (var8_14.startsWith("[checking") && !cogidoPaquete) {
                    tk = new StringTokenizer((String)var8_14);
                    tk.nextToken();
                    nombrePaquete = tk.nextToken();
                    int pos = nombrePaquete.lastIndexOf(".");
                    nombrePaquete = pos != -1 ? nombrePaquete.substring(0, nombrePaquete.lastIndexOf(".")) : "";
                    cogidoPaquete = true;
                }
                if (!var8_14.startsWith("[wrote") || numClases <= 0) continue;
                --numClases;
                tk = new StringTokenizer((String)var8_14);
                String nombreClase = "";
                while (tk.hasMoreTokens()) {
                    nombreClase = tk.nextToken();
                }
                int inicial = 0;
                if (nombreClase.lastIndexOf(File.separator) != -1) {
                    inicial = nombreClase.lastIndexOf(File.separator) + 1;
                }
                nombreClase = nombreClase.substring(inicial, nombreClase.lastIndexOf(46));
                fichero.a\u00f1adirClase((nombrePaquete.length() > 0 ? nombrePaquete + "." : "") + nombreClase);
                System.out.println("[CompiladorFicheroJava]: encontrada la clase: " + (nombrePaquete.length() > 0 ? nombrePaquete + "." : "") + nombreClase);
            }
        }
        catch (IOException ex) {
            throw new CompiladorFicheroException("Se produjo un error de E/S al ejecutar el compilador");
        }
        int salida = 1;
        try {
            salida = proceso.waitFor();
        }
        catch (IllegalThreadStateException ex) {
            ex.fillInStackTrace();
        }
        catch (InterruptedException ex) {
            ex.fillInStackTrace();
        }
        if (salida != 0) {
            return errores;
        }
        return "";
    }
}

