/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javatraceit.gui.depurador.editor.SyntaxStyle;
import javatraceit.gui.depurador.editor.Token;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class SyntaxUtilities {
    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length = offset + match.length();
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[11];
        styles[1] = new SyntaxStyle(new Color(34816), false, false);
        styles[2] = new SyntaxStyle(new Color(34816), false, false);
        styles[6] = new SyntaxStyle(new Color(170), false, true);
        styles[7] = new SyntaxStyle(new Color(170), false, true);
        styles[8] = new SyntaxStyle(new Color(170), false, true);
        styles[3] = new SyntaxStyle(new Color(6619289), false, false);
        styles[4] = new SyntaxStyle(new Color(6619289), false, true);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }

    public static int paintSyntaxLine(Segment line, Token tokens, SyntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    private SyntaxUtilities() {
    }
}

