/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javatraceit.gui.depurador.editor.JEditTextArea;
import javatraceit.gui.depurador.editor.JTIEditor;
import javatraceit.gui.depurador.editor.JTIEditorNotifier;
import javatraceit.gui.depurador.editor.JTITextAreaPainter;
import javatraceit.gui.depurador.editor.JavaTokenMarker;
import javatraceit.gui.depurador.editor.SyntaxDocument;
import javatraceit.gui.depurador.editor.TextAreaDefaults;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;

public class JTITextArea
extends JEditTextArea
implements JTIEditor {
    JTIEditorNotifier notifier;
    private int numeroDeLineasActual = 1;
    public NumLineas numLineas = new NumLineas();
    private Vector numerosDeLineaVector = new Vector();
    private JList numerosDeLineaList = new JList();
    private JViewport viewport = new JViewport();
    private File fichero;
    private int lineaDestacada = 3;
    private Vector breakpoints = new Vector();

    public void setFirstLine(int firstLine) {
        super.setFirstLine(firstLine);
        if (this.numerosDeLineaList != null) {
            this.numerosDeLineaList.repaint();
        }
    }

    public JTITextArea(JTIEditorNotifier notifier) {
        this.notifier = notifier;
        super.setDocument(new SyntaxDocument());
        this.viewport.setView(this.numerosDeLineaList);
        super.add("left", this.numLineas);
        this.remove(this.painter);
        this.painter = new JTITextAreaPainter(this, TextAreaDefaults.getDefaults());
        this.painter.addComponentListener(new JEditTextArea.ComponentHandler());
        this.painter.addMouseListener(new JEditTextArea.MouseHandler());
        this.painter.addMouseMotionListener(new JEditTextArea.DragHandler());
        this.setTokenMarker(new JavaTokenMarker());
        this.add(JEditTextArea.CENTER, this.painter);
        this.setMinimumSize(new Dimension(0, 0));
    }

    protected void documentChanged(DocumentEvent evt) {
        super.documentChanged(evt);
        if (this.numeroDeLineasActual < this.getLineCount()) {
            this.numerosDeLineaList.repaint();
            int i = this.numeroDeLineasActual + 1;
            while (i <= this.getLineCount()) {
                this.numerosDeLineaVector.add(new Integer(i));
                this.numerosDeLineaList.setListData(this.numerosDeLineaVector);
                ++i;
            }
        } else if (this.numeroDeLineasActual > this.getLineCount()) {
            int i = this.numeroDeLineasActual;
            while (i > this.getLineCount()) {
                this.numerosDeLineaVector.remove(this.numerosDeLineaVector.size() - 1);
                this.numerosDeLineaList.setListData(this.numerosDeLineaVector);
                --i;
            }
        }
        this.numeroDeLineasActual = this.getLineCount();
        this.numerosDeLineaList.setFixedCellWidth(this.painter.getFontMetrics().stringWidth(new Integer(this.numeroDeLineasActual).toString()) + 5);
    }

    public void abrir(File fichero) throws IOException, BadLocationException {
        this.getDocument().remove(0, this.getDocument().getLength() - 1);
        StyledEditorKit kit = new StyledEditorKit();
        kit.read(new InputStreamReader(new FileInputStream(fichero)), (Document)this.getDocument(), 0);
        this.fichero = fichero;
        this.scrollTo(1, 0);
        this.numLineas.repaint();
    }

    public void guardar() throws IOException, BadLocationException {
        if (this.fichero == null) {
            return;
        }
        StyledEditorKit kit = new StyledEditorKit();
        kit.write(new FileOutputStream(this.fichero), (Document)this.getDocument(), 0, this.getDocument().getLength());
    }

    public void guardarComo(File f) throws IOException, BadLocationException {
        StyledEditorKit kit = new StyledEditorKit();
        kit.write(new FileOutputStream(f), (Document)this.getDocument(), 0, this.getDocument().getLength());
        this.fichero = f;
    }

    public File getFichero() {
        return this.fichero;
    }

    public void destacarLinea(int numLinea) {
        ((JTITextAreaPainter)this.painter).setLineaDestacada(numLinea);
        this.scrollTo(numLinea, 0);
    }

    public void noDestacarLineaCodigo() {
        ((JTITextAreaPainter)this.painter).sacarLineaDestacada();
    }

    public void toggleBreakpoint(int i) {
        if (this.fichero == null) {
            return;
        }
        boolean a\u00f1adido = ((JTITextAreaPainter)this.painter).toggleBreakpoint(i);
        if (a\u00f1adido) {
            this.notifier.a\u00f1adidoBreakpoint(this.getFichero(), i + 1);
        } else {
            this.notifier.sacadoBreakpoint(this.getFichero(), i + 1);
        }
    }

    public int lineaActual() {
        return super.getCaretLine();
    }

    public void sacarBreakpoints() {
        ((JTITextAreaPainter)this.painter).sacarTodosLosBreakpoints();
    }

    public Vector getBreakpoints() {
        return ((JTITextAreaPainter)this.painter).getBreakpoints();
    }

    public void setEnabled(boolean valor) {
        this.setEditable(valor);
    }

    class NumLineas
    extends JComponent {
        public int y;
        private int first;
        private int last;

        public NumLineas() {
            int lineHeight = JTITextArea.this.painter.getFontMetrics().getHeight();
            int alto = JTITextArea.this.getPreferredSize().height;
            int numLineasVisibles = alto / lineHeight;
            int anchoMinimo = JTITextArea.this.painter.fm.stringWidth(String.valueOf(numLineasVisibles));
            this.setPreferredSize(new Dimension(anchoMinimo + 10, alto));
            this.setMaximumSize(new Dimension(anchoMinimo + 10, alto));
            this.setOpaque(true);
            this.addMouseListener(new MiMouseAdapter());
            this.setToolTipText("colocar / descartar breakpoint");
        }

        public void paint(Graphics g) {
            int anchoDelNumeroMasGrande;
            int lineHeight = JTITextArea.this.painter.getFontMetrics().getHeight();
            int anchoNumLineasVisibles = JTITextArea.this.painter.fm.stringWidth(String.valueOf(this.getParent().getHeight() / lineHeight));
            int anchoDebido = Math.max(anchoNumLineasVisibles, anchoDelNumeroMasGrande = JTITextArea.this.painter.fm.stringWidth(String.valueOf(JTITextArea.this.getLineCount())));
            if (this.getPreferredSize().width != anchoDebido) {
                JTITextArea.this.getLayout().removeLayoutComponent(this);
                this.setPreferredSize(new Dimension(anchoDebido + 15, 20));
                this.setMaximumSize(new Dimension(anchoDebido, 20));
                JTITextArea.this.add((Component)this, LEFT);
            }
            super.paint(g);
            g.setColor(new Color(230, 230, 244));
            g.fillRect(0, 0, this.getBounds().width - 5, this.getParent().getHeight());
            g.setColor(JTITextArea.this.painter.getBackground());
            g.fillRect(this.getBounds().width - 5, 0, 5, this.getParent().getHeight());
            int i = this.first + 1;
            while (i < this.last + 1) {
                g.setColor(new Color(153, 153, 204));
                g.drawString(String.valueOf(i), 0, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.2));
                if (((JTITextAreaPainter)JTITextArea.this.getPainter()).getLineaDestacada() == i) {
                    Polygon p = new Polygon();
                    p.addPoint(anchoDebido + 2, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3));
                    p.addPoint(anchoDebido + 2, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3) - 8);
                    p.addPoint(anchoDebido + 10, (i - this.first) * lineHeight - (int)((double)lineHeight * 0.3) - 4);
                    g.setColor(new Color(238));
                    g.fillPolygon(p);
                }
                ++i;
            }
        }

        public void repaint(int first, int last) {
            this.first = first;
            this.last = last;
            this.repaint();
        }

        class MiMouseAdapter
        extends MouseAdapter {
            MiMouseAdapter() {
            }

            public void mouseClicked(MouseEvent e) {
                if (NumLineas.this.isEnabled()) {
                    int linea = JTITextArea.this.yToLine(e.getPoint().y);
                    JTITextArea.this.toggleBreakpoint(linea);
                }
            }

            public void mouseEntered(MouseEvent e) {
                JTITextArea.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }
}

