/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.controladores;

import java.io.File;
import java.util.Vector;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.manejoDepuracion.AplicacionEjecutandoseException;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.depurador.manejoDepuracion.LanzarDepuracionException;
import javatraceit.depurador.manejoDepuracion.ManejadorDepurador;
import javatraceit.depurador.manejoDepuracion.NoEnDepuracionException;
import javatraceit.depurador.manejoDepuracion.UIConsolaNotifier;
import javatraceit.depurador.manejoDepuracion.UIManejoDepuracionNotifier;
import javatraceit.gui.depurador.controladores.ControladorFicheros;
import javatraceit.gui.depurador.controladores.UIDepurador;
import javax.swing.JTree;

public class ControladorManejoDepuracion
implements UIConsolaNotifier,
UIManejoDepuracionNotifier {
    private UIDepurador ventanaDepurador;

    public ControladorManejoDepuracion(UIDepurador v) {
        this.ventanaDepurador = v;
        ManejadorDepurador.getManejadorDepurador().setManejoDepuracionNotifier(this);
        ManejadorDepurador.getManejadorDepurador().setUIConsolaNotifier(this);
        this.ventanaDepurador = v;
    }

    public void establecerParametros(String cp, String jdkHome, String param) {
        DepuradorParametros.getDepuradorParametros().CLASS_PATH = cp;
        DepuradorParametros.getDepuradorParametros().JDK_HOME = jdkHome;
        DepuradorParametros.getDepuradorParametros().PARAMETROS = param;
    }

    public void lanzarDepuracion() {
        if (this.ventanaDepurador.getFicherosAbiertos().size() == 0) {
            this.ventanaDepurador.mostrarAdvertencia("No hay ning\u00fan fichero abierto");
            return;
        }
        DepuradorParametros.getDepuradorParametros().ficheroMain = ManejadorFicheros.getManejadorFicheros().getFicheroJava(this.ventanaDepurador.getFicheroMain());
        if (DepuradorParametros.getDepuradorParametros().ficheroMain == null) {
            this.ventanaDepurador.mostrarAdvertencia("No se ha definido ningun fichero para depurar.");
            return;
        }
        this.ventanaDepurador.guardarTodos();
        String errores = new ControladorFicheros(this.ventanaDepurador).compilarTodo();
        if (errores.length() > 0) {
            this.ventanaDepurador.mostrarAdvertencia("Hay errores de compilacion, no se puede comenzar la depuracion");
            return;
        }
        DepuradorParametros.getDepuradorParametros().CLASS_PATH = DepuradorParametros.getDepuradorParametros().ficheroMain.getFichero().getParent() + File.pathSeparator + this.ventanaDepurador.getClassPathUsuario();
        DepuradorParametros.getDepuradorParametros().JDK_HOME = this.ventanaDepurador.getJDKHomeUsuario();
        DepuradorParametros.getDepuradorParametros().PARAMETROS = this.ventanaDepurador.getParametrosUsuario();
        try {
            ManejadorDepurador.getManejadorDepurador().lanzarDepuracion(true);
        }
        catch (LanzarDepuracionException ex) {
            this.ventanaDepurador.mostrarError(ex.getMessage());
        }
    }

    public void detenerDepuracion() {
        try {
            this.depuracionFinalizada();
            ManejadorDepurador.getManejadorDepurador().detenerDepuracion();
        }
        catch (NoEnDepuracionException ex) {}
    }

    public void continuarEjecucion() {
        try {
            this.ventanaDepurador.estadoEnEjecucion();
            ManejadorDepurador.getManejadorDepurador().continuarEjecucion();
        }
        catch (AplicacionEjecutandoseException ex) {
            this.ventanaDepurador.mostrarError("Error Interno. Se recomienda reiniciar.");
        }
    }

    public void nuevaSalidaConsola(String s) {
        this.ventanaDepurador.mostrarSalidaConsola(s);
    }

    public void nuevaSalidaExcepcion(String s) {
    }

    public void depuracionLanzada() {
        this.ventanaDepurador.estadoEnEjecucion();
    }

    public void depuracionFinalizada() {
        this.ventanaDepurador.setArbolMemoria(new JTree(new Vector()));
        this.ventanaDepurador.estadoSinDepuracion();
    }
}

