/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javatraceit.gui.depurador.FicherosJTabbedPane;
import javatraceit.gui.depurador.NuevoValorPrimitivoDialog;
import javatraceit.gui.depurador.PreferenciasUsuario;
import javatraceit.gui.depurador.PreferenciasUsuarioDialog;
import javatraceit.gui.depurador.controladores.ControladorGeneral;
import javatraceit.gui.depurador.controladores.UIDepurador;
import javatraceit.gui.depurador.editor.JTIEditor;
import javatraceit.gui.depurador.editor.JTIEditorNotifier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class DepuradorComponente
extends JPanel
implements JTIEditorNotifier,
UIDepurador {
    JPanel menusPane = new JPanel();
    JTextArea consolaArea = new JTextArea();
    JSplitPane splitPaneHoriz = new JSplitPane();
    JSplitPane splitPaneVert = new JSplitPane();
    JScrollPane arbolScroll = new JScrollPane();
    JTree arbol = new JTree();
    JScrollPane consolaScroll = new JScrollPane();
    JMenu ficheroMenuItem = new JMenu();
    JToolBar jToolBar1 = new JToolBar();
    JFrame padre;
    File directorioActual = null;
    ControladorGeneral controlador = new ControladorGeneral(this);
    FicherosJTabbedPane ficherosPane = new FicherosJTabbedPane(this.padre, this);
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuItem cerrarMenuItem = new JMenuItem();
    JMenu depuradorMenuItem = new JMenu();
    JMenu optimizadorMenuItem = new JMenu();
    JMenuItem lanzarOptimizadorMenuItem = new JMenuItem();
    JPanel depuradorPane = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    public static final int ESTADO_INICIAL = 0;
    public static final int ESTADO_SIN_FICHEROS = 1;
    public static final int ESTADO_CON_FICHEROS = 2;
    public static final int ESTADO_EN_DEPURACION = 3;
    public static final int ESTADO_EN_EJECUCION = 4;
    public static final int ESTADO_SIN_DEPURACION = 5;
    private int estadoActual;
    public Action abrirAction = new AbrirAction();
    public Action nuevoFicheroAction = new NuevoFicheroAction();
    public Action cerrarAction = new CerrarAction();
    public Action guardarAction = new GuardarAction();
    public Action guardarComoAction = new GuardarComoAction();
    public Action compilarAction = new CompilarAction();
    public Action preferenciasAction = new PreferenciasAction();
    public Action lanzarAction = new LanzarAction();
    public Action detenerAction = new DetenerAction();
    public Action continuarAction = new ContinuarAction();
    public Action stepOverAction = new StepOverAction();
    public Action stepIntoAction = new StepIntoAction();
    public Action stepOutAction = new StepOutAction();
    public Action toggleBreakpointAction = new ToggleBreakpointAction();
    public Action copiarAction = new CopiarAction();
    public Action pegarAction = new PegarAction();
    public Action cortarAction = new CortarAction();
    static /* synthetic */ Class class$javatraceit$gui$depurador$DepuradorComponente;

    public ControladorGeneral getControladorGeneral() {
        return this.controlador;
    }

    public JTree getArbolMemoria() {
        return this.arbol;
    }

    public void setArbolMemoria(JTree nuevoArbol) {
        this.arbol = nuevoArbol;
        this.arbolScroll.setViewportView(this.arbol);
    }

    public JScrollPane getArbolMemoriaScroll() {
        return this.arbolScroll;
    }

    public JTextArea getConsolaArea() {
        return this.consolaArea;
    }

    public String getUnNuevoValor() {
        NuevoValorPrimitivoDialog dialogo = new NuevoValorPrimitivoDialog(this.padre, "Introduce un valor nuevo...", true);
        dialogo.setVisible(true);
        dialogo.setVisible(false);
        String resultado = dialogo.getValor();
        dialogo.dispose();
        return resultado;
    }

    public Vector getFicherosAbiertos() {
        Vector<File> resultado = new Vector<File>();
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            JTIEditor doc = this.ficherosPane.getJTIEditor(i);
            if (doc.getFichero() != null) {
                resultado.add(doc.getFichero());
            }
            ++i;
        }
        return resultado;
    }

    public void mostrarFichero(File fichero) {
        if (fichero == null) {
            this.ficherosPane.nuevoDocumento();
        } else if (this.ficherosPane.indexFichero(fichero) == -1) {
            this.ficherosPane.abrirDocumento(fichero);
        }
        this.ficherosPane.setSelectedIndex(this.ficherosPane.getComponentCount() - 1);
        this.copiarAction.setEnabled(true);
        this.pegarAction.setEnabled(true);
        this.cortarAction.setEnabled(true);
    }

    public void mostrarInfoCompilacion(String texto) {
        this.consolaArea.append(texto + "\n");
        this.consolaScroll.getVerticalScrollBar().setValue(this.consolaScroll.getVerticalScrollBar().getMaximum());
    }

    public void se\u00f1alarLineaFichero(File fichero, int linea) {
        int pos = this.ficherosPane.indexFichero(fichero);
        if (pos != -1) {
            this.ficherosPane.getJTIEditor(pos).destacarLinea(linea);
        }
    }

    public void mostrarError(String texto) {
        JOptionPane.showMessageDialog(this, texto, "Error", 0);
    }

    public void mostrarAdvertencia(String texto) {
        JOptionPane.showMessageDialog(this, texto, "Advertencia", 2);
    }

    public void mostrarSalidaConsola(String texto) {
        this.consolaArea.append(texto);
        this.consolaScroll.getVerticalScrollBar().setValue(this.consolaScroll.getVerticalScrollBar().getMaximum());
    }

    public void guardarFichero(File f) {
        block2: {
            int pos = this.ficherosPane.indexFichero(f);
            if (pos == -1) break block2;
            try {
                this.ficherosPane.getJTIEditor(pos).guardar();
            }
            catch (Exception ex) {
                this.mostrarError("Se produjo un error grave al guardar " + f + " (" + ex + ")");
            }
        }
    }

    public void guardarComo(File f) {
        try {
            this.ficherosPane.getJTIEditorSeleccionado().guardarComo(f);
        }
        catch (Exception ex) {
            this.mostrarError("Se produjo un error grave al guardar " + f + " (" + ex + ")");
        }
        this.ficherosPane.setTitleAt(this.ficherosPane.getSelectedIndex(), f.getName());
    }

    public void guardarTodos() {
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            try {
                this.ficherosPane.getJTIEditor(i).guardar();
            }
            catch (Exception ex) {
                this.mostrarError("Se produjo un error grave al guardar los ficheros (" + ex + ")");
            }
            ++i;
        }
    }

    public void cerrarFichero(File f) {
        int pos = this.ficherosPane.indexFichero(f);
        if (pos != -1) {
            this.ficherosPane.remove(pos);
            if (PreferenciasUsuario.getPreferenciasUsuario().ficheroMain != null && PreferenciasUsuario.getPreferenciasUsuario().ficheroMain.equals(f)) {
                PreferenciasUsuario.getPreferenciasUsuario().ficheroMain = null;
            }
        } else {
            this.ficherosPane.remove(this.ficherosPane.getSelectedIndex());
        }
        if (this.ficherosPane.getComponentCount() == 0) {
            this.estadoSinFicheros();
            this.copiarAction.setEnabled(false);
            this.pegarAction.setEnabled(false);
            this.cortarAction.setEnabled(false);
        } else {
            boolean todosSinNombre = true;
            int i = 0;
            while (i < this.ficherosPane.getComponentCount()) {
                if (this.ficherosPane.getJTIEditor(i).getFichero() != null) {
                    todosSinNombre = false;
                    break;
                }
                ++i;
            }
            if (todosSinNombre) {
                this.estadoSinFicheros();
            }
        }
    }

    public String getClassPathUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().CLASS_PATH;
    }

    public String getJDKHomeUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().JDK_HOME;
    }

    public String getParametrosUsuario() {
        return PreferenciasUsuario.getPreferenciasUsuario().PARAMETROS;
    }

    public File getFicheroMain() {
        return PreferenciasUsuario.getPreferenciasUsuario().ficheroMain;
    }

    public DepuradorComponente(JFrame padre) {
        this.padre = padre;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DepuradorComponente(String parametroFicheroAbrir, JFrame padre) {
        this(padre);
        this.controlador.abrirFichero(new File(parametroFicheroAbrir));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.depuradorMenuItem.setText("Depurador");
        this.consolaArea.setFont(new Font("Monospaced", 0, 12));
        this.depuradorMenuItem.add(this.lanzarAction);
        this.arbolScroll.setDoubleBuffered(true);
        this.arbolScroll.setMinimumSize(new Dimension(0, 0));
        this.depuradorPane.setLayout(this.borderLayout2);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.jToolBar1.add(this.nuevoFicheroAction);
        this.jToolBar1.add(this.abrirAction);
        this.jToolBar1.add(this.guardarAction);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.lanzarAction);
        this.jToolBar1.add(this.detenerAction);
        this.jToolBar1.add(this.continuarAction);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.stepOverAction);
        this.jToolBar1.add(this.stepIntoAction);
        this.jToolBar1.add(this.stepOutAction);
        this.depuradorPane.add((Component)this.jToolBar1, "North");
        this.consolaScroll.setPreferredSize(new Dimension(0, 100));
        this.consolaScroll.setViewportView(this.consolaArea);
        this.depuradorPane.add((Component)this.splitPaneHoriz, "Center");
        this.add((Component)this.depuradorPane, "Center");
        this.optimizadorMenuItem.add(this.lanzarOptimizadorMenuItem);
        this.splitPaneVert.setOrientation(1);
        this.splitPaneVert.setLeftComponent(this.arbolScroll);
        this.splitPaneVert.setResizeWeight(0.2);
        this.splitPaneVert.setRightComponent(this.ficherosPane);
        this.splitPaneVert.setDividerLocation(150);
        this.splitPaneHoriz.setResizeWeight(1.0);
        this.splitPaneHoriz.setDividerLocation(375);
        this.splitPaneHoriz.setOrientation(0);
        this.splitPaneHoriz.setTopComponent(this.splitPaneVert);
        this.splitPaneHoriz.setBottomComponent(this.consolaScroll);
        this.splitPaneHoriz.setOneTouchExpandable(true);
        this.consolaScroll.setSize(new Dimension(0, 100));
        this.arbol = new JTree(new Vector());
        this.arbolScroll.setViewportView(this.arbol);
        this.estadoInicial();
        JLabel logo_depurador = new JLabel();
        JPanel panelLogo = new JPanel();
        panelLogo.setLayout(new BorderLayout());
        panelLogo.setBackground(new Color(0x666699));
        panelLogo.setOpaque(true);
        ImageIcon icono = new ImageIcon(this.getClass().getResource("iconos/logo.gif"));
        logo_depurador.setIcon(icono);
        logo_depurador.setBackground(Color.white);
        logo_depurador.setPreferredSize(new Dimension(300, 35));
        panelLogo.add((Component)logo_depurador, "South");
        this.add((Component)panelLogo, "South");
    }

    private void guardarTodo() {
        this.ficherosPane.guardarTodo();
    }

    public void salidaDeConsola(String str) {
        this.consolaArea.append(str);
        this.consolaArea.setSelectionStart(this.consolaArea.getText().length());
        this.consolaArea.setSelectionEnd(this.consolaArea.getText().length());
    }

    void estadoInicial() {
        this.cerrarMenuItem.setEnabled(false);
        this.compilarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.lanzarAction.setEnabled(false);
        this.estadoActual = 0;
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.toggleBreakpointAction.setEnabled(false);
        this.copiarAction.setEnabled(false);
        this.cortarAction.setEnabled(false);
        this.pegarAction.setEnabled(false);
    }

    void estadoSinFicheros() {
        this.cerrarMenuItem.setEnabled(false);
        this.compilarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.lanzarAction.setEnabled(false);
        this.estadoActual = 1;
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.toggleBreakpointAction.setEnabled(false);
    }

    public void estadoConFicheros() {
        this.cerrarMenuItem.setEnabled(true);
        this.compilarAction.setEnabled(true);
        this.lanzarAction.setEnabled(true);
        this.guardarAction.setEnabled(true);
        this.estadoActual = 2;
        this.guardarAction.setEnabled(true);
        this.toggleBreakpointAction.setEnabled(true);
    }

    public void lanzando() {
    }

    public void estadoEnDepuracion() {
        this.stepOverAction.setEnabled(true);
        this.stepIntoAction.setEnabled(true);
        this.stepOutAction.setEnabled(true);
        this.detenerAction.setEnabled(true);
        this.continuarAction.setEnabled(true);
        this.nuevoFicheroAction.setEnabled(false);
        this.abrirAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.estadoActual = 3;
        this.lanzarAction.setEnabled(false);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(false);
            ++i;
        }
    }

    public void estadoEnEjecucion() {
        this.nuevoFicheroAction.setEnabled(false);
        this.abrirAction.setEnabled(false);
        this.guardarAction.setEnabled(false);
        this.guardarComoAction.setEnabled(false);
        this.cerrarAction.setEnabled(false);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(true);
        this.continuarAction.setEnabled(false);
        this.preferenciasAction.setEnabled(false);
        this.arbolScroll.setViewportView(new JLabel());
        this.lanzarAction.setEnabled(false);
        this.compilarAction.setEnabled(false);
        this.consolaArea.setBackground(Color.black);
        this.consolaArea.setForeground(Color.white);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(false);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i2).noDestacarLineaCodigo();
            ++i2;
        }
        this.arbolScroll.disable();
        this.estadoActual = 4;
    }

    public void estadoSinDepuracion() {
        this.nuevoFicheroAction.setEnabled(true);
        this.abrirAction.setEnabled(true);
        this.guardarAction.setEnabled(true);
        this.guardarComoAction.setEnabled(true);
        this.cerrarAction.setEnabled(true);
        this.cerrarMenuItem.setEnabled(true);
        this.compilarAction.setEnabled(true);
        this.lanzarAction.setEnabled(true);
        this.stepOverAction.setEnabled(false);
        this.stepIntoAction.setEnabled(false);
        this.stepOutAction.setEnabled(false);
        this.detenerAction.setEnabled(false);
        this.continuarAction.setEnabled(false);
        this.preferenciasAction.setEnabled(true);
        this.consolaArea.setBackground(Color.white);
        this.consolaArea.setForeground(Color.black);
        int i = 0;
        while (i < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i).setEnabled(true);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            this.ficherosPane.getJTIEditor(i2).noDestacarLineaCodigo();
            ++i2;
        }
        this.estadoActual = 5;
    }

    public void a\u00f1adidoBreakpoint(File fichero, int linea) {
        this.controlador.nuevoBreakpoint(fichero, linea);
        System.out.println("a\u00f1adido breakpoint: " + fichero + ": " + linea);
    }

    public void sacadoBreakpoint(File fichero, int linea) {
        this.controlador.sacarBreakpoint(fichero, linea);
        System.out.println("sacado breakpoint: " + fichero + ": " + linea);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ToggleBreakpointAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/togglebreakpoint.gif"));

        public ToggleBreakpointAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "colocar / descartar breakpoint");
            this.putValue("ShortDescription", "colocar / descartar breakpoint");
        }

        public void actionPerformed(ActionEvent ev) {
            if (DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero() == null) {
                DepuradorComponente.this.mostrarAdvertencia("El fichero debe tener un nombre para poder establecer un breakpoint. Gu\u00e1rdelo primero.");
                return;
            }
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().toggleBreakpoint(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().lineaActual());
        }
    }

    class CortarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Cut16.gif"));

        public CortarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.putValue("Name", "cortar");
            this.putValue("ShortDescription", "cortar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().cut();
        }
    }

    class PegarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Paste16.gif"));

        public PegarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
            this.putValue("Name", "pegar");
            this.putValue("ShortDescription", "pegar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().paste();
        }
    }

    class CopiarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Copy16.gif"));

        public CopiarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.putValue("Name", "copiar");
            this.putValue("ShortDescription", "copiar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().copy();
        }
    }

    class StepOutAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_out.gif"));

        public StepOutAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step out");
            this.putValue("ShortDescription", "step out");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepOut();
        }
    }

    class StepIntoAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_into.gif"));

        public StepIntoAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step into");
            this.putValue("ShortDescription", "step into");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepInto();
        }
    }

    class StepOverAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/step_over.gif"));

        public StepOverAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "step over");
            this.putValue("ShortDescription", "step over");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.stepOver();
        }
    }

    class ContinuarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Play16.gif"));

        public ContinuarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "continuar ejecuci\u00f3n");
            this.putValue("ShortDescription", "continuar ejecuci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.continuarEjecucion();
        }
    }

    class DetenerAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Stop16.gif"));

        public DetenerAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "detener depuraci\u00f3n");
            this.putValue("ShortDescription", "detener depuraci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.detenerDepuracion();
        }
    }

    class LanzarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/lanzar16.gif"));

        public LanzarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "lanzar depuraci\u00f3n");
            this.putValue("ShortDescription", "lanzar depuraci\u00f3n");
        }

        public void actionPerformed(ActionEvent ev) {
            if (PreferenciasUsuario.getPreferenciasUsuario().ficheroMain == null) {
                DepuradorComponente.this.preferenciasAction.actionPerformed(null);
            }
            DepuradorComponente.this.controlador.lanzarDepuracion();
        }
    }

    class PreferenciasAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Preferences16.gif"));

        public PreferenciasAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "preferencias...");
            this.putValue("ShortDescription", "preferencias...");
        }

        public void actionPerformed(ActionEvent ev) {
            PreferenciasUsuarioDialog ventana = new PreferenciasUsuarioDialog((Frame)DepuradorComponente.this.padre, "Preferencias...", DepuradorComponente.this.getFicherosAbiertos(), true);
            ventana.setVisible(true);
            String cp = PreferenciasUsuario.getPreferenciasUsuario().CLASS_PATH;
            String jdkHome = PreferenciasUsuario.getPreferenciasUsuario().JDK_HOME;
            String param = PreferenciasUsuario.getPreferenciasUsuario().PARAMETROS;
            DepuradorComponente.this.controlador.establecerParametros(cp, jdkHome, param);
        }
    }

    class CompilarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/compilar16.gif"));

        public CompilarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "compilar");
            this.putValue("ShortDescription", "compilar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.compilarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
        }
    }

    class GuardarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/save16.gif"));

        public GuardarAction() {
            this.putValue("Name", "guardar");
            this.putValue("ShortDescription", "guardar");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            if (DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero() == null) {
                DepuradorComponente.this.guardarComoAction.actionPerformed(null);
            } else {
                DepuradorComponente.this.controlador.guardarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
            }
        }
    }

    class CerrarAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/cerrar16.gif"));

        public CerrarAction() {
            this.putValue("SmallIcon", this.icono);
            this.putValue("Name", "cerrar");
            this.putValue("ShortDescription", "cerrar");
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.cerrarFichero(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero());
        }
    }

    class GuardarComoAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/SaveAs16.gif"));

        public GuardarComoAction() {
            this.putValue("Name", "guardar como...");
            this.putValue("ShortDescription", "guardar como...");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            JFileChooser chooser = new JFileChooser();
            if (DepuradorComponente.this.directorioActual != null) {
                chooser = new JFileChooser(DepuradorComponente.this.directorioActual);
            }
            chooser.setFileFilter(new FileFilter(this){
                private final /* synthetic */ GuardarComoAction this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".java") || f.isDirectory();
                }

                public String getDescription() {
                    return "Ficheros fuente Java";
                }
            });
            int decision = chooser.showSaveDialog(DepuradorComponente.this);
            if (decision != 0) {
                return;
            }
            File fichero = chooser.getSelectedFile();
            if (fichero.getName().indexOf(".") == -1) {
                fichero = new File(fichero.getAbsolutePath() + ".java");
            }
            DepuradorComponente.this.directorioActual = fichero.getParentFile();
            if (fichero != null) {
                DepuradorComponente.this.controlador.guardarComo(DepuradorComponente.this.ficherosPane.getJTIEditorSeleccionado().getFichero(), fichero);
            }
        }
    }

    class NuevoFicheroAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Add16.gif"));

        public NuevoFicheroAction() {
            this.putValue("Name", "nuevo");
            this.putValue("ShortDescription", "nuevo");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            DepuradorComponente.this.controlador.nuevoFichero();
        }
    }

    class AbrirAction
    extends AbstractAction {
        private ImageIcon icono = new ImageIcon((class$javatraceit$gui$depurador$DepuradorComponente == null ? (class$javatraceit$gui$depurador$DepuradorComponente = DepuradorComponente.class$("javatraceit.gui.depurador.DepuradorComponente")) : class$javatraceit$gui$depurador$DepuradorComponente).getResource("iconos/Open16.gif"));

        public AbrirAction() {
            this.putValue("Name", "abrir fichero...");
            this.putValue("ShortDescription", "abrir fichero...");
            this.putValue("SmallIcon", this.icono);
        }

        public void actionPerformed(ActionEvent ev) {
            JFileChooser chooser = new JFileChooser();
            if (DepuradorComponente.this.directorioActual != null) {
                chooser = new JFileChooser(DepuradorComponente.this.directorioActual);
            }
            chooser.setFileFilter(new FileFilter(this){
                private final /* synthetic */ AbrirAction this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".java") || f.isDirectory();
                }

                public String getDescription() {
                    return "Ficheros fuente Java";
                }
            });
            int decision = chooser.showOpenDialog(DepuradorComponente.this);
            if (decision != 0) {
                return;
            }
            File fichero = chooser.getSelectedFile();
            DepuradorComponente.this.directorioActual = fichero.getParentFile();
            if (fichero != null) {
                DepuradorComponente.this.controlador.abrirFichero(fichero);
            }
        }
    }
}

