/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.memoria;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.memoria.ComponenteMemoria;
import javatraceit.depurador.memoria.ComponenteMemoriaModificable;
import javatraceit.depurador.memoria.ImposibleCambiarValorException;

public class ComponenteMemoriaPrimitivo
extends ComponenteMemoria
implements ComponenteMemoriaModificable {
    private boolean esLocalVariable = false;
    private boolean esElementoDeArray = false;
    private int array_index;
    private StackFrame stackFrame = null;
    private LocalVariable localVariable = null;
    private ObjectReference objectReference = null;
    private ArrayReference arrayPadre;
    private Field field = null;
    private String nombre;

    public ComponenteMemoriaPrimitivo(PrimitiveType p, StackFrame st, LocalVariable v) {
        super(p);
        System.out.println(p.getClass());
        this.stackFrame = st;
        this.localVariable = v;
        this.esLocalVariable = true;
        this.nombre = this.localVariable.name();
    }

    public ComponenteMemoriaPrimitivo(PrimitiveType p, ObjectReference padre, Field f) {
        super(p);
        this.objectReference = padre;
        this.field = f;
        this.esLocalVariable = false;
        this.nombre = f.name();
    }

    public ComponenteMemoriaPrimitivo(PrimitiveType p, ArrayReference padre, int index) {
        super(p);
        this.arrayPadre = padre;
        this.array_index = index;
        this.esLocalVariable = false;
        this.esElementoDeArray = true;
        this.nombre = "[" + index + "]";
    }

    public boolean esExpansible() {
        return false;
    }

    public boolean esModificable() {
        return true;
    }

    public PrimitiveType getPrimitiveType() {
        return (PrimitiveType)this.getMirror();
    }

    public Value getValue() {
        if (this.esLocalVariable) {
            return this.stackFrame.getValue(this.localVariable);
        }
        if (this.esElementoDeArray) {
            return this.arrayPadre.getValue(this.array_index);
        }
        return this.objectReference.getValue(this.field);
    }

    public void cambiarValor(String valor) throws ImposibleCambiarValorException {
        block29: {
            block33: {
                block32: {
                    block31: {
                        block30: {
                            if (!(this.getPrimitiveType() instanceof IntegerType)) break block30;
                            try {
                                if (this.esLocalVariable) {
                                    this.stackFrame.setValue(this.localVariable, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Integer.valueOf(valor)));
                                }
                                if (this.esElementoDeArray) {
                                    this.arrayPadre.setValue(this.array_index, (Value)EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Integer.valueOf(valor)));
                                }
                                this.objectReference.setValue(this.field, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Integer.valueOf(valor)));
                            }
                            catch (ClassNotLoadedException ex) {
                                ex.printStackTrace();
                            }
                            catch (InvalidTypeException ex) {
                                ex.printStackTrace();
                                throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                            }
                            catch (NumberFormatException ex) {
                                throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                            }
                        }
                        if (!(this.getPrimitiveType() instanceof CharType)) break block31;
                        try {
                            if (this.esLocalVariable) {
                                this.stackFrame.setValue(this.localVariable, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(valor.charAt(0)));
                            }
                            if (this.esElementoDeArray) {
                                this.arrayPadre.setValue(this.array_index, (Value)EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(valor.charAt(0)));
                            }
                            this.objectReference.setValue(this.field, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(valor.charAt(0)));
                        }
                        catch (ClassNotLoadedException ex) {
                            ex.printStackTrace();
                        }
                        catch (InvalidTypeException ex) {
                            ex.printStackTrace();
                            throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                        }
                    }
                    if (!(this.getPrimitiveType() instanceof FloatType)) break block32;
                    try {
                        if (this.esLocalVariable) {
                            this.stackFrame.setValue(this.localVariable, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Float.valueOf(valor).floatValue()));
                        }
                        if (this.esElementoDeArray) {
                            this.arrayPadre.setValue(this.array_index, (Value)EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Float.valueOf(valor).floatValue()));
                        }
                        this.objectReference.setValue(this.field, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Float.valueOf(valor).floatValue()));
                    }
                    catch (ClassNotLoadedException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvalidTypeException ex) {
                        ex.printStackTrace();
                        throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                    }
                    catch (NumberFormatException ex) {
                        throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                    }
                }
                if (!(this.getPrimitiveType() instanceof DoubleType)) break block33;
                try {
                    if (this.esLocalVariable) {
                        this.stackFrame.setValue(this.localVariable, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Double.valueOf(valor)));
                    }
                    if (this.esElementoDeArray) {
                        this.arrayPadre.setValue(this.array_index, (Value)EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Double.valueOf(valor)));
                    }
                    this.objectReference.setValue(this.field, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Double.valueOf(valor)));
                }
                catch (ClassNotLoadedException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidTypeException ex) {
                    ex.printStackTrace();
                    throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                }
                catch (NumberFormatException ex) {
                    throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable");
                }
            }
            if (!(this.getPrimitiveType() instanceof BooleanType)) break block29;
            if (!valor.equalsIgnoreCase("true") && !valor.equalsIgnoreCase("false")) {
                throw new ImposibleCambiarValorException("El valor no es valido para el tipo de variable. Debe ser \"true\" o \"false\".");
            }
            try {
                if (this.esLocalVariable) {
                    this.stackFrame.setValue(this.localVariable, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Boolean.valueOf(valor)));
                    break block29;
                }
                if (this.esElementoDeArray) {
                    this.arrayPadre.setValue(this.array_index, (Value)EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Boolean.valueOf(valor)));
                    break block29;
                }
                this.objectReference.setValue(this.field, EntornoDepurador.getEntornoDepurador().getVirtualMachine().mirrorOf(Boolean.valueOf(valor)));
            }
            catch (ClassNotLoadedException ex) {
                ex.printStackTrace();
            }
            catch (InvalidTypeException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.getPrimitiveType() + " " + this.nombre + " = " + this.getValue();
    }
}

