/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.memoria;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Vector;
import javatraceit.depurador.memoria.ComponenteMemoria;
import javatraceit.depurador.memoria.ComponenteMemoriaExpansible;
import javatraceit.depurador.memoria.ComponenteMemoriaObjeto;
import javatraceit.depurador.memoria.ComponenteMemoriaPrimitivo;
import javatraceit.depurador.memoria.ImposibleExpandirComponenteMemoriaException;

public class ComponenteMemoriaArray
extends ComponenteMemoria
implements ComponenteMemoriaExpansible {
    private String nombre;
    private ArrayType tipo;

    public ComponenteMemoriaArray(ArrayType tipo, ArrayReference a, String nombre) {
        super(a);
        this.tipo = tipo;
        this.nombre = nombre;
        if (nombre == null) {
            this.nombre = "*sin nombre*";
        }
    }

    public boolean esExpansible() {
        return true;
    }

    public boolean esModificable() {
        return false;
    }

    public ArrayReference getArrayReference() {
        return (ArrayReference)this.getMirror();
    }

    public Vector expandir() throws ImposibleExpandirComponenteMemoriaException {
        Vector<ComponenteMemoriaPrimitivo> resultado = new Vector<ComponenteMemoriaPrimitivo>();
        int i = 0;
        while (i < this.getArrayReference().length()) {
            Value valor = this.getArrayReference().getValue(i);
            if (valor != null) {
                ComponenteMemoria nuevoNodo;
                if (valor instanceof ObjectReference) {
                    if (valor instanceof ArrayReference) {
                        nuevoNodo = new ComponenteMemoriaArray(this.tipo, (ArrayReference)valor, "[" + i + "]");
                        resultado.add((ComponenteMemoriaPrimitivo)nuevoNodo);
                    } else {
                        try {
                            nuevoNodo = new ComponenteMemoriaObjeto((ReferenceType)((ArrayType)this.getArrayReference().type()).componentType(), (ObjectReference)valor, "[" + i + "]");
                            resultado.add((ComponenteMemoriaPrimitivo)nuevoNodo);
                        }
                        catch (ClassNotLoadedException ex) {}
                    }
                } else if (valor.type() instanceof PrimitiveType) {
                    nuevoNodo = new ComponenteMemoriaPrimitivo((PrimitiveType)valor.type(), this.getArrayReference(), i);
                    resultado.add((ComponenteMemoriaPrimitivo)nuevoNodo);
                }
            }
            ++i;
        }
        return resultado;
    }

    public String toString() {
        return "" + this.tipo.name() + " " + this.nombre;
    }
}

