/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.manejoDepuracion;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.MethodEntryRequest;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.VMEventHandler;
import javatraceit.depurador.VMEventNotifier;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.ManejadorFicheros;
import javatraceit.depurador.manejoDepuracion.AplicacionEjecutandoseException;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.depurador.manejoDepuracion.HiloEscuchaConsola;
import javatraceit.depurador.manejoDepuracion.LanzarDepuracionException;
import javatraceit.depurador.manejoDepuracion.NoEnDepuracionException;
import javatraceit.depurador.manejoDepuracion.UIConsolaNotifier;
import javatraceit.depurador.manejoDepuracion.UIManejoDepuracionNotifier;

public class ManejadorDepurador
implements VMEventNotifier {
    private HiloEscuchaConsola hiloConsola;
    private HiloEscuchaConsola hiloExcepciones;
    private UIConsolaNotifier elUIConsolaNotifier;
    private UIManejoDepuracionNotifier elUIManejoDepuracionNotifier;
    private static ManejadorDepurador referenciaAlSingleton;

    public static ManejadorDepurador getManejadorDepurador() {
        if (referenciaAlSingleton == null) {
            referenciaAlSingleton = new ManejadorDepurador();
        }
        return referenciaAlSingleton;
    }

    public void setUIConsolaNotifier(UIConsolaNotifier notifier) {
        this.elUIConsolaNotifier = notifier;
    }

    public void setManejoDepuracionNotifier(UIManejoDepuracionNotifier notifier) {
        this.elUIManejoDepuracionNotifier = notifier;
    }

    public ManejadorDepurador() {
        VMEventHandler.getVMEventHandler().addEventNotifier(this);
    }

    public void lanzarDepuracion(boolean compilar) throws LanzarDepuracionException {
        FicheroJava ficheroMain = DepuradorParametros.getDepuradorParametros().ficheroMain;
        if (ficheroMain == null || !ManejadorFicheros.getManejadorFicheros().estaAbierto(ficheroMain) || !ficheroMain.getFichero().exists()) {
            throw new LanzarDepuracionException("Fichero main no se encuentra, o no se ha indicado");
        }
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        Map losArgumentos = manager.defaultConnector().defaultArguments();
        Vector clases = ficheroMain.getClases();
        if (clases.size() == 0) {
            throw new LanzarDepuracionException("No hay ninguna clase en el fichero main. Es posible que no se haya compilado correctamente.");
        }
        String unaClase = (String)clases.elementAt(0);
        String nombrePaquete = "";
        if (unaClase.indexOf(".") != -1) {
            nombrePaquete = unaClase.substring(0, unaClase.lastIndexOf("."));
            System.out.println("nombre paquete main: " + nombrePaquete);
        }
        String nombreClaseMain = (nombrePaquete.length() > 0 ? nombrePaquete + "." : "") + ficheroMain.getFichero().getName().substring(0, ficheroMain.getFichero().getName().lastIndexOf("."));
        ((Connector.Argument)losArgumentos.get("home")).setValue(DepuradorParametros.getDepuradorParametros().JDK_HOME);
        ((Connector.Argument)losArgumentos.get("main")).setValue(nombreClaseMain + (DepuradorParametros.getDepuradorParametros().PARAMETROS.length() > 0 ? " " + DepuradorParametros.getDepuradorParametros().PARAMETROS : ""));
        File ficheroProfiler = new File(DepuradorParametros.getDepuradorParametros().JDK_HOME + File.separator + "jre" + File.separator + "bin" + File.separator + "jtiprof.dll");
        try {
            try {
                ((Connector.Argument)losArgumentos.get("options")).setValue(" -Xrunjtiprof -cp \"" + ficheroMain.getFichero().getParent() + File.pathSeparator + DepuradorParametros.getDepuradorParametros().CLASS_PATH + "\"");
                VirtualMachine vm = manager.defaultConnector().launch(losArgumentos);
                this.hiloConsola = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getInputStream());
                this.hiloExcepciones = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getErrorStream());
                vm.setDebugTraceMode(0);
                EntornoDepurador.getEntornoDepurador().setVirtualMachine(vm);
                VMEventHandler.getVMEventHandler().start();
            }
            catch (VMStartException ex) {
                ((Connector.Argument)losArgumentos.get("options")).setValue("-cp \"" + ficheroMain.getFichero().getParent() + File.pathSeparator + DepuradorParametros.getDepuradorParametros().CLASS_PATH + "\"");
                VirtualMachine vm = manager.defaultConnector().launch(losArgumentos);
                this.hiloConsola = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getInputStream());
                this.hiloExcepciones = new HiloEscuchaConsola(this.elUIConsolaNotifier, vm.process().getErrorStream());
                vm.setDebugTraceMode(0);
                EntornoDepurador.getEntornoDepurador().setVirtualMachine(vm);
                VMEventHandler.getVMEventHandler().start();
            }
        }
        catch (IOException ex) {
            throw new LanzarDepuracionException("Imposible comenzar depuraci\u00f3n, no se encuentra java. Revise JDK Home");
        }
        catch (VMStartException ex) {
            throw new LanzarDepuracionException("Imposible comenzar la depuracion. Se obtuvo: " + ex.toString());
        }
        catch (IllegalConnectorArgumentsException ex) {
            // empty catch block
        }
        EntornoDepurador.getEntornoDepurador().setThreadActual((ThreadReference)EntornoDepurador.getEntornoDepurador().getVirtualMachine().allThreads().get(2));
        MethodEntryRequest r = EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().createMethodEntryRequest();
        r.setSuspendPolicy(2);
        r.addClassFilter(nombreClaseMain);
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
    }

    public void detenerDepuracion() throws NoEnDepuracionException {
        int estado = EntornoDepurador.getEntornoDepurador().getEstadoActual();
        if (estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO && estado != EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO) {
            throw new NoEnDepuracionException("No se esta depurando.");
        }
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().exit(1);
    }

    public void continuarEjecucion() throws AplicacionEjecutandoseException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().DEPURANDO_DETENIDO) {
            throw new AplicacionEjecutandoseException("La aplicaci\u00f3n ya se est\u00e1 ejecutando");
        }
        System.out.println("Generando un resume...");
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().deleteEventRequests(EntornoDepurador.getEntornoDepurador().getVirtualMachine().eventRequestManager().stepRequests());
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().DEPURANDO_EJECUTANDO);
        Iterator threads = EntornoDepurador.getEntornoDepurador().getVirtualMachine().allThreads().iterator();
        while (threads.hasNext()) {
            ThreadReference t = (ThreadReference)threads.next();
            int c = t.suspendCount();
            int i = 0;
            while (i < c - 1) {
                System.out.println("ManejadorSteps: el hilo " + t + " tiene m\u00e1s de un suspend");
                t.resume();
                ++i;
            }
        }
        EntornoDepurador.getEntornoDepurador().getVirtualMachine().resume();
    }

    public void vmStartEvent(VMStartEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMStartEvent");
        this.elUIManejoDepuracionNotifier.depuracionLanzada();
    }

    public void vmDeathEvent(VMDeathEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMDeathEvent");
        this.finalizacionEvent(e);
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        System.out.println("ManejadorDepuracion: Recibido un VMDisconnectEvent");
        this.finalizacionEvent(e);
    }

    public void vmInterrupted() {
        System.out.println("ManejadorDepuracion: Recibido un VMInterruptedEvent");
        this.finalizacionEvent(null);
    }

    private void finalizacionEvent(Event event) {
        this.hiloConsola.stop();
        this.hiloExcepciones.stop();
        EntornoDepurador.getEntornoDepurador().setEstadoActual(EntornoDepurador.getEntornoDepurador().NO_DEPURANDO);
        this.elUIManejoDepuracionNotifier.depuracionFinalizada();
        EntornoDepurador.getEntornoDepurador().eliminarVirtualMachine();
        this.elUIManejoDepuracionNotifier.depuracionFinalizada();
    }

    public void stepEvent(StepEvent e) {
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
    }

    public void breakpointEvent(BreakpointEvent e) {
    }

    public void threadStartEvent(ThreadStartEvent e) {
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    public void fieldWatchEvent(WatchpointEvent e) {
    }

    public void exceptionEvent(ExceptionEvent e) {
    }

    public void methodEntryEvent(MethodEntryEvent e) {
    }

    public void methodExitEvent(MethodExitEvent e) {
    }

    public void receivedEvent(Event event) {
    }
}

