/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.depurador.ficheros;

import com.sun.jdi.Location;
import java.io.File;
import java.util.Vector;
import javatraceit.depurador.EntornoDepurador;
import javatraceit.depurador.ficheros.CompiladorFicheroException;
import javatraceit.depurador.ficheros.CompiladorFicheroJava;
import javatraceit.depurador.ficheros.FicheroJava;
import javatraceit.depurador.ficheros.FicheroNoAbiertoException;
import javatraceit.depurador.ficheros.FicheroYaAbiertoException;
import javatraceit.depurador.ficheros.ImposibleA\u00f1adirFicheroException;
import javatraceit.depurador.ficheros.ImposibleSacarFicheroException;
import javatraceit.depurador.ficheros.SourceMapper;
import javatraceit.depurador.manejoDepuracion.DepuradorParametros;
import javatraceit.depurador.traza.ManejadorBreakpoints;

public class ManejadorFicheros {
    private Vector ficheros = new Vector();
    private static ManejadorFicheros referenciaAlSingleton;

    public static ManejadorFicheros getManejadorFicheros() {
        if (referenciaAlSingleton == null) {
            referenciaAlSingleton = new ManejadorFicheros();
        }
        return referenciaAlSingleton;
    }

    public void a\u00f1adirFichero(FicheroJava fichero) throws FicheroYaAbiertoException, ImposibleA\u00f1adirFicheroException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().NO_DEPURANDO) {
            throw new ImposibleA\u00f1adirFicheroException("No se puede a\u00f1adir el fichero mientras se depura.");
        }
        if (this.ficheros.indexOf(fichero) != -1) {
            throw new FicheroYaAbiertoException("El fichero ya existe.");
        }
        this.ficheros.add(fichero);
    }

    public void sacarFichero(FicheroJava fichero) throws ImposibleSacarFicheroException {
        if (EntornoDepurador.getEntornoDepurador().getEstadoActual() != EntornoDepurador.getEntornoDepurador().NO_DEPURANDO) {
            throw new ImposibleSacarFicheroException("No se puede sacar el fichero mientras se depura.");
        }
        if (this.ficheros.indexOf(fichero) != -1) {
            ManejadorBreakpoints.getManejadorBreakpoints().sacarBreakpoints(fichero);
            this.ficheros.remove(fichero);
        }
    }

    public FicheroJava getFicheroJava(File f) {
        int i = 0;
        while (i < this.ficheros.size()) {
            if (((FicheroJava)this.ficheros.elementAt(i)).getFichero().equals(f)) {
                return (FicheroJava)this.ficheros.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public boolean estaAbierto(FicheroJava f) {
        return this.ficheros.indexOf(f) != -1;
    }

    public String compilarFichero(FicheroJava fichero) throws FicheroNoAbiertoException, CompiladorFicheroException {
        if (this.ficheros.indexOf(fichero) == -1) {
            throw new FicheroNoAbiertoException("El fichero no est\u00e1 abierto.");
        }
        CompiladorFicheroJava compilador = new CompiladorFicheroJava(DepuradorParametros.getDepuradorParametros().JDK_HOME, DepuradorParametros.getDepuradorParametros().CLASS_PATH);
        return compilador.compilarFicheroJava(fichero);
    }

    public FicheroJava buscarFicheroFuente(Location loc) {
        SourceMapper miSourceMapper = new SourceMapper(DepuradorParametros.getDepuradorParametros().CLASS_PATH);
        File fichero = miSourceMapper.sourceFile(loc);
        if (fichero == null) {
            return null;
        }
        return new FicheroJava(fichero);
    }

    public String compilarTodos() {
        String errores = "";
        int i = 0;
        while (i < this.ficheros.size()) {
            try {
                errores = errores + this.compilarFichero((FicheroJava)this.ficheros.elementAt(i));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        return errores;
    }
}

