/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorReference;
import java.awt.Color;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.plaf.FontUIResource;

public class ColoredFont {
    private ColorReference[] ref;
    private FontUIResource font;
    private boolean isPlainFont;
    private boolean isBoldFont;

    public ColoredFont(String fontFamily, int style, int size) {
        this.font = new FontUIResource(fontFamily, style, size);
    }

    public ColoredFont() {
        this.font = new FontUIResource("sansserif", 0, 12);
        this.isPlainFont = true;
    }

    public ColoredFont(ColorReference[] ref) {
        this("sansserif", 0, 12, ref);
        this.isPlainFont = true;
    }

    public ColoredFont(String fontFamily, int style, int size, ColorReference[] ref) {
        this.font = new FontUIResource(fontFamily, style, size);
        this.ref = ref;
        if (ref[0] == null) {
            ref[0] = new ColorReference(new Color(0, 0, 0));
        }
        if (ref[1] == null) {
            ref[1] = new ColorReference(new Color(0, 0, 0));
        }
        if (ref[2] == null) {
            ref[2] = new ColorReference(new Color(0, 0, 0));
        }
        if (ref[3] == null) {
            ref[3] = new ColorReference(new Color(0, 0, 0));
        }
    }

    public void setPlainFont(boolean b) {
        this.isPlainFont = b;
        if (b) {
            this.isBoldFont = false;
        }
    }

    public void setBoldFont(boolean b) {
        this.isBoldFont = b;
        if (b) {
            this.isPlainFont = false;
        }
    }

    public boolean isPlainFont() {
        return this.isPlainFont;
    }

    public boolean isBoldFont() {
        return this.isBoldFont;
    }

    public void setFont(String fontFamily, int style, int size) {
        this.font = new FontUIResource(fontFamily, style, size);
    }

    public void setFont(Font font) {
        this.font = new FontUIResource(font);
    }

    public void setFont(FontUIResource font) {
        this.font = font;
    }

    public FontUIResource getFont() {
        if (this.isPlainFont) {
            return Theme.plainFont[Theme.style].font;
        }
        if (this.isBoldFont) {
            return Theme.boldFont[Theme.style].font;
        }
        return this.font;
    }

    public ColorReference[] getColorReference() {
        return this.ref;
    }

    public void setColorReference(ColorReference[] ref) {
        this.ref = ref;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.font.getFamily());
        out.writeBoolean(this.font.isBold());
        out.writeInt(this.font.getSize());
        out.writeBoolean(this.isPlainFont);
        out.writeBoolean(this.isBoldFont);
    }

    public void load(DataInputStream in) throws IOException {
        this.font = new FontUIResource(in.readUTF(), in.readBoolean() ? 1 : 0, in.readInt());
        this.isPlainFont = in.readBoolean();
        this.isBoldFont = in.readBoolean();
    }
}

