/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TinyInternalFrameTitlePane
extends MetalInternalFrameTitlePane
implements LayoutManager {
    Color normalTitleColor = Color.white;
    Color shadowColor = new Color(10, 24, 131);
    Color disabledTitleColor = new Color(216, 228, 244);
    private int buttonsWidth;
    static TinyWindowButtonUI iconButtonUI;
    static TinyWindowButtonUI maxButtonUI;
    static TinyWindowButtonUI closeButtonUI;

    protected void installDefaults() {
        super.installDefaults();
        this.frame.setFrameIcon(UIManager.getDefaults().getIcon("InternalFrame.icon"));
    }

    public TinyInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
        frame.setOpaque(false);
    }

    protected void paintTitleBackground(Graphics g) {
    }

    public boolean isFrameSelected() {
        return this.frame.isSelected();
    }

    public boolean isFrameMaximized() {
        return this.frame.isMaximum();
    }

    public void paintComponent(Graphics g) {
        if (Theme.frameIsTransparent[Theme.derivedStyle[Theme.style]]) {
            this.frame.setOpaque(false);
        }
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorUIResource foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
        int titleLength = 0;
        int xOffset = leftToRight ? 2 : width - 2;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            int iconY = Math.round((float)(height - icon.getIconHeight()) / 2.0f);
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            if (Theme.derivedStyle[Theme.style] == 1) {
                ++iconY;
            }
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 2 : -2;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleLength = fm.stringWidth(frameTitle);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 1;
            if (!leftToRight) {
                xOffset -= titleLength;
            }
            if (isSelected) {
                g.setColor(Theme.frameTitleColor[Theme.style].getColor());
                g.drawString(frameTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + 2 : -2;
            } else {
                g.setColor(Theme.frameTitleDisabledColor[Theme.style].getColor());
                g.drawString(frameTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + 2 : -2;
            }
        }
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void addSubComponents() {
        super.addSubComponents();
        if (this.menuBar != null) {
            this.menuBar.setOpaque(false);
        }
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton(iconButtonUI);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton, this.iconifyAction));
        this.maxButton = new SpecialUIButton(maxButtonUI);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton, this.maximizeAction));
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton, this.closeAction));
        this.iconButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.maxButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics g) {
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        return new Dimension(c.getSize().width, this.isPalette ? Theme.framePaletteTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]]);
    }

    public Dimension getMinimumSize() {
        return new Dimension(70, 25);
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public void layoutContainer(Container c) {
        int spacing;
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int buttonHeight = this.closeButton.getPreferredSize().height;
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int y = (this.getHeight() - buttonHeight) / 2 + 1;
        if (Theme.derivedStyle[Theme.style] == 1) {
            ++y;
        }
        int buttonWidth = Theme.frameInternalButtonSize[Theme.style].width;
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                spacing = 2;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            } else {
                spacing = 2;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            spacing = 2;
            this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            spacing = this.frame.isMaximizable() && Theme.style == 1 ? 0 : 2;
            this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        this.buttonsWidth = leftToRight ? w - x : x;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        return this.isPalette ? super.getFont() : UIManager.getFont("InternalFrame.normalTitleFont");
    }

    class RolloverListener
    implements MouseListener {
        JButton button;
        Action action;

        public RolloverListener(JButton b, Action a) {
            this.button = b;
            this.action = a;
        }

        public void mouseClicked(MouseEvent e) {
            this.action.actionPerformed(new ActionEvent(this, 1001, this.button.getText()));
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.button.getModel().setRollover(false);
            if (!TinyInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }
    }
}

