/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.CheckContext;
import sun.tools.tree.ContextEnvironment;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.InlineMethodExpression;
import sun.tools.tree.InlineNewInstanceExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.ThisExpression;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class Context
implements Constants {
    Context prev;
    Node node;
    int varNumber;
    LocalMember locals;
    LocalMember classes;
    MemberDefinition field;
    int scopeNumber;
    int frameNumber;

    public Context(Context context, MemberDefinition memberDefinition) {
        this.field = memberDefinition;
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = context;
            this.locals = context.locals;
            this.classes = context.classes;
            if (memberDefinition != null && (memberDefinition.isVariable() || memberDefinition.isInitializer())) {
                this.frameNumber = context.frameNumber;
                this.scopeNumber = context.scopeNumber + 1;
            } else {
                this.frameNumber = context.scopeNumber + 1;
                this.scopeNumber = this.frameNumber + 1;
            }
            this.varNumber = context.varNumber;
        }
    }

    public Context(Context context, ClassDefinition classDefinition) {
        this(context, (MemberDefinition)null);
    }

    Context(Context context, Node node) {
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = context;
            this.locals = context.locals;
            this.classes = context.classes;
            this.varNumber = context.varNumber;
            this.field = context.field;
            this.frameNumber = context.frameNumber;
            this.scopeNumber = context.scopeNumber + 1;
            this.node = node;
        }
    }

    public Context(Context context) {
        this(context, (Node)null);
    }

    public int declare(Environment environment, LocalMember localMember) {
        localMember.scopeNumber = this.scopeNumber;
        if (this.field == null && Constants.idThis.equals(localMember.getName())) {
            ++localMember.scopeNumber;
        }
        if (localMember.isInnerClass()) {
            localMember.prev = this.classes;
            this.classes = localMember;
            return 0;
        }
        localMember.prev = this.locals;
        this.locals = localMember;
        localMember.number = this.varNumber;
        this.varNumber += localMember.getType().stackSize();
        return localMember.number;
    }

    public LocalMember getLocalField(Identifier identifier) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (identifier.equals(localMember.getName())) {
                return localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    public int getScopeNumber(ClassDefinition classDefinition) {
        Context context = this;
        while (context != null) {
            if (context.field != null && context.field.getClassDefinition() == classDefinition) {
                return context.frameNumber;
            }
            context = context.prev;
        }
        return -1;
    }

    private MemberDefinition getFieldCommon(Environment environment, Identifier identifier, boolean bl) throws AmbiguousMember, ClassNotFound {
        ClassDefinition classDefinition;
        LocalMember localMember = this.getLocalField(identifier);
        int n2 = localMember == null ? -2 : localMember.scopeNumber;
        ClassDefinition classDefinition2 = classDefinition = this.field.getClassDefinition();
        while (classDefinition2 != null) {
            MemberDefinition memberDefinition = classDefinition2.getVariable(environment, identifier, classDefinition);
            if (!(memberDefinition == null || this.getScopeNumber(classDefinition2) <= n2 || bl && memberDefinition.getClassDefinition() != classDefinition2)) {
                return memberDefinition;
            }
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return localMember;
    }

    public int declareFieldNumber(MemberDefinition memberDefinition) {
        return this.declare(null, new LocalMember(memberDefinition));
    }

    public int getFieldNumber(MemberDefinition memberDefinition) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.getMember() == memberDefinition) {
                return localMember.number;
            }
            localMember = localMember.prev;
        }
        return -1;
    }

    public MemberDefinition getElement(int n2) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.number == n2) {
                MemberDefinition memberDefinition = localMember.getMember();
                return memberDefinition != null ? memberDefinition : localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    public LocalMember getLocalClass(Identifier identifier) {
        LocalMember localMember = this.classes;
        while (localMember != null) {
            if (identifier.equals(localMember.getName())) {
                return localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    private MemberDefinition getClassCommon(Environment environment, Identifier identifier, boolean bl) throws ClassNotFound {
        LocalMember localMember = this.getLocalClass(identifier);
        int n2 = localMember == null ? -2 : localMember.scopeNumber;
        ClassDefinition classDefinition = this.field.getClassDefinition();
        while (classDefinition != null) {
            MemberDefinition memberDefinition = classDefinition.getInnerClass(environment, identifier);
            if (!(memberDefinition == null || this.getScopeNumber(classDefinition) <= n2 || bl && memberDefinition.getClassDefinition() != classDefinition)) {
                return memberDefinition;
            }
            classDefinition = classDefinition.getOuterClass();
        }
        return localMember;
    }

    public final MemberDefinition getField(Environment environment, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(environment, identifier, false);
    }

    public final MemberDefinition getApparentField(Environment environment, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(environment, identifier, true);
    }

    public boolean isInScope(LocalMember localMember) {
        LocalMember localMember2 = this.locals;
        while (localMember2 != null) {
            if (localMember == localMember2) {
                return true;
            }
            localMember2 = localMember2.prev;
        }
        return false;
    }

    public UplevelReference noteReference(Environment environment, LocalMember localMember) {
        int n2 = !this.isInScope(localMember) ? -1 : localMember.scopeNumber;
        UplevelReference uplevelReference = null;
        int n3 = -1;
        Context context = this;
        while (context != null) {
            if (n3 != context.frameNumber) {
                n3 = context.frameNumber;
                if (n2 >= n3) break;
                ClassDefinition classDefinition = context.field.getClassDefinition();
                UplevelReference uplevelReference2 = classDefinition.getReference(localMember);
                uplevelReference2.noteReference(environment, context);
                if (uplevelReference == null) {
                    uplevelReference = uplevelReference2;
                }
            }
            context = context.prev;
        }
        return uplevelReference;
    }

    public Expression makeReference(Environment environment, LocalMember localMember) {
        UplevelReference uplevelReference = this.noteReference(environment, localMember);
        if (uplevelReference != null) {
            return uplevelReference.makeLocalReference(environment, this);
        }
        if (Constants.idThis.equals(localMember.getName())) {
            return new ThisExpression(0L, localMember);
        }
        return new IdentifierExpression(0L, localMember);
    }

    public Expression findOuterLink(Environment environment, long l2, MemberDefinition memberDefinition) {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = memberDefinition.getClassDefinition();
        ClassDefinition classDefinition3 = memberDefinition.isStatic() ? null : (!memberDefinition.isConstructor() ? classDefinition2 : (classDefinition = classDefinition2.isTopLevel() ? null : classDefinition2.getOuterClass()));
        if (classDefinition == null) {
            return null;
        }
        return this.findOuterLink(environment, l2, classDefinition, memberDefinition, false);
    }

    private static boolean match(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        try {
            return classDefinition == classDefinition2 || classDefinition2.implementedBy(environment, classDefinition.getClassDeclaration());
        }
        catch (ClassNotFound classNotFound) {
            return false;
        }
    }

    public Expression findOuterLink(Environment environment, long l2, ClassDefinition classDefinition, MemberDefinition memberDefinition, boolean bl) {
        Constants constants;
        if (this.field.isStatic()) {
            Constants constants2;
            if (memberDefinition == null) {
                constants2 = classDefinition.getName().getFlatName().getName();
                environment.error(l2, "undef.var", Identifier.lookup(constants2, Constants.idThis));
            } else if (memberDefinition.isConstructor()) {
                environment.error(l2, "no.outer.arg", classDefinition, memberDefinition.getClassDeclaration());
            } else if (memberDefinition.isMethod()) {
                environment.error(l2, "no.static.meth.access", memberDefinition, memberDefinition.getClassDeclaration());
            } else {
                environment.error(l2, "no.static.field.access", memberDefinition.getName(), memberDefinition.getClassDeclaration());
            }
            constants2 = new ThisExpression(l2, this);
            ((Expression)constants2).type = classDefinition.getType();
            return constants2;
        }
        LocalMember localMember = this.locals;
        Expression expression = null;
        LocalMember localMember2 = null;
        ClassDefinition classDefinition2 = null;
        ClassDefinition classDefinition3 = null;
        if (this.field.isConstructor()) {
            classDefinition3 = this.field.getClassDefinition();
        }
        if (!this.field.isMethod()) {
            classDefinition2 = this.field.getClassDefinition();
            expression = new ThisExpression(l2, this);
        }
        while (true) {
            if (expression == null) {
                while (localMember != null && !Constants.idThis.equals(localMember.getName())) {
                    localMember = localMember.prev;
                }
                if (localMember == null) break;
                expression = new ThisExpression(l2, localMember);
                classDefinition2 = localMember.getClassDefinition();
                localMember2 = localMember;
                localMember = localMember.prev;
            }
            if (classDefinition2 == classDefinition || !bl && Context.match(environment, classDefinition2, classDefinition)) break;
            constants = classDefinition2.findOuterMember();
            if (constants == null) {
                expression = null;
                continue;
            }
            ClassDefinition classDefinition4 = classDefinition2;
            classDefinition2 = classDefinition4.getOuterClass();
            if (classDefinition4 == classDefinition3) {
                Identifier identifier = ((MemberDefinition)constants).getName();
                IdentifierExpression identifierExpression = new IdentifierExpression(l2, identifier);
                identifierExpression.bind(environment, this);
                expression = identifierExpression;
                continue;
            }
            expression = new FieldExpression(l2, expression, (MemberDefinition)constants);
        }
        if (expression != null) {
            return expression;
        }
        if (memberDefinition == null) {
            constants = classDefinition.getName().getFlatName().getName();
            environment.error(l2, "undef.var", Identifier.lookup((Identifier)constants, Constants.idThis));
        } else if (memberDefinition.isConstructor()) {
            environment.error(l2, "no.outer.arg", classDefinition, memberDefinition.getClassDefinition());
        } else {
            environment.error(l2, "no.static.field.access", memberDefinition, this.field);
        }
        constants = new ThisExpression(l2, this);
        ((Expression)constants).type = classDefinition.getType();
        return constants;
    }

    public static boolean outerLinkExists(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        while (!Context.match(environment, classDefinition2, classDefinition)) {
            if (classDefinition2.isTopLevel()) {
                return false;
            }
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return true;
    }

    public ClassDefinition findScope(Environment environment, ClassDefinition classDefinition) {
        ClassDefinition classDefinition2 = this.field.getClassDefinition();
        while (classDefinition2 != null && !Context.match(environment, classDefinition2, classDefinition)) {
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return classDefinition2;
    }

    Identifier resolveName(Environment environment, Identifier identifier) {
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(environment, identifier.getHead());
            if (identifier2.hasAmbigPrefix()) {
                return identifier2;
            }
            if (!environment.classExists(identifier2)) {
                return environment.resolvePackageQualifiedName(identifier);
            }
            try {
                return environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            MemberDefinition memberDefinition = this.getClassCommon(environment, identifier, false);
            if (memberDefinition != null) {
                return memberDefinition.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {}
        return environment.resolveName(identifier);
    }

    public Identifier getApparentClassName(Environment environment, Identifier identifier) {
        Constants constants;
        if (identifier.isQualified()) {
            Identifier identifier2 = this.getApparentClassName(environment, identifier.getHead());
            return identifier2 == null ? Constants.idNull : Identifier.lookup(identifier2, identifier.getTail());
        }
        try {
            constants = this.getClassCommon(environment, identifier, true);
            if (constants != null) {
                return ((MemberDefinition)constants).getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        constants = this.field.getClassDefinition().getTopClass().getName();
        if (((Identifier)constants).getName().equals(identifier)) {
            return constants;
        }
        return Constants.idNull;
    }

    public void checkBackBranch(Environment environment, Statement statement, Vset vset, Vset vset2) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.isBlankFinal() && vset.testVarUnassigned(localMember.number) && !vset2.testVarUnassigned(localMember.number)) {
                environment.error(statement.where, "assign.to.blank.final.in.loop", localMember.getName());
            }
            localMember = localMember.prev;
        }
    }

    public boolean canReach(Environment environment, MemberDefinition memberDefinition) {
        return this.field.canReach(environment, memberDefinition);
    }

    public Context getLabelContext(Identifier identifier) {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node instanceof Statement && ((Statement)context.node).hasLabel(identifier)) {
                return context;
            }
            context = context.prev;
        }
        return null;
    }

    public Context getBreakContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public Context getContinueContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public CheckContext getReturnContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node.op == 47) {
                return (CheckContext)context;
            }
            context = context.prev;
        }
        return null;
    }

    public CheckContext getTryExitContext() {
        Context context = this;
        while (context != null && context.node != null && context.node.op != 47) {
            if (context.node.op == 101) {
                return (CheckContext)context;
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: 
                    case 151: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineMemberContext(MemberDefinition memberDefinition) {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: {
                        if (!((InlineMethodExpression)context.node).field.equals(memberDefinition)) break;
                        return context;
                    }
                    case 151: {
                        if (!((InlineNewInstanceExpression)context.node).field.equals(memberDefinition)) break;
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public final Vset removeAdditionalVars(Vset vset) {
        return vset.removeAdditionalVars(this.varNumber);
    }

    public final int getVarNumber() {
        return this.varNumber;
    }

    public int getThisNumber() {
        LocalMember localMember = this.getLocalField(Constants.idThis);
        if (localMember != null && localMember.getClassDefinition() == this.field.getClassDefinition()) {
            return localMember.number;
        }
        return this.varNumber;
    }

    public final MemberDefinition getField() {
        return this.field;
    }

    public static Environment newEnvironment(Environment environment, Context context) {
        return new ContextEnvironment(environment, context);
    }
}

