/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryCode;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryExceptionHandler;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodType;
import sun.tools.java.RuntimeConstants;
import sun.tools.javap.ConstantPrinter;
import sun.tools.javap.JavaPEnvironment;

class JavaPBinaryCode
extends BinaryCode
implements Constants {
    private JavaPEnvironment env;
    private PrintWriter output;
    private byte[] codeBytes;
    private BinaryConstantPool cpool;
    private ConstantPrinter constPrint;
    private MemberDefinition fieldDef;
    private String methodName;
    private int offset;

    JavaPBinaryCode(byte[] byArray, BinaryConstantPool binaryConstantPool, JavaPEnvironment javaPEnvironment, MemberDefinition memberDefinition) {
        super(byArray, binaryConstantPool, javaPEnvironment);
        this.output = javaPEnvironment.output;
        this.codeBytes = this.getCode();
        this.cpool = binaryConstantPool;
        this.constPrint = new ConstantPrinter(binaryConstantPool, javaPEnvironment, this.output, !javaPEnvironment.showBackwardCompatible);
        this.fieldDef = memberDefinition;
        this.methodName = memberDefinition.toString();
    }

    MemberDefinition fieldDefinition() {
        return this.fieldDef;
    }

    private final int at(int n2) {
        return this.codeBytes[this.offset + n2] & 0xFF;
    }

    private final int shortAt(int n2) {
        int n3 = this.offset + n2;
        return (this.codeBytes[n3] & 0xFF) << 8 | this.codeBytes[n3 + 1] & 0xFF;
    }

    private final long intAt(int n2, int n3) {
        int n4 = n2 + (n3 << 2);
        return this.codeBytes[n4] << 24 | (this.codeBytes[n4 + 1] & 0xFF) << 16 | (this.codeBytes[n4 + 2] & 0xFF) << 8 | this.codeBytes[n4 + 3] & 0xFF;
    }

    private void printFixedWidthInt(long l2, int n2) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.print(l2);
        String string = charArrayWriter.toString();
        int n3 = n2 - string.length();
        while (n3 > 0) {
            this.output.print(' ');
            --n3;
        }
        this.output.print(string);
    }

    void printCodeSequence() throws IOException {
        this.output.println();
        this.output.println("Method " + this.methodName);
        this.offset = 0;
        while (this.offset < this.codeBytes.length) {
            int n2 = this.at(0);
            this.printFixedWidthInt(this.offset, 4);
            this.output.print(" ");
            if (n2 == 196) {
                n2 = this.at(1);
                this.output.print(RuntimeConstants.opcNames[n2] + "_w ");
                int n3 = this.shortAt(2);
                switch (n2) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        this.output.print(n3);
                        this.offset += 4;
                        break;
                    }
                    case 132: {
                        this.output.print(n3 + " " + (short)this.shortAt(4));
                        this.offset += 6;
                        break;
                    }
                    default: {
                        this.output.print("Invalid opcode");
                        ++this.offset;
                        break;
                    }
                }
            } else {
                this.output.print(RuntimeConstants.opcNames[n2]);
                switch (n2) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        this.output.print(" " + this.at(1));
                        this.offset += 2;
                        break;
                    }
                    case 132: {
                        this.output.print(" " + this.at(1) + " " + (byte)this.at(2));
                        this.offset += 3;
                        break;
                    }
                    case 170: {
                        int n4 = this.offset + 1 + 3 & 0xFFFFFFFC;
                        long l2 = this.intAt(n4, 0);
                        long l3 = this.intAt(n4, 1);
                        long l4 = this.intAt(n4, 2);
                        this.output.print(" " + l3 + " to " + l4 + ": default=");
                        this.output.print((long)this.offset + l2);
                        n4 += 12;
                        long l5 = l3;
                        while (l5 <= l4) {
                            this.output.println("");
                            this.output.print('\t');
                            this.printFixedWidthInt(l5, 5);
                            this.output.print(": " + ((long)this.offset + this.intAt(n4, (int)(l5 - l3))));
                            ++l5;
                        }
                        this.offset = n4 + (int)(l4 - l3 + 1L << 2);
                        break;
                    }
                    case 171: {
                        int n5 = this.offset + 1 + 3 & 0xFFFFFFFC;
                        long l2 = this.intAt(n5, 0);
                        int n6 = (int)this.intAt(n5, 1);
                        int n7 = n6 * 2;
                        this.output.print(" " + n6);
                        this.output.print(": default=" + ((long)this.offset + l2));
                        n5 += 8;
                        int n8 = 0;
                        while (n8 < n7) {
                            this.output.println("");
                            this.output.print('\t');
                            this.printFixedWidthInt(this.intAt(n5, n8), 5);
                            this.output.print(": " + ((long)this.offset + this.intAt(n5, n8 + 1)));
                            n8 += 2;
                        }
                        this.offset = n5 + (n7 << 2);
                        break;
                    }
                    case 188: {
                        switch (this.at(1)) {
                            case 10: {
                                this.output.print(" int");
                                break;
                            }
                            case 11: {
                                this.output.print(" long");
                                break;
                            }
                            case 6: {
                                this.output.print(" float");
                                break;
                            }
                            case 7: {
                                this.output.print(" double");
                                break;
                            }
                            case 5: {
                                this.output.print(" char");
                                break;
                            }
                            case 9: {
                                this.output.print(" short");
                                break;
                            }
                            case 8: {
                                this.output.print(" byte");
                                break;
                            }
                            case 4: {
                                this.output.print(" boolean");
                                break;
                            }
                            default: {
                                this.output.print(" BOGUS TYPE");
                            }
                        }
                        this.offset += 2;
                        break;
                    }
                    case 189: {
                        int n9 = this.shortAt(1);
                        this.output.print(" class #" + n9 + " ");
                        this.constPrint.printConstant(n9);
                        this.offset += 3;
                        break;
                    }
                    case 17: {
                        this.output.print(" " + (short)this.shortAt(1));
                        this.offset += 3;
                        break;
                    }
                    case 16: {
                        this.output.print(" " + (byte)this.at(1));
                        this.offset += 2;
                        break;
                    }
                    case 18: {
                        int n10 = this.at(1);
                        this.output.print(" #" + n10 + " ");
                        this.constPrint.printConstant(n10);
                        this.offset += 2;
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 193: {
                        int n11 = this.shortAt(1);
                        this.output.print(" #" + n11 + " ");
                        this.constPrint.printConstant(n11);
                        this.offset += 3;
                        break;
                    }
                    case 185: {
                        int n12 = this.shortAt(1);
                        this.output.print(" (args " + this.at(3) + ") #" + n12 + " ");
                        this.constPrint.printConstant(n12);
                        this.offset += 5;
                        break;
                    }
                    case 197: {
                        int n13 = this.shortAt(1);
                        this.output.print(" #" + n13 + " dim #" + this.at(3) + " ");
                        this.constPrint.printConstant(n13);
                        this.offset += 4;
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 198: 
                    case 199: {
                        int n14 = this.offset + (short)this.shortAt(1);
                        this.output.print(" " + n14);
                        this.offset += 3;
                        break;
                    }
                    case 200: 
                    case 201: {
                        long l6 = (long)this.offset + this.intAt(this.offset + 1, 0);
                        this.output.print(" " + l6);
                        this.offset += 5;
                        break;
                    }
                    default: {
                        ++this.offset;
                    }
                }
            }
            this.output.println();
        }
    }

    void printExceptionTable() throws IOException {
        BinaryExceptionHandler[] binaryExceptionHandlerArray = this.getExceptionHandlers();
        if (binaryExceptionHandlerArray.length > 0) {
            this.output.print("Exception table:\n   from   to  target type\n");
            int n2 = 0;
            while (n2 < binaryExceptionHandlerArray.length) {
                BinaryExceptionHandler binaryExceptionHandler = binaryExceptionHandlerArray[n2];
                this.printFixedWidthInt(binaryExceptionHandler.startPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.endPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.handlerPC, 6);
                this.output.print("   ");
                ClassDeclaration classDeclaration = binaryExceptionHandler.exceptionClass;
                if (classDeclaration == null) {
                    this.output.println("any");
                } else {
                    this.constPrint.printClassDeclaration(classDeclaration);
                    this.output.println("");
                }
                ++n2;
            }
        }
    }

    private DataInputStream findAttribute(Identifier identifier) {
        BinaryAttribute binaryAttribute = this.getAttributes();
        while (binaryAttribute != null) {
            if (binaryAttribute.getName().equals(identifier)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binaryAttribute.getData());
                return new DataInputStream(byteArrayInputStream);
            }
            binaryAttribute = binaryAttribute.getNextAttribute();
        }
        return null;
    }

    void printLineNumberTable() throws IOException {
        int n2;
        DataInputStream dataInputStream = this.findAttribute(Constants.idLineNumberTable);
        if (dataInputStream != null && (n2 = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Line numbers for method " + this.methodName);
            int n3 = n2;
            while (n3 > 0) {
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                this.output.println("   line " + s3 + ": " + s2);
                --n3;
            }
        }
    }

    void printLocalVariableTable() throws IOException {
        int n2;
        DataInputStream dataInputStream = this.findAttribute(Constants.idLocalVariableTable);
        if (dataInputStream != null && (n2 = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Local variables for method " + this.methodName);
            int n3 = n2;
            while (n3 > 0) {
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                short s4 = dataInputStream.readShort();
                short s5 = dataInputStream.readShort();
                short s6 = dataInputStream.readShort();
                this.output.print("   ");
                this.output.print(this.cpool.getType(s5));
                this.output.print(" ");
                this.output.print(this.cpool.getString(s4));
                this.output.println("  pc=" + s2 + ", length=" + s3 + ", slot=" + s6);
                --n3;
            }
        }
    }

    void printVerboseHeader() {
        MethodType methodType = (MethodType)this.fieldDef.getType();
        int n2 = methodType.getArgumentTypes().length;
        if (!this.fieldDef.isStatic()) {
            ++n2;
        }
        this.output.println("\t/* Stack=" + this.getMaxStack() + ", Locals=" + this.getMaxLocals() + ", Args_size=" + n2 + " */");
    }
}

