/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.PrintWriter;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.Constants;
import sun.tools.javap.JavaPEnvironment;

public final class ConstantPrinter
implements Constants {
    BinaryConstantPool cpool;
    private JavaPEnvironment env;
    private PrintWriter output;
    private boolean decodeTypeSignatures;

    public ConstantPrinter(BinaryConstantPool binaryConstantPool, JavaPEnvironment javaPEnvironment, PrintWriter printWriter, boolean bl) {
        this.cpool = binaryConstantPool;
        this.env = javaPEnvironment;
        this.output = printWriter;
        this.decodeTypeSignatures = bl;
    }

    public String getString(int n2) {
        return this.cpool.getString(n2);
    }

    private void printNameAndType(int n2, String string, boolean bl) {
        int n3 = n2 >> 16;
        int n4 = n2 & 0xFFFF;
        this.output.print(this.cpool.getString(n3) + string);
        if (bl) {
            this.output.print(this.cpool.getType(n4));
        } else {
            this.output.print(this.cpool.getString(n4));
        }
    }

    private void printNameAndTypeFromIndex(int n2, String string) {
        int n3 = this.cpool.getInteger(n2);
        this.printNameAndType(n3, string, this.decodeTypeSignatures);
    }

    private void printRef(int n2, String string) {
        if (this.decodeTypeSignatures) {
            this.output.print(this.cpool.getConstant(n2, this.env));
        } else {
            int n3 = this.cpool.getInteger(n2);
            int n4 = n3 >> 16;
            int n5 = n3 & 0xFFFF;
            this.output.print(this.cpool.getDeclaration(this.env, n4).getName());
            this.output.print(".");
            this.printNameAndTypeFromIndex(n5, string);
        }
    }

    public void printClassDeclaration(ClassDeclaration classDeclaration) {
        ClassDefinition classDefinition = classDeclaration.getClassDefinition();
        if (classDefinition != null && classDefinition.isInterface()) {
            this.output.print("<Interface ");
        } else {
            this.output.print("<Class ");
        }
        this.output.print(classDeclaration.getName());
        this.output.print(">");
    }

    public void printConstant(int n2) {
        int n3 = this.cpool.getConstantType(n2);
        switch (n3) {
            case 8: {
                this.output.print("<String \"" + this.cpool.getConstant(n2, this.env) + "\"");
                break;
            }
            case 1: {
                this.output.print("<\"" + this.cpool.getString(n2) + "\"");
                break;
            }
            case 3: {
                this.output.print("<Integer " + this.cpool.getInteger(n2));
                break;
            }
            case 4: {
                this.output.print("<Real " + this.cpool.getValue(n2));
                break;
            }
            case 5: {
                this.output.print("<Long " + this.cpool.getValue(n2));
                break;
            }
            case 6: {
                this.output.print("<Double " + this.cpool.getValue(n2));
                break;
            }
            case 7: {
                this.printClassDeclaration(this.cpool.getDeclaration(this.env, n2));
                return;
            }
            case 10: {
                this.output.print("<Method ");
                this.printRef(n2, "");
                break;
            }
            case 9: {
                this.output.print("<Field ");
                this.printRef(n2, " ");
                break;
            }
            case 11: {
                this.output.print("<InterfaceMethod ");
                this.printRef(n2, "");
                break;
            }
            case 12: {
                this.output.print("<NameAndType");
                this.printNameAndTypeFromIndex(n2, " ");
                break;
            }
            default: {
                this.output.print("<Unknown " + n3);
            }
        }
        this.output.print('>');
    }
}

