/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javac;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Package;
import sun.tools.java.Type;
import sun.tools.javac.BatchParser;
import sun.tools.javac.ErrorConsumer;
import sun.tools.javac.ErrorMessage;
import sun.tools.javac.Main;
import sun.tools.javac.SourceClass;
import sun.tools.javac.SourceMember;
import sun.tools.tree.Node;

public class BatchEnvironment
extends Environment
implements ErrorConsumer {
    OutputStream out;
    protected ClassPath sourcePath;
    protected ClassPath binaryPath;
    Hashtable packages = new Hashtable(31);
    Vector classesOrdered = new Vector();
    Hashtable classes = new Hashtable(351);
    public int flags;
    public short majorVersion = (short)45;
    public short minorVersion = (short)3;
    public File covFile;
    public int nerrors;
    public int nwarnings;
    public int ndeprecations;
    Vector deprecationFiles = new Vector();
    ErrorConsumer errorConsumer;
    private Set exemptPackages;
    String errorFileName;
    ErrorMessage errors;
    private int errorsPushed;
    public int errorLimit = 100;
    private boolean hitErrorLimit;

    public BatchEnvironment(ClassPath classPath) {
        this(System.out, classPath);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath) {
        this(outputStream, classPath, (ErrorConsumer)null);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, ErrorConsumer errorConsumer) {
        this(outputStream, classPath, classPath, errorConsumer);
    }

    public BatchEnvironment(ClassPath classPath, ClassPath classPath2) {
        this((OutputStream)System.out, classPath, classPath2);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, ClassPath classPath2) {
        this(outputStream, classPath, classPath2, null);
    }

    public BatchEnvironment(OutputStream outputStream, ClassPath classPath, ClassPath classPath2, ErrorConsumer errorConsumer) {
        this.out = outputStream;
        this.sourcePath = classPath;
        this.binaryPath = classPath2;
        this.errorConsumer = errorConsumer == null ? this : errorConsumer;
    }

    static BatchEnvironment create(OutputStream outputStream, String string, String string2, String string3, String string4) {
        ClassPath[] classPathArray = BatchEnvironment.classPaths(string, string2, string3, string4);
        return new BatchEnvironment(outputStream, classPathArray[0], classPathArray[1]);
    }

    protected static ClassPath[] classPaths(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null && (string2 = System.getProperty("env.class.path")) == null) {
            string2 = ".";
        }
        if (string == null) {
            string = string2;
        }
        if (string3 == null && (string3 = System.getProperty("sun.boot.class.path")) == null) {
            string3 = string2;
        }
        BatchEnvironment.appendPath(stringBuffer, string3);
        if (string4 == null) {
            string4 = System.getProperty("java.ext.dirs");
        }
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                File file = new File(string5);
                if (!string5.endsWith(File.separator)) {
                    string5 = string5 + File.separator;
                }
                if (!file.isDirectory()) continue;
                String[] stringArray = file.list();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string6 = stringArray[n2];
                    if (string6.endsWith(".jar")) {
                        BatchEnvironment.appendPath(stringBuffer, string5 + string6);
                    }
                    ++n2;
                }
            }
        }
        BatchEnvironment.appendPath(stringBuffer, string2);
        ClassPath classPath = new ClassPath(string);
        ClassPath classPath2 = new ClassPath(stringBuffer.toString());
        return new ClassPath[]{classPath, classPath2};
    }

    private static void appendPath(StringBuffer stringBuffer, String string) {
        if (string.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(string);
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public File getcovFile() {
        return this.covFile;
    }

    public Enumeration getClasses() {
        return this.classesOrdered.elements();
    }

    public boolean isExemptPackage(Identifier identifier) {
        if (this.exemptPackages == null) {
            this.setExemptPackages();
        }
        return this.exemptPackages.contains(identifier);
    }

    private void setExemptPackages() {
        block5: {
            this.exemptPackages = new HashSet(101);
            Enumeration enumeration = this.getClasses();
            while (enumeration.hasMoreElements()) {
                SourceClass sourceClass;
                ClassDeclaration classDeclaration = (ClassDeclaration)enumeration.nextElement();
                if (classDeclaration.getStatus() != 4 || (sourceClass = (SourceClass)classDeclaration.getClassDefinition()).isLocal()) continue;
                Identifier identifier = sourceClass.getImports().getCurrentPackage();
                while (identifier != Constants.idNull && this.exemptPackages.add(identifier)) {
                    identifier = identifier.getQualifier();
                }
            }
            if (this.exemptPackages.contains(Constants.idJavaLang)) break block5;
            this.exemptPackages.add(Constants.idJavaLang);
            try {
                if (!this.getPackage(Constants.idJavaLang).exists()) {
                    this.error(0L, "package.not.found.strong", Constants.idJavaLang);
                    return;
                }
            }
            catch (IOException iOException) {
                this.error(0L, "io.exception.package", Constants.idJavaLang);
            }
        }
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.getClassDeclaration(Type.tClass(identifier));
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
        if (classDeclaration == null) {
            classDeclaration = new ClassDeclaration(type.getClassName());
            this.classes.put(type, classDeclaration);
            this.classesOrdered.addElement(classDeclaration);
        }
        return classDeclaration;
    }

    public boolean classExists(Identifier identifier) {
        if (identifier.isInner()) {
            identifier = identifier.getTopName();
        }
        Type type = Type.tClass(identifier);
        try {
            ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
            return classDeclaration != null ? classDeclaration.getName().equals(identifier) : this.getPackage(identifier.getQualifier()).classExists(identifier.getName());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public Package getPackage(Identifier identifier) throws IOException {
        Package package_ = (Package)this.packages.get(identifier);
        if (package_ == null) {
            package_ = new Package(this.sourcePath, this.binaryPath, identifier);
            this.packages.put(identifier, package_);
        }
        return package_;
    }

    public void parseFile(ClassFile classFile) throws FileNotFoundException {
        BatchParser batchParser;
        InputStream inputStream;
        long l2 = System.currentTimeMillis();
        this.dtEnter("parseFile: PARSING SOURCE " + classFile);
        Environment environment = new Environment(this, classFile);
        try {
            inputStream = classFile.getInputStream();
            environment.setCharacterEncoding(this.getCharacterEncoding());
            batchParser = new BatchParser(environment, inputStream);
        }
        catch (IOException iOException) {
            this.dtEvent("parseFile: IO EXCEPTION " + classFile);
            throw new FileNotFoundException();
        }
        try {
            batchParser.parseFile();
        }
        catch (Exception exception) {
            throw new CompilerError(exception);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.verbose()) {
            l2 = System.currentTimeMillis() - l2;
            this.output(Main.getText("benv.parsed_in", classFile.getPath(), Long.toString(l2)));
        }
        if (batchParser.classes.size() == 0) {
            batchParser.imports.resolve(environment);
        } else {
            Enumeration enumeration = batchParser.classes.elements();
            ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
            if (classDefinition.isInnerClass()) {
                throw new CompilerError("BatchEnvironment, first is inner");
            }
            ClassDefinition classDefinition2 = classDefinition;
            while (enumeration.hasMoreElements()) {
                ClassDefinition classDefinition3 = (ClassDefinition)enumeration.nextElement();
                if (classDefinition3.isInnerClass()) continue;
                classDefinition2.addDependency(classDefinition3.getClassDeclaration());
                classDefinition3.addDependency(classDefinition2.getClassDeclaration());
                classDefinition2 = classDefinition3;
            }
            if (classDefinition2 != classDefinition) {
                classDefinition2.addDependency(classDefinition.getClassDeclaration());
                classDefinition.addDependency(classDefinition2.getClassDeclaration());
            }
        }
        this.dtExit("parseFile: SOURCE PARSED " + classFile);
    }

    BinaryClass loadFile(ClassFile classFile) throws IOException {
        long l2 = System.currentTimeMillis();
        InputStream inputStream = classFile.getInputStream();
        BinaryClass binaryClass = null;
        this.dtEnter("loadFile: LOADING CLASSFILE " + classFile);
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            binaryClass = BinaryClass.load(new Environment(this, classFile), dataInputStream, this.loadFileFlags());
        }
        catch (ClassFormatError classFormatError) {
            this.error(0L, "class.format", classFile.getPath(), classFormatError.getMessage());
            this.dtExit("loadFile: CLASS FORMAT ERROR " + classFile);
            return null;
        }
        catch (EOFException eOFException) {
            this.error(0L, "truncated.class", classFile.getPath());
            return null;
        }
        inputStream.close();
        if (this.verbose()) {
            l2 = System.currentTimeMillis() - l2;
            this.output(Main.getText("benv.loaded_in", classFile.getPath(), Long.toString(l2)));
        }
        this.dtExit("loadFile: CLASSFILE LOADED " + classFile);
        return binaryClass;
    }

    int loadFileFlags() {
        return 0;
    }

    boolean needsCompilation(Hashtable hashtable, ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                this.dtEnter("needsCompilation: UNDEFINED " + classDeclaration.getName());
                this.loadDefinition(classDeclaration);
                return this.needsCompilation(hashtable, classDeclaration);
            }
            case 1: {
                this.dtEnter("needsCompilation: UNDECIDED " + classDeclaration.getName());
                if (hashtable.get(classDeclaration) == null) {
                    hashtable.put(classDeclaration, classDeclaration);
                    BinaryClass binaryClass = (BinaryClass)classDeclaration.getClassDefinition();
                    Enumeration enumeration = binaryClass.getDependencies();
                    while (enumeration.hasMoreElements()) {
                        ClassDeclaration classDeclaration2 = (ClassDeclaration)enumeration.nextElement();
                        if (!this.needsCompilation(hashtable, classDeclaration2)) continue;
                        classDeclaration.setDefinition(binaryClass, 3);
                        this.dtExit("needsCompilation: YES (source) " + classDeclaration.getName());
                        return true;
                    }
                }
                this.dtExit("needsCompilation: NO (undecided) " + classDeclaration.getName());
                return false;
            }
            case 2: {
                this.dtEnter("needsCompilation: BINARY " + classDeclaration.getName());
                this.dtExit("needsCompilation: NO (binary) " + classDeclaration.getName());
                return false;
            }
        }
        this.dtExit("needsCompilation: YES " + classDeclaration.getName());
        return true;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        this.dtEnter("loadDefinition: ENTER " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
        switch (classDeclaration.getStatus()) {
            case 0: {
                Package package_;
                this.dtEvent("loadDefinition: STATUS IS UNDEFINED");
                Identifier identifier = classDeclaration.getName();
                try {
                    package_ = this.getPackage(identifier.getQualifier());
                }
                catch (IOException iOException) {
                    classDeclaration.setDefinition(null, 7);
                    this.error(0L, "io.exception", classDeclaration);
                    this.dtExit("loadDefinition: IO EXCEPTION (package)");
                    return;
                }
                ClassFile classFile = package_.getBinaryFile(identifier.getName());
                if (classFile == null) {
                    classDeclaration.setDefinition(null, 3);
                    this.dtExit("loadDefinition: MUST BE SOURCE (no binary) " + classDeclaration.getName());
                    return;
                }
                ClassFile classFile2 = package_.getSourceFile(identifier.getName());
                if (classFile2 == null) {
                    this.dtEvent("loadDefinition: NO SOURCE " + classDeclaration.getName());
                    BinaryClass binaryClass = null;
                    try {
                        binaryClass = this.loadFile(classFile);
                    }
                    catch (IOException iOException) {
                        classDeclaration.setDefinition(null, 7);
                        this.error(0L, "io.exception", classFile);
                        this.dtExit("loadDefinition: IO EXCEPTION (binary)");
                        return;
                    }
                    if (binaryClass != null && !binaryClass.getName().equals(identifier)) {
                        this.error(0L, "wrong.class", classFile.getPath(), classDeclaration, binaryClass);
                        binaryClass = null;
                        this.dtEvent("loadDefinition: WRONG CLASS (binary)");
                    }
                    if (binaryClass == null) {
                        classDeclaration.setDefinition(null, 7);
                        this.dtExit("loadDefinition: NOT FOUND (source or binary)");
                        return;
                    }
                    if (binaryClass.getSource() != null) {
                        classFile2 = new ClassFile(new File((String)binaryClass.getSource()));
                        if ((classFile2 = package_.getSourceFile(classFile2.getName())) != null && classFile2.exists()) {
                            this.dtEvent("loadDefinition: FILENAME IN BINARY " + classFile2);
                            if (classFile2.lastModified() > classFile.lastModified()) {
                                classDeclaration.setDefinition(binaryClass, 3);
                                this.dtEvent("loadDefinition: SOURCE IS NEWER " + classFile2);
                                binaryClass.loadNested(this);
                                this.dtExit("loadDefinition: MUST BE SOURCE " + classDeclaration.getName());
                                return;
                            }
                            if (this.dependencies()) {
                                classDeclaration.setDefinition(binaryClass, 1);
                                this.dtEvent("loadDefinition: UNDECIDED " + classDeclaration.getName());
                            } else {
                                classDeclaration.setDefinition(binaryClass, 2);
                                this.dtEvent("loadDefinition: MUST BE BINARY " + classDeclaration.getName());
                            }
                            binaryClass.loadNested(this);
                            this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                            return;
                        }
                    }
                    classDeclaration.setDefinition(binaryClass, 2);
                    this.dtEvent("loadDefinition: MUST BE BINARY (no source) " + classDeclaration.getName());
                    binaryClass.loadNested(this);
                    this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                    return;
                }
                BinaryClass binaryClass = null;
                try {
                    if (classFile2.lastModified() > classFile.lastModified()) {
                        classDeclaration.setDefinition(null, 3);
                        this.dtEvent("loadDefinition: MUST BE SOURCE (younger than binary) " + classDeclaration.getName());
                        return;
                    }
                    binaryClass = this.loadFile(classFile);
                }
                catch (IOException iOException) {
                    this.error(0L, "io.exception", classFile);
                    this.dtEvent("loadDefinition: IO EXCEPTION (binary)");
                }
                if (binaryClass != null && !binaryClass.getName().equals(identifier)) {
                    this.error(0L, "wrong.class", classFile.getPath(), classDeclaration, binaryClass);
                    binaryClass = null;
                    this.dtEvent("loadDefinition: WRONG CLASS (binary)");
                }
                if (binaryClass != null) {
                    Identifier identifier2 = binaryClass.getName();
                    if (identifier2.equals(classDeclaration.getName())) {
                        if (this.dependencies()) {
                            classDeclaration.setDefinition(binaryClass, 1);
                            this.dtEvent("loadDefinition: UNDECIDED " + identifier2);
                        } else {
                            classDeclaration.setDefinition(binaryClass, 2);
                            this.dtEvent("loadDefinition: MUST BE BINARY " + identifier2);
                        }
                    } else {
                        classDeclaration.setDefinition(null, 7);
                        this.dtEvent("loadDefinition: NOT FOUND (source or binary)");
                        if (this.dependencies()) {
                            this.getClassDeclaration(identifier2).setDefinition(binaryClass, 1);
                            this.dtEvent("loadDefinition: UNDECIDED " + identifier2);
                        } else {
                            this.getClassDeclaration(identifier2).setDefinition(binaryClass, 2);
                            this.dtEvent("loadDefinition: MUST BE BINARY " + identifier2);
                        }
                    }
                } else {
                    classDeclaration.setDefinition(null, 7);
                    this.dtEvent("loadDefinition: NOT FOUND (source or binary)");
                }
                if (binaryClass != null && binaryClass == classDeclaration.getClassDefinition()) {
                    binaryClass.loadNested(this);
                }
                this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                return;
            }
            case 1: {
                this.dtEvent("loadDefinition: STATUS IS UNDECIDED");
                Hashtable hashtable = new Hashtable();
                if (!this.needsCompilation(hashtable, classDeclaration)) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        ClassDeclaration classDeclaration2 = (ClassDeclaration)enumeration.nextElement();
                        if (classDeclaration2.getStatus() != 1) continue;
                        classDeclaration2.setDefinition(classDeclaration2.getClassDefinition(), 2);
                        this.dtEvent("loadDefinition: MUST BE BINARY " + classDeclaration2);
                    }
                }
                this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                return;
            }
            case 3: {
                this.dtEvent("loadDefinition: STATUS IS SOURCE");
                ClassFile classFile = null;
                Package package_ = null;
                if (classDeclaration.getClassDefinition() != null) {
                    try {
                        package_ = this.getPackage(classDeclaration.getName().getQualifier());
                        classFile = package_.getSourceFile((String)classDeclaration.getClassDefinition().getSource());
                    }
                    catch (IOException iOException) {
                        this.error(0L, "io.exception", classDeclaration);
                        this.dtEvent("loadDefinition: IO EXCEPTION (package)");
                    }
                    if (classFile == null) {
                        String string = (String)classDeclaration.getClassDefinition().getSource();
                        classFile = new ClassFile(new File(string));
                    }
                } else {
                    Identifier identifier = classDeclaration.getName();
                    try {
                        package_ = this.getPackage(identifier.getQualifier());
                        classFile = package_.getSourceFile(identifier.getName());
                    }
                    catch (IOException iOException) {
                        this.error(0L, "io.exception", classDeclaration);
                        this.dtEvent("loadDefinition: IO EXCEPTION (package)");
                    }
                    if (classFile == null) {
                        classDeclaration.setDefinition(null, 7);
                        this.dtExit("loadDefinition: SOURCE NOT FOUND " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                        return;
                    }
                }
                try {
                    this.parseFile(classFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.error(0L, "io.exception", classFile);
                    this.dtEvent("loadDefinition: IO EXCEPTION (source)");
                }
                if (classDeclaration.getClassDefinition() == null || classDeclaration.getStatus() == 3) {
                    this.error(0L, "wrong.source", classFile.getPath(), classDeclaration, package_);
                    classDeclaration.setDefinition(null, 7);
                    this.dtEvent("loadDefinition: WRONG CLASS (source) " + classDeclaration.getName());
                }
                this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
                return;
            }
        }
        this.dtExit("loadDefinition: EXIT " + classDeclaration.getName() + ", status " + classDeclaration.getStatus());
    }

    public ClassDefinition makeClassDefinition(Environment environment, long l2, IdentifierToken identifierToken, String string, int n2, IdentifierToken identifierToken2, IdentifierToken[] identifierTokenArray, ClassDefinition classDefinition) {
        Constants constants;
        Identifier identifier;
        Identifier identifier2 = identifierToken.getName();
        long l3 = identifierToken.getWhere();
        String string2 = null;
        ClassDefinition classDefinition2 = null;
        Identifier identifier3 = null;
        if (identifier2.isQualified() || identifier2.isInner()) {
            identifier = identifier2;
        } else if ((n2 & 0x30000) != 0) {
            classDefinition2 = classDefinition.getTopClass();
            int n3 = 1;
            while (classDefinition2.getLocalClass(string2 = n3 + (identifier2.equals(Constants.idNull) ? "" : "$" + identifier2)) != null) {
                ++n3;
            }
            constants = classDefinition2.getName();
            identifier = Identifier.lookupInner((Identifier)constants, Identifier.lookup(string2));
            identifier3 = (n2 & 0x10000) != 0 ? Constants.idNull : identifier2;
        } else {
            identifier = classDefinition != null ? Identifier.lookupInner(classDefinition.getName(), identifier2) : identifier2;
        }
        ClassDeclaration classDeclaration = environment.getClassDeclaration(identifier);
        if (classDeclaration.isDefined()) {
            environment.error(l3, "class.multidef", classDeclaration.getName(), classDeclaration.getClassDefinition().getSource());
            classDeclaration = new ClassDeclaration(identifier);
        }
        if (identifierToken2 == null && !identifier.equals(Constants.idJavaLangObject)) {
            identifierToken2 = new IdentifierToken(Constants.idJavaLangObject);
        }
        constants = new SourceClass(environment, l2, classDeclaration, string, n2, identifierToken2, identifierTokenArray, (SourceClass)classDefinition, identifier3);
        if (classDefinition != null) {
            classDefinition.addMember(environment, new SourceMember((ClassDefinition)constants));
            if ((n2 & 0x30000) != 0) {
                classDefinition2.addLocalClass((ClassDefinition)constants, string2);
            }
        }
        return constants;
    }

    public MemberDefinition makeMemberDefinition(Environment environment, long l2, ClassDefinition classDefinition, String string, int n2, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, IdentifierToken[] identifierTokenArray2, Object object) {
        this.dtEvent("makeMemberDefinition: " + identifier + " IN " + classDefinition);
        Vector<IdentifierToken> vector = null;
        if (identifierTokenArray != null) {
            vector = new Vector<IdentifierToken>(identifierTokenArray.length);
            int n3 = 0;
            while (n3 < identifierTokenArray.length) {
                vector.addElement(identifierTokenArray[n3]);
                ++n3;
            }
        }
        SourceMember sourceMember = new SourceMember(l2, classDefinition, string, n2, type, identifier, vector, identifierTokenArray2, (Node)object);
        classDefinition.addMember(environment, sourceMember);
        return sourceMember;
    }

    public void shutdown() {
        try {
            if (this.sourcePath != null) {
                this.sourcePath.close();
            }
            if (this.binaryPath != null && this.binaryPath != this.sourcePath) {
                this.binaryPath.close();
            }
        }
        catch (IOException iOException) {
            this.output(Main.getText("benv.failed_to_close_class_path", iOException.toString()));
        }
        this.sourcePath = null;
        this.binaryPath = null;
        super.shutdown();
    }

    public String errorString(String string, Object object, Object object2, Object object3) {
        String string2 = null;
        string2 = string.startsWith("warn.") ? "javac.err." + string.substring(5) : "javac.err." + string;
        return Main.getText(string2, object != null ? object.toString() : null, object2 != null ? object2.toString() : null, object3 != null ? object3.toString() : null);
    }

    protected boolean insertError(long l2, String string) {
        if (this.errors == null || this.errors.where > l2) {
            ErrorMessage errorMessage = new ErrorMessage(l2, string);
            errorMessage.next = this.errors;
            this.errors = errorMessage;
        } else {
            ErrorMessage errorMessage;
            if (this.errors.where == l2 && this.errors.message.equals(string)) {
                return false;
            }
            ErrorMessage errorMessage2 = this.errors;
            while ((errorMessage = errorMessage2.next) != null && errorMessage.where < l2) {
                errorMessage2 = errorMessage;
            }
            while ((errorMessage = errorMessage2.next) != null && errorMessage.where == l2) {
                if (errorMessage.message.equals(string)) {
                    return false;
                }
                errorMessage2 = errorMessage;
            }
            ErrorMessage errorMessage3 = new ErrorMessage(l2, string);
            errorMessage3.next = errorMessage2.next;
            errorMessage2.next = errorMessage3;
        }
        return true;
    }

    public void pushError(String string, int n2, String string2, String string3, String string4) {
        int n3 = this.errorLimit + this.nwarnings;
        if (++this.errorsPushed >= n3 && this.errorLimit >= 0) {
            if (!this.hitErrorLimit) {
                this.hitErrorLimit = true;
                this.output(this.errorString("too.many.errors", new Integer(this.errorLimit), null, null));
            }
            return;
        }
        if (string.endsWith(".java")) {
            this.output(string + ":" + n2 + ": " + string2);
            this.output(string3);
            this.output(string4);
        } else {
            this.output(string + ": " + string2);
        }
    }

    public void flushErrors() {
        Object object;
        if (this.errors == null) {
            return;
        }
        boolean bl = false;
        char[] cArray = null;
        int n2 = 0;
        try {
            object = new FileInputStream(this.errorFileName);
            cArray = new char[((FileInputStream)object).available()];
            InputStreamReader inputStreamReader = this.getCharacterEncoding() != null ? new InputStreamReader((InputStream)object, this.getCharacterEncoding()) : new InputStreamReader((InputStream)object);
            n2 = inputStreamReader.read(cArray);
            inputStreamReader.close();
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.errors;
        while (object != null) {
            int n3 = (int)(((ErrorMessage)object).where >>> 32);
            int n4 = (int)(((ErrorMessage)object).where & 0xFFFFFFFFL);
            if (n4 > n2) {
                n4 = n2;
            }
            String string = "";
            String string2 = "";
            if (bl) {
                int n5 = n4;
                while (n5 > 0 && cArray[n5 - 1] != '\n' && cArray[n5 - 1] != '\r') {
                    --n5;
                }
                int n6 = n4;
                while (n6 < n2 && cArray[n6] != '\n' && cArray[n6] != '\r') {
                    ++n6;
                }
                string = new String(cArray, n5, n6 - n5);
                char[] cArray2 = new char[n4 - n5 + 1];
                n6 = n5;
                while (n6 < n4) {
                    cArray2[n6 - n5] = cArray[n6] == '\t' ? 9 : 32;
                    ++n6;
                }
                cArray2[n4 - n5] = 94;
                string2 = new String(cArray2);
            }
            this.errorConsumer.pushError(this.errorFileName, n3, ((ErrorMessage)object).message, string, string2);
            object = ((ErrorMessage)object).next;
        }
        this.errors = null;
    }

    public void reportError(Object object, long l2, String string, String string2) {
        if (object == null) {
            if (this.errorFileName != null) {
                this.flushErrors();
                this.errorFileName = null;
            }
            if (string.startsWith("warn.")) {
                if (this.warnings()) {
                    ++this.nwarnings;
                    this.output(string2);
                }
                return;
            }
            this.output("error: " + string2);
            ++this.nerrors;
            this.flags |= 0x10000;
        } else if (object instanceof String) {
            String string3 = (String)object;
            if (!string3.equals(this.errorFileName)) {
                this.flushErrors();
                this.errorFileName = string3;
            }
            if (string.startsWith("warn.")) {
                if (string.indexOf("is.deprecated") >= 0) {
                    if (!this.deprecationFiles.contains(object)) {
                        this.deprecationFiles.addElement(object);
                    }
                    if (this.deprecation()) {
                        if (this.insertError(l2, string2)) {
                            ++this.ndeprecations;
                        }
                    } else {
                        ++this.ndeprecations;
                    }
                } else if (this.warnings()) {
                    if (this.insertError(l2, string2)) {
                        ++this.nwarnings;
                    }
                } else {
                    ++this.nwarnings;
                }
            } else if (this.insertError(l2, string2)) {
                ++this.nerrors;
                this.flags |= 0x10000;
            }
        } else if (object instanceof ClassFile) {
            this.reportError(((ClassFile)object).getPath(), l2, string, string2);
        } else if (object instanceof Identifier) {
            this.reportError(object.toString(), l2, string, string2);
        } else if (object instanceof ClassDeclaration) {
            try {
                this.reportError(((ClassDeclaration)object).getClassDefinition(this), l2, string, string2);
            }
            catch (ClassNotFound classNotFound) {
                this.reportError(((ClassDeclaration)object).getName(), l2, string, string2);
            }
        } else if (object instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)object;
            if (!string.startsWith("warn.")) {
                classDefinition.setError();
            }
            this.reportError(classDefinition.getSource(), l2, string, string2);
        } else if (object instanceof MemberDefinition) {
            this.reportError(((MemberDefinition)object).getClassDeclaration(), l2, string, string2);
        } else {
            this.output(object + ":error=" + string + ":" + string2);
        }
    }

    public void error(Object object, long l2, String string, Object object2, Object object3, Object object4) {
        if (this.errorsPushed >= this.errorLimit + this.nwarnings) {
            return;
        }
        if (System.getProperty("javac.dump.stack") != null) {
            this.output("javac.err." + string + ": " + this.errorString(string, object2, object3, object4));
            new Exception("Stack trace").printStackTrace(new PrintStream(this.out));
        }
        this.reportError(object, l2, string, this.errorString(string, object2, object3, object4));
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }
}

