/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.io.InputStream;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.ScannerInputReader;

public class Scanner
implements Constants {
    public static final long OFFSETINC = 1L;
    public static final long LINEINC = 0x100000000L;
    public static final int EOF = -1;
    public Environment env;
    protected ScannerInputReader in;
    public boolean scanComments = false;
    public int token;
    public long pos;
    public long prevPos;
    protected int ch;
    public char charValue;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public String stringValue;
    public Identifier idValue;
    public int radix;
    public String docComment;
    private int count;
    private char[] buffer = new char[1024];

    private void growBuffer() {
        char[] cArray = new char[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
        this.buffer = cArray;
    }

    private void putc(int n2) {
        if (this.count == this.buffer.length) {
            this.growBuffer();
        }
        this.buffer[this.count++] = (char)n2;
    }

    private String bufferString() {
        return new String(this.buffer, 0, this.count);
    }

    public Scanner(Environment environment, InputStream inputStream) throws IOException {
        this.env = environment;
        this.useInputStream(inputStream);
    }

    protected void useInputStream(InputStream inputStream) throws IOException {
        try {
            this.in = new ScannerInputReader(this.env, inputStream);
        }
        catch (Exception exception) {
            this.env.setCharacterEncoding(null);
            this.in = new ScannerInputReader(this.env, inputStream);
        }
        this.ch = this.in.read();
        this.prevPos = this.in.pos;
        this.scan();
    }

    protected Scanner(Environment environment) {
        this.env = environment;
    }

    private static void defineKeyword(int n2) {
        Identifier.lookup(Constants.opNames[n2]).setType(n2);
    }

    private void skipComment() throws IOException {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.comment");
                    return;
                }
                case 42: {
                    this.ch = this.in.read();
                    if (this.ch != 47) continue block4;
                    this.ch = this.in.read();
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    private String scanDocComment() throws IOException {
        int n2;
        ScannerInputReader scannerInputReader = this.in;
        char[] cArray = this.buffer;
        int n3 = 0;
        while ((n2 = scannerInputReader.read()) == 42) {
        }
        if (n2 == 47) {
            this.ch = scannerInputReader.read();
            return "";
        }
        if (n2 == 10) {
            n2 = scannerInputReader.read();
        }
        block12: while (true) {
            switch (n2) {
                case 9: 
                case 32: {
                    n2 = scannerInputReader.read();
                    continue block12;
                }
            }
            if (n2 == 42) {
                while ((n2 = scannerInputReader.read()) == 42) {
                }
                if (n2 == 47) {
                    this.ch = scannerInputReader.read();
                    break;
                }
            }
            block14: while (true) {
                switch (n2) {
                    case -1: {
                        this.env.error(this.pos, "eof.in.comment");
                        this.ch = -1;
                        break block12;
                    }
                    case 42: {
                        n2 = scannerInputReader.read();
                        if (n2 == 47) {
                            this.ch = scannerInputReader.read();
                            break block12;
                        }
                        if (n3 == cArray.length) {
                            this.growBuffer();
                            cArray = this.buffer;
                        }
                        cArray[n3++] = 42;
                        continue block14;
                    }
                    case 10: {
                        if (n3 == cArray.length) {
                            this.growBuffer();
                            cArray = this.buffer;
                        }
                        cArray[n3++] = 10;
                        n2 = scannerInputReader.read();
                        continue block12;
                    }
                    default: {
                        if (n3 == cArray.length) {
                            this.growBuffer();
                            cArray = this.buffer;
                        }
                        cArray[n3++] = (char)n2;
                        n2 = scannerInputReader.read();
                        continue block14;
                    }
                }
                break;
            }
            break;
        }
        if (n3 > 0) {
            int n4 = n3 - 1;
            block15: while (n4 > -1) {
                switch (cArray[n4]) {
                    case '\t': 
                    case ' ': 
                    case '*': {
                        --n4;
                        break;
                    }
                    default: {
                        break block15;
                    }
                }
            }
            n3 = n4 + 1;
            return new String(cArray, 0, n3);
        }
        return "";
    }

    private void scanNumber() throws IOException {
        block26: {
            boolean bl;
            block29: {
                long l2;
                block28: {
                    boolean bl2;
                    block27: {
                        boolean bl3;
                        block25: {
                            bl3 = false;
                            bl = false;
                            bl2 = false;
                            this.radix = this.ch == 48 ? 8 : 10;
                            l2 = this.ch - 48;
                            this.count = 0;
                            this.putc(this.ch);
                            block19: while (true) {
                                this.ch = this.in.read();
                                switch (this.ch) {
                                    case 46: {
                                        if (this.radix == 16) break block19;
                                        this.scanReal();
                                        return;
                                    }
                                    case 56: 
                                    case 57: {
                                        bl3 = true;
                                    }
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: {
                                        bl2 = true;
                                        this.putc(this.ch);
                                        if (this.radix == 10) {
                                            bl = bl || l2 * 10L / 10L != l2;
                                            l2 = l2 * 10L + (long)(this.ch - 48);
                                            bl = bl || l2 - 1L < -1L;
                                            continue block19;
                                        }
                                        if (this.radix == 8) {
                                            bl = bl || l2 >>> 61 != 0L;
                                            l2 = (l2 << 3) + (long)(this.ch - 48);
                                            continue block19;
                                        }
                                        bl = bl || l2 >>> 60 != 0L;
                                        l2 = (l2 << 4) + (long)(this.ch - 48);
                                        continue block19;
                                    }
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        if (this.radix != 16) {
                                            this.scanReal();
                                            return;
                                        }
                                    }
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 97: 
                                    case 98: 
                                    case 99: {
                                        bl2 = true;
                                        this.putc(this.ch);
                                        if (this.radix != 16) break block19;
                                        bl = bl || l2 >>> 60 != 0L;
                                        l2 = (l2 << 4) + 10L + (long)Character.toLowerCase((char)this.ch) - 97L;
                                        continue block19;
                                    }
                                    case 76: 
                                    case 108: {
                                        this.ch = this.in.read();
                                        this.longValue = l2;
                                        this.token = 66;
                                        break block19;
                                    }
                                    case 88: 
                                    case 120: {
                                        if (this.count != 1 || this.radix != 8) break block19;
                                        this.radix = 16;
                                        bl2 = false;
                                        continue block19;
                                    }
                                    default: {
                                        this.intValue = (int)l2;
                                        this.token = 65;
                                        break block19;
                                    }
                                }
                                break;
                            }
                            if (!Character.isJavaLetterOrDigit((char)this.ch) && this.ch != 46) break block25;
                            this.env.error(this.in.pos, "invalid.number");
                            do {
                                this.ch = this.in.read();
                            } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
                            this.intValue = 0;
                            this.token = 65;
                            break block26;
                        }
                        if (this.radix != 8 || !bl3) break block27;
                        this.intValue = 0;
                        this.token = 65;
                        this.env.error(this.pos, "invalid.octal.number");
                        break block26;
                    }
                    if (this.radix != 16 || bl2) break block28;
                    this.intValue = 0;
                    this.token = 65;
                    this.env.error(this.pos, "invalid.hex.number");
                    break block26;
                }
                if (this.token != 65) break block29;
                boolean bl4 = bl = bl || (l2 & 0xFFFFFFFF00000000L) != 0L || this.radix == 10 && l2 > 0x80000000L;
                if (!bl) break block26;
                this.intValue = 0;
                switch (this.radix) {
                    case 8: {
                        this.env.error(this.pos, "overflow.int.oct");
                        break block26;
                    }
                    case 10: {
                        this.env.error(this.pos, "overflow.int.dec");
                        break block26;
                    }
                    case 16: {
                        this.env.error(this.pos, "overflow.int.hex");
                        break block26;
                    }
                    default: {
                        throw new CompilerError("invalid radix");
                    }
                }
            }
            if (bl) {
                this.longValue = 0L;
                switch (this.radix) {
                    case 8: {
                        this.env.error(this.pos, "overflow.long.oct");
                        break;
                    }
                    case 10: {
                        this.env.error(this.pos, "overflow.long.dec");
                        break;
                    }
                    case 16: {
                        this.env.error(this.pos, "overflow.long.hex");
                        break;
                    }
                    default: {
                        throw new CompilerError("invalid radix");
                    }
                }
            }
        }
    }

    private void scanReal() throws IOException {
        block20: {
            char c2;
            boolean bl = false;
            boolean bl2 = false;
            if (this.ch == 46) {
                this.putc(this.ch);
                this.ch = this.in.read();
            }
            block9: while (true) {
                switch (this.ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.putc(this.ch);
                        break;
                    }
                    case 69: 
                    case 101: {
                        if (bl) break block9;
                        this.putc(this.ch);
                        bl = true;
                        break;
                    }
                    case 43: 
                    case 45: {
                        c2 = this.buffer[this.count - 1];
                        if (c2 != 'e' && c2 != 'E') break block9;
                        this.putc(this.ch);
                        break;
                    }
                    case 70: 
                    case 102: {
                        this.ch = this.in.read();
                        bl2 = true;
                        break block9;
                    }
                    case 68: 
                    case 100: {
                        this.ch = this.in.read();
                    }
                    default: {
                        break block9;
                    }
                }
                this.ch = this.in.read();
            }
            if (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46) {
                this.env.error(this.in.pos, "invalid.number");
                do {
                    this.ch = this.in.read();
                } while (Character.isJavaLetterOrDigit((char)this.ch) || this.ch == 46);
                this.doubleValue = 0.0;
                this.token = 68;
            } else {
                this.token = bl2 ? 67 : 68;
                try {
                    c2 = this.buffer[this.count - 1];
                    if (c2 == 'e' || c2 == 'E' || c2 == '+' || c2 == '-') {
                        this.env.error(this.in.pos - 1L, "float.format");
                        break block20;
                    }
                    if (bl2) {
                        String string = this.bufferString();
                        this.floatValue = Float.valueOf(string).floatValue();
                        if (Float.isInfinite(this.floatValue)) {
                            this.env.error(this.pos, "overflow.float");
                            break block20;
                        }
                        if (this.floatValue != 0.0f || Scanner.looksLikeZero(string)) break block20;
                        this.env.error(this.pos, "underflow.float");
                        break block20;
                    }
                    String string = this.bufferString();
                    this.doubleValue = Double.valueOf(string);
                    if (Double.isInfinite(this.doubleValue)) {
                        this.env.error(this.pos, "overflow.double");
                    } else if (this.doubleValue == 0.0 && !Scanner.looksLikeZero(string)) {
                        this.env.error(this.pos, "underflow.double");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.env.error(this.pos, "float.format");
                    this.doubleValue = 0.0;
                    this.floatValue = 0.0f;
                }
            }
        }
    }

    private static boolean looksLikeZero(String string) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            switch (string.charAt(n3)) {
                case '\u0000': 
                case '.': {
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'E': 
                case 'F': 
                case 'e': 
                case 'f': {
                    return true;
                }
            }
            ++n3;
        }
        return true;
    }

    private int scanEscapeChar() throws IOException {
        long l2 = this.in.pos;
        this.ch = this.in.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n2 = this.ch - 48;
                int n3 = 2;
                while (n3 > 0) {
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n2 = (n2 << 3) + this.ch - 48;
                            break;
                        }
                        default: {
                            if (n2 > 255) {
                                this.env.error(l2, "invalid.escape.char");
                            }
                            return n2;
                        }
                    }
                    --n3;
                }
                this.ch = this.in.read();
                if (n2 > 255) {
                    this.env.error(l2, "invalid.escape.char");
                }
                return n2;
            }
            case 114: {
                this.ch = this.in.read();
                return 13;
            }
            case 110: {
                this.ch = this.in.read();
                return 10;
            }
            case 102: {
                this.ch = this.in.read();
                return 12;
            }
            case 98: {
                this.ch = this.in.read();
                return 8;
            }
            case 116: {
                this.ch = this.in.read();
                return 9;
            }
            case 92: {
                this.ch = this.in.read();
                return 92;
            }
            case 34: {
                this.ch = this.in.read();
                return 34;
            }
            case 39: {
                this.ch = this.in.read();
                return 39;
            }
        }
        this.env.error(l2, "invalid.escape.char");
        this.ch = this.in.read();
        return -1;
    }

    private void scanString() throws IOException {
        this.token = 69;
        this.count = 0;
        this.ch = this.in.read();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.env.error(this.pos, "eof.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 10: 
                case 13: {
                    this.ch = this.in.read();
                    this.env.error(this.pos, "newline.in.string");
                    this.stringValue = this.bufferString();
                    return;
                }
                case 34: {
                    this.ch = this.in.read();
                    this.stringValue = this.bufferString();
                    return;
                }
                case 92: {
                    int n2 = this.scanEscapeChar();
                    if (n2 < 0) continue block6;
                    this.putc((char)n2);
                    continue block6;
                }
            }
            this.putc(this.ch);
            this.ch = this.in.read();
        }
    }

    private void scanCharacter() throws IOException {
        this.token = 63;
        this.ch = this.in.read();
        switch (this.ch) {
            case 92: {
                int n2 = this.scanEscapeChar();
                this.charValue = (char)(n2 >= 0 ? n2 : 0);
                break;
            }
            case 39: {
                this.charValue = '\u0000';
                this.env.error(this.pos, "invalid.char.constant");
                this.ch = this.in.read();
                while (this.ch == 39) {
                    this.ch = this.in.read();
                }
                return;
            }
            case 10: 
            case 13: {
                this.charValue = '\u0000';
                this.env.error(this.pos, "invalid.char.constant");
                return;
            }
            default: {
                this.charValue = (char)this.ch;
                this.ch = this.in.read();
            }
        }
        if (this.ch != 39) {
            this.env.error(this.pos, "invalid.char.constant");
            while (true) {
                switch (this.ch) {
                    case 39: {
                        this.ch = this.in.read();
                        return;
                    }
                    case -1: 
                    case 10: 
                    case 59: {
                        return;
                    }
                }
                this.ch = this.in.read();
            }
        }
        this.ch = this.in.read();
    }

    private void scanIdentifier() throws IOException {
        this.count = 0;
        block3: while (true) {
            this.putc(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 36: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block3;
                }
            }
            if (!Character.isJavaLetterOrDigit((char)this.ch)) break;
        }
        this.idValue = Identifier.lookup(this.bufferString());
        this.token = this.idValue.getType();
    }

    public long getEndPos() {
        return this.in.pos;
    }

    public IdentifierToken getIdToken() {
        return this.token != 60 ? null : new IdentifierToken(this.pos, this.idValue);
    }

    public long scan() throws IOException {
        return this.xscan();
    }

    protected long xscan() throws IOException {
        ScannerInputReader scannerInputReader = this.in;
        long l2 = this.pos;
        this.prevPos = scannerInputReader.pos;
        this.docComment = null;
        block70: while (true) {
            this.pos = scannerInputReader.pos;
            switch (this.ch) {
                case -1: {
                    this.token = -1;
                    return l2;
                }
                case 10: {
                    if (this.scanComments) {
                        this.ch = 32;
                        this.token = 146;
                        return l2;
                    }
                }
                case 9: 
                case 12: 
                case 32: {
                    this.ch = scannerInputReader.read();
                    continue block70;
                }
                case 47: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 47: {
                            while ((this.ch = scannerInputReader.read()) != -1 && this.ch != 10) {
                            }
                            if (!this.scanComments) continue block70;
                            this.token = 146;
                            return l2;
                        }
                        case 42: {
                            this.ch = scannerInputReader.read();
                            if (this.ch == 42) {
                                this.docComment = this.scanDocComment();
                            } else {
                                this.skipComment();
                            }
                            if (!this.scanComments) continue block70;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 3;
                            return l2;
                        }
                    }
                    this.token = 31;
                    return l2;
                }
                case 34: {
                    this.scanString();
                    return l2;
                }
                case 39: {
                    this.scanCharacter();
                    return l2;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanNumber();
                    return l2;
                }
                case 46: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.count = 0;
                            this.putc(46);
                            this.scanReal();
                            break;
                        }
                        default: {
                            this.token = 46;
                        }
                    }
                    return l2;
                }
                case 123: {
                    this.ch = scannerInputReader.read();
                    this.token = 138;
                    return l2;
                }
                case 125: {
                    this.ch = scannerInputReader.read();
                    this.token = 139;
                    return l2;
                }
                case 40: {
                    this.ch = scannerInputReader.read();
                    this.token = 140;
                    return l2;
                }
                case 41: {
                    this.ch = scannerInputReader.read();
                    this.token = 141;
                    return l2;
                }
                case 91: {
                    this.ch = scannerInputReader.read();
                    this.token = 142;
                    return l2;
                }
                case 93: {
                    this.ch = scannerInputReader.read();
                    this.token = 143;
                    return l2;
                }
                case 44: {
                    this.ch = scannerInputReader.read();
                    this.token = 0;
                    return l2;
                }
                case 59: {
                    this.ch = scannerInputReader.read();
                    this.token = 135;
                    return l2;
                }
                case 63: {
                    this.ch = scannerInputReader.read();
                    this.token = 137;
                    return l2;
                }
                case 126: {
                    this.ch = scannerInputReader.read();
                    this.token = 38;
                    return l2;
                }
                case 58: {
                    this.ch = scannerInputReader.read();
                    this.token = 136;
                    return l2;
                }
                case 45: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 45: {
                            this.ch = scannerInputReader.read();
                            this.token = 51;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 6;
                            return l2;
                        }
                    }
                    this.token = 30;
                    return l2;
                }
                case 43: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 43: {
                            this.ch = scannerInputReader.read();
                            this.token = 50;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 5;
                            return l2;
                        }
                    }
                    this.token = 29;
                    return l2;
                }
                case 60: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 60: {
                            this.ch = scannerInputReader.read();
                            if (this.ch == 61) {
                                this.ch = scannerInputReader.read();
                                this.token = 7;
                                return l2;
                            }
                            this.token = 26;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 23;
                            return l2;
                        }
                    }
                    this.token = 24;
                    return l2;
                }
                case 62: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 62: {
                            this.ch = scannerInputReader.read();
                            switch (this.ch) {
                                case 61: {
                                    this.ch = scannerInputReader.read();
                                    this.token = 8;
                                    return l2;
                                }
                                case 62: {
                                    this.ch = scannerInputReader.read();
                                    if (this.ch == 61) {
                                        this.ch = scannerInputReader.read();
                                        this.token = 9;
                                        return l2;
                                    }
                                    this.token = 28;
                                    return l2;
                                }
                            }
                            this.token = 27;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 21;
                            return l2;
                        }
                    }
                    this.token = 22;
                    return l2;
                }
                case 124: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 124: {
                            this.ch = scannerInputReader.read();
                            this.token = 14;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 11;
                            return l2;
                        }
                    }
                    this.token = 16;
                    return l2;
                }
                case 38: {
                    this.ch = scannerInputReader.read();
                    switch (this.ch) {
                        case 38: {
                            this.ch = scannerInputReader.read();
                            this.token = 15;
                            return l2;
                        }
                        case 61: {
                            this.ch = scannerInputReader.read();
                            this.token = 10;
                            return l2;
                        }
                    }
                    this.token = 18;
                    return l2;
                }
                case 61: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == 61) {
                        this.ch = scannerInputReader.read();
                        this.token = 20;
                        return l2;
                    }
                    this.token = 1;
                    return l2;
                }
                case 37: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == 61) {
                        this.ch = scannerInputReader.read();
                        this.token = 4;
                        return l2;
                    }
                    this.token = 32;
                    return l2;
                }
                case 94: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == 61) {
                        this.ch = scannerInputReader.read();
                        this.token = 12;
                        return l2;
                    }
                    this.token = 17;
                    return l2;
                }
                case 33: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == 61) {
                        this.ch = scannerInputReader.read();
                        this.token = 19;
                        return l2;
                    }
                    this.token = 37;
                    return l2;
                }
                case 42: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == 61) {
                        this.ch = scannerInputReader.read();
                        this.token = 2;
                        return l2;
                    }
                    this.token = 33;
                    return l2;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.scanIdentifier();
                    return l2;
                }
                case 26: {
                    this.ch = scannerInputReader.read();
                    if (this.ch == -1) {
                        this.token = -1;
                        return l2;
                    }
                    this.env.error(this.pos, "funny.char");
                    this.ch = scannerInputReader.read();
                    continue block70;
                }
            }
            if (Character.isJavaLetter((char)this.ch)) {
                this.scanIdentifier();
                return l2;
            }
            this.env.error(this.pos, "funny.char");
            this.ch = scannerInputReader.read();
        }
    }

    public void match(int n2, int n3) throws IOException {
        int n4 = 1;
        while (true) {
            this.scan();
            if (this.token == n2) {
                ++n4;
                continue;
            }
            if (this.token == n3) {
                if (--n4 != 0) continue;
                return;
            }
            if (this.token == -1) break;
        }
        this.env.error(this.pos, "unbalanced.paren");
    }

    static {
        Scanner.defineKeyword(92);
        Scanner.defineKeyword(90);
        Scanner.defineKeyword(91);
        Scanner.defineKeyword(93);
        Scanner.defineKeyword(94);
        Scanner.defineKeyword(95);
        Scanner.defineKeyword(96);
        Scanner.defineKeyword(97);
        Scanner.defineKeyword(98);
        Scanner.defineKeyword(99);
        Scanner.defineKeyword(100);
        Scanner.defineKeyword(101);
        Scanner.defineKeyword(102);
        Scanner.defineKeyword(103);
        Scanner.defineKeyword(104);
        Scanner.defineKeyword(70);
        Scanner.defineKeyword(71);
        Scanner.defineKeyword(72);
        Scanner.defineKeyword(73);
        Scanner.defineKeyword(74);
        Scanner.defineKeyword(75);
        Scanner.defineKeyword(76);
        Scanner.defineKeyword(77);
        Scanner.defineKeyword(78);
        Scanner.defineKeyword(25);
        Scanner.defineKeyword(80);
        Scanner.defineKeyword(81);
        Scanner.defineKeyword(49);
        Scanner.defineKeyword(82);
        Scanner.defineKeyword(83);
        Scanner.defineKeyword(84);
        Scanner.defineKeyword(110);
        Scanner.defineKeyword(111);
        Scanner.defineKeyword(112);
        Scanner.defineKeyword(113);
        Scanner.defineKeyword(114);
        Scanner.defineKeyword(115);
        Scanner.defineKeyword(144);
        Scanner.defineKeyword(120);
        Scanner.defineKeyword(121);
        Scanner.defineKeyword(122);
        Scanner.defineKeyword(124);
        Scanner.defineKeyword(125);
        Scanner.defineKeyword(126);
        Scanner.defineKeyword(127);
        Scanner.defineKeyword(130);
        Scanner.defineKeyword(129);
        Scanner.defineKeyword(128);
        Scanner.defineKeyword(131);
        Scanner.defineKeyword(123);
        Scanner.defineKeyword(58);
    }
}

