/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.ImportEnvironment;

public class Imports
implements Constants {
    Identifier currentPackage = Constants.idNull;
    long currentPackageWhere = 0L;
    Hashtable classes = new Hashtable();
    Vector packages = new Vector();
    Vector singles = new Vector();
    protected int checked;

    public Imports(Environment environment) {
        this.addPackage(Constants.idJavaLang);
    }

    public synchronized void resolve(Environment environment) {
        Object object;
        Object object2;
        if (this.checked != 0) {
            return;
        }
        this.checked = -1;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (IdentifierToken)enumeration.nextElement();
            object = ((IdentifierToken)object2).getName();
            long l2 = ((IdentifierToken)object2).getWhere();
            if (environment.isExemptPackage((Identifier)object)) {
                vector.addElement(object2);
                continue;
            }
            try {
                Identifier identifier = environment.resolvePackageQualifiedName((Identifier)object);
                if (Imports.importable(identifier, environment)) {
                    if (environment.getPackage(identifier.getTopName()).exists()) {
                        environment.error(l2, "class.and.package", identifier.getTopName());
                    }
                    if (!identifier.isInner()) {
                        identifier = Identifier.lookupInner(identifier, Constants.idNull);
                    }
                    object = identifier;
                } else if (!environment.getPackage((Identifier)object).exists()) {
                    environment.error(l2, "package.not.found", object, "import");
                } else if (identifier.isInner()) {
                    environment.error(l2, "class.and.package", identifier.getTopName());
                }
                vector.addElement(new IdentifierToken(l2, (Identifier)object));
            }
            catch (IOException iOException) {
                environment.error(l2, "io.exception", "import");
            }
        }
        this.packages = vector;
        object2 = this.singles.elements();
        block6: while (object2.hasMoreElements()) {
            Constants constants;
            Constants constants2;
            Identifier identifier;
            Identifier identifier2;
            object = (IdentifierToken)object2.nextElement();
            Identifier identifier3 = ((IdentifierToken)object).getName();
            long l3 = ((IdentifierToken)object).getWhere();
            Identifier identifier4 = identifier3.getQualifier();
            if (!environment.classExists((identifier3 = environment.resolvePackageQualifiedName(identifier3)).getTopName())) {
                environment.error(l3, "class.not.found", identifier3, "import");
            }
            if ((identifier2 = (Identifier)this.classes.get(identifier = identifier3.getFlatName().getName())) != null && !(constants2 = Identifier.lookup(identifier2.getQualifier(), identifier2.getFlatName())).equals(constants = Identifier.lookup(identifier3.getQualifier(), identifier3.getFlatName()))) {
                environment.error(l3, "ambig.class", identifier3, identifier2);
            }
            this.classes.put(identifier, identifier3);
            try {
                constants2 = environment.getClassDeclaration(identifier3);
                constants = ((ClassDeclaration)constants2).getClassDefinitionNoCheck(environment);
                Identifier identifier5 = ((ClassDefinition)constants).getName().getQualifier();
                while (constants != null) {
                    if (((ClassDefinition)constants).isPrivate() || !((ClassDefinition)constants).isPublic() && !identifier5.equals(this.currentPackage)) {
                        environment.error(l3, "cant.access.class", constants);
                        continue block6;
                    }
                    constants = ((ClassDefinition)constants).getOuterClass();
                }
            }
            catch (AmbiguousClass ambiguousClass) {
                environment.error(l3, "ambig.class", ambiguousClass.name1, ambiguousClass.name2);
            }
            catch (ClassNotFound classNotFound) {
                environment.error(l3, "class.not.found", classNotFound.name, "import");
            }
        }
        this.checked = 1;
    }

    public synchronized Identifier resolve(Environment environment, Identifier identifier) throws ClassNotFound {
        Identifier identifier2;
        environment.dtEnter("Imports.resolve: " + identifier);
        if (identifier.hasAmbigPrefix()) {
            identifier = identifier.removeAmbigPrefix();
        }
        if (identifier.isQualified()) {
            environment.dtExit("Imports.resolve: QUALIFIED " + identifier);
            return identifier;
        }
        if (this.checked <= 0) {
            this.checked = 0;
            this.resolve(environment);
        }
        if ((identifier2 = (Identifier)this.classes.get(identifier)) != null) {
            environment.dtExit("Imports.resolve: PREVIOUSLY IMPORTED " + identifier);
            return identifier2;
        }
        Identifier identifier3 = Identifier.lookup(this.currentPackage, identifier);
        if (Imports.importable(identifier3, environment)) {
            identifier2 = identifier3;
        } else {
            Enumeration enumeration = this.packages.elements();
            while (enumeration.hasMoreElements()) {
                IdentifierToken identifierToken = (IdentifierToken)enumeration.nextElement();
                identifier3 = Identifier.lookup(identifierToken.getName(), identifier);
                if (!Imports.importable(identifier3, environment)) continue;
                if (identifier2 == null) {
                    identifier2 = identifier3;
                    continue;
                }
                environment.dtExit("Imports.resolve: AMBIGUOUS " + identifier);
                throw new AmbiguousClass(identifier2, identifier3);
            }
        }
        if (identifier2 == null) {
            environment.dtExit("Imports.resolve: NOT FOUND " + identifier);
            throw new ClassNotFound(identifier);
        }
        this.classes.put(identifier, identifier2);
        environment.dtExit("Imports.resolve: FIRST IMPORT " + identifier);
        return identifier2;
    }

    public static boolean importable(Identifier identifier, Environment environment) {
        if (!identifier.isInner()) {
            return environment.classExists(identifier);
        }
        if (!environment.classExists(identifier.getTopName())) {
            return false;
        }
        try {
            ClassDeclaration classDeclaration = environment.getClassDeclaration(identifier.getTopName());
            ClassDefinition classDefinition = classDeclaration.getClassDefinitionNoCheck(environment);
            return classDefinition.innerClassExists(identifier.getFlatName().getTail());
        }
        catch (ClassNotFound classNotFound) {
            return false;
        }
    }

    public synchronized Identifier forceResolve(Environment environment, Identifier identifier) {
        if (identifier.isQualified()) {
            return identifier;
        }
        Identifier identifier2 = (Identifier)this.classes.get(identifier);
        if (identifier2 != null) {
            return identifier2;
        }
        identifier2 = Identifier.lookup(this.currentPackage, identifier);
        this.classes.put(identifier, identifier2);
        return identifier2;
    }

    public synchronized void addClass(IdentifierToken identifierToken) {
        this.singles.addElement(identifierToken);
    }

    public void addClass(Identifier identifier) throws AmbiguousClass {
        this.addClass(new IdentifierToken(identifier));
    }

    public synchronized void addPackage(IdentifierToken identifierToken) {
        Identifier identifier = identifierToken.getName();
        if (identifier == this.currentPackage) {
            return;
        }
        int n2 = this.packages.size();
        int n3 = 0;
        while (n3 < n2) {
            if (identifier == ((IdentifierToken)this.packages.elementAt(n3)).getName()) {
                return;
            }
            ++n3;
        }
        this.packages.addElement(identifierToken);
    }

    public void addPackage(Identifier identifier) {
        this.addPackage(new IdentifierToken(identifier));
    }

    public synchronized void setCurrentPackage(IdentifierToken identifierToken) {
        this.currentPackage = identifierToken.getName();
        this.currentPackageWhere = identifierToken.getWhere();
    }

    public synchronized void setCurrentPackage(Identifier identifier) {
        this.currentPackage = identifier;
    }

    public Identifier getCurrentPackage() {
        return this.currentPackage;
    }

    public List getImportedPackages() {
        return Collections.unmodifiableList(this.packages);
    }

    public List getImportedClasses() {
        return Collections.unmodifiableList(this.singles);
    }

    public Environment newEnvironment(Environment environment) {
        return new ImportEnvironment(environment, this);
    }
}

