/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPathEntry;

public class ClassPath {
    static final char dirSeparator = File.pathSeparatorChar;
    String pathstr;
    private ClassPathEntry[] path;
    private final String fileSeparatorChar = "" + File.separatorChar;

    public ClassPath(String string) {
        this.init(string);
    }

    public ClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        String string2 = System.getProperty("env.class.path");
        if (string2 == null) {
            string2 = ".";
        }
        String string3 = string + File.pathSeparator + string2;
        this.init(string3);
    }

    private void init(String string) {
        this.pathstr = string;
        if (string.length() == 0) {
            this.path = new ClassPathEntry[0];
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(dirSeparator, n3)) != -1) {
            ++n2;
            ++n3;
        }
        ClassPathEntry[] classPathEntryArray = new ClassPathEntry[n2 + 1];
        int n4 = string.length();
        n2 = 0;
        n3 = 0;
        while (n3 < n4) {
            int n5 = string.indexOf(dirSeparator, n3);
            if (n5 == -1) {
                n5 = n4;
            }
            if (n3 == n5) {
                classPathEntryArray[n2] = new ClassPathEntry();
                classPathEntryArray[n2++].dir = new File(".");
            } else {
                File file = new File(string.substring(n3, n5));
                if (file.isFile()) {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        classPathEntryArray[n2] = new ClassPathEntry();
                        classPathEntryArray[n2++].zip = zipFile;
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {}
                } else {
                    classPathEntryArray[n2] = new ClassPathEntry();
                    classPathEntryArray[n2++].dir = file;
                }
            }
            n3 = n5 + 1;
        }
        this.path = new ClassPathEntry[n2];
        System.arraycopy(classPathEntryArray, 0, this.path, 0, n2);
    }

    public ClassFile getDirectory(String string) {
        return this.getFile(string, true);
    }

    public ClassFile getFile(String string) {
        return this.getFile(string, false);
    }

    private ClassFile getFile(String string, boolean bl) {
        int n2;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            n2 = string.lastIndexOf(File.separatorChar);
            string2 = string.substring(0, n2 + 1);
            string3 = string.substring(n2 + 1);
        } else if (!string2.equals("") && !string2.endsWith(this.fileSeparatorChar)) {
            string = string2 = string2 + File.separatorChar;
        }
        n2 = 0;
        while (n2 < this.path.length) {
            String[] stringArray;
            Object object;
            if (this.path[n2].zip != null) {
                object = string.replace(File.separatorChar, '/');
                stringArray = this.path[n2].zip.getEntry((String)object);
                if (stringArray != null) {
                    return new ClassFile(this.path[n2].zip, (ZipEntry)stringArray);
                }
            } else {
                object = new File(this.path[n2].dir.getPath(), string);
                stringArray = this.path[n2].getFiles(string2);
                if (bl) {
                    if (stringArray.length > 0) {
                        return new ClassFile((File)object);
                    }
                } else {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (string3.equals(stringArray[n3])) {
                            return new ClassFile((File)object);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public Enumeration getFiles(String string, String string2) {
        Hashtable<String, ClassFile> hashtable = new Hashtable<String, ClassFile>();
        int n2 = this.path.length;
        while (--n2 >= 0) {
            String string3;
            String[] stringArray;
            if (this.path[n2].zip != null) {
                stringArray = this.path[n2].zip.entries();
                while (stringArray.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)stringArray.nextElement();
                    string3 = zipEntry.getName();
                    if (!(string3 = string3.replace('/', File.separatorChar)).startsWith(string) || !string3.endsWith(string2)) continue;
                    hashtable.put(string3, new ClassFile(this.path[n2].zip, zipEntry));
                }
                continue;
            }
            stringArray = this.path[n2].getFiles(string);
            int n3 = 0;
            while (n3 < stringArray.length) {
                string3 = stringArray[n3];
                if (string3.endsWith(string2)) {
                    string3 = string + File.separatorChar + string3;
                    File file = new File(this.path[n2].dir.getPath(), string3);
                    hashtable.put(string3, new ClassFile(file));
                }
                ++n3;
            }
        }
        return hashtable.elements();
    }

    public void close() throws IOException {
        int n2 = this.path.length;
        while (--n2 >= 0) {
            if (this.path[n2].zip == null) continue;
            this.path[n2].zip.close();
        }
    }

    public String toString() {
        return this.pathstr;
    }
}

