/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public final class ClassDeclaration
implements Constants {
    int status;
    Type type;
    ClassDefinition definition;
    private boolean found = false;

    public ClassDeclaration(Identifier identifier) {
        this.type = Type.tClass(identifier);
    }

    public int getStatus() {
        return this.status;
    }

    public Identifier getName() {
        return this.type.getClassName();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDefined() {
        switch (this.status) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public ClassDefinition getClassDefinition() {
        return this.definition;
    }

    public ClassDefinition getClassDefinition(Environment environment) throws ClassNotFound {
        environment.dtEvent("getClassDefinition: " + this.getName() + ", status " + this.getStatus());
        if (this.found) {
            return this.definition;
        }
        block5: while (true) {
            switch (this.status) {
                case 0: 
                case 1: 
                case 3: {
                    environment.loadDefinition(this);
                    continue block5;
                }
                case 2: 
                case 4: {
                    if (!this.definition.isInsideLocal()) {
                        this.definition.basicCheck(environment);
                    }
                    this.found = true;
                    return this.definition;
                }
                case 5: 
                case 6: {
                    this.found = true;
                    return this.definition;
                }
            }
            break;
        }
        throw new ClassNotFound(this.getName());
    }

    public ClassDefinition getClassDefinitionNoCheck(Environment environment) throws ClassNotFound {
        environment.dtEvent("getClassDefinition: " + this.getName() + ", status " + this.getStatus());
        block4: while (true) {
            switch (this.status) {
                case 0: 
                case 1: 
                case 3: {
                    environment.loadDefinition(this);
                    continue block4;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return this.definition;
                }
            }
            break;
        }
        throw new ClassNotFound(this.getName());
    }

    public void setDefinition(ClassDefinition classDefinition, int n2) {
        if (classDefinition != null && !this.getName().equals(classDefinition.getName())) {
            throw new CompilerError("setDefinition: name mismatch: " + this + ", " + classDefinition);
        }
        this.definition = classDefinition;
        this.status = n2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ClassDeclaration) {
            return this.type.equals(((ClassDeclaration)object).type);
        }
        return false;
    }

    public String toString() {
        String string;
        String string2 = this.getName().toString();
        String string3 = "type ";
        String string4 = string = this.getName().isInner() ? "nested " : "";
        if (this.getClassDefinition() != null) {
            string3 = this.getClassDefinition().isInterface() ? "interface " : "class ";
            if (!this.getClassDefinition().isTopLevel()) {
                string = "inner ";
                if (this.getClassDefinition().isLocal()) {
                    string = "local ";
                    if (!this.getClassDefinition().isAnonymous()) {
                        string2 = this.getClassDefinition().getLocalName() + " (" + string2 + ")";
                    }
                }
            }
        }
        return string + string3 + string2;
    }
}

