/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public final class BinaryConstantPool
implements Constants {
    private byte[] types;
    private Object[] cpool;
    Hashtable indexHashObject;
    Hashtable indexHashAscii;
    Vector MoreStuff;

    BinaryConstantPool(DataInputStream dataInputStream) throws IOException {
        this.types = new byte[dataInputStream.readUnsignedShort()];
        this.cpool = new Object[this.types.length];
        int n2 = 1;
        while (n2 < this.cpool.length) {
            int n3 = n2;
            this.types[n2] = dataInputStream.readByte();
            switch (this.types[n2]) {
                case 1: {
                    this.cpool[n2] = dataInputStream.readUTF();
                    break;
                }
                case 3: {
                    this.cpool[n2] = new Integer(dataInputStream.readInt());
                    break;
                }
                case 4: {
                    this.cpool[n2] = new Float(dataInputStream.readFloat());
                    break;
                }
                case 5: {
                    this.cpool[n2++] = new Long(dataInputStream.readLong());
                    break;
                }
                case 6: {
                    this.cpool[n2++] = new Double(dataInputStream.readDouble());
                    break;
                }
                case 7: 
                case 8: {
                    this.cpool[n2] = new Integer(dataInputStream.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[n2] = new Integer(dataInputStream.readUnsignedShort() << 16 | dataInputStream.readUnsignedShort());
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[n2]);
                }
            }
            ++n2;
        }
    }

    public int getInteger(int n2) {
        return n2 == 0 ? 0 : ((Number)this.cpool[n2]).intValue();
    }

    public Object getValue(int n2) {
        return n2 == 0 ? null : this.cpool[n2];
    }

    public String getString(int n2) {
        return n2 == 0 ? null : (String)this.cpool[n2];
    }

    public Identifier getIdentifier(int n2) {
        return n2 == 0 ? null : Identifier.lookup(this.getString(n2));
    }

    public ClassDeclaration getDeclarationFromName(Environment environment, int n2) {
        return n2 == 0 ? null : environment.getClassDeclaration(Identifier.lookup(this.getString(n2).replace('/', '.')));
    }

    public ClassDeclaration getDeclaration(Environment environment, int n2) {
        return n2 == 0 ? null : this.getDeclarationFromName(environment, this.getInteger(n2));
    }

    public Type getType(int n2) {
        return Type.tType(this.getString(n2));
    }

    public int getConstantType(int n2) {
        return this.types[n2];
    }

    public Object getConstant(int n2, Environment environment) {
        int n3 = this.getConstantType(n2);
        switch (n3) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.getValue(n2);
            }
            case 7: {
                return this.getDeclaration(environment, n2);
            }
            case 8: {
                return this.getString(this.getInteger(n2));
            }
            case 9: 
            case 10: 
            case 11: {
                try {
                    int n4 = this.getInteger(n2);
                    ClassDefinition classDefinition = this.getDeclaration(environment, n4 >> 16).getClassDefinition(environment);
                    int n5 = this.getInteger(n4 & 0xFFFF);
                    Identifier identifier = this.getIdentifier(n5 >> 16);
                    Type type = this.getType(n5 & 0xFFFF);
                    MemberDefinition memberDefinition = classDefinition.getFirstMatch(identifier);
                    while (memberDefinition != null) {
                        Type type2 = memberDefinition.getType();
                        if (n3 == 9 ? type2 == type : type2.equalArguments(type)) {
                            return memberDefinition;
                        }
                        memberDefinition = memberDefinition.getNextMatch();
                    }
                }
                catch (ClassNotFound classNotFound) {
                    // empty catch block
                }
                return null;
            }
        }
        throw new ClassFormatError("invalid constant type: " + n3);
    }

    public Vector getDependencies(Environment environment) {
        Vector<ClassDeclaration> vector = new Vector<ClassDeclaration>();
        int n2 = 1;
        while (n2 < this.cpool.length) {
            switch (this.types[n2]) {
                case 7: {
                    vector.addElement(this.getDeclarationFromName(environment, this.getInteger(n2)));
                }
            }
            ++n2;
        }
        return vector;
    }

    public int indexObject(Object object, Environment environment) {
        Integer n2;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n2 = (Integer)this.indexHashObject.get(object)) == null) {
            throw new IndexOutOfBoundsException("Cannot find object " + object + " of type " + object.getClass() + " in constant pool");
        }
        return n2;
    }

    public int indexString(String string, Environment environment) {
        Integer n2;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n2 = (Integer)this.indexHashAscii.get(string)) == null) {
            if (this.MoreStuff == null) {
                this.MoreStuff = new Vector();
            }
            n2 = new Integer(this.cpool.length + this.MoreStuff.size());
            this.MoreStuff.addElement(string);
            this.indexHashAscii.put(string, n2);
        }
        return n2;
    }

    public void createIndexHash(Environment environment) {
        this.indexHashObject = new Hashtable();
        this.indexHashAscii = new Hashtable();
        int n2 = 1;
        while (n2 < this.cpool.length) {
            if (this.types[n2] == 1) {
                this.indexHashAscii.put(this.cpool[n2], new Integer(n2));
            } else {
                try {
                    this.indexHashObject.put(this.getConstant(n2, environment), new Integer(n2));
                }
                catch (ClassFormatError classFormatError) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void write(DataOutputStream dataOutputStream, Environment environment) throws IOException {
        Object object;
        int n2;
        int n3 = this.cpool.length;
        if (this.MoreStuff != null) {
            n3 += this.MoreStuff.size();
        }
        dataOutputStream.writeShort(n3);
        int n4 = 1;
        while (n4 < this.cpool.length) {
            n2 = this.types[n4];
            object = this.cpool[n4];
            dataOutputStream.writeByte(n2);
            switch (n2) {
                case 1: {
                    dataOutputStream.writeUTF((String)object);
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt(((Number)object).intValue());
                    break;
                }
                case 4: {
                    dataOutputStream.writeFloat(((Number)object).floatValue());
                    break;
                }
                case 5: {
                    dataOutputStream.writeLong(((Number)object).longValue());
                    ++n4;
                    break;
                }
                case 6: {
                    dataOutputStream.writeDouble(((Number)object).doubleValue());
                    ++n4;
                    break;
                }
                case 7: 
                case 8: {
                    dataOutputStream.writeShort(((Number)object).intValue());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int n5 = ((Number)object).intValue();
                    dataOutputStream.writeShort(n5 >> 16);
                    dataOutputStream.writeShort(n5 & 0xFFFF);
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[n4]);
                }
            }
            ++n4;
        }
        n2 = this.cpool.length;
        while (n2 < n3) {
            object = (String)this.MoreStuff.elementAt(n2 - this.cpool.length);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF((String)object);
            ++n2;
        }
    }
}

