/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.LocalVariable;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;

final class LocalVariableTable {
    LocalVariable[] locals = new LocalVariable[8];
    int len;

    LocalVariableTable() {
    }

    void define(MemberDefinition memberDefinition, int n2, int n3, int n4) {
        if (n3 >= n4) {
            return;
        }
        int n5 = 0;
        while (n5 < this.len) {
            if (this.locals[n5].field == memberDefinition && this.locals[n5].slot == n2 && n3 <= this.locals[n5].to && n4 >= this.locals[n5].from) {
                this.locals[n5].from = Math.min(this.locals[n5].from, n3);
                this.locals[n5].to = Math.max(this.locals[n5].to, n4);
                return;
            }
            ++n5;
        }
        if (this.len == this.locals.length) {
            LocalVariable[] localVariableArray = new LocalVariable[this.len * 2];
            System.arraycopy(this.locals, 0, localVariableArray, 0, this.len);
            this.locals = localVariableArray;
        }
        this.locals[this.len++] = new LocalVariable(memberDefinition, n2, n3, n4);
    }

    private void trim_ranges() {
        int n2 = 0;
        while (n2 < this.len) {
            int n3 = n2 + 1;
            while (n3 < this.len) {
                if (this.locals[n2].field.getName() == this.locals[n3].field.getName() && this.locals[n2].from <= this.locals[n3].to && this.locals[n2].to >= this.locals[n3].from) {
                    if (this.locals[n2].slot < this.locals[n3].slot) {
                        if (this.locals[n2].from < this.locals[n3].from) {
                            this.locals[n2].to = Math.min(this.locals[n2].to, this.locals[n3].from);
                        }
                    } else if (this.locals[n2].slot > this.locals[n3].slot && this.locals[n2].from > this.locals[n3].from) {
                        this.locals[n3].to = Math.min(this.locals[n3].to, this.locals[n2].from);
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    void write(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        this.trim_ranges();
        dataOutputStream.writeShort(this.len);
        int n2 = 0;
        while (n2 < this.len) {
            dataOutputStream.writeShort(this.locals[n2].from);
            dataOutputStream.writeShort(this.locals[n2].to - this.locals[n2].from);
            dataOutputStream.writeShort(constantPool.index(this.locals[n2].field.getName().toString()));
            dataOutputStream.writeShort(constantPool.index(this.locals[n2].field.getType().getTypeSignature()));
            dataOutputStream.writeShort(this.locals[n2].slot);
            ++n2;
        }
    }
}

