/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.tools.asm.CatchData;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.Cover;
import sun.tools.asm.Instruction;
import sun.tools.asm.Label;
import sun.tools.asm.LocalVariable;
import sun.tools.asm.LocalVariableTable;
import sun.tools.asm.SwitchData;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.javac.SourceClass;

public final class Assembler
implements Constants {
    static final int NOTREACHED = 0;
    static final int REACHED = 1;
    static final int NEEDED = 2;
    Label first = new Label();
    Instruction last = this.first;
    int maxdepth;
    int maxvar;
    int maxpc;
    static Vector SourceClassList = new Vector();
    static Vector TmpCovTable = new Vector();
    static int[] JcovClassCountArray = new int[9];
    static String JcovMagicLine = "JCOV-DATA-FILE-VERSION: 2.0";
    static String JcovClassLine = "CLASS: ";
    static String JcovSrcfileLine = "SRCFILE: ";
    static String JcovTimestampLine = "TIMESTAMP: ";
    static String JcovDataLine = "DATA: ";
    static String JcovHeadingLine = "#kind\tcount";
    static int[] arrayModifiers = new int[]{1, 2, 4, 1024, 16, 512};
    static int[] arrayModifiersOpc = new int[]{121, 120, 122, 130, 128, 114};

    public void add(Instruction instruction) {
        if (instruction != null) {
            this.last.next = instruction;
            this.last = instruction;
        }
    }

    public void add(long l2, int n2) {
        this.add(new Instruction(l2, n2, null));
    }

    public void add(long l2, int n2, Object object) {
        this.add(new Instruction(l2, n2, object));
    }

    public void add(long l2, int n2, Object object, boolean bl) {
        this.add(new Instruction(l2, n2, object, bl));
    }

    public void add(boolean bl, long l2, int n2, Object object) {
        this.add(new Instruction(bl, l2, n2, object));
    }

    public void add(long l2, int n2, boolean bl) {
        this.add(new Instruction(l2, n2, bl));
    }

    void optimize(Environment environment, Label label) {
        label.pc = 1;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.pc) {
                case 0: {
                    instruction.optimize(environment);
                    instruction.pc = 1;
                    break;
                }
                case 1: {
                    return;
                }
            }
            switch (instruction.opc) {
                case -2: 
                case -1: {
                    if (instruction.pc != 1) break;
                    instruction.pc = 0;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 167: {
                    this.optimize(environment, (Label)instruction.value);
                    return;
                }
                case 168: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.optimize(environment, ((SwitchData)object).defaultLabel);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.optimize(environment, (Label)enumeration.nextElement());
                    }
                    return;
                }
                case -3: {
                    Object object = (TryData)instruction.value;
                    ((TryData)object).getEndLabel().pc = 2;
                    Enumeration<Object> enumeration = ((TryData)object).catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.optimize(environment, catchData.getLabel());
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    boolean eliminate() {
        boolean bl = false;
        Instruction instruction = this.first;
        Instruction instruction2 = this.first.next;
        while (instruction2 != null) {
            if (instruction2.pc != 0) {
                instruction.next = instruction2;
                instruction = instruction2;
                instruction2.pc = 0;
            } else {
                bl = true;
            }
            instruction2 = instruction2.next;
        }
        this.first.pc = 0;
        instruction.next = null;
        return bl;
    }

    public void optimize(Environment environment) {
        do {
            this.optimize(environment, this.first);
        } while (this.eliminate() && environment.opt());
    }

    public void collect(Environment environment, MemberDefinition memberDefinition, ConstantPool constantPool) {
        Object object;
        if (memberDefinition != null && environment.debug_vars() && memberDefinition.getArguments() != null) {
            object = memberDefinition.getArguments().elements();
            while (object.hasMoreElements()) {
                MemberDefinition memberDefinition2 = (MemberDefinition)object.nextElement();
                constantPool.put(memberDefinition2.getName().toString());
                constantPool.put(memberDefinition2.getType().getTypeSignature());
            }
        }
        object = this.first;
        while (object != null) {
            ((Instruction)object).collect(constantPool);
            object = ((Instruction)object).next;
        }
    }

    void balance(Label label, int n2) {
        Instruction instruction = label;
        while (instruction != null) {
            if ((n2 += instruction.balance()) < 0) {
                throw new CompilerError("stack under flow: " + instruction.toString() + " = " + n2);
            }
            if (n2 > this.maxdepth) {
                this.maxdepth = n2;
            }
            switch (instruction.opc) {
                case -1: {
                    label = instruction;
                    if (instruction.pc == 1) {
                        if (label.depth != n2) {
                            throw new CompilerError("stack depth error " + n2 + "/" + label.depth + ": " + instruction.toString());
                        }
                        return;
                    }
                    label.pc = 1;
                    label.depth = n2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.balance((Label)instruction.value, n2);
                    break;
                }
                case 167: {
                    this.balance((Label)instruction.value, n2);
                    return;
                }
                case 168: {
                    this.balance((Label)instruction.value, n2 + 1);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int n3 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 1;
                    if (n3 <= this.maxvar) break;
                    this.maxvar = n3;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int n4 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 2;
                    if (n4 <= this.maxvar) break;
                    this.maxvar = n4;
                    break;
                }
                case 132: {
                    int n5 = ((int[])instruction.value)[0] + 1;
                    if (n5 <= this.maxvar) break;
                    this.maxvar = n5 + 1;
                    break;
                }
                case 170: 
                case 171: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    this.balance(switchData.defaultLabel, n2);
                    Enumeration<Object> enumeration = switchData.tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.balance((Label)enumeration.nextElement(), n2);
                    }
                    return;
                }
                case -3: {
                    TryData tryData = (TryData)instruction.value;
                    Enumeration<Object> enumeration = tryData.catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.balance(catchData.getLabel(), n2 + 1);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void write(Environment environment, DataOutputStream dataOutputStream, MemberDefinition memberDefinition, ConstantPool constantPool) throws IOException {
        Object object;
        int n2;
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            n2 = 0;
            Vector vector = memberDefinition.getArguments();
            object = vector.elements();
            while (object.hasMoreElements()) {
                MemberDefinition memberDefinition2 = (MemberDefinition)object.nextElement();
                n2 += memberDefinition2.getType().stackSize();
            }
            this.maxvar = n2;
        }
        try {
            this.balance(this.first, 0);
        }
        catch (CompilerError compilerError) {
            System.out.println("ERROR: " + compilerError);
            this.listing(System.out);
            throw compilerError;
        }
        n2 = 0;
        int n3 = 0;
        object = this.first;
        while (object != null) {
            ((Instruction)object).pc = n2;
            int n4 = ((Instruction)object).size(constantPool);
            if (n2 < 65536 && n2 + n4 >= 65536) {
                environment.error(((Instruction)object).where, "warn.method.too.long");
            }
            n2 += n4;
            if (((Instruction)object).opc == -3) {
                n3 += ((TryData)((Instruction)object).value).catches.size();
            }
            object = ((Instruction)object).next;
        }
        dataOutputStream.writeShort(this.maxdepth);
        dataOutputStream.writeShort(this.maxvar);
        this.maxpc = n2;
        dataOutputStream.writeInt(this.maxpc);
        Instruction instruction = this.first.next;
        while (instruction != null) {
            instruction.write(dataOutputStream, constantPool);
            instruction = instruction.next;
        }
        dataOutputStream.writeShort(n3);
        if (n3 > 0) {
            this.writeExceptions(environment, dataOutputStream, constantPool, this.first, this.last);
        }
    }

    void writeExceptions(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool, Instruction instruction, Instruction instruction2) throws IOException {
        Instruction instruction3 = instruction;
        while (instruction3 != instruction2.next) {
            if (instruction3.opc == -3) {
                TryData tryData = (TryData)instruction3.value;
                this.writeExceptions(environment, dataOutputStream, constantPool, instruction3.next, tryData.getEndLabel());
                Enumeration enumeration = tryData.catches.elements();
                while (enumeration.hasMoreElements()) {
                    CatchData catchData = (CatchData)enumeration.nextElement();
                    dataOutputStream.writeShort(instruction3.pc);
                    dataOutputStream.writeShort(tryData.getEndLabel().pc);
                    dataOutputStream.writeShort(catchData.getLabel().pc);
                    if (catchData.getType() != null) {
                        dataOutputStream.writeShort(constantPool.index(catchData.getType()));
                        continue;
                    }
                    dataOutputStream.writeShort(0);
                }
                instruction3 = tryData.getEndLabel();
            }
            instruction3 = instruction3.next;
        }
    }

    public void writeCoverageTable(Environment environment, ClassDefinition classDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool, long l2) throws IOException {
        Vector<Cover> vector = new Vector<Cover>();
        boolean bl = false;
        boolean bl2 = false;
        long l3 = ((SourceClass)classDefinition).getWhere();
        Vector<Long> vector2 = new Vector<Long>();
        boolean bl3 = false;
        int n2 = 0;
        Instruction instruction = this.first;
        while (instruction != null) {
            Enumeration enumeration;
            long l4 = instruction.where >> 32;
            if (l4 > 0L && instruction.opc != -1) {
                if (!bl2) {
                    if (l3 == instruction.where) {
                        vector.addElement(new Cover(2, l2, instruction.pc));
                    } else {
                        vector.addElement(new Cover(1, l2, instruction.pc));
                    }
                    ++n2;
                    bl2 = true;
                }
                if (!bl && !instruction.flagNoCovered) {
                    boolean bl4 = false;
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        if ((Long)enumeration.nextElement() != instruction.where) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        vector.addElement(new Cover(3, instruction.where, instruction.pc));
                        ++n2;
                        bl = true;
                    }
                }
            }
            switch (instruction.opc) {
                case -1: {
                    bl = false;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (instruction.flagCondInverted) {
                        vector.addElement(new Cover(7, instruction.where, instruction.pc));
                        vector.addElement(new Cover(8, instruction.where, instruction.pc));
                    } else {
                        vector.addElement(new Cover(8, instruction.where, instruction.pc));
                        vector.addElement(new Cover(7, instruction.where, instruction.pc));
                    }
                    n2 += 2;
                    bl = false;
                    break;
                }
                case 167: {
                    bl = false;
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    break;
                }
                case -3: {
                    vector2.addElement(new Long(instruction.where));
                    bl = false;
                    break;
                }
                case 170: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    int n3 = switchData.minValue;
                    while (n3 <= switchData.maxValue) {
                        vector.addElement(new Cover(5, switchData.whereCase(new Integer(n3)), instruction.pc));
                        ++n2;
                        ++n3;
                    }
                    if (!switchData.getDefault()) {
                        vector.addElement(new Cover(6, instruction.where, instruction.pc));
                        ++n2;
                    } else {
                        vector.addElement(new Cover(5, switchData.whereCase("default"), instruction.pc));
                        ++n2;
                    }
                    bl = false;
                    break;
                }
                case 171: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    enumeration = switchData.sortedKeys();
                    while (enumeration.hasMoreElements()) {
                        Integer n4 = (Integer)enumeration.nextElement();
                        vector.addElement(new Cover(5, switchData.whereCase(n4), instruction.pc));
                        ++n2;
                    }
                    if (!switchData.getDefault()) {
                        vector.addElement(new Cover(6, instruction.where, instruction.pc));
                        ++n2;
                    } else {
                        vector.addElement(new Cover(5, switchData.whereCase("default"), instruction.pc));
                        ++n2;
                    }
                    bl = false;
                }
            }
            instruction = instruction.next;
        }
        dataOutputStream.writeShort(n2);
        int n5 = 0;
        while (n5 < n2) {
            Cover cover = (Cover)vector.elementAt(n5);
            long l5 = cover.Addr >> 32;
            long l6 = cover.Addr << 32 >> 32;
            dataOutputStream.writeShort(cover.NumCommand);
            dataOutputStream.writeShort(cover.Type);
            dataOutputStream.writeInt((int)l5);
            dataOutputStream.writeInt((int)l6);
            if (cover.Type != 5 || cover.Addr != 0L) {
                int n6 = cover.Type;
                JcovClassCountArray[n6] = JcovClassCountArray[n6] + 1;
            }
            ++n5;
        }
    }

    public void addNativeToJcovTab(Environment environment, ClassDefinition classDefinition) {
        JcovClassCountArray[1] = JcovClassCountArray[1] + 1;
    }

    private String createClassJcovElement(Environment environment, ClassDefinition classDefinition) {
        String string = Type.mangleInnerType(classDefinition.getClassDeclaration().getName()).toString();
        SourceClassList.addElement(string);
        String string2 = string.replace('.', '/');
        String string3 = JcovClassLine + string2;
        string3 = string3 + " [";
        String string4 = "";
        int n2 = 0;
        while (n2 < arrayModifiers.length) {
            if ((classDefinition.getModifiers() & arrayModifiers[n2]) != 0) {
                string3 = string3 + string4 + Constants.opNames[arrayModifiersOpc[n2]];
                string4 = " ";
            }
            ++n2;
        }
        string3 = string3 + "]";
        return string3;
    }

    public void GenVecJCov(Environment environment, ClassDefinition classDefinition, long l2) {
        String string = ((SourceClass)classDefinition).getAbsoluteName();
        TmpCovTable.addElement(this.createClassJcovElement(environment, classDefinition));
        TmpCovTable.addElement(JcovSrcfileLine + string);
        TmpCovTable.addElement(JcovTimestampLine + l2);
        TmpCovTable.addElement(JcovDataLine + "A");
        TmpCovTable.addElement(JcovHeadingLine);
        int n2 = 1;
        while (n2 <= 8) {
            if (JcovClassCountArray[n2] != 0) {
                TmpCovTable.addElement(new String(n2 + "\t" + JcovClassCountArray[n2]));
                Assembler.JcovClassCountArray[n2] = 0;
            }
            ++n2;
        }
    }

    public void GenJCov(Environment environment) {
        try {
            Object object;
            Closeable closeable;
            File file = environment.getcovFile();
            if (file.exists()) {
                closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                object = null;
                boolean bl = true;
                object = ((DataInputStream)closeable).readLine();
                if (object != null && ((String)object).startsWith(JcovMagicLine)) {
                    while ((object = ((DataInputStream)closeable).readLine()) != null) {
                        if (((String)object).startsWith(JcovClassLine)) {
                            bl = true;
                            Enumeration enumeration = SourceClassList.elements();
                            while (enumeration.hasMoreElements()) {
                                String string;
                                String string2 = ((String)object).substring(JcovClassLine.length());
                                int n2 = string2.indexOf(32);
                                if (n2 != -1) {
                                    string2 = string2.substring(0, n2);
                                }
                                if ((string = (String)enumeration.nextElement()).compareTo(string2) != 0) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (!bl) continue;
                        TmpCovTable.addElement(object);
                    }
                }
                ((FilterInputStream)closeable).close();
            }
            closeable = new PrintStream(new DataOutputStream(new FileOutputStream(file)));
            ((PrintStream)closeable).println(JcovMagicLine);
            object = TmpCovTable.elements();
            while (object.hasMoreElements()) {
                ((PrintStream)closeable).println(object.nextElement());
            }
            ((PrintStream)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: " + iOException);
        }
    }

    public void writeLineNumberTable(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        long l2 = -1L;
        int n2 = 0;
        Instruction instruction = this.first;
        while (instruction != null) {
            long l3 = instruction.where >> 32;
            if (l3 > 0L && l2 != l3) {
                l2 = l3;
                ++n2;
            }
            instruction = instruction.next;
        }
        l2 = -1L;
        dataOutputStream.writeShort(n2);
        Instruction instruction2 = this.first;
        while (instruction2 != null) {
            long l4 = instruction2.where >> 32;
            if (l4 > 0L && l2 != l4) {
                l2 = l4;
                dataOutputStream.writeShort(instruction2.pc);
                dataOutputStream.writeShort((int)l2);
            }
            instruction2 = instruction2.next;
        }
    }

    void flowFields(Environment environment, Label label, MemberDefinition[] memberDefinitionArray) {
        if (label.locals != null) {
            MemberDefinition[] memberDefinitionArray2 = label.locals;
            int n2 = 0;
            while (n2 < this.maxvar) {
                if (memberDefinitionArray2[n2] != memberDefinitionArray[n2]) {
                    memberDefinitionArray2[n2] = null;
                }
                ++n2;
            }
            return;
        }
        label.locals = new MemberDefinition[this.maxvar];
        System.arraycopy(memberDefinitionArray, 0, label.locals, 0, this.maxvar);
        MemberDefinition[] memberDefinitionArray3 = new MemberDefinition[this.maxvar];
        System.arraycopy(memberDefinitionArray, 0, memberDefinitionArray3, 0, this.maxvar);
        memberDefinitionArray = memberDefinitionArray3;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (!(instruction.value instanceof LocalVariable)) break;
                    Object object = (LocalVariable)instruction.value;
                    memberDefinitionArray[((LocalVariable)object).slot] = ((LocalVariable)object).field;
                    break;
                }
                case -1: {
                    this.flowFields(environment, (Label)instruction, memberDefinitionArray);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: {
                    this.flowFields(environment, (Label)instruction.value, memberDefinitionArray);
                    break;
                }
                case 167: {
                    this.flowFields(environment, (Label)instruction.value, memberDefinitionArray);
                    return;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.flowFields(environment, ((SwitchData)object).defaultLabel, memberDefinitionArray);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.flowFields(environment, (Label)enumeration.nextElement(), memberDefinitionArray);
                    }
                    return;
                }
                case -3: {
                    Object object = ((TryData)instruction.value).catches;
                    Enumeration<Object> enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.flowFields(environment, catchData.getLabel(), memberDefinitionArray);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void writeLocalVariableTable(Environment environment, MemberDefinition memberDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        MemberDefinition[] memberDefinitionArray;
        Object object;
        Object object2;
        Object object3;
        MemberDefinition[] memberDefinitionArray2 = new MemberDefinition[this.maxvar];
        int n2 = 0;
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            int n3 = 0;
            object3 = memberDefinition.getArguments();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (MemberDefinition)object2.nextElement();
                memberDefinitionArray2[n3] = object;
                n3 += ((MemberDefinition)object).getType().stackSize();
            }
        }
        this.flowFields(environment, this.first, memberDefinitionArray2);
        LocalVariableTable localVariableTable = new LocalVariableTable();
        n2 = 0;
        while (n2 < this.maxvar) {
            memberDefinitionArray2[n2] = null;
            ++n2;
        }
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            int n4 = 0;
            object2 = memberDefinition.getArguments();
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                memberDefinitionArray = (MemberDefinition[])object.nextElement();
                memberDefinitionArray2[n4] = memberDefinitionArray;
                localVariableTable.define((MemberDefinition)memberDefinitionArray, n4, 0, this.maxpc);
                n4 += memberDefinitionArray.getType().stackSize();
            }
        }
        object3 = new int[this.maxvar];
        object2 = this.first;
        while (object2 != null) {
            switch (((Instruction)object2).opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int n5;
                    if (!(((Instruction)object2).value instanceof LocalVariable)) break;
                    LocalVariable localVariable = (LocalVariable)((Instruction)object2).value;
                    int n6 = n5 = ((Instruction)object2).next != null ? ((Instruction)object2).next.pc : ((Instruction)object2).pc;
                    if (memberDefinitionArray2[localVariable.slot] != null) {
                        localVariableTable.define(memberDefinitionArray2[localVariable.slot], localVariable.slot, (int)object3[localVariable.slot], n5);
                    }
                    object3[localVariable.slot] = n5;
                    memberDefinitionArray2[localVariable.slot] = localVariable.field;
                    break;
                }
                case -1: {
                    n2 = 0;
                    while (n2 < this.maxvar) {
                        if (memberDefinitionArray2[n2] != null) {
                            localVariableTable.define(memberDefinitionArray2[n2], n2, (int)object3[n2], ((Instruction)object2).pc);
                        }
                        ++n2;
                    }
                    int n7 = ((Instruction)object2).pc;
                    memberDefinitionArray = ((Label)object2).locals;
                    if (memberDefinitionArray == null) {
                        n2 = 0;
                        while (n2 < this.maxvar) {
                            memberDefinitionArray2[n2] = null;
                            ++n2;
                        }
                    } else {
                        System.arraycopy(memberDefinitionArray, 0, memberDefinitionArray2, 0, this.maxvar);
                    }
                    n2 = 0;
                    while (n2 < this.maxvar) {
                        object3[n2] = n7;
                        ++n2;
                    }
                    break;
                }
            }
            object2 = ((Instruction)object2).next;
        }
        n2 = 0;
        while (n2 < this.maxvar) {
            if (memberDefinitionArray2[n2] != null) {
                localVariableTable.define(memberDefinitionArray2[n2], n2, (int)object3[n2], this.maxpc);
            }
            ++n2;
        }
        localVariableTable.write(environment, dataOutputStream, constantPool);
    }

    public boolean empty() {
        return this.first == this.last;
    }

    public void listing(PrintStream printStream) {
        printStream.println("-- listing --");
        Instruction instruction = this.first;
        while (instruction != null) {
            printStream.println(((Instruction)instruction).toString());
            instruction = instruction.next;
        }
    }
}

