/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyEntry;
import sun.security.tools.ToolWindow;
import sun.security.util.PropertyExpander;

class PolicyTool {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    static final Collator collator = Collator.getInstance();
    Vector warnings;
    boolean newWarning = false;
    boolean modified = false;
    private static final boolean testing = false;
    private static final Class[] TWOPARAMS;
    private static final Class[] ONEPARAMS;
    private static final Class[] NOPARAMS;
    private static String policyFileName;
    private Vector policyEntries = new Vector();
    private PolicyParser parser = new PolicyParser();
    private KeyStore keyStore = null;
    private String keyStoreName = " ";
    private String keyStoreType = " ";
    static /* synthetic */ Class class$java$lang$String;

    private PolicyTool() {
        this.warnings = new Vector();
    }

    String getPolicyFileName() {
        return policyFileName;
    }

    void setPolicyFileName(String string) {
        policyFileName = string;
    }

    void setKeyStoreInfo(String string, String string2) {
        this.keyStoreName = string;
        this.keyStoreType = string2;
        this.modified = true;
    }

    String getKeyStoreName() {
        return this.keyStoreName;
    }

    String getKeyStoreType() {
        return this.keyStoreType;
    }

    void openPolicy(String string) throws MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, PolicyParser.ParsingException, IOException, FileNotFoundException, CertificateException, Exception {
        this.newWarning = false;
        this.policyEntries = new Vector();
        this.parser = new PolicyParser();
        this.warnings = new Vector();
        this.setPolicyFileName(null);
        this.setKeyStoreInfo(null, null);
        if (string == null) {
            this.modified = false;
            return;
        }
        this.setPolicyFileName(string);
        this.parser.read(new FileReader(string));
        this.setKeyStoreInfo(this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType());
        Enumeration<PolicyParser.GrantEntry> enumeration = this.parser.grantElements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            Object object;
            Object object2;
            PolicyParser.GrantEntry grantEntry = enumeration.nextElement();
            if (grantEntry.signedBy != null) {
                object2 = this.parseSigners(grantEntry.signedBy);
                int n2 = 0;
                while (n2 < ((Object)object2).length) {
                    object = this.getPublicKeyAlias((String)object2[n2]);
                    if (object == null) {
                        this.newWarning = true;
                        stringArray = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                        Object[] objectArray = new Object[]{object2[n2]};
                        this.warnings.addElement(stringArray.format(objectArray));
                    }
                    ++n2;
                }
            }
            object2 = grantEntry.principals.listIterator(0);
            while (object2.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object2.next();
                try {
                    this.verifyPrincipal(principalEntry.getPrincipalClass(), principalEntry.getPrincipalName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Class not found: ") + principalEntry.getPrincipalClass());
                }
            }
            Enumeration<PolicyParser.PermissionEntry> enumeration2 = grantEntry.permissionElements();
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                try {
                    this.verifyPermission(((PolicyParser.PermissionEntry)object).permission, ((PolicyParser.PermissionEntry)object).name, ((PolicyParser.PermissionEntry)object).action);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Class not found: ") + ((PolicyParser.PermissionEntry)object).permission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.newWarning = true;
                    this.warnings.addElement(rb.getString("Warning: Invalid argument(s) for constructor: ") + ((PolicyParser.PermissionEntry)object).permission);
                }
                if (((PolicyParser.PermissionEntry)object).signedBy == null) continue;
                stringArray = this.parseSigners(((PolicyParser.PermissionEntry)object).signedBy);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    PublicKey publicKey = this.getPublicKeyAlias(stringArray[n3]);
                    if (publicKey == null) {
                        this.newWarning = true;
                        MessageFormat messageFormat = new MessageFormat(rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                        Object[] objectArray = new Object[]{stringArray[n3]};
                        this.warnings.addElement(messageFormat.format(objectArray));
                    }
                    ++n3;
                }
            }
            object = new PolicyEntry(this, grantEntry);
            this.policyEntries.addElement(object);
        }
        if (!this.newWarning) {
            this.warnings.addElement(rb.getString("Policy File opened successfully"));
        }
        this.modified = false;
    }

    void savePolicy(String string) throws FileNotFoundException, IOException {
        this.parser.setKeyStoreUrl(this.keyStoreName);
        this.parser.setKeyStoreType(this.keyStoreType);
        this.parser.write(new FileWriter(string));
        this.modified = false;
    }

    void openKeyStore(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, PropertyExpander.ExpandException {
        if (string == null || string.length() == 0) {
            throw new IOException(rb.getString("null Keystore name"));
        }
        string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(policyFileName);
            URL uRL2 = new URL("file:" + file.getCanonicalPath());
            uRL = new URL(uRL2, string);
        }
        InputStream inputStream = uRL.openStream();
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(inputStream, cArray);
        inputStream.close();
    }

    boolean addEntry(PolicyEntry policyEntry, int n2) {
        if (n2 < 0) {
            this.policyEntries.addElement(policyEntry);
            this.parser.add(policyEntry.getGrantEntry());
        } else {
            PolicyEntry policyEntry2 = (PolicyEntry)this.policyEntries.elementAt(n2);
            this.parser.replace(policyEntry2.getGrantEntry(), policyEntry.getGrantEntry());
            this.policyEntries.setElementAt(policyEntry, n2);
        }
        return true;
    }

    boolean addPrinEntry(PolicyEntry policyEntry, PolicyParser.PrincipalEntry principalEntry, int n2) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(principalEntry)) {
            return false;
        }
        LinkedList<PolicyParser.PrincipalEntry> linkedList = grantEntry.principals;
        if (n2 != -1) {
            linkedList.set(n2, principalEntry);
        } else {
            linkedList.add(principalEntry);
        }
        this.modified = true;
        return true;
    }

    boolean addPermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry, int n2) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(permissionEntry)) {
            return false;
        }
        Vector<PolicyParser.PermissionEntry> vector = grantEntry.permissionEntries;
        if (n2 != -1) {
            vector.setElementAt(permissionEntry, n2);
        } else {
            vector.addElement(permissionEntry);
        }
        this.modified = true;
        return true;
    }

    boolean removePermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        this.modified = grantEntry.remove(permissionEntry);
        return this.modified;
    }

    boolean removeEntry(PolicyEntry policyEntry) {
        this.parser.remove(policyEntry.getGrantEntry());
        this.modified = true;
        return this.policyEntries.removeElement(policyEntry);
    }

    PolicyEntry[] getEntry() {
        if (this.policyEntries.size() > 0) {
            PolicyEntry[] policyEntryArray = new PolicyEntry[this.policyEntries.size()];
            int n2 = 0;
            while (n2 < this.policyEntries.size()) {
                policyEntryArray[n2] = (PolicyEntry)this.policyEntries.elementAt(n2);
                ++n2;
            }
            return policyEntryArray;
        }
        return null;
    }

    PublicKey getPublicKeyAlias(String string) throws CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, PropertyExpander.ExpandException {
        try {
            this.openKeyStore(this.keyStoreName, null);
            Certificate certificate = this.keyStore.getCertificate(string);
            if (certificate == null) {
                return null;
            }
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
        catch (IOException iOException) {
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Warning: Unable to open Keystore: ") + this.keyStoreName);
            return null;
        }
    }

    String[] getPublicKeyAlias() throws CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, PropertyExpander.ExpandException {
        try {
            int n2 = 0;
            String[] stringArray = null;
            this.openKeyStore(this.keyStoreName, null);
            Enumeration<String> enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n2;
            }
            if (n2 > 0) {
                stringArray = new String[n2];
                n2 = 0;
                enumeration = this.keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    stringArray[n2] = new String(enumeration.nextElement());
                    ++n2;
                }
            }
            return stringArray;
        }
        catch (IOException iOException) {
            this.newWarning = true;
            this.warnings.addElement(rb.getString("Warning: Unable to open Keystore: ") + this.keyStoreName);
            return null;
        }
    }

    String[] parseSigners(String string) {
        String[] stringArray = null;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 >= 0) {
            n4 = string.indexOf(44, n3);
            if (n4 < 0) continue;
            ++n2;
            n3 = n4 + 1;
        }
        stringArray = new String[n2];
        n4 = 0;
        n3 = 0;
        while (n4 >= 0) {
            n4 = string.indexOf(44, n3);
            if (n4 >= 0) {
                stringArray[n5] = string.substring(n3, n4).trim();
                ++n5;
                n3 = n4 + 1;
                continue;
            }
            stringArray[n5] = string.substring(n3).trim();
        }
        return stringArray;
    }

    void verifyPrincipal(String string, String string2) throws ClassNotFoundException, InstantiationException {
        Class<?> clazz;
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") || string.equals("PolicyParser.REPLACE_NAME")) {
            return;
        }
        Class<?> clazz2 = Class.forName("java.security.Principal");
        if (!clazz2.isAssignableFrom(clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader()))) {
            throw new InstantiationException(rb.getString("Illegal Principal Type"));
        }
    }

    void verifyPermission(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        Constructor<?> constructor = null;
        Vector<String> vector = new Vector<String>(2);
        if (string2 != null) {
            vector.add(string2);
        }
        if (string3 != null) {
            vector.add(string3);
        }
        Object[] objectArray = vector.toArray();
        switch (objectArray.length) {
            case 0: {
                constructor = clazz.getConstructor(NOPARAMS);
                break;
            }
            case 1: {
                constructor = clazz.getConstructor(ONEPARAMS);
                break;
            }
            case 2: {
                constructor = clazz.getConstructor(TWOPARAMS);
            }
        }
        Permission permission = (Permission)constructor.newInstance(objectArray);
    }

    static void parseArgs(String[] stringArray) {
        int n2 = 0;
        n2 = 0;
        while (n2 < stringArray.length && stringArray[n2].startsWith("-")) {
            String string = stringArray[n2];
            if (collator.compare(string, "-file") == 0) {
                if (++n2 == stringArray.length) {
                    PolicyTool.usage();
                }
                policyFileName = stringArray[n2];
            } else {
                System.err.println(rb.getString("Illegal option: ") + string);
                PolicyTool.usage();
            }
            ++n2;
        }
    }

    static void usage() {
        System.out.println(rb.getString("Usage: policytool [options]"));
        System.out.println();
        System.out.println(rb.getString("  [-file <file>]    policy file location"));
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        PolicyTool.parseArgs(stringArray);
        ToolWindow toolWindow = new ToolWindow(new PolicyTool());
        toolWindow.displayToolWindow(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        collator.setStrength(0);
        TWOPARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String};
        ONEPARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyTool.class$("java.lang.String")) : class$java$lang$String};
        NOPARAMS = new Class[0];
        policyFileName = null;
    }
}

