/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.TypeContext;
import sun.tools.java.CompilerError;

public class ContextStack {
    public static final int TOP = 1;
    public static final int METHOD = 2;
    public static final int METHOD_RETURN = 3;
    public static final int METHOD_ARGUMENT = 4;
    public static final int METHOD_EXCEPTION = 5;
    public static final int MEMBER = 6;
    public static final int MEMBER_CONSTANT = 7;
    public static final int MEMBER_STATIC = 8;
    public static final int MEMBER_TRANSIENT = 9;
    public static final int IMPLEMENTS = 10;
    public static final int EXTENDS = 11;
    private static final String[] CODE_NAMES = new String[]{"UNKNOWN ", "Top level type ", "Method ", "Return parameter ", "Parameter ", "Exception ", "Member ", "Constant member ", "Static member ", "Transient member ", "Implements ", "Extends "};
    private int currentIndex = -1;
    private int maxIndex = 100;
    private TypeContext[] stack = new TypeContext[this.maxIndex];
    private int newCode = 1;
    private BatchEnvironment env = null;
    private boolean trace = false;
    private TypeContext tempContext = new TypeContext();
    private static final String TRACE_INDENT = "   ";

    public ContextStack(BatchEnvironment batchEnvironment) {
        this.env = batchEnvironment;
        batchEnvironment.contextStack = this;
    }

    public boolean anyErrors() {
        return this.env.nerrors > 0;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean isTraceOn() {
        return this.trace;
    }

    public BatchEnvironment getEnv() {
        return this.env;
    }

    public void setNewContextCode(int n2) {
        this.newCode = n2;
    }

    public int getCurrentContextCode() {
        return this.newCode;
    }

    final void traceCallStack() {
        if (this.trace) {
            ContextStack.dumpCallStack();
        }
    }

    public static final void dumpCallStack() {
        new Error().printStackTrace(System.out);
    }

    private final void tracePrint(String string, boolean bl) {
        int n2 = string.length() + this.currentIndex * TRACE_INDENT.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < this.currentIndex) {
            stringBuffer.append(TRACE_INDENT);
            ++n3;
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("\n");
        }
        System.out.print(stringBuffer.toString());
    }

    final void trace(String string) {
        if (this.trace) {
            this.tracePrint(string, false);
        }
    }

    final void traceln(String string) {
        if (this.trace) {
            this.tracePrint(string, true);
        }
    }

    final void traceExistingType(Type type) {
        if (this.trace) {
            this.tempContext.set(this.newCode, type);
            this.traceln(this.toResultString(this.tempContext, true, true));
        }
    }

    public TypeContext push(ContextElement contextElement) {
        TypeContext typeContext;
        ++this.currentIndex;
        if (this.currentIndex == this.maxIndex) {
            int n2 = this.maxIndex * 2;
            TypeContext[] typeContextArray = new TypeContext[n2];
            System.arraycopy(this.stack, 0, typeContextArray, 0, this.maxIndex);
            this.maxIndex = n2;
            this.stack = typeContextArray;
        }
        if ((typeContext = this.stack[this.currentIndex]) == null) {
            this.stack[this.currentIndex] = typeContext = new TypeContext();
        }
        typeContext.set(this.newCode, contextElement);
        this.traceln(this.toTrialString(typeContext));
        return typeContext;
    }

    public TypeContext pop(boolean bl) {
        if (this.currentIndex < 0) {
            throw new CompilerError("Nothing on stack!");
        }
        this.newCode = this.stack[this.currentIndex].getCode();
        this.traceln(this.toResultString(this.stack[this.currentIndex], bl, false));
        Type type = this.stack[this.currentIndex].getCandidateType();
        if (type != null) {
            if (bl) {
                type.setStatus(1);
            } else {
                type.setStatus(2);
            }
        }
        --this.currentIndex;
        if (this.currentIndex < 0) {
            if (bl) {
                Type.updateAllInvalidTypes(this);
            }
            return null;
        }
        return this.stack[this.currentIndex];
    }

    public int size() {
        return this.currentIndex + 1;
    }

    public TypeContext getContext(int n2) {
        if (this.currentIndex < n2) {
            throw new Error("Index out of range");
        }
        return this.stack[n2];
    }

    public TypeContext getContext() {
        if (this.currentIndex < 0) {
            throw new Error("Nothing on stack!");
        }
        return this.stack[this.currentIndex];
    }

    public boolean isParentAValue() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1].isValue();
        }
        return false;
    }

    public TypeContext getParentContext() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1];
        }
        return null;
    }

    public String getContextCodeString() {
        if (this.currentIndex >= 0) {
            return CODE_NAMES[this.newCode];
        }
        return CODE_NAMES[0];
    }

    public static String getContextCodeString(int n2) {
        return CODE_NAMES[n2];
    }

    private String toTrialString(TypeContext typeContext) {
        int n2 = typeContext.getCode();
        if (n2 != 2 && n2 != 6) {
            return typeContext.toString() + " (trying " + typeContext.getTypeDescription() + ")";
        }
        return typeContext.toString();
    }

    private String toResultString(TypeContext typeContext, boolean bl, boolean bl2) {
        int n2 = typeContext.getCode();
        if (n2 != 2 && n2 != 6) {
            if (bl) {
                String string = typeContext.toString() + " --> " + typeContext.getTypeDescription();
                if (bl2) {
                    return string + " [Previously mapped]";
                }
                return string;
            }
        } else if (bl) {
            return typeContext.toString() + " --> [Mapped]";
        }
        return typeContext.toString() + " [Did not map]";
    }

    public void clear() {
        int n2 = 0;
        while (n2 < this.stack.length) {
            if (this.stack[n2] != null) {
                this.stack[n2].destroy();
            }
            ++n2;
        }
    }
}

