/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.ArrayType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.DirectoryLoader;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.NCClassType;
import sun.rmi.rmic.iiop.NCInterfaceType;
import sun.rmi.rmic.iiop.PrimitiveType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.SpecialClassType;
import sun.rmi.rmic.iiop.SpecialInterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.IntegerExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;

public abstract class CompoundType
extends Type {
    protected Method[] methods;
    protected InterfaceType[] interfaces;
    protected Member[] members;
    protected ClassDefinition classDef;
    protected ClassDeclaration classDecl;
    protected boolean isCORBAObject = false;
    protected boolean isIDLEntity = false;
    protected boolean isAbstractBase = false;
    protected boolean isValueBase = false;
    protected boolean isCORBAUserException = false;
    protected boolean isException = false;
    protected boolean isCheckedException = false;
    protected boolean isRemoteExceptionOrSubclass = false;
    protected String idlExceptionName;
    protected String qualifiedIDLExceptionName;

    public boolean isCORBAObject() {
        return this.isCORBAObject;
    }

    public boolean isIDLEntity() {
        return this.isIDLEntity;
    }

    public boolean isValueBase() {
        return this.isValueBase;
    }

    public boolean isAbstractBase() {
        return this.isAbstractBase;
    }

    public boolean isException() {
        return this.isException;
    }

    public boolean isCheckedException() {
        return this.isCheckedException;
    }

    public boolean isRemoteExceptionOrSubclass() {
        return this.isRemoteExceptionOrSubclass;
    }

    public boolean isCORBAUserException() {
        return this.isCORBAUserException;
    }

    public boolean isIDLEntityException() {
        return this.isIDLEntity() && this.isException();
    }

    public boolean isBoxed() {
        return this.isIDLEntity() && !this.isValueBase() && !this.isAbstractBase() && !this.isCORBAObject() && !this.isIDLEntityException();
    }

    public String getIDLExceptionName() {
        return this.idlExceptionName;
    }

    public String getQualifiedIDLExceptionName(boolean bl) {
        if (this.qualifiedIDLExceptionName != null && bl && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLExceptionName;
        }
        return this.qualifiedIDLExceptionName;
    }

    public String getSignature() {
        String string = this.classDecl.getType().getTypeSignature();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDecl;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDef;
    }

    public ClassType getSuperclass() {
        return null;
    }

    public InterfaceType[] getInterfaces() {
        if (this.interfaces != null) {
            return (InterfaceType[])this.interfaces.clone();
        }
        return null;
    }

    public Method[] getMethods() {
        if (this.methods != null) {
            return (Method[])this.methods.clone();
        }
        return null;
    }

    public Member[] getMembers() {
        if (this.members != null) {
            return (Member[])this.members.clone();
        }
        return null;
    }

    public static CompoundType forCompound(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        try {
            compoundType = (CompoundType)CompoundType.makeType(classDefinition.getType(), classDefinition, contextStack);
        }
        catch (ClassCastException classCastException) {}
        return compoundType;
    }

    protected void destroy() {
        if (!this.destroyed) {
            int n2;
            super.destroy();
            if (this.methods != null) {
                n2 = 0;
                while (n2 < this.methods.length) {
                    if (this.methods[n2] != null) {
                        this.methods[n2].destroy();
                    }
                    ++n2;
                }
                this.methods = null;
            }
            if (this.interfaces != null) {
                n2 = 0;
                while (n2 < this.interfaces.length) {
                    if (this.interfaces[n2] != null) {
                        this.interfaces[n2].destroy();
                    }
                    ++n2;
                }
                this.interfaces = null;
            }
            if (this.members != null) {
                n2 = 0;
                while (n2 < this.members.length) {
                    if (this.members[n2] != null) {
                        this.members[n2].destroy();
                    }
                    ++n2;
                }
                this.members = null;
            }
            this.classDef = null;
            this.classDecl = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class loadClass() {
        block14: {
            block12: {
                var1_1 = null;
                try {
                    this.env.getMain().compileAllClasses(this.env);
                    break block12;
                }
                catch (Exception var2_2) {
                    var3_6 = this.env.getClasses();
                    ** while (var3_6.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    var4_8 = (ClassDeclaration)var3_6.nextElement();
                    continue;
                }
lbl10:
                // 1 sources

                Type.failedConstraint(26, false, this.stack, "required classes");
                this.env.flushErrors();
            }
            try {
                var2_3 = Thread.currentThread().getContextClassLoader();
                var1_1 = var2_3.loadClass(this.getQualifiedName());
            }
            catch (ClassNotFoundException var2_4) {
                try {
                    var1_1 = this.env.classPathLoader.loadClass(this.getQualifiedName());
                }
                catch (NullPointerException var3_7) {
                }
                catch (ClassNotFoundException var4_9) {
                    // empty catch block
                }
            }
            if (var1_1 != null) break block14;
            if (this.env.loader == null) {
                var2_3 = this.env.getMain().getDestinationDir();
                if (var2_3 == null) {
                    var2_3 = new File(".");
                }
                this.env.loader = new DirectoryLoader((File)var2_3);
            }
            try {
                var1_1 = this.env.loader.loadClass(this.getQualifiedName());
            }
            catch (Exception var2_5) {}
        }
        return var1_1;
    }

    protected boolean printExtends(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        ClassType classType = this.getSuperclass();
        if (!(classType == null || bl2 && (classType.isType(1024) || classType.isType(2048)))) {
            indentingWriter.p(" extends ");
            classType.printTypeName(indentingWriter, bl, bl2, bl3);
            return true;
        }
        return false;
    }

    protected void printImplements(IndentingWriter indentingWriter, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        InterfaceType[] interfaceTypeArray = this.getInterfaces();
        String string2 = " implements";
        if (this.isInterface()) {
            string2 = " extends";
        }
        if (bl2) {
            string2 = ":";
        }
        int n2 = 0;
        while (n2 < interfaceTypeArray.length) {
            if (!bl2 || !interfaceTypeArray[n2].isType(1024) && !interfaceTypeArray[n2].isType(2048)) {
                if (n2 == 0) {
                    indentingWriter.p(string + string2 + " ");
                } else {
                    indentingWriter.p(", ");
                }
                interfaceTypeArray[n2].printTypeName(indentingWriter, bl, bl2, bl3);
            }
            ++n2;
        }
    }

    protected void printMembers(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Member[] memberArray = this.getMembers();
        int n2 = 0;
        while (n2 < memberArray.length) {
            if (!memberArray[n2].isInnerClassDeclaration()) {
                Type type = memberArray[n2].getType();
                String string = memberArray[n2].getVisibility();
                String string2 = bl2 ? memberArray[n2].getIDLName() : memberArray[n2].getName();
                String string3 = memberArray[n2].getValue();
                indentingWriter.p(string);
                if (string.length() > 0) {
                    indentingWriter.p(" ");
                }
                type.printTypeName(indentingWriter, bl, bl2, bl3);
                indentingWriter.p(" " + string2);
                if (string3 != null) {
                    indentingWriter.pln(" = " + string3 + ";");
                } else {
                    indentingWriter.pln(";");
                }
            }
            ++n2;
        }
    }

    protected void printMethods(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Method[] methodArray = this.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            this.printMethod(method, indentingWriter, bl, bl2, bl3);
            ++n2;
        }
    }

    protected void printMethod(Method method, IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string = method.getVisibility();
        indentingWriter.p(string);
        if (string.length() > 0) {
            indentingWriter.p(" ");
        }
        method.getReturnType().printTypeName(indentingWriter, bl, bl2, bl3);
        if (bl2) {
            indentingWriter.p(" " + method.getIDLName());
        } else {
            indentingWriter.p(" " + method.getName());
        }
        indentingWriter.p(" (");
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        int n2 = 0;
        while (n2 < typeArray.length) {
            if (n2 > 0) {
                indentingWriter.p(", ");
            }
            if (bl2) {
                indentingWriter.p("in ");
            }
            typeArray[n2].printTypeName(indentingWriter, bl, bl2, bl3);
            indentingWriter.p(" " + stringArray[n2]);
            ++n2;
        }
        indentingWriter.p(")");
        ValueType[] valueTypeArray = this.isType(65536) ? method.getImplExceptions() : method.getExceptions();
        int n3 = 0;
        while (n3 < valueTypeArray.length) {
            if (n3 == 0) {
                if (bl2) {
                    indentingWriter.p(" raises (");
                } else {
                    indentingWriter.p(" throws ");
                }
            } else {
                indentingWriter.p(", ");
            }
            if (bl2) {
                if (bl) {
                    indentingWriter.p(valueTypeArray[n3].getQualifiedIDLExceptionName(bl3));
                } else {
                    indentingWriter.p(valueTypeArray[n3].getIDLExceptionName());
                }
                indentingWriter.p(" [a.k.a. ");
                valueTypeArray[n3].printTypeName(indentingWriter, bl, bl2, bl3);
                indentingWriter.p("]");
            } else {
                valueTypeArray[n3].printTypeName(indentingWriter, bl, bl2, bl3);
            }
            ++n3;
        }
        if (bl2 && valueTypeArray.length > 0) {
            indentingWriter.p(")");
        }
        if (method.isInherited()) {
            indentingWriter.p(" // Inherited from ");
            indentingWriter.p(method.getDeclaredBy());
        }
        indentingWriter.pln(";");
    }

    protected CompoundType(ContextStack contextStack, int n2, ClassDefinition classDefinition) {
        super(contextStack, n2);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        this.interfaces = new InterfaceType[0];
        this.methods = new Method[0];
        this.members = new Member[0];
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n2 | Integer.MIN_VALUE);
        }
        this.setFlags();
    }

    private void setFlags() {
        block3: {
            try {
                this.isCORBAObject = this.env.defCorbaObject.implementedBy(this.env, this.classDecl);
                this.isIDLEntity = this.env.defIDLEntity.implementedBy(this.env, this.classDecl);
                this.isValueBase = this.env.defValueBase.implementedBy(this.env, this.classDecl);
                this.isAbstractBase = this.isInterface() && this.isIDLEntity && !this.isValueBase && !this.isCORBAObject;
                boolean bl = this.isCORBAUserException = this.classDecl.getName() == Constants.idCorbaUserException;
                if (this.env.defThrowable.implementedBy(this.env, this.classDecl)) {
                    this.isException = true;
                    this.isCheckedException = !this.env.defRuntimeException.implementedBy(this.env, this.classDecl) && !this.env.defError.implementedBy(this.env, this.classDecl);
                    this.isRemoteExceptionOrSubclass = this.env.defRemoteException.implementedBy(this.env, this.classDecl);
                    break block3;
                }
                this.isException = false;
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(this.stack, classNotFound);
            }
        }
    }

    protected CompoundType(ContextStack contextStack, ClassDefinition classDefinition, int n2) {
        super(contextStack, n2);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n2 | Integer.MIN_VALUE);
        }
        this.setFlags();
        Identifier identifier = classDefinition.getName();
        try {
            String string = IDLNames.getClassOrInterfaceName(identifier, this.env);
            String[] stringArray = IDLNames.getModuleNames(identifier, this.isBoxed(), this.env);
            this.setNames(identifier, stringArray, string);
            if (this.isException()) {
                this.isException = true;
                this.idlExceptionName = IDLNames.getExceptionName(this.getIDLName());
                this.qualifiedIDLExceptionName = IDLNames.getQualifiedName(this.getIDLModuleNames(), this.idlExceptionName);
            }
            this.interfaces = null;
            this.methods = null;
            this.members = null;
        }
        catch (Exception exception) {
            Type.failedConstraint(7, false, contextStack, identifier.toString(), exception.getMessage());
            throw new CompilerError("");
        }
    }

    protected boolean initialize(Vector vector, Vector vector2, Vector vector3, ContextStack contextStack, boolean bl) {
        boolean bl2 = true;
        if (vector != null && vector.size() > 0) {
            this.interfaces = new InterfaceType[vector.size()];
            vector.copyInto(this.interfaces);
        } else {
            this.interfaces = new InterfaceType[0];
        }
        if (vector2 != null && vector2.size() > 0) {
            this.methods = new Method[vector2.size()];
            vector2.copyInto(this.methods);
            try {
                IDLNames.setMethodNames(this, this.methods, this.env);
            }
            catch (Exception exception) {
                Type.failedConstraint(13, bl, contextStack, this.getQualifiedName(), exception.getMessage());
                bl2 = false;
            }
        } else {
            this.methods = new Method[0];
        }
        if (vector3 != null && vector3.size() > 0) {
            this.members = new Member[vector3.size()];
            vector3.copyInto(this.members);
            int n2 = 0;
            while (n2 < this.members.length) {
                if (this.members[n2].isInnerClassDeclaration()) {
                    try {
                        this.members[n2].init(contextStack, this);
                    }
                    catch (CompilerError compilerError) {
                        return false;
                    }
                }
                ++n2;
            }
            try {
                IDLNames.setMemberNames(this, this.members, this.methods, this.env);
            }
            catch (Exception exception) {
                int n3 = this.classDef.isInterface() ? 19 : 20;
                Type.failedConstraint(n3, bl, contextStack, this.getQualifiedName(), exception.getMessage());
                bl2 = false;
            }
        } else {
            this.members = new Member[0];
        }
        if (bl2) {
            bl2 = this.setRepositoryID();
        }
        return bl2;
    }

    protected static Type makeType(sun.tools.java.Type type, ClassDefinition classDefinition, ContextStack contextStack) {
        if (contextStack.anyErrors()) {
            return null;
        }
        String string = type.toString();
        Type type2 = Type.getType(string, contextStack);
        if (type2 != null) {
            return type2;
        }
        type2 = Type.getType(string + contextStack.getContextCodeString(), contextStack);
        if (type2 != null) {
            return type2;
        }
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        int n2 = type.getTypeCode();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                type2 = PrimitiveType.forPrimitive(type, contextStack);
                break;
            }
            case 9: {
                type2 = ArrayType.forArray(type, contextStack);
                break;
            }
            case 10: {
                try {
                    ClassDefinition classDefinition2 = classDefinition;
                    if (classDefinition2 == null) {
                        classDefinition2 = batchEnvironment.getClassDeclaration(type).getClassDefinition(batchEnvironment);
                    }
                    if (classDefinition2.isInterface()) {
                        type2 = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
                        if (type2 != null) break;
                        if (batchEnvironment.defRemote.implementedBy(batchEnvironment, classDefinition2.getClassDeclaration())) {
                            boolean bl = contextStack.isParentAValue();
                            type2 = RemoteType.forRemote(classDefinition2, contextStack, bl);
                            if (type2 != null || !bl) break;
                            type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                            break;
                        }
                        type2 = AbstractType.forAbstract(classDefinition2, contextStack, true);
                        if (type2 != null) break;
                        type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                        break;
                    }
                    type2 = SpecialClassType.forSpecial(classDefinition2, contextStack);
                    if (type2 != null) break;
                    ClassDeclaration classDeclaration = classDefinition2.getClassDeclaration();
                    if (batchEnvironment.defRemote.implementedBy(batchEnvironment, classDeclaration)) {
                        boolean bl = contextStack.isParentAValue();
                        type2 = ImplementationType.forImplementation(classDefinition2, contextStack, bl);
                        if (type2 != null || !bl) break;
                        type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                        break;
                    }
                    if (batchEnvironment.defSerializable.implementedBy(batchEnvironment, classDeclaration)) {
                        type2 = ValueType.forValue(classDefinition2, contextStack, true);
                    }
                    if (type2 != null) break;
                    type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                }
                break;
            }
            default: {
                throw new CompilerError("Unknown typecode (" + n2 + ") for " + type.getTypeSignature());
            }
        }
        return type2;
    }

    public static boolean isRemoteException(ClassType classType, BatchEnvironment batchEnvironment) {
        sun.tools.java.Type type = classType.getClassDeclaration().getType();
        return type.equals(batchEnvironment.typeRemoteException) || type.equals(batchEnvironment.typeIOException) || type.equals(batchEnvironment.typeException) || type.equals(batchEnvironment.typeThrowable);
    }

    protected boolean isConformingRemoteMethod(Method method, boolean bl) throws ClassNotFound {
        boolean bl2;
        boolean bl3 = false;
        ValueType[] valueTypeArray = method.getExceptions();
        int n2 = 0;
        while (n2 < valueTypeArray.length) {
            if (CompoundType.isRemoteException(valueTypeArray[n2], this.env)) {
                bl3 = true;
                break;
            }
            ++n2;
        }
        if (!bl3) {
            Type.failedConstraint(5, bl, this.stack, method.getEnclosing(), method.toString());
        }
        boolean bl4 = bl2 = !this.isIDLEntityException(method.getReturnType(), method, bl);
        if (bl2) {
            Type[] typeArray = method.getArguments();
            int n3 = 0;
            while (n3 < typeArray.length) {
                if (this.isIDLEntityException(typeArray[n3], method, bl)) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
        }
        return bl3 && bl2;
    }

    protected boolean isIDLEntityException(Type type, Method method, boolean bl) throws ClassNotFound {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isCompound() && ((CompoundType)type).isIDLEntityException()) {
            Type.failedConstraint(18, bl, this.stack, method.getEnclosing(), method.toString());
            return true;
        }
        return false;
    }

    protected void swapInvalidTypes() {
        int n2 = 0;
        while (n2 < this.interfaces.length) {
            if (this.interfaces[n2].getStatus() != 1) {
                this.interfaces[n2] = (InterfaceType)this.getValidType(this.interfaces[n2]);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.methods.length) {
            this.methods[n3].swapInvalidTypes();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.members.length) {
            this.members[n4].swapInvalidTypes();
            ++n4;
        }
    }

    protected boolean addTypes(int n2, HashSet hashSet, Vector vector) {
        boolean bl = super.addTypes(n2, hashSet, vector);
        if (bl) {
            ClassType classType = this.getSuperclass();
            if (classType != null) {
                classType.addTypes(n2, hashSet, vector);
            }
            int n3 = 0;
            while (n3 < this.interfaces.length) {
                this.interfaces[n3].addTypes(n2, hashSet, vector);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.methods.length) {
                ValueType[] valueTypeArray;
                this.methods[n4].getReturnType().addTypes(n2, hashSet, vector);
                Type[] typeArray = this.methods[n4].getArguments();
                int n5 = 0;
                while (n5 < typeArray.length) {
                    valueTypeArray = typeArray[n5];
                    valueTypeArray.addTypes(n2, hashSet, vector);
                    ++n5;
                }
                valueTypeArray = this.methods[n4].getExceptions();
                int n6 = 0;
                while (n6 < valueTypeArray.length) {
                    ValueType valueType = valueTypeArray[n6];
                    valueType.addTypes(n2, hashSet, vector);
                    ++n6;
                }
                ++n4;
            }
            int n7 = 0;
            while (n7 < this.members.length) {
                Type type = this.members[n7].getType();
                type.addTypes(n2, hashSet, vector);
                ++n7;
            }
        }
        return bl;
    }

    private boolean isConformingConstantType(MemberDefinition memberDefinition) {
        return this.isConformingConstantType(memberDefinition.getType(), memberDefinition);
    }

    private boolean isConformingConstantType(sun.tools.java.Type type, MemberDefinition memberDefinition) {
        boolean bl = true;
        int n2 = type.getTypeCode();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 10: {
                if (type.getClassName() == sun.tools.java.Constants.idJavaLangString) break;
                Type.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl = false;
                break;
            }
            case 9: {
                Type.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl = false;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n2);
            }
        }
        return bl;
    }

    protected Vector updateParentClassMethods(ClassDefinition classDefinition, Vector vector, boolean bl, ContextStack contextStack) throws ClassNotFound {
        ClassDeclaration classDeclaration = classDefinition.getSuperClass(this.env);
        while (classDeclaration != null) {
            ClassDefinition classDefinition2 = classDeclaration.getClassDefinition(this.env);
            Identifier identifier = classDeclaration.getName();
            if (identifier == sun.tools.java.Constants.idJavaLangObject) break;
            MemberDefinition memberDefinition = classDefinition2.getFirstMember();
            while (memberDefinition != null) {
                if (memberDefinition.isMethod() && !memberDefinition.isInitializer() && !memberDefinition.isConstructor() && !memberDefinition.isPrivate()) {
                    Method method;
                    try {
                        method = new Method(this, memberDefinition, bl, contextStack);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    int n2 = vector.indexOf(method);
                    if (n2 >= 0) {
                        Method method2 = (Method)vector.elementAt(n2);
                        method2.setDeclaredBy(identifier);
                    } else {
                        vector.addElement(method);
                    }
                }
                memberDefinition = memberDefinition.getNextMember();
            }
            classDeclaration = classDefinition2.getSuperClass(this.env);
        }
        return vector;
    }

    protected Vector addAllMethods(ClassDefinition classDefinition, Vector vector, boolean bl, boolean bl2, ContextStack contextStack) throws ClassNotFound {
        Object object;
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            object = this.addAllMethods(classDeclarationArray[n2].getClassDefinition(this.env), vector, bl, bl2, contextStack);
            if (object == null) {
                return null;
            }
            ++n2;
        }
        object = classDefinition.getFirstMember();
        while (object != null) {
            if (((MemberDefinition)object).isMethod() && !((MemberDefinition)object).isInitializer() && !((MemberDefinition)object).isPrivate()) {
                Method method;
                ClassDefinition classDefinition2;
                Method method2;
                try {
                    method2 = new Method(this, (MemberDefinition)object, bl2, contextStack);
                }
                catch (Exception exception) {
                    return null;
                }
                if (!vector.contains(method2)) {
                    vector.addElement(method2);
                } else if (!(!bl || classDefinition == this.classDef || contextStack.isParentAValue() || contextStack.getContext().isValue() || classDefinition == (classDefinition2 = (method = (Method)vector.elementAt(vector.indexOf(method2))).getMemberDefinition().getClassDefinition()) || this.inheritsFrom(classDefinition, classDefinition2) || this.inheritsFrom(classDefinition2, classDefinition))) {
                    String string = classDefinition2.getName() + " and " + classDefinition.getName();
                    Type.failedConstraint(6, bl2, contextStack, this.classDef, string, method2);
                    return null;
                }
            }
            object = ((MemberDefinition)object).getNextMember();
        }
        return vector;
    }

    protected boolean inheritsFrom(ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        ClassDefinition classDefinition3;
        if (classDefinition == classDefinition2) {
            return true;
        }
        if (classDefinition.getSuperClass() != null && this.inheritsFrom(classDefinition3 = classDefinition.getSuperClass().getClassDefinition(), classDefinition2)) {
            return true;
        }
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            classDefinition3 = classDeclarationArray[n2].getClassDefinition();
            if (this.inheritsFrom(classDefinition3, classDefinition2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Vector addRemoteInterfaces(Vector vector, boolean bl, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            ClassDefinition classDefinition2 = classDeclarationArray[n2].getClassDefinition(this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null) {
                if (this.env.defRemote.implementedBy(this.env, classDeclarationArray[n2])) {
                    interfaceType = RemoteType.forRemote(classDefinition2, contextStack, false);
                } else {
                    interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, true);
                    if (interfaceType == null && bl) {
                        interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                    }
                }
            }
            if (interfaceType == null) {
                return null;
            }
            vector.addElement(interfaceType);
            ++n2;
        }
        return vector;
    }

    protected Vector addNonRemoteInterfaces(Vector vector, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        int n2 = 0;
        while (n2 < classDeclarationArray.length) {
            ClassDefinition classDefinition2 = classDeclarationArray[n2].getClassDefinition(this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null && (interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, true)) == null) {
                interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
            }
            if (interfaceType == null) {
                return null;
            }
            vector.addElement(interfaceType);
            ++n2;
        }
        return vector;
    }

    protected boolean addAllMembers(Vector vector, boolean bl, boolean bl2, ContextStack contextStack) {
        boolean bl3 = true;
        MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember();
        while (memberDefinition != null && bl3) {
            if (!memberDefinition.isMethod()) {
                try {
                    Object object;
                    String string = null;
                    memberDefinition.getValue(this.env);
                    Node node = memberDefinition.getValue();
                    if (node != null) {
                        if (memberDefinition.getType().getTypeCode() == 2) {
                            object = (Integer)((IntegerExpression)node).getValue();
                            string = "L'" + String.valueOf((char)((Integer)object).intValue()) + "'";
                        } else {
                            string = node.toString();
                        }
                    }
                    if (bl && memberDefinition.getInnerClass() == null && (string == null || !this.isConformingConstantType(memberDefinition))) {
                        Type.failedConstraint(3, bl2, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                        bl3 = false;
                        break;
                    }
                    try {
                        object = new Member(memberDefinition, string, contextStack, this);
                        vector.addElement(object);
                    }
                    catch (CompilerError compilerError) {
                        bl3 = false;
                    }
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                    bl3 = false;
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return bl3;
    }

    protected boolean addConformingConstants(Vector vector, boolean bl, ContextStack contextStack) {
        boolean bl2 = true;
        MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember();
        while (memberDefinition != null && bl2) {
            if (!memberDefinition.isMethod()) {
                try {
                    String string = null;
                    memberDefinition.getValue(this.env);
                    Node node = memberDefinition.getValue();
                    if (node != null) {
                        string = node.toString();
                    }
                    if (string != null) {
                        if (!this.isConformingConstantType(memberDefinition)) {
                            Type.failedConstraint(3, bl, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                            bl2 = false;
                            break;
                        }
                        try {
                            Member member = new Member(memberDefinition, string, contextStack, this);
                            vector.addElement(member);
                        }
                        catch (CompilerError compilerError) {
                            bl2 = false;
                        }
                    }
                }
                catch (ClassNotFound classNotFound) {
                    Type.classNotFound(contextStack, classNotFound);
                    bl2 = false;
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return bl2;
    }

    protected ValueType[] getMethodExceptions(MemberDefinition memberDefinition, boolean bl, ContextStack contextStack) throws Exception {
        boolean bl2 = true;
        contextStack.setNewContextCode(5);
        ClassDeclaration[] classDeclarationArray = memberDefinition.getExceptions(this.env);
        ValueType[] valueTypeArray = new ValueType[classDeclarationArray.length];
        try {
            int n2 = 0;
            while (n2 < classDeclarationArray.length) {
                ClassDefinition classDefinition = classDeclarationArray[n2].getClassDefinition(this.env);
                try {
                    ValueType valueType = ValueType.forValue(classDefinition, contextStack, false);
                    if (valueType != null) {
                        valueTypeArray[n2] = valueType;
                    } else {
                        bl2 = false;
                    }
                }
                catch (ClassCastException classCastException) {
                    Type.failedConstraint(22, bl, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: exception " + classDefinition.getName() + " not a class type!");
                }
                catch (NullPointerException nullPointerException) {
                    Type.failedConstraint(23, bl, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: caught null pointer exception");
                }
                ++n2;
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(bl, contextStack, classNotFound);
            bl2 = false;
        }
        if (!bl2) {
            throw new Exception();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < valueTypeArray.length) {
            int n5 = 0;
            while (n5 < valueTypeArray.length) {
                if (n4 != n5 && valueTypeArray[n4] != null && valueTypeArray[n4] == valueTypeArray[n5]) {
                    valueTypeArray[n5] = null;
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        if (n3 > 0) {
            int n6 = 0;
            ValueType[] valueTypeArray2 = new ValueType[valueTypeArray.length - n3];
            int n7 = 0;
            while (n7 < valueTypeArray.length) {
                if (valueTypeArray[n7] != null) {
                    valueTypeArray2[n6++] = valueTypeArray[n7];
                }
                ++n7;
            }
            valueTypeArray = valueTypeArray2;
        }
        return valueTypeArray;
    }

    protected static String getVisibilityString(MemberDefinition memberDefinition) {
        String string = "";
        String string2 = "";
        if (memberDefinition.isPublic()) {
            string = string + "public";
            string2 = " ";
        } else if (memberDefinition.isProtected()) {
            string = string + "protected";
            string2 = " ";
        } else if (memberDefinition.isPrivate()) {
            string = string + "private";
            string2 = " ";
        }
        if (memberDefinition.isStatic()) {
            string = string + string2;
            string = string + "static";
            string2 = " ";
        }
        if (memberDefinition.isFinal()) {
            string = string + string2;
            string = string + "final";
            string2 = " ";
        }
        return string;
    }

    protected boolean assertNotImpl(Type type, boolean bl, ContextStack contextStack, CompoundType compoundType, boolean bl2) {
        if (type.isType(65536)) {
            int n2 = bl2 ? 28 : 21;
            Type.failedConstraint(n2, bl, contextStack, type, compoundType.getName());
            return false;
        }
        return true;
    }

    public class Member
    implements ContextElement,
    Cloneable {
        private Type type;
        private String vis;
        private String value;
        private String name;
        private String idlName;
        private boolean innerClassDecl;
        private boolean constant;
        private MemberDefinition member;
        private boolean forceTransient;

        public String getElementName() {
            return "\"" + this.getName() + "\"";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.member.isPublic();
        }

        public boolean isPrivate() {
            return this.member.isPrivate();
        }

        public boolean isStatic() {
            return this.member.isStatic();
        }

        public boolean isFinal() {
            return this.member.isFinal();
        }

        public boolean isTransient() {
            if (this.forceTransient) {
                return true;
            }
            return this.member.isTransient();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInnerClassDeclaration() {
            return this.innerClassDecl;
        }

        public boolean isConstant() {
            return this.constant;
        }

        public String toString() {
            String string = this.type.toString();
            if (this.value != null) {
                string = string + " = " + this.value;
            }
            return string;
        }

        protected void swapInvalidTypes() {
            if (this.type.getStatus() != 1) {
                this.type = CompoundType.this.getValidType(this.type);
            }
        }

        protected void setTransient() {
            if (!this.isTransient()) {
                this.forceTransient = true;
                this.vis = this.vis.length() > 0 ? this.vis + " transient" : "transient";
            }
        }

        protected MemberDefinition getMemberDefinition() {
            return this.member;
        }

        public void destroy() {
            if (this.type != null) {
                this.type.destroy();
                this.type = null;
                this.vis = null;
                this.value = null;
                this.name = null;
                this.idlName = null;
                this.member = null;
            }
        }

        public Member(MemberDefinition memberDefinition, String string, ContextStack contextStack, CompoundType compoundType2) {
            this.member = memberDefinition;
            this.value = string;
            this.forceTransient = false;
            boolean bl = this.innerClassDecl = memberDefinition.getInnerClass() != null;
            if (!this.innerClassDecl) {
                this.init(contextStack, compoundType2);
            }
        }

        public void init(ContextStack contextStack, CompoundType compoundType) {
            this.constant = false;
            this.name = this.member.getName().toString();
            this.vis = CompoundType.getVisibilityString(this.member);
            this.idlName = null;
            int n2 = 6;
            contextStack.setNewContextCode(n2);
            if (this.member.isVariable()) {
                if (this.value != null && this.member.isConstant()) {
                    n2 = 7;
                    this.constant = true;
                } else if (this.member.isStatic()) {
                    n2 = 8;
                } else if (this.member.isTransient()) {
                    n2 = 9;
                }
            }
            contextStack.setNewContextCode(n2);
            contextStack.push(this);
            this.type = CompoundType.makeType(this.member.getType(), null, contextStack);
            if (this.type == null || !this.innerClassDecl && !this.member.isStatic() && !this.member.isTransient() && !CompoundType.this.assertNotImpl(this.type, false, contextStack, compoundType, true)) {
                contextStack.pop(false);
                throw new CompilerError("");
            }
            if (this.constant && this.type.isPrimitive()) {
                if (this.type.isType(64) || this.type.isType(128) || this.type.isType(256)) {
                    int n3 = this.value.length();
                    char c2 = this.value.charAt(n3 - 1);
                    if (!Character.isDigit(c2)) {
                        this.value = this.value.substring(0, n3 - 1);
                    }
                } else if (this.type.isType(2)) {
                    this.value = this.value.toUpperCase();
                }
            }
            if (this.constant && this.type.isType(512)) {
                this.value = "L" + this.value;
            }
            contextStack.pop(true);
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }
    }

    public class Method
    implements ContextElement,
    Cloneable {
        private MemberDefinition memberDef;
        private CompoundType enclosing;
        private ValueType[] exceptions;
        private ValueType[] implExceptions;
        private Type returnType;
        private Type[] arguments;
        private String[] argumentNames;
        private String vis;
        private String name;
        private String idlName;
        private String stringRep = null;
        private int attributeKind = 0;
        private String attributeName = null;
        private int attributePairIndex = -1;
        private Identifier declaredBy = null;

        public boolean isInherited() {
            return this.declaredBy != this.enclosing.getIdentifier();
        }

        public boolean isAttribute() {
            return this.attributeKind != 0;
        }

        public boolean isReadWriteAttribute() {
            return this.attributeKind == 3 || this.attributeKind == 4;
        }

        public int getAttributeKind() {
            return this.attributeKind;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getAttributePairIndex() {
            return this.attributePairIndex;
        }

        public String getElementName() {
            return this.memberDef.toString();
        }

        public boolean equals(Object object) {
            Method method = (Method)object;
            if (this.getName().equals(method.getName()) && this.arguments.length == method.arguments.length) {
                int n2 = 0;
                while (n2 < this.arguments.length) {
                    if (!this.arguments[n2].equals(method.arguments[n2])) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public CompoundType getEnclosing() {
            return this.enclosing;
        }

        public Identifier getDeclaredBy() {
            return this.declaredBy;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.memberDef.isPublic();
        }

        public boolean isProtected() {
            return this.memberDef.isPrivate();
        }

        public boolean isPrivate() {
            return this.memberDef.isPrivate();
        }

        public boolean isStatic() {
            return this.memberDef.isStatic();
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public sun.tools.java.Type getType() {
            return this.memberDef.getType();
        }

        public boolean isConstructor() {
            return this.memberDef.isConstructor();
        }

        public boolean isNormalMethod() {
            return !this.memberDef.isConstructor() && this.attributeKind == 0;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Type[] getArguments() {
            return (Type[])this.arguments.clone();
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public ValueType[] getExceptions() {
            return (ValueType[])this.exceptions.clone();
        }

        public ValueType[] getImplExceptions() {
            return (ValueType[])this.implExceptions.clone();
        }

        public ValueType[] getUniqueCatchList(ValueType[] valueTypeArray) {
            int n2;
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n3 = valueTypeArray.length;
            try {
                int n4 = 0;
                while (n4 < valueTypeArray.length) {
                    ClassDeclaration classDeclaration = valueTypeArray[n4].getClassDeclaration();
                    if (CompoundType.this.env.defRemoteException.superClassOf(CompoundType.this.env, classDeclaration) || CompoundType.this.env.defRuntimeException.superClassOf(CompoundType.this.env, classDeclaration) || CompoundType.this.env.defError.superClassOf(CompoundType.this.env, classDeclaration)) {
                        valueTypeArray[n4] = null;
                        --n3;
                    }
                    ++n4;
                }
                n2 = 0;
                while (n2 < valueTypeArray.length) {
                    if (valueTypeArray[n2] != null) {
                        ClassDefinition classDefinition = valueTypeArray[n2].getClassDefinition();
                        int n5 = 0;
                        while (n5 < valueTypeArray.length) {
                            if (n5 != n2 && valueTypeArray[n2] != null && valueTypeArray[n5] != null && classDefinition.superClassOf(CompoundType.this.env, valueTypeArray[n5].getClassDeclaration())) {
                                valueTypeArray[n5] = null;
                                --n3;
                            }
                            ++n5;
                        }
                    }
                    ++n2;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n3 < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n3];
                n2 = 0;
                int n6 = 0;
                while (n6 < valueTypeArray.length) {
                    if (valueTypeArray[n6] != null) {
                        valueTypeArray3[n2++] = valueTypeArray[n6];
                    }
                    ++n6;
                }
                valueTypeArray = valueTypeArray3;
            }
            if (valueTypeArray.length == 0) {
                return null;
            }
            return valueTypeArray;
        }

        public ValueType[] getFilteredStubExceptions(ValueType[] valueTypeArray) {
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n2 = valueTypeArray.length;
            try {
                int n3 = 0;
                while (n3 < valueTypeArray.length) {
                    ClassDeclaration classDeclaration = valueTypeArray[n3].getClassDeclaration();
                    if (CompoundType.this.env.defRemoteException.superClassOf(CompoundType.this.env, classDeclaration) && !CompoundType.this.env.defRemoteException.getClassDeclaration().equals(classDeclaration) || CompoundType.this.env.defRuntimeException.superClassOf(CompoundType.this.env, classDeclaration) || CompoundType.this.env.defError.superClassOf(CompoundType.this.env, classDeclaration)) {
                        valueTypeArray[n3] = null;
                        --n2;
                    }
                    ++n3;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n2 < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < valueTypeArray.length) {
                    if (valueTypeArray[n5] != null) {
                        valueTypeArray3[n4++] = valueTypeArray[n5];
                    }
                    ++n5;
                }
                valueTypeArray = valueTypeArray3;
            }
            return valueTypeArray;
        }

        public String toString() {
            if (this.stringRep == null) {
                StringBuffer stringBuffer = new StringBuffer(this.returnType.toString());
                stringBuffer.append(" ");
                stringBuffer.append(this.getName());
                stringBuffer.append(" (");
                int n2 = 0;
                while (n2 < this.arguments.length) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[n2]);
                    stringBuffer.append(" ");
                    stringBuffer.append(this.argumentNames[n2]);
                    ++n2;
                }
                stringBuffer.append(")");
                int n3 = 0;
                while (n3 < this.exceptions.length) {
                    if (n3 == 0) {
                        stringBuffer.append(" throws ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.exceptions[n3]);
                    ++n3;
                }
                stringBuffer.append(";");
                this.stringRep = stringBuffer.toString();
            }
            return this.stringRep;
        }

        public void setAttributeKind(int n2) {
            this.attributeKind = n2;
        }

        public void setAttributePairIndex(int n2) {
            this.attributePairIndex = n2;
        }

        public void setAttributeName(String string) {
            this.attributeName = string;
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        public void setImplExceptions(ValueType[] valueTypeArray) {
            this.implExceptions = valueTypeArray;
        }

        public void setDeclaredBy(Identifier identifier) {
            this.declaredBy = identifier;
        }

        protected void swapInvalidTypes() {
            if (this.returnType.getStatus() != 1) {
                this.returnType = CompoundType.this.getValidType(this.returnType);
            }
            int n2 = 0;
            while (n2 < this.arguments.length) {
                if (this.arguments[n2].getStatus() != 1) {
                    this.arguments[n2] = CompoundType.this.getValidType(this.arguments[n2]);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.exceptions.length) {
                if (this.exceptions[n3].getStatus() != 1) {
                    this.exceptions[n3] = (ValueType)CompoundType.this.getValidType(this.exceptions[n3]);
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.implExceptions.length) {
                if (this.implExceptions[n4].getStatus() != 1) {
                    this.implExceptions[n4] = (ValueType)CompoundType.this.getValidType(this.implExceptions[n4]);
                }
                ++n4;
            }
        }

        public void destroy() {
            if (this.memberDef != null) {
                int n2;
                this.memberDef = null;
                this.enclosing = null;
                if (this.exceptions != null) {
                    n2 = 0;
                    while (n2 < this.exceptions.length) {
                        if (this.exceptions[n2] != null) {
                            this.exceptions[n2].destroy();
                        }
                        this.exceptions[n2] = null;
                        ++n2;
                    }
                    this.exceptions = null;
                }
                if (this.implExceptions != null) {
                    n2 = 0;
                    while (n2 < this.implExceptions.length) {
                        if (this.implExceptions[n2] != null) {
                            this.implExceptions[n2].destroy();
                        }
                        this.implExceptions[n2] = null;
                        ++n2;
                    }
                    this.implExceptions = null;
                }
                if (this.returnType != null) {
                    this.returnType.destroy();
                }
                this.returnType = null;
                if (this.arguments != null) {
                    n2 = 0;
                    while (n2 < this.arguments.length) {
                        if (this.arguments[n2] != null) {
                            this.arguments[n2].destroy();
                        }
                        this.arguments[n2] = null;
                        ++n2;
                    }
                    this.arguments = null;
                }
                if (this.argumentNames != null) {
                    n2 = 0;
                    while (n2 < this.argumentNames.length) {
                        this.argumentNames[n2] = null;
                        ++n2;
                    }
                    this.argumentNames = null;
                }
                this.vis = null;
                this.name = null;
                this.idlName = null;
                this.stringRep = null;
                this.attributeName = null;
                this.declaredBy = null;
            }
        }

        private String makeArgName(int n2, Type type) {
            return "arg" + n2;
        }

        public Method(CompoundType compoundType2, MemberDefinition memberDefinition, boolean bl, ContextStack contextStack) throws Exception {
            this.enclosing = compoundType2;
            this.memberDef = memberDefinition;
            this.vis = CompoundType.getVisibilityString(memberDefinition);
            this.idlName = null;
            boolean bl2 = true;
            this.declaredBy = memberDefinition.getClassDeclaration().getName();
            this.name = memberDefinition.getName().toString();
            contextStack.setNewContextCode(2);
            contextStack.push(this);
            contextStack.setNewContextCode(3);
            sun.tools.java.Type type = memberDefinition.getType();
            sun.tools.java.Type type2 = type.getReturnType();
            if (type2 == sun.tools.java.Type.tVoid) {
                this.returnType = PrimitiveType.forPrimitive(type2, contextStack);
            } else {
                this.returnType = CompoundType.makeType(type2, null, contextStack);
                if (this.returnType == null || !CompoundType.this.assertNotImpl(this.returnType, bl, contextStack, compoundType2, false)) {
                    bl2 = false;
                    Type.failedConstraint(24, bl, contextStack, compoundType2.getName());
                }
            }
            contextStack.setNewContextCode(4);
            sun.tools.java.Type[] typeArray = memberDefinition.getType().getArgumentTypes();
            this.arguments = new Type[typeArray.length];
            this.argumentNames = new String[typeArray.length];
            Vector vector = memberDefinition.getArguments();
            int n2 = 0;
            while (n2 < typeArray.length) {
                Type type3 = null;
                try {
                    type3 = CompoundType.makeType(typeArray[n2], null, contextStack);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type3 != null) {
                    if (!CompoundType.this.assertNotImpl(type3, bl, contextStack, compoundType2, false)) {
                        bl2 = false;
                    } else {
                        this.arguments[n2] = type3;
                        if (vector != null) {
                            LocalMember localMember = (LocalMember)vector.elementAt(n2 + 1);
                            this.argumentNames[n2] = localMember.getName().toString();
                        } else {
                            this.argumentNames[n2] = this.makeArgName(n2, type3);
                        }
                    }
                } else {
                    bl2 = false;
                    Type.failedConstraint(25, false, contextStack, compoundType2.getQualifiedName(), this.name);
                }
                ++n2;
            }
            if (!bl2) {
                contextStack.pop(false);
                throw new Exception();
            }
            try {
                this.exceptions = compoundType2.getMethodExceptions(memberDefinition, bl, contextStack);
                this.implExceptions = this.exceptions;
                contextStack.pop(true);
            }
            catch (Exception exception) {
                contextStack.pop(false);
                throw new Exception();
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }
    }
}

