/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;

public class ArrayType
extends Type {
    private Type type;
    private int arrayDimension;
    private String brackets;
    private String bracketsSig;

    public static ArrayType forArray(sun.tools.java.Type type, ContextStack contextStack) {
        ArrayType arrayType = null;
        sun.tools.java.Type type2 = type;
        if (type2.getTypeCode() == 9) {
            while (type2.getTypeCode() == 9) {
                type2 = type2.getElementType();
            }
            Type type3 = Type.getType(type, contextStack);
            if (type3 != null) {
                if (!(type3 instanceof ArrayType)) {
                    return null;
                }
                return (ArrayType)type3;
            }
            Type type4 = CompoundType.makeType(type2, null, contextStack);
            if (type4 != null) {
                arrayType = new ArrayType(contextStack, type4, type.getArrayDimension());
                Type.putType(type, (Type)arrayType, contextStack);
                contextStack.push(arrayType);
                contextStack.pop(true);
            }
        }
        return arrayType;
    }

    public String getSignature() {
        return this.bracketsSig + this.type.getSignature();
    }

    public Type getElementType() {
        return this.type;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public String getArrayBrackets() {
        return this.brackets;
    }

    public String toString() {
        return this.getQualifiedName() + this.brackets;
    }

    public String getTypeDescription() {
        return "Array of " + this.type.getTypeDescription();
    }

    public String getTypeName(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return super.getTypeName(bl, bl2, bl3);
        }
        return super.getTypeName(bl, bl2, bl3) + this.brackets;
    }

    protected void swapInvalidTypes() {
        if (this.type.getStatus() != 1) {
            this.type = this.getValidType(this.type);
        }
    }

    protected boolean addTypes(int n2, HashSet hashSet, Vector vector) {
        boolean bl = super.addTypes(n2, hashSet, vector);
        if (bl) {
            this.getElementType().addTypes(n2, hashSet, vector);
        }
        return bl;
    }

    private ArrayType(ContextStack contextStack, Type type, int n2) {
        super(contextStack, 262144);
        this.type = type;
        this.arrayDimension = n2;
        this.brackets = "";
        this.bracketsSig = "";
        int n3 = 0;
        while (n3 < n2) {
            this.brackets = this.brackets + "[]";
            this.bracketsSig = this.bracketsSig + "[";
            ++n3;
        }
        String string = IDLNames.getArrayName(type, n2);
        String[] stringArray = IDLNames.getArrayModuleNames(type);
        this.setNames(type.getIdentifier(), stringArray, string);
        this.setRepositoryID();
    }

    protected Class loadClass() {
        Class<?> clazz = null;
        Class clazz2 = this.type.getClassInstance();
        if (clazz2 != null) {
            clazz = Array.newInstance(clazz2, new int[this.arrayDimension]).getClass();
        }
        return clazz;
    }

    protected void destroy() {
        super.destroy();
        if (this.type != null) {
            this.type.destroy();
            this.type = null;
        }
        this.brackets = null;
        this.bracketsSig = null;
    }
}

