/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.Constants;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.RMIConstants;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RemoteClass
implements RMIConstants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private ClassDefinition[] remoteInterfaces;
    private Method[] remoteMethods;
    private long interfaceHash;
    private ClassDefinition defRemote;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;

    public static RemoteClass forClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        RemoteClass remoteClass = new RemoteClass(batchEnvironment, classDefinition);
        if (remoteClass.initialize()) {
            return remoteClass;
        }
        return null;
    }

    public ClassDefinition getClassDefinition() {
        return this.implClassDef;
    }

    public Identifier getName() {
        return this.implClassDef.getName();
    }

    public ClassDefinition[] getRemoteInterfaces() {
        return (ClassDefinition[])this.remoteInterfaces.clone();
    }

    public Method[] getRemoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    public long getInterfaceHash() {
        return this.interfaceHash;
    }

    public String toString() {
        return "remote class " + this.implClassDef.getName().toString();
    }

    private RemoteClass(BatchEnvironment batchEnvironment, ClassDefinition classDefinition) {
        this.env = batchEnvironment;
        this.implClassDef = classDefinition;
    }

    private boolean initialize() {
        int n2;
        ClassDeclaration[] classDeclarationArray;
        String[] stringArray;
        Object object;
        int n3;
        ClassDeclaration[] classDeclarationArray2;
        if (this.implClassDef.isInterface()) {
            this.env.error(0L, "rmic.cant.make.stubs.for.interface", this.implClassDef.getName());
            return false;
        }
        try {
            this.defRemote = this.env.getClassDeclaration(Constants.idRemote).getClassDefinition(this.env);
            this.defException = this.env.getClassDeclaration(sun.tools.java.Constants.idJavaLangException).getClassDefinition(this.env);
            this.defRemoteException = this.env.getClassDeclaration(Constants.idRemoteException).getClassDefinition(this.env);
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "rmic.class.not.found", classNotFound.name);
            return false;
        }
        Vector<Object> vector = new Vector<Object>();
        ClassDefinition classDefinition = this.implClassDef;
        while (classDefinition != null) {
            try {
                classDeclarationArray2 = classDefinition.getInterfaces();
                n3 = 0;
                while (n3 < classDeclarationArray2.length) {
                    object = classDeclarationArray2[n3].getClassDefinition(this.env);
                    if (!vector.contains(object) && this.defRemote.implementedBy(this.env, classDeclarationArray2[n3])) {
                        vector.addElement(object);
                        if (this.env.verbose()) {
                            System.out.println("[found remote interface: " + ((ClassDefinition)object).getName() + "]");
                        }
                    }
                    ++n3;
                }
                if (classDefinition == this.implClassDef && vector.isEmpty()) {
                    if (this.defRemote.implementedBy(this.env, this.implClassDef.getClassDeclaration())) {
                        this.env.error(0L, "rmic.must.implement.remote.directly", this.implClassDef.getName());
                    } else {
                        this.env.error(0L, "rmic.must.implement.remote", this.implClassDef.getName());
                    }
                    return false;
                }
                classDefinition = classDefinition.getSuperClass() != null ? classDefinition.getSuperClass().getClassDefinition(this.env) : null;
            }
            catch (ClassNotFound classNotFound) {
                this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
                return false;
            }
        }
        classDeclarationArray2 = new Hashtable();
        n3 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            stringArray = (String[])object.nextElement();
            if (this.collectRemoteMethods((ClassDefinition)stringArray, (Hashtable)classDeclarationArray2)) continue;
            n3 = 1;
        }
        if (n3 != 0) {
            return false;
        }
        this.remoteInterfaces = new ClassDefinition[vector.size()];
        vector.copyInto(this.remoteInterfaces);
        stringArray = new String[classDeclarationArray2.size()];
        int n4 = 0;
        Enumeration enumeration = classDeclarationArray2.elements();
        while (enumeration.hasMoreElements()) {
            Method method = (Method)enumeration.nextElement();
            classDeclarationArray = method.getNameAndDescriptor();
            n2 = n4;
            while (n2 > 0) {
                if (classDeclarationArray.compareTo(stringArray[n2 - 1]) >= 0) break;
                stringArray[n2] = stringArray[n2 - 1];
                --n2;
            }
            stringArray[n2] = classDeclarationArray;
            ++n4;
        }
        this.remoteMethods = new Method[classDeclarationArray2.size()];
        int n5 = 0;
        while (n5 < this.remoteMethods.length) {
            this.remoteMethods[n5] = (Method)classDeclarationArray2.get(stringArray[n5]);
            if (this.env.verbose()) {
                System.out.print("[found remote method <" + n5 + ">: " + this.remoteMethods[n5].getOperationString());
                classDeclarationArray = this.remoteMethods[n5].getExceptions();
                if (classDeclarationArray.length > 0) {
                    System.out.print(" throws ");
                }
                n2 = 0;
                while (n2 < classDeclarationArray.length) {
                    if (n2 > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(classDeclarationArray[n2].getName());
                    ++n2;
                }
                System.out.println("]");
            }
            ++n5;
        }
        this.interfaceHash = this.computeInterfaceHash();
        return true;
    }

    private boolean collectRemoteMethods(ClassDefinition classDefinition, Hashtable hashtable) {
        int n2;
        ClassDeclaration[] classDeclarationArray;
        if (!classDefinition.isInterface()) {
            throw new Error("expected interface, not class: " + classDefinition.getName());
        }
        boolean bl = false;
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            block19: {
                if (memberDefinition.isMethod() && !memberDefinition.isConstructor() && !memberDefinition.isInitializer()) {
                    classDeclarationArray = memberDefinition.getExceptions(this.env);
                    n2 = 0;
                    int n3 = 0;
                    while (n3 < classDeclarationArray.length) {
                        try {
                            if (this.defRemoteException.subClassOf(this.env, classDeclarationArray[n3])) {
                                n2 = 1;
                                break;
                            }
                        }
                        catch (ClassNotFound classNotFound) {
                            this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
                            break block19;
                        }
                        ++n3;
                    }
                    if (n2 == 0) {
                        this.env.error(0L, "rmic.must.throw.remoteexception", classDefinition.getName(), memberDefinition.toString());
                        bl = true;
                    } else {
                        Object object;
                        block20: {
                            try {
                                object = this.implClassDef.findMethod(this.env, memberDefinition.getName(), memberDefinition.getType());
                                if (object == null) break block20;
                                classDeclarationArray = ((MemberDefinition)object).getExceptions(this.env);
                                int n4 = 0;
                                while (n4 < classDeclarationArray.length) {
                                    if (!this.defException.superClassOf(this.env, classDeclarationArray[n4])) {
                                        this.env.error(0L, "rmic.must.only.throw.exception", ((MemberDefinition)object).toString(), classDeclarationArray[n4].getName());
                                        bl = true;
                                        break block19;
                                    }
                                    ++n4;
                                }
                            }
                            catch (ClassNotFound classNotFound) {
                                this.env.error(0L, "class.not.found", classNotFound.name, this.implClassDef.getName());
                                break block19;
                            }
                        }
                        object = new Method(memberDefinition);
                        String string = ((Method)object).getNameAndDescriptor();
                        Method method = (Method)hashtable.get(string);
                        if (method != null && (object = ((Method)object).mergeWith(method)) == null) {
                            bl = true;
                        } else {
                            hashtable.put(string, object);
                        }
                    }
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        try {
            classDeclarationArray = classDefinition.getInterfaces();
            n2 = 0;
            while (n2 < classDeclarationArray.length) {
                ClassDefinition classDefinition2 = classDeclarationArray[n2].getClassDefinition(this.env);
                if (!this.collectRemoteMethods(classDefinition2, hashtable)) {
                    bl = true;
                }
                ++n2;
            }
        }
        catch (ClassNotFound classNotFound) {
            this.env.error(0L, "class.not.found", classNotFound.name, classDefinition.getName());
            return false;
        }
        return !bl;
    }

    private long computeInterfaceHash() {
        long l2 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        try {
            Object object;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            dataOutputStream.writeInt(1);
            int n2 = 0;
            while (n2 < this.remoteMethods.length) {
                object = this.remoteMethods[n2].getMemberDefinition();
                Identifier identifier = ((MemberDefinition)object).getName();
                Type type = ((MemberDefinition)object).getType();
                dataOutputStream.writeUTF(identifier.toString());
                dataOutputStream.writeUTF(type.getTypeSignature());
                ClassDeclaration[] classDeclarationArray = ((MemberDefinition)object).getExceptions(this.env);
                this.sortClassDeclarations(classDeclarationArray);
                int n3 = 0;
                while (n3 < classDeclarationArray.length) {
                    dataOutputStream.writeUTF(Names.mangleClass(classDeclarationArray[n3].getName()).toString());
                    ++n3;
                }
                ++n2;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n4 = 0;
            while (n4 < Math.min(8, ((Object)object).length)) {
                l2 += (long)(object[n4] & 0xFF) << n4 * 8;
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new Error("unexpected exception computing intetrface hash: " + iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
        }
        return l2;
    }

    private void sortClassDeclarations(ClassDeclaration[] classDeclarationArray) {
        int n2 = 1;
        while (n2 < classDeclarationArray.length) {
            ClassDeclaration classDeclaration = classDeclarationArray[n2];
            String string = Names.mangleClass(classDeclaration.getName()).toString();
            int n3 = n2;
            while (n3 > 0) {
                if (string.compareTo(Names.mangleClass(classDeclarationArray[n3 - 1].getName()).toString()) >= 0) break;
                classDeclarationArray[n3] = classDeclarationArray[n3 - 1];
                --n3;
            }
            classDeclarationArray[n3] = classDeclaration;
            ++n2;
        }
    }

    public class Method
    implements Cloneable {
        private MemberDefinition memberDef;
        private long methodHash;
        private ClassDeclaration[] exceptions;

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public Identifier getName() {
            return this.memberDef.getName();
        }

        public Type getType() {
            return this.memberDef.getType();
        }

        public ClassDeclaration[] getExceptions() {
            return (ClassDeclaration[])this.exceptions.clone();
        }

        public long getMethodHash() {
            return this.methodHash;
        }

        public String toString() {
            return this.memberDef.toString();
        }

        public String getOperationString() {
            return this.memberDef.toString();
        }

        public String getNameAndDescriptor() {
            return this.memberDef.getName().toString() + this.memberDef.getType().getTypeSignature();
        }

        Method(MemberDefinition memberDefinition) {
            this.memberDef = memberDefinition;
            this.exceptions = memberDefinition.getExceptions(RemoteClass.this.env);
            this.methodHash = this.computeMethodHash();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }

        private Method mergeWith(Method method) {
            if (!this.getName().equals(method.getName()) || !this.getType().equals(method.getType())) {
                throw new Error("attempt to merge method \"" + method.getNameAndDescriptor() + "\" with \"" + this.getNameAndDescriptor());
            }
            Vector vector = new Vector();
            try {
                this.collectCompatibleExceptions(method.exceptions, this.exceptions, vector);
                this.collectCompatibleExceptions(this.exceptions, method.exceptions, vector);
            }
            catch (ClassNotFound classNotFound) {
                RemoteClass.this.env.error(0L, "class.not.found", classNotFound.name, RemoteClass.this.getClassDefinition().getName());
                return null;
            }
            Method method2 = (Method)this.clone();
            method2.exceptions = new ClassDeclaration[vector.size()];
            vector.copyInto(method2.exceptions);
            return method2;
        }

        private void collectCompatibleExceptions(ClassDeclaration[] classDeclarationArray, ClassDeclaration[] classDeclarationArray2, Vector vector) throws ClassNotFound {
            int n2 = 0;
            while (n2 < classDeclarationArray.length) {
                ClassDefinition classDefinition = classDeclarationArray[n2].getClassDefinition(RemoteClass.this.env);
                if (!vector.contains(classDeclarationArray[n2])) {
                    int n3 = 0;
                    while (n3 < classDeclarationArray2.length) {
                        if (classDefinition.subClassOf(RemoteClass.this.env, classDeclarationArray2[n3])) {
                            vector.addElement(classDeclarationArray[n2]);
                            break;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }

        private long computeMethodHash() {
            long l2 = 0L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
                String string = this.getNameAndDescriptor();
                if (RemoteClass.this.env.verbose()) {
                    System.out.println("[string used for method hash: \"" + string + "\"]");
                }
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
                byte[] byArray = messageDigest.digest();
                int n2 = 0;
                while (n2 < Math.min(8, byArray.length)) {
                    l2 += (long)(byArray[n2] & 0xFF) << n2 * 8;
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new Error("unexpected exception computing intetrface hash: " + iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new Error("unexpected exception computing intetrface hash: " + noSuchAlgorithmException);
            }
            return l2;
        }
    }
}

