/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import sun.applet.AppContextCreator;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletThreadGroup;
import sun.awt.AppContext;
import sun.net.www.ParseUtil;

public class AppletClassLoader
extends URLClassLoader {
    private URL base;
    private CodeSource codesource;
    private AccessControlContext acc;
    private final Object threadGroupSynchronizer = new Object();
    private final Object grabReleaseSynchronizer = new Object();
    private Object syncResourceAsStream = new Object();
    private boolean resourceAsStreamInCall = false;
    private AppletThreadGroup threadGroup;
    private AppContext appContext;
    int usageCount = 0;
    private static AppletMessageHandler mh = new AppletMessageHandler("appletclassloader");

    protected AppletClassLoader(URL uRL) {
        super(new URL[0]);
        this.base = uRL;
        this.codesource = new CodeSource(uRL, null);
        this.acc = AccessController.getContext();
    }

    URL getBaseURL() {
        return this.base;
    }

    public URL[] getURLs() {
        URL[] uRLArray = super.getURLs();
        URL[] uRLArray2 = new URL[uRLArray.length + 1];
        System.arraycopy(uRLArray, 0, uRLArray2, 0, uRLArray.length);
        uRLArray2[uRLArray2.length - 1] = this.base;
        return uRLArray2;
    }

    protected void addJar(String string) throws IOException {
        URL uRL;
        try {
            uRL = new URL(this.base, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("name");
        }
        this.addURL(uRL);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        SecurityManager securityManager;
        int n2 = string.lastIndexOf(46);
        if (n2 != -1 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPackageAccess(string.substring(0, n2));
        }
        try {
            return super.loadClass(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            final String string2 = string.replace('.', '/').concat(".class");
            try {
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return AppletClassLoader.getBytes(new URL(AppletClassLoader.this.base, string2));
                    }
                }, this.acc);
                if (byArray != null) {
                    return this.defineClass(string, byArray, 0, byArray.length, this.codesource);
                }
                throw new ClassNotFoundException(string);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new ClassNotFoundException(string, privilegedActionException.getException());
            }
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permission permission;
        final PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        String string = null;
        try {
            permission = uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        if (permission instanceof FilePermission) {
            string = permission.getName();
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
        }
        if (string != null) {
            Permission permission2;
            int n2;
            if (!string.endsWith(File.separator) && (n2 = string.lastIndexOf(File.separatorChar)) != -1) {
                string = string.substring(0, n2 + 1) + "-";
                permissionCollection.add(new FilePermission(string, "read"));
            }
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    return null;
                }
            });
            try {
                permission2 = this.base.openConnection().getPermission();
            }
            catch (IOException iOException) {
                permission2 = null;
            }
            if (permission2 instanceof FilePermission) {
                String string2 = permission2.getName();
                if (string2.endsWith(File.separator)) {
                    string2 = string2 + "-";
                }
                permissionCollection.add(new FilePermission(string2, "read"));
            } else if (permission2 == null && this.base.getProtocol().equals("file")) {
                String string3 = this.base.getFile().replace('/', File.separatorChar);
                if ((string3 = ParseUtil.decode(string3)).endsWith(File.separator)) {
                    string3 = string3 + "-";
                }
                permissionCollection.add(new FilePermission(string3, "read"));
            }
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL uRL) throws IOException {
        byte[] byArray;
        HttpURLConnection httpURLConnection;
        int n2;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        int n3 = uRLConnection.getContentLength();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            if (n3 != -1) {
                byArray = new byte[n3];
                while (n3 > 0) {
                    int n4 = ((InputStream)bufferedInputStream).read(byArray, byArray.length - n3, n3);
                    if (n4 == -1) {
                        throw new IOException("unexpected EOF");
                    }
                    n3 -= n4;
                }
            } else {
                byte[] byArray2;
                byArray = new byte[8192];
                int n5 = 0;
                while ((n3 = ((InputStream)bufferedInputStream).read(byArray, n5, byArray.length - n5)) != -1) {
                    if ((n5 += n3) < byArray.length) continue;
                    byArray2 = new byte[n5 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n5);
                    byArray = byArray2;
                }
                if (n5 != byArray.length) {
                    byArray2 = new byte[n5];
                    System.arraycopy(byArray, 0, byArray2, 0, n5);
                    byArray = byArray2;
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        try {
            InputStream inputStream = null;
            Object object = this.syncResourceAsStream;
            synchronized (object) {
                this.resourceAsStreamInCall = true;
                inputStream = super.getResourceAsStream(string);
                this.resourceAsStreamInCall = false;
            }
            if (inputStream == null) {
                URL uRL = new URL(this.base, string);
                inputStream = uRL.openStream();
            }
            return inputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String string) {
        URL uRL;
        block7: {
            uRL = super.findResource(string);
            if (uRL != null) break block7;
            boolean bl = false;
            Object object = this.syncResourceAsStream;
            synchronized (object) {
                bl = this.resourceAsStreamInCall;
            }
            if (!bl) {
                try {
                    uRL = new URL(this.base, string);
                    if (!this.resourceExists(uRL)) {
                        uRL = null;
                    }
                }
                catch (Exception exception) {
                    uRL = null;
                }
            }
        }
        return uRL;
    }

    private boolean resourceExists(URL uRL) {
        boolean bl;
        block5: {
            bl = true;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("HEAD");
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 == 200) {
                        return true;
                    }
                    if (n2 >= 400) {
                        return false;
                    }
                    break block5;
                }
                InputStream inputStream = uRLConnection.getInputStream();
                inputStream.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public Enumeration findResources(String string) throws IOException {
        URL uRL = new URL(this.base, string);
        if (!this.resourceExists(uRL)) {
            uRL = null;
        }
        final Enumeration<URL> enumeration = super.findResources(string);
        final URL uRL2 = uRL;
        return new Enumeration(){
            private boolean done;

            public Object nextElement() {
                if (!this.done) {
                    if (enumeration.hasMoreElements()) {
                        return enumeration.nextElement();
                    }
                    this.done = true;
                    if (uRL2 != null) {
                        return uRL2;
                    }
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return !this.done && (enumeration.hasMoreElements() || uRL2 != null);
            }
        };
    }

    Class loadCode(String string) throws ClassNotFoundException {
        string = string.replace('/', '.');
        String string2 = string = string.replace(File.separatorChar, '.');
        if (string.endsWith(".class") || string.endsWith(".java")) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        try {
            return this.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClass(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadGroup getThreadGroup() {
        Object object = this.threadGroupSynchronizer;
        synchronized (object) {
            if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        AppletClassLoader.this.threadGroup = new AppletThreadGroup(AppletClassLoader.this.base + "-threadGroup");
                        AppContextCreator appContextCreator = new AppContextCreator(AppletClassLoader.this.threadGroup);
                        appContextCreator.setContextClassLoader(AppletClassLoader.this);
                        Object object = appContextCreator.syncObject;
                        synchronized (object) {
                            appContextCreator.start();
                            try {
                                appContextCreator.syncObject.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            AppletClassLoader.this.appContext = appContextCreator.appContext;
                        }
                        return null;
                    }
                });
            }
            return this.threadGroup;
        }
    }

    AppContext getAppContext() {
        return this.appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grab() {
        Object object = this.grabReleaseSynchronizer;
        synchronized (object) {
            ++this.usageCount;
        }
        this.getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        block10: {
            AppContext appContext = null;
            Object object = this.grabReleaseSynchronizer;
            synchronized (object) {
                if (this.usageCount > 1) {
                    --this.usageCount;
                } else {
                    Object object2 = this.threadGroupSynchronizer;
                    synchronized (object2) {
                        appContext = this.appContext;
                        this.usageCount = 0;
                        this.appContext = null;
                        this.threadGroup = null;
                    }
                }
            }
            if (appContext == null) break block10;
            try {
                appContext.dispose();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
    }

    private static void printError(String string, Throwable throwable) {
        String string2 = null;
        if (throwable == null) {
            string2 = mh.getMessage("filenotfound", string);
        } else if (throwable instanceof IOException) {
            string2 = mh.getMessage("fileioexception", string);
        } else if (throwable instanceof ClassFormatError) {
            string2 = mh.getMessage("fileformat", string);
        } else if (throwable instanceof ThreadDeath) {
            string2 = mh.getMessage("filedeath", string);
        } else if (throwable instanceof Error) {
            string2 = mh.getMessage("fileerror", throwable.toString(), string);
        }
        if (string2 != null) {
            System.err.println(string2);
        }
    }
}

