/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.comedia.util.scanner.CXmlScanner;
import org.comedia.util.xml.CXmlElement;
import org.comedia.util.xml.CXmlException;

public class CDefaultXmlElement
implements CXmlElement {
    protected String tagName = "";
    protected Hashtable props = new Hashtable();
    protected ArrayList childs = new ArrayList();

    public CDefaultXmlElement() {
    }

    public CDefaultXmlElement(String tagName) {
        this.tagName = tagName.toUpperCase();
    }

    public void clear() {
        this.props.clear();
        this.childs.clear();
    }

    public void parseElement(CXmlScanner scanner) throws CXmlException {
        while (true) {
            String value;
            if (scanner.getTokenType() == 32) {
                String token = scanner.getToken();
                scanner.gotoNextToken();
                if (token.equals("/>")) {
                    return;
                }
                if (token.endsWith(">")) break;
                throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
            }
            if (scanner.getTokenType() != 2) {
                throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
            }
            String param = scanner.getToken();
            scanner.gotoNextToken();
            if (scanner.getTokenType() == 16) {
                scanner.gotoNextToken();
                value = CXmlScanner.unwrapString(scanner.getToken());
                scanner.gotoNextToken();
            } else {
                value = null;
            }
            this.props.put(param.toUpperCase(), value);
        }
        this.parseChildElements(scanner);
    }

    /*
     * Unable to fully structure code
     */
    public void parseChildElements(CXmlScanner scanner) throws CXmlException {
        line = "";
        if (true) ** GOTO lbl65
        do {
            if ((token = scanner.getToken()).equals("<?")) {
                while (!scanner.getToken().equals("?>")) {
                    if (scanner.getTokenType() == 32768) {
                        throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
                    }
                    scanner.gotoNextToken();
                }
                scanner.gotoNextToken();
                continue;
            }
            if (token.equals("<!")) {
                while (!scanner.getToken().equals(">")) {
                    if (scanner.getTokenType() == 32768) {
                        throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
                    }
                    scanner.gotoNextToken();
                }
                scanner.gotoNextToken();
                continue;
            }
            if (token.equals("<")) {
                if (line.length() > 0) {
                    this.childs.add(line);
                    line = "";
                }
                scanner.gotoNextToken();
                token = scanner.getToken();
                if (scanner.getTokenType() != 2) {
                    throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
                }
                scanner.gotoNextToken();
                element = this.createChildElement(token.toUpperCase());
                this.childs.add(element);
                element.parseElement(scanner);
                continue;
            }
            if (token.equals("</")) {
                scanner.gotoNextToken();
                token = scanner.getToken().toUpperCase();
                if (token.equals(this.tagName)) {
                    scanner.gotoNextToken();
                    if (scanner.getToken().equals(">")) {
                        scanner.gotoNextToken();
                        break;
                    }
                }
                throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
            }
            if (scanner.getTokenType() == 32) {
                throw new CXmlException("Incorrent XML structure at line: " + scanner.getLineNo());
            }
            if (line.length() > 0) {
                line = line + " ";
            }
            line = line + CXmlScanner.unwrapValue(token);
            scanner.gotoNextToken();
lbl65:
            // 5 sources

        } while (scanner.getTokenType() != 32768);
        if (line.length() > 0) {
            this.childs.add(line);
        }
    }

    protected String createIndent(int indent) {
        String result = "";
        int i2 = 0;
        while (i2 < indent) {
            result = result + " ";
            ++i2;
        }
        return result;
    }

    public void writeElement(Writer out, int indent) throws IOException {
        out.write(this.createIndent(indent) + "<" + this.tagName);
        Enumeration params = this.props.keys();
        while (params.hasMoreElements()) {
            Object param = params.nextElement();
            Object value = this.props.get(param);
            out.write(" " + param.toString());
            if (value == null) continue;
            out.write("=" + CXmlScanner.wrapString(value.toString()));
        }
        if (this.childs.size() == 0) {
            out.write("/>\n");
        } else {
            out.write(">\n");
            this.writeChildElements(out, indent);
            out.write(this.createIndent(indent) + "</" + this.tagName + ">\n");
        }
    }

    public void writeChildElements(Writer out, int indent) throws IOException {
        int i2 = 0;
        while (i2 < this.childs.size()) {
            Object current = this.childs.get(i2);
            if (current instanceof CXmlElement) {
                ((CXmlElement)current).writeElement(out, indent + 2);
            } else {
                out.write(this.createIndent(indent) + "  " + CXmlScanner.wrapValue(current.toString()) + "\n");
            }
            ++i2;
        }
    }

    public CXmlElement createChildElement(String tagName) {
        return new CDefaultXmlElement(tagName.toUpperCase());
    }
}

