/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CXmlScanner
extends CScanner {
    private boolean insideTag = false;

    public boolean isInsideTag() {
        return this.insideTag;
    }

    public void setBuffer(String s2) {
        this.insideTag = false;
        super.setBuffer(s2);
    }

    protected int lowRunLex(CScanner.Lexem curr) {
        char temp3;
        this.innerStartLex(curr);
        if (curr.tokenType != 0) {
            return curr.tokenType;
        }
        char temp = curr.token.charAt(0);
        char temp1 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
        char temp2 = this.bufferPos + 1 < this.bufferLen ? this.buffer.charAt(this.bufferPos + 1) : (char)'\u0000';
        char c2 = temp3 = this.bufferPos + 2 < this.bufferLen ? this.buffer.charAt(this.bufferPos + 2) : (char)'\u0000';
        if (temp == '<' && temp1 == '!' && temp2 == '-' && temp3 == '-') {
            curr.token = curr.token + temp1 + temp2 + temp3;
            this.bufferPos += 3;
            while (this.bufferPos + 2 < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                temp1 = this.buffer.charAt(this.bufferPos + 1);
                temp2 = this.buffer.charAt(this.bufferPos + 2);
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == '-' && temp1 == '-' && temp2 == '>') {
                    curr.token = curr.token + temp1 + temp2;
                    this.bufferPos += 2;
                    break;
                }
                if (temp != '\n') continue;
                ++this.bufferLine;
            }
            curr.tokenType = 1;
            return 1;
        }
        if (temp == '<') {
            if (temp1 == '?' || temp1 == '!' || temp1 == '/') {
                curr.token = curr.token + temp1;
                ++this.bufferPos;
            }
            this.insideTag = true;
            curr.tokenType = 32;
            return 32;
        }
        if (temp == '>') {
            this.insideTag = false;
            curr.tokenType = 32;
            return 32;
        }
        if (temp1 == '>' && (temp == '?' || temp == '/')) {
            curr.token = curr.token + temp1;
            ++this.bufferPos;
            this.insideTag = false;
            curr.tokenType = 32;
            return 32;
        }
        if (this.insideTag && temp == '=') {
            curr.tokenType = 16;
            return 16;
        }
        if (this.insideTag && (temp == '\'' || temp == '\"')) {
            return this.innerProcString(curr);
        }
        this.innerProcIdent(curr);
        if (this.insideTag && curr.tokenType == 8) {
            curr.tokenType = 2;
            return 2;
        }
        if (this.insideTag && curr.tokenType == 0) {
            curr.tokenType = 64;
        }
        while (!this.insideTag && this.bufferPos < this.bufferLen) {
            temp = this.buffer.charAt(this.bufferPos);
            if (CScanner.isWhite(temp) || temp == '\n' || temp == '\r' || temp == '<') break;
            curr.token = curr.token + temp;
            ++this.bufferPos;
        }
        curr.tokenType = this.insideTag ? curr.tokenType : 0;
        return curr.tokenType;
    }

    public static String wrapValue(String s2) {
        String result = "";
        int p2 = 0;
        while (p2 < s2.length()) {
            switch (s2.charAt(p2)) {
                case '&': {
                    result = result + "&amp;";
                    break;
                }
                case '\"': {
                    result = result + "&quot;";
                    break;
                }
                case '\'': {
                    result = result + "&apos;";
                    break;
                }
                case '>': {
                    result = result + "&gt;";
                    break;
                }
                case '<': {
                    result = result + "&lt;";
                    break;
                }
                default: {
                    result = result + s2.charAt(p2);
                }
            }
            ++p2;
        }
        return result;
    }

    public static String wrapString(String s2) {
        return "'" + CXmlScanner.wrapValue(s2) + "'";
    }

    public static int convertHex2Int(String s2) {
        int result = 0;
        int i2 = 0;
        while (i2 < s2.length()) {
            if (s2.charAt(i2) >= '0' && s2.charAt(i2) <= '9') {
                result = result << 4 | (byte)s2.charAt(i2) - 48;
            }
            if (s2.charAt(i2) >= 'A' && s2.charAt(i2) <= 'F') {
                result = result << 4 | (byte)s2.charAt(i2) - 65 + 10;
            }
            if (s2.charAt(i2) >= 'a' && s2.charAt(i2) <= 'f') {
                result = result << 4 | (byte)s2.charAt(i2) - 97 + 10;
            }
            ++i2;
        }
        return result;
    }

    public static String unwrapValue(String s2) {
        int p2 = 0;
        int len = s2.length();
        if (len == 0) {
            return "";
        }
        String result = "";
        while (p2 < len) {
            char temp = s2.charAt(p2);
            ++p2;
            if (temp == '&') {
                String escape = "";
                while (p2 < len) {
                    temp = s2.charAt(p2);
                    ++p2;
                    if (temp == ';') break;
                    escape = escape + temp;
                }
                escape = escape.toLowerCase();
                if (escape.equals("amp")) {
                    result = result + "&";
                    continue;
                }
                if (escape.equals("quot")) {
                    result = result + "\"";
                    continue;
                }
                if (escape.equals("apos")) {
                    result = result + "'";
                    continue;
                }
                if (escape.equals("gt")) {
                    result = result + ">";
                    continue;
                }
                if (escape.equals("lt")) {
                    result = result + "<";
                    continue;
                }
                if (escape.startsWith("#x")) {
                    result = result + (char)CXmlScanner.convertHex2Int(escape.substring(2));
                    continue;
                }
                if (!escape.startsWith("#")) continue;
                try {
                    result = result + (char)new Integer(escape.substring(1)).intValue();
                }
                catch (Exception e2) {}
                continue;
            }
            result = result + temp;
        }
        return result;
    }

    public static String unwrapString(String s2) {
        return CXmlScanner.unwrapValue(CScanner.unwrapString(s2));
    }

    public static void main(String[] args) {
        System.out.println("*********** Xml Scanner Test *************");
        CXmlScanner scanner = new CXmlScanner();
        scanner.setBuffer("<?xml <!-- comment -->param+0.1=\"xxx\">\"www\" +=11 labmda</ a/>");
        scanner.setShowEol(true);
        scanner.setShowSpace(true);
        scanner.setShowComment(true);
        String str = "The test & 'string'";
        System.out.println("Start string: " + str);
        str = CXmlScanner.wrapString(str);
        System.out.println("Wrapped string: " + str);
        str = CXmlScanner.unwrapString("&#169;" + str + "&#xA9;");
        System.out.println("Unwrapped string: " + str);
        System.out.println();
        System.out.println("Initial string: " + scanner.getBuffer());
        while (scanner.lex() != 32768) {
            switch (scanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                    break;
                }
                default: {
                    System.out.print("Type: ??? ");
                }
            }
            System.out.println("Value: '" + scanner.getToken() + "' Pos: " + scanner.getPosition() + " Line: " + scanner.getLineNo());
        }
    }
}

