/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

public class CScanner {
    public static final int UNKNOWN = 0;
    public static final int COMMENT = 1;
    public static final int KEYWORD = 2;
    public static final int TYPE = 4;
    public static final int IDENT = 8;
    public static final int ALPHA = 14;
    public static final int OPERATOR = 16;
    public static final int BRACE = 32;
    public static final int SEPARATOR = 64;
    public static final int EOL = 128;
    public static final int LF = 224;
    public static final int SPACE = 256;
    public static final int DELIM = 496;
    public static final int INT = 512;
    public static final int FLOAT = 1024;
    public static final int STRING = 2048;
    public static final int BOOL = 4096;
    public static final int CONST = 7680;
    public static final int EOF = 32768;
    protected String buffer;
    protected int bufferPos;
    protected int bufferLine;
    protected int bufferLen;
    protected Lexem current;
    protected Lexem next;
    protected boolean showComment = false;
    protected boolean showString = true;
    protected boolean showEol = false;
    protected boolean showKeyword = true;
    protected boolean showType = true;
    protected boolean showSpace = false;
    protected String[] operators;
    protected String[] types;
    protected String[] keywords;

    public CScanner() {
        this.setBuffer("");
    }

    protected int lowRunLex(Lexem curr) {
        int result = this.innerStartLex(curr);
        if (result != 0) {
            return result;
        }
        char temp = curr.token.charAt(0);
        if (new String("(){}[]").indexOf(temp) >= 0) {
            curr.tokenType = 32;
            return 32;
        }
        if (temp == ',' || temp == '.' || temp == ';' || temp == ':') {
            curr.tokenType = 64;
            return 64;
        }
        if (CScanner.isDelim(temp)) {
            curr.tokenType = 16;
            return 16;
        }
        if (CScanner.isQuote(temp)) {
            char quote = temp;
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                if (temp == '\n' || temp == '\r') break;
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == quote) break;
            }
            curr.tokenType = 2048;
            return 2048;
        }
        result = CScanner.isDigit(temp) ? 512 : 8;
        while (this.bufferPos < this.bufferLen) {
            temp = this.buffer.charAt(this.bufferPos);
            if (CScanner.isDelim(temp) || CScanner.isQuote(temp)) break;
            if (result == 512 && temp == '.') {
                result = 1024;
            }
            curr.token = curr.token + temp;
            ++this.bufferPos;
        }
        curr.tokenType = result;
        return curr.tokenType;
    }

    protected int runLex(Lexem curr) {
        int result;
        while (!(((result = this.lowRunLex(curr)) == 128 || result == 224) && this.showEol || result == 1 && this.showComment || result != 128 && result != 224 && result != 1)) {
        }
        if (result == 2048 && !this.showString) {
            curr.token = CScanner.unwrapString(curr.token);
        }
        curr.tokenType = result;
        return curr.tokenType;
    }

    protected void extractToken() {
        if (this.next.token.length() != 0 && this.next.tokenType != 0) {
            this.current.tokenType = this.next.tokenType;
            this.current.lineNo = this.next.lineNo;
            this.current.position = this.next.position;
            this.current.token = this.next.token;
            this.next = new Lexem();
        } else {
            this.runLex(this.current);
        }
    }

    protected void extractNextToken() {
        if (this.next.token.length() == 0 && this.next.tokenType == 0) {
            this.runLex(this.next);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int innerStartLex(Lexem curr) {
        curr.lineNo = this.bufferLine;
        curr.position = this.bufferPos;
        curr.token = "";
        if (this.bufferPos >= this.bufferLen) {
            curr.tokenType = 32768;
            return 32768;
        }
        if (!this.showSpace || !CScanner.isWhite(this.buffer.charAt(this.bufferPos))) ** GOTO lbl19
        do {
            curr.token = curr.token + this.buffer.charAt(this.bufferPos);
            ++this.bufferPos;
        } while (this.bufferPos < this.bufferLen && CScanner.isWhite(this.buffer.charAt(this.bufferPos)));
        curr.tokenType = 256;
        return 256;
lbl-1000:
        // 1 sources

        {
            ++this.bufferPos;
            if (this.bufferPos < this.bufferLen) continue;
            curr.position = this.bufferPos;
            curr.tokenType = 32768;
            return 32768;
lbl19:
            // 2 sources

            ** while (CScanner.isWhite((char)this.buffer.charAt((int)this.bufferPos)))
        }
lbl20:
        // 1 sources

        curr.position = this.bufferPos;
        curr.token = "" + this.buffer.charAt(this.bufferPos);
        ++this.bufferPos;
        if (curr.token.charAt(0) == '\r') {
            curr.tokenType = 224;
            return 224;
        }
        if (curr.token.charAt(0) == '\n') {
            ++this.bufferLine;
            curr.tokenType = 128;
            return 128;
        }
        curr.tokenType = 0;
        return 0;
    }

    protected int innerProcLineComment(Lexem curr) {
        while (this.bufferPos < this.bufferLen) {
            char temp = this.buffer.charAt(this.bufferPos);
            curr.token = curr.token + temp;
            ++this.bufferPos;
            if (temp != '\n') continue;
            ++this.bufferLine;
            break;
        }
        curr.tokenType = 1;
        return 1;
    }

    protected int innerProcCComment(Lexem curr) {
        curr.tokenType = 0;
        if (curr.token.charAt(0) == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '*') {
            curr.tokenType = 1;
            int temp1 = 0;
            while (this.bufferPos < this.bufferLen) {
                char temp = this.buffer.charAt(this.bufferPos);
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == '/' && temp1 == 42 && curr.token.length() > 3) break;
                if (temp == '\n') {
                    ++this.bufferLine;
                }
                temp1 = temp;
            }
        }
        return curr.tokenType;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int innerProcIdent(Lexem curr) {
        char temp;
        block9: {
            temp = curr.token.charAt(0);
            curr.tokenType = 0;
            if (!CScanner.isDigit(temp) && !CScanner.isLetter(temp)) {
                if (new String("._,$").indexOf(temp) < 0) return curr.tokenType;
            }
            if (temp == '.') {
                if (this.bufferPos < this.bufferLen && CScanner.isDigit(this.buffer.charAt(this.bufferPos))) {
                    curr.tokenType = 1024;
                    break block9;
                } else {
                    curr.tokenType = 64;
                    return 64;
                }
            }
            curr.tokenType = CScanner.isDigit(temp) ? 512 : 8;
        }
        while (this.bufferPos < this.bufferLen) {
            temp = this.buffer.charAt(this.bufferPos);
            if (!CScanner.isDigit(temp) && !CScanner.isLetter(temp) && new String("._,$").indexOf(temp) < 0) {
                return curr.tokenType;
            }
            if (curr.tokenType == 512 && temp == '.') {
                curr.tokenType = 1024;
            } else if (temp == '.') {
                return curr.tokenType;
            }
            curr.token = curr.token + temp;
            ++this.bufferPos;
        }
        return curr.tokenType;
    }

    protected int innerProcString(Lexem curr) {
        curr.tokenType = 0;
        char temp = curr.token.charAt(0);
        if (CScanner.isQuote(temp)) {
            curr.tokenType = 2048;
            char quote = temp;
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                if (temp == '\n' || temp == '\r') break;
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == quote) break;
            }
        }
        return curr.tokenType;
    }

    protected int innerProcCString(Lexem curr) {
        curr.tokenType = 0;
        char temp = curr.token.charAt(0);
        if (CScanner.isQuote(temp)) {
            curr.tokenType = 2048;
            char quote = temp;
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                if (temp == '\n' || temp == '\r') break;
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == '\\' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == quote) {
                    curr.token = curr.token + quote;
                    ++this.bufferPos;
                    continue;
                }
                if (temp == quote) break;
            }
        }
        return curr.tokenType;
    }

    protected int innerProcPasString(Lexem curr) {
        curr.tokenType = 0;
        char temp = curr.token.charAt(0);
        if (CScanner.isQuote(temp)) {
            curr.tokenType = 2048;
            char quote = temp;
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                if (temp == '\n' || temp == '\r') break;
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == quote && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == quote) {
                    curr.token = curr.token + quote;
                    ++this.bufferPos;
                    continue;
                }
                if (temp == quote) break;
            }
        }
        return curr.tokenType;
    }

    protected boolean searchForString(String s2, String[] a2) {
        if (a2 != null) {
            int i2 = 0;
            while (i2 < a2.length) {
                if (s2.equals(a2[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public void restart() {
        this.setBuffer(this.buffer);
    }

    public static String wrapString(String s2) {
        return "\"" + s2 + "\"";
    }

    public static String unwrapString(String s2) {
        if (s2.length() == 0) {
            return s2;
        }
        char quote = s2.charAt(0);
        int start = 0;
        int end = s2.length() - 1;
        if (quote == '\"' || quote == '\'') {
            ++start;
            if (end > 0 && s2.charAt(end) == quote) {
                --end;
            }
        }
        return s2.substring(start, end + 1);
    }

    public static boolean isAlpha(char c2) {
        return c2 >= ' ' && !CScanner.isDelim(c2) && !CScanner.isDigit(c2);
    }

    public static boolean isLetter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    public static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isDelim(char c2) {
        return new String(":;,+-<>/*%^=()[]|&~@#$\\`{}!? \t\n\r").indexOf(c2) >= 0;
    }

    public static boolean isWhite(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    public static boolean isEol(char c2) {
        return c2 == '\n';
    }

    public static boolean isQuote(char c2) {
        return c2 == '\"' || c2 == '\'';
    }

    public int lex() {
        this.extractToken();
        return this.current.tokenType;
    }

    public int gotoNextToken() {
        return this.lex();
    }

    public boolean isShowComment() {
        return this.showComment;
    }

    public void setShowComment(boolean value) {
        this.showComment = value;
    }

    public boolean isShowEol() {
        return this.showEol;
    }

    public void setShowEol(boolean value) {
        this.showEol = value;
    }

    public boolean isShowString() {
        return this.showString;
    }

    public void setShowString(boolean value) {
        this.showString = value;
    }

    public boolean isShowKeyword() {
        return this.showKeyword;
    }

    public void setShowKeyword(boolean value) {
        this.showKeyword = value;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean value) {
        this.showType = value;
    }

    public boolean isShowSpace() {
        return this.showSpace;
    }

    public void setShowSpace(boolean value) {
        this.showSpace = value;
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    public void setBuffer(String s2) {
        this.buffer = s2;
        this.bufferLen = s2.length();
        this.bufferPos = 0;
        this.bufferLine = 0;
        this.current = new Lexem();
        this.current.tokenType = 32768;
        this.next = new Lexem();
    }

    public int getBufferPos() {
        return this.bufferPos;
    }

    public int getPosition() {
        return this.current.position;
    }

    public int getLineNo() {
        return this.current.lineNo;
    }

    public String getToken() {
        return this.current.token;
    }

    public int getTokenType() {
        return this.current.tokenType;
    }

    public int getNextPosition() {
        this.extractNextToken();
        return this.next.position;
    }

    public int getNextLineNo() {
        this.extractNextToken();
        return this.next.lineNo;
    }

    public String getNextToken() {
        this.extractNextToken();
        return this.next.token;
    }

    public int getNextTokenType() {
        this.extractNextToken();
        return this.next.tokenType;
    }

    public static void main(String[] args) {
        System.out.println("*********** Scanner Test *************");
        CScanner scanner = new CScanner();
        scanner.setBuffer("while(1.0e2*i := \t\r\n> \"string''\")\n// comment\n/*second\ncomment*/{xxx}");
        scanner.setShowEol(true);
        scanner.setShowSpace(true);
        String str = "The test \"string\"";
        System.out.println("Start string: " + str);
        str = CScanner.wrapString(str);
        System.out.println("Wrapped string: " + str);
        str = CScanner.unwrapString(str);
        System.out.println("Unwrapped string: " + str);
        System.out.println();
        System.out.println("Initial string: " + scanner.getBuffer());
        while (scanner.lex() != 32768) {
            switch (scanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + scanner.getToken() + "' Pos: " + scanner.getPosition() + " Line: " + scanner.getLineNo());
        }
    }

    protected class Lexem {
        public String token = "";
        public int tokenType = 0;
        public int position = 0;
        public int lineNo = 0;

        protected Lexem() {
        }
    }
}

