/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CPasScanner
extends CScanner {
    protected String[] pasOperators = new String[]{"and", "or", "not", "shr", "shl", "div", "mod"};
    protected String[] pasTypes = new String[]{"integer", "longint", "byte", "char", "string", "boolean", "real", "double", "word"};
    protected String[] pasKeywords = new String[]{"with", "array", "function", "case", "var", "const", "until", "then", "set", "record", "program", "procedure", "packed", "nil", "label", "in", "repeat", "of", "goto", "forward", "for", "while", "file", "else", "downto", "do", "to", "type", "end", "begin", "if", "true", "false", "unit", "interface", "uses", "implementation", "initialization"};

    public CPasScanner() {
        this.operators = this.pasOperators;
        this.types = this.pasTypes;
        this.keywords = this.pasKeywords;
    }

    protected int lowRunLex(CScanner.Lexem curr) {
        this.innerStartLex(curr);
        if (curr.tokenType != 0) {
            return curr.tokenType;
        }
        char temp = curr.token.charAt(0);
        if (temp == '{') {
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == '}') break;
                if (temp != '\n') continue;
                ++this.bufferLine;
            }
            curr.tokenType = 1;
            return 1;
        }
        if (temp == '(' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '*') {
            int temp1 = 0;
            while (this.bufferPos < this.bufferLen) {
                temp = this.buffer.charAt(this.bufferPos);
                curr.token = curr.token + temp;
                ++this.bufferPos;
                if (temp == ')' && temp1 == 42 && curr.token.length() > 3) break;
                if (temp == '\n') {
                    ++this.bufferLine;
                }
                temp1 = temp;
            }
            curr.tokenType = 1;
            return 1;
        }
        if (temp == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '/') {
            return this.innerProcLineComment(curr);
        }
        if (new String("()[]").indexOf(temp) >= 0) {
            curr.tokenType = 32;
            return 32;
        }
        if (temp == ',' || temp == '.' || temp == ';' || temp == ':' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) != '=') {
            curr.tokenType = 64;
            return 64;
        }
        if (new String(":=+-<>/*^@#").indexOf(temp) >= 0) {
            char temp1;
            char c2 = temp1 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if ((temp == ':' || temp == '>') && temp1 == '=' || temp == '<' && (temp1 == '=' || temp1 == '>')) {
                curr.token = curr.token + temp1;
                ++this.bufferPos;
            }
            curr.tokenType = 16;
            return 16;
        }
        if (temp == '\'') {
            return this.innerProcPasString(curr);
        }
        this.innerProcIdent(curr);
        if (curr.tokenType == 8) {
            if (this.searchForString(curr.token.toLowerCase(), this.operators)) {
                curr.tokenType = 16;
                return 16;
            }
            if (this.showType && this.searchForString(curr.token.toLowerCase(), this.types)) {
                curr.tokenType = 4;
                return 4;
            }
            if (this.showKeyword && this.searchForString(curr.token.toLowerCase(), this.keywords)) {
                curr.tokenType = 2;
                return 2;
            }
        }
        return curr.tokenType;
    }

    public static String wrapString(String s2) {
        String result = "'";
        int p2 = 0;
        while (p2 < s2.length()) {
            result = result + s2.charAt(p2);
            if (s2.charAt(p2) == '\'') {
                result = result + s2.charAt(p2);
            }
            ++p2;
        }
        return result + "'";
    }

    public static String unwrapString(String s2) {
        int p2 = 0;
        int len = s2.length();
        if (len == 0) {
            return "";
        }
        if (s2.charAt(p2) == '\'') {
            ++p2;
        }
        if (s2.charAt(len - 1) == '\'') {
            --len;
        }
        if (len - p2 <= 0) {
            return "";
        }
        String result = "";
        while (p2 < len) {
            char temp = s2.charAt(p2);
            if (temp != '\'') {
                result = result + temp;
            } else if (p2 < len - 1 && s2.charAt(p2 + 1) == '\'') {
                result = result + '\'';
                ++p2;
            }
            ++p2;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("*********** Pascal Scanner Test *************");
        CPasScanner scanner = new CPasScanner();
        scanner.setBuffer("while(1.0e2*i := \t\r\n> 'string''')\n// comment\n(*second\ncomment*){xxx}");
        scanner.setShowEol(true);
        scanner.setShowSpace(true);
        scanner.setShowComment(true);
        scanner.setShowKeyword(true);
        scanner.setShowType(true);
        String str = "The test 'string'";
        System.out.println("Start string: " + str);
        str = CPasScanner.wrapString(str);
        System.out.println("Wrapped string: " + str);
        str = CPasScanner.unwrapString(str);
        System.out.println("Unwrapped string: " + str);
        System.out.println();
        System.out.println("Initial string: " + scanner.getBuffer());
        while (scanner.lex() != 32768) {
            switch (scanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + scanner.getToken() + "' Pos: " + scanner.getPosition() + " Line: " + scanner.getLineNo());
        }
    }
}

