/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CCppScanner;
import org.comedia.util.scanner.CScanner;

public class CJavaScanner
extends CCppScanner {
    String[] javaTypes = new String[]{"int", "long", "short", "char", "boolean", "float", "double", "byte", "void"};
    String[] javaKeywords = new String[]{"return", "if", "else", "while", "do", "switch", "case", "default", "typedef", "class", "true", "false", "break", "continue", "for", "static", "public", "private", "protected", "extends", "implements", "interface", "final", "null", "package", "import", "instanceof", "new", "try", "catch", "finally", "this"};

    public CJavaScanner() {
        this.keywords = this.javaKeywords;
        this.types = this.javaTypes;
    }

    protected int lowRunLex(CScanner.Lexem curr) {
        super.lowRunLex(curr);
        if (curr.token.equals("->")) {
            curr.token = "-";
            --this.bufferPos;
        }
        return curr.tokenType;
    }

    public static void main(String[] args) {
        System.out.println("*********** Java Scanner Test *************");
        CJavaScanner scanner = new CJavaScanner();
        scanner.setBuffer("final(1.0e2=i.a >>= \t\r\n-> \"string\\\"\")\n// comment\n/*second\ncomment*/{xxx}");
        scanner.setShowEol(true);
        scanner.setShowSpace(true);
        scanner.setShowComment(true);
        scanner.setShowKeyword(true);
        scanner.setShowType(true);
        String str = "The test \"string\"";
        System.out.println("Start string: " + str);
        str = CJavaScanner.wrapString(str);
        System.out.println("Wrapped string: " + str);
        str = CJavaScanner.unwrapString(str);
        System.out.println("Unwrapped string: " + str);
        System.out.println();
        System.out.println("Initial string: " + scanner.getBuffer());
        while (scanner.lex() != 32768) {
            switch (scanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + scanner.getToken() + "' Pos: " + scanner.getPosition() + " Line: " + scanner.getLineNo());
        }
    }
}

