/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CCppScanner
extends CScanner {
    String[] cTypes = new String[]{"int", "long", "short", "char", "bool", "float", "double", "void"};
    String[] cKeywords = new String[]{"return", "if", "else", "while", "do", "switch", "case", "default", "typedef", "union", "class", "struct", "true", "false", "goto", "break", "continue", "for", "operator", "static", "public", "private", "protected", "friend", "this"};

    protected int lowRunLex(CScanner.Lexem curr) {
        this.innerStartLex(curr);
        if (curr.tokenType != 0) {
            return curr.tokenType;
        }
        this.innerProcCComment(curr);
        if (curr.tokenType != 0) {
            return curr.tokenType;
        }
        char temp = curr.token.charAt(0);
        if (temp == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '/') {
            return this.innerProcLineComment(curr);
        }
        if (new String("{}()[]").indexOf(temp) >= 0) {
            curr.tokenType = 32;
            return 32;
        }
        if (new String(":;.,").indexOf(temp) >= 0) {
            curr.tokenType = 64;
            return 64;
        }
        if (new String("=+-<>/*^@#?%!|&~").indexOf(temp) >= 0) {
            char temp2;
            char temp1;
            char c2 = temp1 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if (new String("+-!|~&*/>%").indexOf(temp) >= 0 && temp1 == '=' || temp == '<' && temp1 == '=' || new String("<>|&+-").indexOf(temp) >= 0 && temp1 == temp || temp == '-' && temp1 == '>') {
                curr.token = curr.token + temp1;
                ++this.bufferPos;
            }
            char c3 = temp2 = temp1 != '\u0000' && this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if (temp == '>' && temp1 == '>' && temp2 == '=' || temp == '<' && temp1 == '<' && temp2 == '=') {
                curr.token = curr.token + temp2;
                ++this.bufferPos;
            }
            curr.tokenType = 16;
            return 16;
        }
        if (temp == '\"') {
            return this.innerProcCString(curr);
        }
        this.innerProcIdent(curr);
        if (curr.tokenType == 8) {
            if (this.showType && this.searchForString(curr.token, this.types)) {
                curr.tokenType = 4;
                return 4;
            }
            if (this.showKeyword && this.searchForString(curr.token, this.keywords)) {
                curr.tokenType = 2;
                return 2;
            }
        }
        return curr.tokenType;
    }

    public static String wrapString(String s2) {
        String result = "\"";
        int p2 = 0;
        while (p2 < s2.length()) {
            char temp = s2.charAt(p2);
            switch (temp) {
                case '\t': {
                    result = result + "\\t";
                    break;
                }
                case '\n': {
                    result = result + "\\n";
                    break;
                }
                case '\r': {
                    result = result + "\\r";
                    break;
                }
                case '\u0000': {
                    result = result + "\\0";
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    result = result + '\\';
                }
                default: {
                    result = result + temp;
                }
            }
            ++p2;
        }
        return result + "\"";
    }

    public static String unwrapString(String s2) {
        if ((s2 = CScanner.unwrapString(s2)).length() == 0) {
            return "";
        }
        String result = "";
        int p2 = 0;
        while (p2 < s2.length()) {
            int temp = s2.charAt(p2);
            if (temp == 92) {
                if (++p2 >= s2.length()) break;
                temp = s2.charAt(p2);
                switch (temp) {
                    case 110: {
                        temp = 10;
                        break;
                    }
                    case 114: {
                        temp = 13;
                        break;
                    }
                    case 116: {
                        temp = 9;
                        break;
                    }
                    case 48: {
                        temp = 0;
                    }
                }
            }
            result = result + (char)temp;
            ++p2;
        }
        return result;
    }

    public CCppScanner() {
        this.keywords = this.cKeywords;
        this.types = this.cTypes;
    }

    public static void main(String[] args) {
        System.out.println("*********** C Scanner Test *************");
        CCppScanner scanner = new CCppScanner();
        scanner.setBuffer("while(1.0e2=i.a >>= \t\r\n-> \"string\\\"\")\n// comment\n/*second\ncomment*/{xxx}");
        scanner.setShowEol(true);
        scanner.setShowSpace(true);
        scanner.setShowComment(true);
        scanner.setShowKeyword(true);
        scanner.setShowType(true);
        String str = "The test \"string\"";
        System.out.println("Start string: " + str);
        str = CCppScanner.wrapString(str);
        System.out.println("Wrapped string: " + str);
        str = CCppScanner.unwrapString(str);
        System.out.println("Unwrapped string: " + str);
        System.out.println();
        System.out.println("Initial string: " + scanner.getBuffer());
        while (scanner.lex() != 32768) {
            switch (scanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + scanner.getToken() + "' Pos: " + scanner.getPosition() + " Line: " + scanner.getLineNo());
        }
    }
}

